/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.modules.checker;

import chemaxon.checkers.StructureChecker;
import chemaxon.marvin.sketch.swing.checker.editor.CheckerEditor;
import chemaxon.marvin.sketch.swing.modules.checker.CheckerEditorInstanceProvider;
import chemaxon.marvin.sketch.swing.modules.checker.editors.DefaultCheckerEditor;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.table.DefaultTableCellRenderer;

public class CheckerCellRenderer
extends DefaultTableCellRenderer
implements ListCellRenderer {
    private static final long serialVersionUID = -7650929681748232213L;
    private final boolean validating;

    public CheckerCellRenderer() {
        this(true);
    }

    public CheckerCellRenderer(boolean validating) {
        this.validating = validating;
    }

    protected static String getToolTip(StructureChecker checker, String extraInfo) {
        return CheckerCellRenderer.getToolTip(checker, extraInfo, true);
    }

    protected static String getToolTip(StructureChecker checker, String extraInfo, boolean validate) {
        String currentConfig;
        CheckerEditor editor = CheckerEditorInstanceProvider.getEditor(checker);
        StringBuffer tooltip = new StringBuffer(255);
        tooltip.append("<html><body><b>");
        tooltip.append(checker.getDescriptor().getName());
        tooltip.append("</b>");
        if (checker.getDescriptor().getDescription() != null && checker.getDescriptor().getDescription().trim().length() > 0) {
            tooltip.append("<div style=\"width: 200px;\">");
            tooltip.append(checker.getDescriptor().getDescription());
            tooltip.append("</div>");
        }
        if (checker.getDescriptor().getHelpText() != null && checker.getDescriptor().getHelpText().trim().length() > 0) {
            tooltip.append("<div style=\"width: 200px;\">");
            tooltip.append(checker.getDescriptor().getHelpText());
            tooltip.append("</div>");
        }
        if (editor instanceof DefaultCheckerEditor && !"".equals(currentConfig = ((DefaultCheckerEditor)editor).getConfigurationInfo(checker))) {
            tooltip.append("<br><div style=\"width: 200px;\"><i><b>Configured to:</b><br>");
            tooltip.append(currentConfig);
            tooltip.append("</i></div><br>");
        }
        if (!checker.isAvailable()) {
            tooltip.append("<i>This item is not available.</i><br>");
        }
        if (validate && !checker.isValid()) {
            tooltip.append("<i>This item is badly configured.</i><br>");
        }
        if (extraInfo != null) {
            tooltip.append("<div style=\"width: 200px;\">");
            tooltip.append(extraInfo);
            tooltip.append("</div>");
        }
        tooltip.append("</body></html>");
        return tooltip.toString();
    }

    protected String getToolTipForItem(StructureChecker checker) {
        return CheckerCellRenderer.getToolTip(checker, null, this.validating);
    }

    protected Component getCellRendererComponent(StructureChecker checker, boolean isSelected, boolean hasFocus, boolean editable) {
        JComponent component;
        CheckerEditor editor = CheckerEditorInstanceProvider.getEditor(checker);
        if (isSelected && editor != null && editable) {
            if (editor instanceof DefaultCheckerEditor) {
                ((DefaultCheckerEditor)editor).setValidating(this.validating);
            }
            component = editor.getEditorComponent(checker);
        } else {
            editor = CheckerEditorInstanceProvider.getDefaultEditor();
            if (editor instanceof DefaultCheckerEditor) {
                ((DefaultCheckerEditor)editor).setValidating(this.validating);
            }
            component = editor.getEditorComponent(checker);
            component.setBackground(isSelected ? Color.LIGHT_GRAY : Color.WHITE);
        }
        component.setToolTipText(isSelected && editable ? null : this.getToolTipForItem(checker));
        return component;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value instanceof StructureChecker) {
            return this.getCellRendererComponent((StructureChecker)value, isSelected, hasFocus, true);
        }
        return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (value instanceof StructureChecker) {
            return this.getCellRendererComponent((StructureChecker)value, isSelected, cellHasFocus, false);
        }
        return new JLabel(value.toString());
    }
}

