/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.modules.checker;

import chemaxon.checkers.StructureChecker;
import chemaxon.checkers.StructureCheckerFactory;
import chemaxon.checkers.runner.configuration.reader.ConfigurationReader;
import chemaxon.checkers.runner.configuration.reader.XMLBasedConfigurationReader;
import chemaxon.checkers.runner.configuration.writer.ConfigurationWriter;
import chemaxon.marvin.sketch.swing.modules.checker.CheckerCellRenderer;
import chemaxon.marvin.sketch.swing.modules.checker.CheckerTable;
import chemaxon.marvin.util.codeassist.toolbar.AbstractFilterListModel;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableCellEditor;

public class CheckerConfigurationPanel
extends JPanel {
    public static final String PROPERTY_KEY_PANEL_ENABLED = "CheckerConfigurationPanelEnabled";
    private static final long serialVersionUID = -7527646282392152372L;
    private static final String EMPTY_TABLE_MESSAGE = "There are no active checkers.\nYou can add checkers by pressing the 'Add' button on the right";
    private static final String FILTER_HELP = "Type keywords to narrow your search";
    private static final String CHECKER_COLUMN_TITLE = "List of active checkers";
    private static final String EDITOR_PAGE = "editor";
    private static final String MESSAGE_PAGE = "message";
    private JToolBar toolbar = null;
    private JButton moveUpButton = null;
    private JButton moveDownButton = null;
    private JButton addButton = null;
    private JButton removeButton = null;
    private JButton importButton = null;
    private JButton exportButton = null;
    private CheckerTable checkersTable = null;
    private JFileChooser fileChooser = null;
    private ConfigurationReader reader = null;
    private ConfigurationWriter writer = null;
    private final StructureCheckerFactory factory;
    private JPopupMenu availableCheckersMenu = null;
    private JList popupList = null;
    private JTextField popupFilterText = null;
    private boolean editMode = true;
    private Action acceptAction = null;
    private final Action MOVE_UP_ACTION = new AbstractAction(){
        private static final long serialVersionUID = 4471725996048235621L;

        @Override
        public void actionPerformed(ActionEvent e) {
            int index = CheckerConfigurationPanel.this.getCheckersTable().getSelectedRow();
            if (index > 0) {
                TableCellEditor editor = CheckerConfigurationPanel.this.getCheckersTable().getCellEditor();
                if (editor != null && !editor.stopCellEditing()) {
                    editor.cancelCellEditing();
                }
                CheckerConfigurationPanel.this.getCheckersTable().getModel().moveRow(index, index, index - 1);
                CheckerConfigurationPanel.this.getCheckersTable().getSelectionModel().setSelectionInterval(index - 1, index - 1);
            }
        }
    };
    private final Action MOVE_DOWN_ACTION = new AbstractAction(){
        private static final long serialVersionUID = -3286209517143411953L;

        @Override
        public void actionPerformed(ActionEvent e) {
            int index = CheckerConfigurationPanel.this.getCheckersTable().getSelectedRow();
            if (index > -1 && index < CheckerConfigurationPanel.this.getCheckersTable().getRowCount() - 1) {
                TableCellEditor editor = CheckerConfigurationPanel.this.getCheckersTable().getCellEditor();
                if (editor != null && !editor.stopCellEditing()) {
                    editor.cancelCellEditing();
                }
                CheckerConfigurationPanel.this.getCheckersTable().getModel().moveRow(index, index, index + 1);
                CheckerConfigurationPanel.this.getCheckersTable().getSelectionModel().setSelectionInterval(index + 1, index + 1);
            }
        }
    };
    private final Action ADD_ACTION = new AbstractAction(){
        private static final long serialVersionUID = -222467631748756920L;

        @Override
        public void actionPerformed(ActionEvent e) {
            CheckerConfigurationPanel.this.getAvailableCheckersMenu().show(CheckerConfigurationPanel.this.getAddButton(), 0, 0);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CheckerConfigurationPanel.this.getPopupList().requestFocus();
                }
            });
        }
    };
    private final Action REMOVE_ACTION = new AbstractAction(){
        private static final long serialVersionUID = -1223035953425425571L;

        @Override
        public void actionPerformed(ActionEvent e) {
            int index = CheckerConfigurationPanel.this.getCheckersTable().getSelectedRow();
            if (index > -1 && index < CheckerConfigurationPanel.this.getCheckersTable().getRowCount()) {
                TableCellEditor editor = CheckerConfigurationPanel.this.getCheckersTable().getCellEditor();
                if (editor != null && !editor.stopCellEditing()) {
                    editor.cancelCellEditing();
                }
                CheckerConfigurationPanel.this.getCheckersTable().getModel().removeRow(index);
                if (CheckerConfigurationPanel.this.getCheckersTable().getModel().getRowCount() > index) {
                    CheckerConfigurationPanel.this.getCheckersTable().setSelectedRow(index);
                } else if (CheckerConfigurationPanel.this.getCheckersTable().getModel().getRowCount() > 0) {
                    CheckerConfigurationPanel.this.getCheckersTable().setSelectedRow(index - 1);
                }
                CheckerConfigurationPanel.this.getCheckersTable().getViewport().repaint();
            }
        }
    };
    private final Action IMPORT_ACTION = new AbstractAction(){
        private static final long serialVersionUID = -397678241016423265L;

        @Override
        public void actionPerformed(ActionEvent e) {
            if (CheckerConfigurationPanel.this.getFileChooser() != null && CheckerConfigurationPanel.this.getFileChooser().showOpenDialog(CheckerConfigurationPanel.this) == 0) {
                try {
                    CheckerConfigurationPanel.this.readCheckers(new FileInputStream(CheckerConfigurationPanel.this.getFileChooser().getSelectedFile()));
                }
                catch (FileNotFoundException e1) {
                    e1.printStackTrace();
                }
            }
        }
    };
    private final Action EXPORT_ACTION = new AbstractAction(){
        private static final long serialVersionUID = 4408445169452416111L;

        @Override
        public void actionPerformed(ActionEvent e) {
            if (CheckerConfigurationPanel.this.getFileChooser() != null && CheckerConfigurationPanel.this.getFileChooser().showSaveDialog(CheckerConfigurationPanel.this) == 0) {
                try {
                    CheckerConfigurationPanel.this.writeCheckers(new FileOutputStream(CheckerConfigurationPanel.this.getFileChooser().getSelectedFile()));
                }
                catch (FileNotFoundException e1) {
                    e1.printStackTrace();
                }
            }
        }
    };

    CheckerConfigurationPanel(StructureCheckerFactory factory) {
        this.factory = factory;
        this.initComponents();
    }

    private void initComponents() {
        JLabel messageLabel = new JLabel("Configuration of Checkers are disabled by external program.");
        JPanel checkersPanel = new JPanel(new BorderLayout());
        checkersPanel.add((Component)this.getCheckersTable(), "Center");
        checkersPanel.add((Component)this.getToolbar(), "East");
        CardLayout layout = new CardLayout();
        this.setLayout(layout);
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)messageLabel, MESSAGE_PAGE);
        this.add((Component)checkersPanel, EDITOR_PAGE);
        layout.show(this, EDITOR_PAGE);
    }

    public ConfigurationReader getReader() {
        return this.reader;
    }

    public void setReader(ConfigurationReader reader) {
        this.reader = reader;
    }

    public ConfigurationWriter getWriter() {
        return this.writer;
    }

    public void setWriter(ConfigurationWriter writer) {
        this.writer = writer;
    }

    public void readCheckers() {
        TableCellEditor editor = this.getCheckersTable().getCellEditor();
        if (editor != null && !editor.stopCellEditing()) {
            editor.cancelCellEditing();
        }
        List<StructureChecker> checkerList = this.reader.getCheckerList();
        this.getCheckersTable().clear();
        for (StructureChecker checker : checkerList) {
            this.getCheckersTable().getModel().addRow(new Object[]{checker});
        }
    }

    public void readCheckers(InputStream inputStream) {
        TableCellEditor editor = this.getCheckersTable().getCellEditor();
        if (editor != null && !editor.stopCellEditing()) {
            editor.cancelCellEditing();
        }
        XMLBasedConfigurationReader reader = new XMLBasedConfigurationReader(inputStream);
        List<StructureChecker> checkerList = reader.getCheckerList();
        this.getCheckersTable().clear();
        for (StructureChecker checker : checkerList) {
            this.getCheckersTable().getModel().addRow(new Object[]{checker});
        }
    }

    public void writeCheckers(OutputStream outputStream) {
        ArrayList<StructureChecker> checkerList = new ArrayList<StructureChecker>();
        for (int i = 0; i < this.getCheckersTable().getModel().getRowCount(); ++i) {
            Object obj = this.getCheckersTable().getModel().getValueAt(i, 0);
            if (!(obj instanceof StructureChecker)) continue;
            checkerList.add((StructureChecker)obj);
        }
        this.writer.writeConfiguration(checkerList, outputStream);
    }

    public void setPanelEnabled(boolean enabled) {
        this.editMode = enabled;
        ((CardLayout)this.getLayout()).show(this, enabled ? EDITOR_PAGE : MESSAGE_PAGE);
    }

    public boolean isPanelEnabled() {
        return this.editMode;
    }

    public void setAcceptAction(Action acceptAction) {
        this.acceptAction = acceptAction;
    }

    public Action getAcceptAction() {
        return this.acceptAction;
    }

    private CheckerTable getCheckersTable() {
        if (this.checkersTable == null) {
            this.checkersTable = new CheckerTable(CHECKER_COLUMN_TITLE, EMPTY_TABLE_MESSAGE);
            this.checkersTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    CheckerConfigurationPanel.this.updateActions();
                }
            });
            this.checkersTable.getPropertyChangeSupport().addPropertyChangeListener("VALID", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    CheckerConfigurationPanel.this.updateValidationState();
                }
            });
            this.checkersTable.getModel().addTableModelListener(new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent e) {
                    if (e.getType() == 1 || e.getType() == 0) {
                        CheckerConfigurationPanel.this.updateValidationState();
                    }
                }
            });
            this.updateActions();
        }
        return this.checkersTable;
    }

    private void updateValidationState() {
        if (this.acceptAction != null) {
            boolean valid = true;
            for (int i = 0; i < this.getCheckersTable().getModel().getRowCount() && valid; ++i) {
                Object value = this.getCheckersTable().getModel().getValueAt(i, 0);
                if (!(value instanceof StructureChecker)) continue;
                valid = ((StructureChecker)value).isValid();
            }
            this.acceptAction.setEnabled(valid);
        }
    }

    private JPopupMenu getAvailableCheckersMenu() {
        if (this.availableCheckersMenu == null) {
            this.availableCheckersMenu = new JPopupMenu();
            JScrollPane scroll = new JScrollPane(20, 31);
            scroll.setViewportView(this.getPopupList());
            this.availableCheckersMenu.add(this.getPopupFilterText());
            this.availableCheckersMenu.add(scroll);
            this.availableCheckersMenu.setPopupSize(350, 450);
        }
        return this.availableCheckersMenu;
    }

    private JFileChooser getFileChooser() {
        if (this.fileChooser == null) {
            try {
                this.fileChooser = new JFileChooser();
                this.fileChooser.setFileFilter(new FileFilter(){

                    @Override
                    public boolean accept(File f) {
                        return f.isDirectory() || f.getAbsolutePath().toLowerCase().endsWith(".xml");
                    }

                    @Override
                    public String getDescription() {
                        return "Structure Checker Configuration (*.xml)";
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.fileChooser;
    }

    private JTextField getPopupFilterText() {
        if (this.popupFilterText == null) {
            this.popupFilterText = new JTextField(){
                private static final long serialVersionUID = -517441470284843554L;

                @Override
                protected void paintComponent(Graphics g) {
                    super.paintComponent(g);
                    if ("".equalsIgnoreCase(this.getText())) {
                        Graphics2D g2 = (Graphics2D)g.create();
                        g2.setColor(Color.LIGHT_GRAY);
                        int width = SwingUtilities.computeStringWidth(this.getFontMetrics(this.getFont()), CheckerConfigurationPanel.FILTER_HELP);
                        g2.drawString(CheckerConfigurationPanel.FILTER_HELP, (this.getWidth() - width) / 2, (this.getHeight() + this.getFont().getSize()) / 2);
                        g2.dispose();
                    }
                }
            };
            this.popupFilterText.getDocument().addDocumentListener(new DocumentListener(){

                private void handleChanges(DocumentEvent e) {
                    ListModel model = CheckerConfigurationPanel.this.getPopupList().getModel();
                    if (model instanceof AbstractFilterListModel) {
                        ((AbstractFilterListModel)model).filter();
                    }
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.handleChanges(e);
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.handleChanges(e);
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.handleChanges(e);
                }
            });
        }
        return this.popupFilterText;
    }

    private JList getPopupList() {
        if (this.popupList == null) {
            List<StructureChecker> checkerList = this.factory.getAvailableCheckers();
            Collections.sort(checkerList, new Comparator<StructureChecker>(){

                @Override
                public int compare(StructureChecker o1, StructureChecker o2) {
                    return o1.getDescriptor().getName().compareTo(o2.getDescriptor().getName());
                }
            });
            AbstractFilterListModel model = new AbstractFilterListModel(){
                private static final long serialVersionUID = -3032268995697117796L;

                @Override
                protected boolean filter(Object checker) {
                    if (checker instanceof StructureChecker) {
                        String haystack = ((StructureChecker)checker).getDescriptor().getName().toLowerCase() + " " + ((StructureChecker)checker).getDescriptor().getDescription().toLowerCase();
                        String[] needles = CheckerConfigurationPanel.this.getPopupFilterText().getText().trim().toLowerCase().split(" ");
                        for (int i = 0; i < needles.length; ++i) {
                            if (!haystack.contains(needles[i])) continue;
                            return true;
                        }
                    }
                    return false;
                }
            };
            for (StructureChecker checker : checkerList) {
                model.addElement(checker);
            }
            this.popupList = new JList();
            this.popupList.setModel(model);
            this.popupList.getSelectionModel().setSelectionMode(0);
            this.popupList.addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseMoved(MouseEvent e) {
                    int index = CheckerConfigurationPanel.this.popupList.locationToIndex(e.getPoint());
                    if (CheckerConfigurationPanel.this.popupList.getSelectedIndex() != index) {
                        CheckerConfigurationPanel.this.popupList.setSelectedIndex(index);
                    }
                }
            });
            this.popupList.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (CheckerConfigurationPanel.this.popupList.getSelectedIndex() != -1) {
                        CheckerConfigurationPanel.this.getCheckersTable().getModel().addRow(new Object[]{((StructureChecker)CheckerConfigurationPanel.this.popupList.getSelectedValue()).cloneItem()});
                        CheckerConfigurationPanel.this.getCheckersTable().scrollToRow(CheckerConfigurationPanel.this.getCheckersTable().getRowCount() - 1);
                        CheckerConfigurationPanel.this.getCheckersTable().setSelectedRow(CheckerConfigurationPanel.this.getCheckersTable().getRowCount() - 1);
                        CheckerConfigurationPanel.this.popupList.getSelectionModel().clearSelection();
                        CheckerConfigurationPanel.this.getAvailableCheckersMenu().setVisible(false);
                    }
                }
            });
            this.popupList.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 10 || e.getKeyCode() == 32) {
                        CheckerConfigurationPanel.this.getCheckersTable().getModel().addRow(new Object[]{((StructureChecker)CheckerConfigurationPanel.this.popupList.getSelectedValue()).cloneItem()});
                        CheckerConfigurationPanel.this.popupList.getSelectionModel().clearSelection();
                        CheckerConfigurationPanel.this.getAvailableCheckersMenu().setVisible(false);
                        CheckerConfigurationPanel.this.getCheckersTable().getViewport().repaint();
                    } else if (e.getKeyCode() == 27) {
                        CheckerConfigurationPanel.this.popupList.getSelectionModel().clearSelection();
                        CheckerConfigurationPanel.this.getAvailableCheckersMenu().setVisible(false);
                    }
                }
            });
            this.popupList.setCellRenderer(new CheckerCellRenderer(false));
        }
        return this.popupList;
    }

    private JToolBar getToolbar() {
        if (this.toolbar == null) {
            this.toolbar = new JToolBar(1);
            this.toolbar.add(this.getMoveUpButton());
            this.toolbar.add(this.getMoveDownButton());
            this.toolbar.add(this.getAddButton());
            this.toolbar.add(this.getRemoveButton());
            this.toolbar.add(this.getImportButton());
            this.toolbar.add(this.getExportButton());
            this.toolbar.setFloatable(false);
            this.toolbar.setRollover(true);
            this.toolbar.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        }
        return this.toolbar;
    }

    private void updateActions() {
        int index = this.getCheckersTable().getSelectedRow();
        this.REMOVE_ACTION.setEnabled(index != -1);
        this.MOVE_UP_ACTION.setEnabled(index > 0);
        this.MOVE_DOWN_ACTION.setEnabled(index > -1 && index < this.getCheckersTable().getRowCount() - 1);
    }

    private JButton getMoveUpButton() {
        if (this.moveUpButton == null) {
            this.moveUpButton = new JButton(this.MOVE_UP_ACTION);
            this.moveUpButton.setToolTipText("Move selected Checker upwards in list");
            this.moveUpButton.setIcon(new ImageIcon(this.getClass().getResource("/chemaxon/icons/marvin/checker/up.png")));
        }
        return this.moveUpButton;
    }

    private JButton getMoveDownButton() {
        if (this.moveDownButton == null) {
            this.moveDownButton = new JButton(this.MOVE_DOWN_ACTION);
            this.moveDownButton.setToolTipText("Move selected Checker downwards in list");
            this.moveDownButton.setIcon(new ImageIcon(this.getClass().getResource("/chemaxon/icons/marvin/checker/down.png")));
        }
        return this.moveDownButton;
    }

    private JButton getAddButton() {
        if (this.addButton == null) {
            this.addButton = new JButton(this.ADD_ACTION);
            this.addButton.setToolTipText("Add new Checker...");
            this.addButton.setIcon(new ImageIcon(this.getClass().getResource("/chemaxon/icons/marvin/checker/add.png")));
        }
        return this.addButton;
    }

    private JButton getRemoveButton() {
        if (this.removeButton == null) {
            this.removeButton = new JButton(this.REMOVE_ACTION);
            this.removeButton.setToolTipText("Remove selected Checker");
            this.removeButton.setIcon(new ImageIcon(this.getClass().getResource("/chemaxon/icons/marvin/checker/remove.png")));
        }
        return this.removeButton;
    }

    private JButton getImportButton() {
        if (this.importButton == null) {
            this.importButton = new JButton(this.IMPORT_ACTION);
            this.importButton.setToolTipText("Load Checker Configuration from file");
            this.importButton.setIcon(new ImageIcon(this.getClass().getResource("/chemaxon/icons/marvin/checker/open.png")));
        }
        return this.importButton;
    }

    private JButton getExportButton() {
        if (this.exportButton == null) {
            this.exportButton = new JButton(this.EXPORT_ACTION);
            this.exportButton.setToolTipText("Save Checker Configuration to file");
            this.exportButton.setIcon(new ImageIcon(this.getClass().getResource("/chemaxon/icons/marvin/checker/save.png")));
        }
        return this.exportButton;
    }
}

