/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.modules.checker;

import chemaxon.checkers.StructureChecker;
import chemaxon.marvin.sketch.swing.checker.editor.CheckerEditor;
import chemaxon.marvin.sketch.swing.modules.checker.editors.DefaultCheckerEditor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;

public class CheckerEditorInstanceProvider {
    protected static final Map<String, CheckerEditor> EDITOR_CACHE = new HashMap<String, CheckerEditor>();

    public static CheckerEditor getEditor(StructureChecker checker) {
        if (checker.getDescriptor().getEditorClassName() != null && !"".equals(checker.getDescriptor().getEditorClassName())) {
            CheckerEditor editor = EDITOR_CACHE.get(checker.getClass().getName());
            if (editor == null) {
                editor = CheckerEditorInstanceProvider.createAndCacheEditor(checker.getClass(), checker.getDescriptor().getEditorClassName());
            }
            return editor;
        }
        return null;
    }

    public static CheckerEditor getDefaultEditor() {
        CheckerEditor editor = EDITOR_CACHE.get(StructureChecker.class.getName());
        if (editor == null) {
            editor = CheckerEditorInstanceProvider.createAndCacheEditor(StructureChecker.class, DefaultCheckerEditor.class.getName());
        }
        return editor;
    }

    @Deprecated
    protected static CheckerEditor createAndCacheEditor(String checkerClassName, String editorClassName) {
        CheckerEditor editor = null;
        try {
            editor = CheckerEditorInstanceProvider.createAndCacheEditor(Class.forName(checkerClassName), editorClassName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return editor;
    }

    protected static CheckerEditor createAndCacheEditor(Class<? extends StructureChecker> checkerClass, String editorClassName) {
        try {
            Class<?> editorClass = Class.forName(editorClassName, false, checkerClass.getClassLoader());
            Constructor<?> constructor = editorClass.getConstructor(new Class[0]);
            Object editor = constructor.newInstance(new Object[0]);
            if (editor instanceof CheckerEditor) {
                EDITOR_CACHE.put(checkerClass.getName(), (CheckerEditor)editor);
                return (CheckerEditor)editor;
            }
        }
        catch (ClassNotFoundException e) {
            System.err.println("Class not found: " + editorClassName);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return null;
    }
}

