/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.modules.checker;

import chemaxon.checkers.result.StructureCheckerResult;
import chemaxon.checkers.runner.CheckerRunner;
import chemaxon.fixers.StructureFixer;
import chemaxon.marvin.sketch.swing.modules.checker.CheckerResultWrapper;
import chemaxon.marvin.sketch.swing.modules.checker.CheckerStatusbarComponent;
import chemaxon.marvin.sketch.swing.modules.checker.CheckerTable;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.StereoConstants;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class FixerSelectionPanel
extends JPanel {
    private static final long serialVersionUID = -5166069706593339180L;
    private static final String EMPTY_TABLE_MESSAGE = "There are no problems found.";
    private static final String IN_PROGRESS_MESSAGE = "Structure Checker is working, please wait...";
    private static final String INVALIDATED_MESSAGE = "Structure has been changed since last check.You can check manually by pressing the button.";
    private static final String AUTOCHECK_ENABLE_TEXT = "To automatically recheck molecule on every change, You can enable automatic structure checking.";
    private static final String FIXER_COLUMN_TITLE = "Problem list";
    private static final String TOOLTIP_EXTRA_FOR_NO_FIXERS = "<i>This problem can not be fixed</i>";
    private static final String TOOLTIP_EXTRA_FOR_FIXERS = "<i>You can apply a fix for this problem</i>";
    private static final String TOOLTIP_FIX_ALL = "Try to fix all problems in the list with the specified options.";
    private static final String TOOLTIP_FIX_SELECTED = "Try to fix the selected problem with the specified option.";
    private static final String TABLE_VIEW = "table";
    private static final String MESSAGE_VIEW = "message";
    private CheckerTable fixersTable = null;
    private JButton fixButton = null;
    private JButton fixAllButton = null;
    private JPanel tableHolder = null;
    private JPanel textPanel = null;
    private JButton recheckButton = null;
    private JButton autocheckButton = null;
    private JTextPane messageTextPart1 = null;
    private JTextPane messageTextPart2 = null;
    private boolean dirty = false;
    private CheckerRunner runner = null;
    private final CheckerStatusbarComponent checkerComponent;
    private final Action FIX_ACTION = new AbstractAction(){
        private static final long serialVersionUID = 9067591330161382902L;

        @Override
        public void actionPerformed(ActionEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FixerSelectionPanel.this.checkerComponent.performFix(FixerSelectionPanel.this.getSelectedResult());
                }
            });
        }
    };
    private final Action FIX_ALL_ACTION = new AbstractAction(){
        private static final long serialVersionUID = -244452693956384606L;

        @Override
        public void actionPerformed(ActionEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FixerSelectionPanel.this.checkerComponent.performFixAll();
                }
            });
        }
    };

    public FixerSelectionPanel(CheckerStatusbarComponent checkerComponent) {
        this.checkerComponent = checkerComponent;
        this.initComponents();
    }

    private void initComponents() {
        CellConstraints cc = new CellConstraints();
        FormLayout layout = new FormLayout("4dlu, fill:min:grow, min, 2dlu, min, 4dlu", "4dlu, fill:pref:grow, 2dlu, pref, 4dlu");
        layout.setColumnGroups((int[][])new int[][]{{3, 5}});
        this.setLayout((LayoutManager)layout);
        this.add((Component)this.getTableHolder(), cc.xyw(2, 2, 4));
        this.add((Component)this.getFixAllButton(), cc.xy(3, 4));
        this.add((Component)this.getFixButton(), cc.xy(5, 4));
        this.updateButtons();
    }

    public List<StructureFixer> getCurrentFixers() {
        ArrayList<StructureFixer> fixers = new ArrayList<StructureFixer>();
        for (int i = 0; i < this.getFixersTable().getRowCount(); ++i) {
            CheckerResultWrapper item = this.getResult(i);
            if (item == null || this.runner == null || item.getSelectedIndex() == -1) continue;
            List<StructureFixer> fixerList = this.runner.getFixers(item.getResult());
            fixers.add(fixerList.get(item.getSelectedIndex()));
        }
        return fixers;
    }

    public void clearSelection() {
        this.getFixersTable().getSelectionModel().clearSelection();
    }

    public CheckerResultWrapper getSelectedResult() {
        Object value;
        int row = this.getFixersTable().getSelectedRow();
        if (row != -1 && (value = this.getFixersTable().getModel().getValueAt(row, 0)) instanceof CheckerResultWrapper) {
            return (CheckerResultWrapper)value;
        }
        return null;
    }

    private CheckerResultWrapper getResult(int row) {
        Object value;
        if (row != -1 && (value = this.getFixersTable().getModel().getValueAt(row, 0)) instanceof CheckerResultWrapper) {
            return (CheckerResultWrapper)value;
        }
        return null;
    }

    private JTextPane getMessageTextPart1() {
        if (this.messageTextPart1 == null) {
            this.messageTextPart1 = new JTextPane();
            this.messageTextPart1.setBorder(null);
            this.messageTextPart1.setBackground(Color.WHITE);
            this.messageTextPart1.setForeground(Color.GRAY);
            this.messageTextPart1.setFocusable(false);
            this.messageTextPart1.setEditable(false);
            SimpleAttributeSet attribs = new SimpleAttributeSet();
            StyleConstants.setAlignment(attribs, 1);
            this.messageTextPart1.setParagraphAttributes(attribs, false);
        }
        return this.messageTextPart1;
    }

    private JTextPane getMessageTextPart2() {
        if (this.messageTextPart2 == null) {
            this.messageTextPart2 = new JTextPane();
            this.messageTextPart2.setBorder(null);
            this.messageTextPart2.setBackground(Color.WHITE);
            this.messageTextPart2.setForeground(Color.GRAY);
            this.messageTextPart2.setFocusable(false);
            this.messageTextPart2.setEditable(false);
            SimpleAttributeSet attribs = new SimpleAttributeSet();
            StyleConstants.setAlignment(attribs, 1);
            this.messageTextPart2.setParagraphAttributes(attribs, false);
            this.messageTextPart2.setText(AUTOCHECK_ENABLE_TEXT);
        }
        return this.messageTextPart2;
    }

    private JButton getRecheckButton() {
        if (this.recheckButton == null) {
            this.recheckButton = new JButton(new AbstractAction(){
                private static final long serialVersionUID = 9067591330161382902L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    FixerSelectionPanel.this.checkerComponent.performCheck();
                }
            });
            this.recheckButton.setText("Check structure again");
            this.recheckButton.setContentAreaFilled(false);
            this.recheckButton.setIcon(new ImageIcon(this.getClass().getResource("/chemaxon/icons/marvin/checker/recheck.png")));
        }
        return this.recheckButton;
    }

    private JButton getAutocheckButton() {
        if (this.autocheckButton == null) {
            this.autocheckButton = new JButton(new AbstractAction(){
                private static final long serialVersionUID = -244452693956384606L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    FixerSelectionPanel.this.checkerComponent.performCheck();
                    FixerSelectionPanel.this.checkerComponent.setAutoCheckEnabled(true);
                }
            });
            this.autocheckButton.setText("Enable automatic checking");
            this.autocheckButton.setContentAreaFilled(false);
        }
        return this.autocheckButton;
    }

    private JPanel getTextPanel() {
        if (this.textPanel == null) {
            this.textPanel = new JPanel();
            CellConstraints cc = new CellConstraints();
            this.textPanel.setLayout((LayoutManager)new FormLayout("4dlu, fill:pref:grow, pref, fill:pref:grow, 4dlu", "4dlu, fill:pref:grow, pref, 2dlu, pref, 16dlu, pref, 2dlu, pref, fill:pref:grow, 4dlu"));
            this.textPanel.add((Component)this.getMessageTextPart1(), cc.xyw(2, 3, 3));
            this.textPanel.add((Component)this.getRecheckButton(), cc.xy(3, 5));
            this.textPanel.add((Component)this.getMessageTextPart2(), cc.xyw(2, 7, 3));
            this.textPanel.add((Component)this.getAutocheckButton(), cc.xy(3, 9));
            this.textPanel.setBackground(Color.WHITE);
            this.textPanel.setBorder(BorderFactory.createLineBorder(Color.DARK_GRAY));
        }
        return this.textPanel;
    }

    public void showWaitView() {
        this.FIX_ACTION.setEnabled(false);
        this.FIX_ALL_ACTION.setEnabled(false);
        this.getMessageTextPart1().setText(IN_PROGRESS_MESSAGE);
        this.getMessageTextPart2().setVisible(false);
        this.getRecheckButton().setVisible(false);
        this.getAutocheckButton().setVisible(false);
        ((CardLayout)this.getTableHolder().getLayout()).show(this.getTableHolder(), MESSAGE_VIEW);
    }

    private void showTableView() {
        ((CardLayout)this.getTableHolder().getLayout()).show(this.getTableHolder(), TABLE_VIEW);
    }

    public void showInvalidatedView() {
        this.getMessageTextPart1().setText(INVALIDATED_MESSAGE);
        this.getMessageTextPart2().setVisible(true);
        this.getRecheckButton().setVisible(true);
        this.getAutocheckButton().setVisible(true);
        ((CardLayout)this.getTableHolder().getLayout()).show(this.getTableHolder(), MESSAGE_VIEW);
    }

    private JPanel getTableHolder() {
        if (this.tableHolder == null) {
            this.tableHolder = new JPanel();
            this.tableHolder.setLayout(new CardLayout());
            this.tableHolder.add((Component)this.getFixersTable(), TABLE_VIEW);
            this.tableHolder.add((Component)this.getTextPanel(), MESSAGE_VIEW);
        }
        return this.tableHolder;
    }

    private CheckerTable getFixersTable() {
        if (this.fixersTable == null) {
            this.fixersTable = new CheckerTable(FIXER_COLUMN_TITLE, EMPTY_TABLE_MESSAGE);
            this.fixersTable.setTooltipExtraForEditorSupport(TOOLTIP_EXTRA_FOR_FIXERS);
            this.fixersTable.setTooltipExtraForNoEditorSupport(TOOLTIP_EXTRA_FOR_NO_FIXERS);
            this.fixersTable.setPreferredSize(new Dimension(200, 200));
            this.fixersTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    FixerSelectionPanel.this.updateButtons();
                }
            });
        }
        return this.fixersTable;
    }

    private JButton getFixButton() {
        if (this.fixButton == null) {
            this.fixButton = new JButton(this.FIX_ACTION);
            this.fixButton.setText("Fix Selected");
            this.fixButton.setToolTipText(TOOLTIP_FIX_SELECTED);
            this.fixButton.setIcon(new ImageIcon(this.getClass().getResource("/chemaxon/icons/marvin/checker/fix.png")));
        }
        return this.fixButton;
    }

    private JButton getFixAllButton() {
        if (this.fixAllButton == null) {
            this.fixAllButton = new JButton(this.FIX_ALL_ACTION);
            this.fixAllButton.setText("Fix All");
            this.fixAllButton.setToolTipText(TOOLTIP_FIX_ALL);
            this.fixAllButton.setIcon(new ImageIcon(this.getClass().getResource("/chemaxon/icons/marvin/checker/fixall.png")));
        }
        return this.fixAllButton;
    }

    public void setCheckerResultList(CheckerRunner runner) {
        this.getFixersTable().clear();
        this.runner = runner;
        if (this.runner != null) {
            for (StructureCheckerResult result : this.runner.getResultList()) {
                this.getFixersTable().getModel().addRow(new Object[]{new CheckerResultWrapper(runner, result)});
            }
        }
        this.setDirty(false);
        this.showTableView();
        this.getFixersTable().repaint();
    }

    private boolean canFixSelected() {
        CheckerResultWrapper resultItem = this.getSelectedResult();
        return resultItem == null || this.runner == null ? false : !this.runner.getFixers(resultItem).isEmpty();
    }

    private boolean canFixAny() {
        for (int i = 0; i < this.getFixersTable().getModel().getRowCount(); ++i) {
            Object value = this.getFixersTable().getModel().getValueAt(i, 0);
            if (this.runner == null || !(value instanceof CheckerResultWrapper)) continue;
            CheckerResultWrapper item = (CheckerResultWrapper)value;
            return !this.runner.getFixers(item).isEmpty();
        }
        return false;
    }

    private void updateButtons() {
        this.FIX_ACTION.setEnabled(!this.dirty && this.canFixSelected());
        this.FIX_ALL_ACTION.setEnabled(!this.dirty && this.canFixAny());
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
        this.updateButtons();
    }

    public void updateObjectAtPointer(Object object) {
        for (int i = 0; i < this.getFixersTable().getRowCount(); ++i) {
            Object obj = this.getFixersTable().getModel().getValueAt(i, 0);
            if (!(obj instanceof CheckerResultWrapper)) continue;
            CheckerResultWrapper item = (CheckerResultWrapper)obj;
            item.setHighlighted(false);
            if (object == null || !(object instanceof MolAtom) && !(object instanceof MolBond)) continue;
            List<StereoConstants> list = object instanceof MolAtom ? item.getResult().getAtoms() : item.getResult().getBonds();
            for (int j = 0; j < list.size() && !item.isHighlighted(); ++j) {
                if (list.get(j) != object) continue;
                item.setHighlighted(true);
            }
        }
        this.getFixersTable().repaint();
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        this.getFixersTable().getSelectionModel().addListSelectionListener(listener);
    }

    public void removeListSelectionListener(ListSelectionListener listener) {
        this.getFixersTable().getSelectionModel().removeListSelectionListener(listener);
    }
}

