/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.modules.checker.editors;

import chemaxon.checkers.AbbreviatedGroupChecker;
import chemaxon.checkers.StructureChecker;
import chemaxon.marvin.sketch.swing.modules.checker.editors.DefaultCheckerEditor;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class AbbreviatedGroupCheckerEditor
extends DefaultCheckerEditor {
    private AbbreviatedGroupChecker checker = null;
    private JPanel controlPanel = null;
    private JRadioButton contractedOption = null;
    private JRadioButton expandedOption = null;
    private JRadioButton bothOption = null;
    private final Action UPDATE_ITEM = new AbstractAction(){
        private static final long serialVersionUID = -4202713533761800941L;

        @Override
        public void actionPerformed(ActionEvent e) {
            AbbreviatedGroupCheckerEditor.this.checker.setSearchExpanded(AbbreviatedGroupCheckerEditor.this.getExpandedOption().isSelected() || AbbreviatedGroupCheckerEditor.this.getBothOption().isSelected());
            AbbreviatedGroupCheckerEditor.this.checker.setSearchContracted(AbbreviatedGroupCheckerEditor.this.getContractedOption().isSelected() || AbbreviatedGroupCheckerEditor.this.getBothOption().isSelected());
        }
    };

    public AbbreviatedGroupCheckerEditor() {
        ButtonGroup group = new ButtonGroup();
        group.add(this.getContractedOption());
        group.add(this.getExpandedOption());
        group.add(this.getBothOption());
    }

    @Override
    public JComponent getEditorComponent(StructureChecker checker) {
        if (checker instanceof AbbreviatedGroupChecker) {
            this.checker = (AbbreviatedGroupChecker)checker;
            if (this.checker.isSearchExpanded() && !this.checker.isSearchContracted()) {
                this.getExpandedOption().setSelected(true);
            } else if (this.checker.isSearchContracted() && !this.checker.isSearchExpanded()) {
                this.getContractedOption().setSelected(true);
            } else {
                this.getBothOption().setSelected(true);
            }
        }
        return super.getEditorComponent(checker);
    }

    @Override
    protected Component getCustomComponent() {
        if (this.controlPanel == null) {
            this.controlPanel = new JPanel();
            this.controlPanel.setBorder(BorderFactory.createLineBorder(Color.BLACK));
            this.controlPanel.setBackground(Color.WHITE);
            this.controlPanel.setLayout((LayoutManager)new FormLayout("4dlu, fill:pref:grow, 4dlu", "4dlu, min, 2dlu, min, 2dlu, min, 4dlu"));
            this.controlPanel.add((Component)this.getExpandedOption(), CC.xy(2, 2));
            this.controlPanel.add((Component)this.getContractedOption(), CC.xy(2, 4));
            this.controlPanel.add((Component)this.getBothOption(), CC.xy(2, 6));
        }
        return this.controlPanel;
    }

    private JRadioButton getContractedOption() {
        if (this.contractedOption == null) {
            this.contractedOption = new JRadioButton(this.UPDATE_ITEM);
            this.contractedOption.setOpaque(false);
            this.contractedOption.setText("Detect Contracted Groups");
        }
        return this.contractedOption;
    }

    private JRadioButton getExpandedOption() {
        if (this.expandedOption == null) {
            this.expandedOption = new JRadioButton(this.UPDATE_ITEM);
            this.expandedOption.setOpaque(false);
            this.expandedOption.setText("Detect Expanded Groups");
        }
        return this.expandedOption;
    }

    private JRadioButton getBothOption() {
        if (this.bothOption == null) {
            this.bothOption = new JRadioButton(this.UPDATE_ITEM);
            this.bothOption.setOpaque(false);
            this.bothOption.setText("Detect All Groups");
        }
        return this.bothOption;
    }

    @Override
    public String getConfigurationInfo(StructureChecker checker) {
        AbbreviatedGroupChecker abbrevChecker = null;
        if (checker instanceof AbbreviatedGroupChecker) {
            abbrevChecker = (AbbreviatedGroupChecker)checker;
        }
        if (abbrevChecker != null) {
            if (abbrevChecker.isSearchExpanded() && !abbrevChecker.isSearchContracted()) {
                return this.getExpandedOption().getText();
            }
            if (abbrevChecker.isSearchContracted() && !abbrevChecker.isSearchExpanded()) {
                return this.getContractedOption().getText();
            }
            if (abbrevChecker.isSearchExpanded() && abbrevChecker.isSearchContracted()) {
                return this.getBothOption().getText();
            }
        }
        return null;
    }
}

