/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.modules.checker.editors;

import chemaxon.checkers.AromaticityErrorChecker;
import chemaxon.checkers.StructureChecker;
import chemaxon.marvin.sketch.swing.modules.checker.editors.DefaultCheckerEditor;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class AromaticityErrorCheckerEditor
extends DefaultCheckerEditor {
    private AromaticityErrorChecker checker = null;
    private JPanel controlPanel = null;
    private JRadioButton generalRadio = null;
    private JRadioButton basicRadio = null;
    private JRadioButton looseRadio = null;
    private final ButtonGroup BUTTON_GROUP = new ButtonGroup();

    @Override
    public JComponent getEditorComponent(StructureChecker checker) {
        if (checker instanceof AromaticityErrorChecker) {
            this.checker = (AromaticityErrorChecker)checker;
            switch (this.checker.getType()) {
                case 1: {
                    this.getBasicRadio().setSelected(true);
                    break;
                }
                case 2: {
                    this.getGeneralRadio().setSelected(true);
                    break;
                }
                case 3: {
                    this.getLooseRadio().setSelected(true);
                }
            }
        }
        return super.getEditorComponent(checker);
    }

    @Override
    protected Component getCustomComponent() {
        if (this.controlPanel == null) {
            this.controlPanel = new JPanel();
            this.controlPanel.setBorder(BorderFactory.createLineBorder(Color.BLACK));
            this.controlPanel.setBackground(Color.WHITE);
            this.controlPanel.setLayout((LayoutManager)new FormLayout("4dlu, pref, 4dlu", "4dlu, min, 2dlu, min, 2dlu, min, 4dlu"));
            this.controlPanel.add((Component)this.getGeneralRadio(), CC.xy(2, 2));
            this.controlPanel.add((Component)this.getBasicRadio(), CC.xy(2, 4));
            this.controlPanel.add((Component)this.getLooseRadio(), CC.xy(2, 6));
        }
        return this.controlPanel;
    }

    private JRadioButton getGeneralRadio() {
        if (this.generalRadio == null) {
            this.generalRadio = new JRadioButton(new AbstractAction(){
                private static final long serialVersionUID = -5901355106709047447L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (AromaticityErrorCheckerEditor.this.generalRadio.isSelected()) {
                        AromaticityErrorCheckerEditor.this.checker.setType(2);
                    }
                }
            });
            this.generalRadio.setOpaque(false);
            this.generalRadio.setText("General");
            this.BUTTON_GROUP.add(this.generalRadio);
        }
        return this.generalRadio;
    }

    private JRadioButton getBasicRadio() {
        if (this.basicRadio == null) {
            this.basicRadio = new JRadioButton(new AbstractAction(){
                private static final long serialVersionUID = -2321710464624491913L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (AromaticityErrorCheckerEditor.this.basicRadio.isSelected()) {
                        AromaticityErrorCheckerEditor.this.checker.setType(1);
                    }
                }
            });
            this.basicRadio.setOpaque(false);
            this.basicRadio.setText("Basic");
            this.BUTTON_GROUP.add(this.basicRadio);
        }
        return this.basicRadio;
    }

    private JRadioButton getLooseRadio() {
        if (this.looseRadio == null) {
            this.looseRadio = new JRadioButton(new AbstractAction(){
                private static final long serialVersionUID = -1043606582551579394L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (AromaticityErrorCheckerEditor.this.looseRadio.isSelected()) {
                        AromaticityErrorCheckerEditor.this.checker.setType(3);
                    }
                }
            });
            this.looseRadio.setText("Loose");
            this.looseRadio.setOpaque(false);
            this.BUTTON_GROUP.add(this.looseRadio);
        }
        return this.looseRadio;
    }

    @Override
    public String getConfigurationInfo(StructureChecker checker) {
        AromaticityErrorChecker aromChecker = null;
        if (checker instanceof AromaticityErrorChecker) {
            aromChecker = (AromaticityErrorChecker)checker;
        }
        if (aromChecker != null) {
            if (aromChecker.getType() == 2) {
                return this.getGeneralRadio().getText();
            }
            if (aromChecker.getType() == 1) {
                return this.getBasicRadio().getText();
            }
            if (aromChecker.getType() == 3) {
                return this.getLooseRadio().getText();
            }
        }
        return null;
    }
}

