/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.modules.checker.editors;

import chemaxon.checkers.AtomQueryPropertyChecker;
import chemaxon.checkers.StructureChecker;
import chemaxon.marvin.sketch.swing.modules.checker.editors.DefaultCheckerEditor;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class AtomQueryPropertyCheckerEditor
extends DefaultCheckerEditor {
    private AtomQueryPropertyChecker checker = null;
    private JPanel controlPanel = null;
    private JCheckBox hydrogenCountCheck = null;
    private JCheckBox connectionCountCheck = null;
    private JCheckBox explicitConnectionCountCheck = null;
    private JCheckBox ringCountCheck = null;
    private JCheckBox implicitHydrogenCountCheck = null;
    private JCheckBox smallestRingSizeCheck = null;
    private JCheckBox aromaticityCheck = null;
    private JCheckBox substitutionCountCheck = null;
    private JCheckBox unsaturationCheck = null;
    private JCheckBox ringBondCountCheck = null;

    @Override
    public JComponent getEditorComponent(StructureChecker item) {
        if (item instanceof AtomQueryPropertyChecker) {
            this.checker = (AtomQueryPropertyChecker)item;
            this.getHydrogenCountCheck().setSelected(this.checker.isHydrogenCountChecking());
            this.getConnectionCountCheck().setSelected(this.checker.isConnectionCountChecking());
            this.getExplicitConnectionCountCheck().setSelected(this.checker.isExplicitConnectionCountChecking());
            this.getRingCountCheck().setSelected(this.checker.isRingCountChecking());
            this.getImplicitHydrogenCountCheck().setSelected(this.checker.isImplicitHydrogenCountChecking());
            this.getSmallestRingSizeCheck().setSelected(this.checker.isSmallestRingSizeChecking());
            this.getAromaticityCheck().setSelected(this.checker.isAromaticityChecking());
            this.getSubstitutionCountCheck().setSelected(this.checker.isSubstitutionCountChecking());
            this.getUnsaturationCheck().setSelected(this.checker.isUnsaturationChecking());
            this.getRingBondCountCheck().setSelected(this.checker.isRingBondCountChecking());
        }
        return super.getEditorComponent(item);
    }

    @Override
    protected Component getCustomComponent() {
        if (this.controlPanel == null) {
            this.controlPanel = new JPanel();
            this.controlPanel.setBorder(BorderFactory.createLineBorder(Color.BLACK));
            this.controlPanel.setBackground(Color.WHITE);
            this.controlPanel.setLayout((LayoutManager)new FormLayout("4dlu, min, 2dlu, min, 2dlu, min, 4dlu", "4dlu, min, 2dlu, min, 2dlu, min, 2dlu, min, 4dlu"));
            this.controlPanel.add((Component)this.getHydrogenCountCheck(), CC.xy(2, 2));
            this.controlPanel.add((Component)this.getConnectionCountCheck(), CC.xy(4, 2));
            this.controlPanel.add((Component)this.getRingBondCountCheck(), CC.xy(6, 2));
            this.controlPanel.add((Component)this.getRingCountCheck(), CC.xy(2, 4));
            this.controlPanel.add((Component)this.getImplicitHydrogenCountCheck(), CC.xy(4, 4));
            this.controlPanel.add((Component)this.getSmallestRingSizeCheck(), CC.xy(6, 4));
            this.controlPanel.add((Component)this.getAromaticityCheck(), CC.xy(2, 6));
            this.controlPanel.add((Component)this.getSubstitutionCountCheck(), CC.xy(4, 6));
            this.controlPanel.add((Component)this.getUnsaturationCheck(), CC.xy(6, 6));
            this.controlPanel.add((Component)this.getExplicitConnectionCountCheck(), CC.xyw(2, 8, 3));
        }
        return this.controlPanel;
    }

    private JCheckBox getHydrogenCountCheck() {
        if (this.hydrogenCountCheck == null) {
            this.hydrogenCountCheck = new JCheckBox(new AbstractAction("Hydrogen Count"){
                private static final long serialVersionUID = 2059429746877952793L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    AtomQueryPropertyCheckerEditor.this.checker.setHydrogenCountChecking(AtomQueryPropertyCheckerEditor.this.getHydrogenCountCheck().isSelected());
                }
            });
            this.hydrogenCountCheck.setOpaque(false);
        }
        return this.hydrogenCountCheck;
    }

    private JCheckBox getConnectionCountCheck() {
        if (this.connectionCountCheck == null) {
            this.connectionCountCheck = new JCheckBox(new AbstractAction("Connection Count"){
                private static final long serialVersionUID = -6415293436737024845L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    AtomQueryPropertyCheckerEditor.this.checker.setConnectionCountChecking(AtomQueryPropertyCheckerEditor.this.getConnectionCountCheck().isSelected());
                }
            });
            this.connectionCountCheck.setOpaque(false);
        }
        return this.connectionCountCheck;
    }

    private JCheckBox getExplicitConnectionCountCheck() {
        if (this.explicitConnectionCountCheck == null) {
            this.explicitConnectionCountCheck = new JCheckBox(new AbstractAction("Explicit Connection Count"){
                private static final long serialVersionUID = -4677202211877429314L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    AtomQueryPropertyCheckerEditor.this.checker.setExplicitConnectionCountChecking(AtomQueryPropertyCheckerEditor.this.getExplicitConnectionCountCheck().isSelected());
                }
            });
            this.explicitConnectionCountCheck.setOpaque(false);
        }
        return this.explicitConnectionCountCheck;
    }

    private JCheckBox getRingCountCheck() {
        if (this.ringCountCheck == null) {
            this.ringCountCheck = new JCheckBox(new AbstractAction("Ring Count"){
                private static final long serialVersionUID = 4817997204440132153L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    AtomQueryPropertyCheckerEditor.this.checker.setRingCountChecking(AtomQueryPropertyCheckerEditor.this.getRingCountCheck().isSelected());
                }
            });
            this.ringCountCheck.setOpaque(false);
        }
        return this.ringCountCheck;
    }

    private JCheckBox getImplicitHydrogenCountCheck() {
        if (this.implicitHydrogenCountCheck == null) {
            this.implicitHydrogenCountCheck = new JCheckBox(new AbstractAction("Implicit Hydrogen Count"){
                private static final long serialVersionUID = -2898568649901961431L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    AtomQueryPropertyCheckerEditor.this.checker.setImplicitHydrogenCountChecking(AtomQueryPropertyCheckerEditor.this.getImplicitHydrogenCountCheck().isSelected());
                }
            });
            this.implicitHydrogenCountCheck.setOpaque(false);
        }
        return this.implicitHydrogenCountCheck;
    }

    private JCheckBox getSmallestRingSizeCheck() {
        if (this.smallestRingSizeCheck == null) {
            this.smallestRingSizeCheck = new JCheckBox(new AbstractAction("Smalles Ring Size"){
                private static final long serialVersionUID = -246682656804718999L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    AtomQueryPropertyCheckerEditor.this.checker.setSmallestRingSizeChecking(AtomQueryPropertyCheckerEditor.this.getSmallestRingSizeCheck().isSelected());
                }
            });
            this.smallestRingSizeCheck.setOpaque(false);
        }
        return this.smallestRingSizeCheck;
    }

    private JCheckBox getAromaticityCheck() {
        if (this.aromaticityCheck == null) {
            this.aromaticityCheck = new JCheckBox(new AbstractAction("Aromacity"){
                private static final long serialVersionUID = 8535247634642895251L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    AtomQueryPropertyCheckerEditor.this.checker.setAromaticityChecking(AtomQueryPropertyCheckerEditor.this.getAromaticityCheck().isSelected());
                }
            });
            this.aromaticityCheck.setOpaque(false);
        }
        return this.aromaticityCheck;
    }

    private JCheckBox getSubstitutionCountCheck() {
        if (this.substitutionCountCheck == null) {
            this.substitutionCountCheck = new JCheckBox(new AbstractAction("Substitution Count"){
                private static final long serialVersionUID = -5797759577051598727L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    AtomQueryPropertyCheckerEditor.this.checker.setSubstitutionCountChecking(AtomQueryPropertyCheckerEditor.this.getSubstitutionCountCheck().isSelected());
                }
            });
            this.substitutionCountCheck.setOpaque(false);
        }
        return this.substitutionCountCheck;
    }

    private JCheckBox getUnsaturationCheck() {
        if (this.unsaturationCheck == null) {
            this.unsaturationCheck = new JCheckBox(new AbstractAction("Unsaturation"){
                private static final long serialVersionUID = 7771645797810744544L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    AtomQueryPropertyCheckerEditor.this.checker.setUnsaturationChecking(AtomQueryPropertyCheckerEditor.this.getUnsaturationCheck().isSelected());
                }
            });
            this.unsaturationCheck.setOpaque(false);
        }
        return this.unsaturationCheck;
    }

    private JCheckBox getRingBondCountCheck() {
        if (this.ringBondCountCheck == null) {
            this.ringBondCountCheck = new JCheckBox(new AbstractAction("Ring Bond Count"){
                private static final long serialVersionUID = 1919478814522627376L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    AtomQueryPropertyCheckerEditor.this.checker.setRingBondCountChecking(AtomQueryPropertyCheckerEditor.this.getRingBondCountCheck().isSelected());
                }
            });
            this.ringBondCountCheck.setOpaque(false);
        }
        return this.ringBondCountCheck;
    }

    @Override
    public String getConfigurationInfo(StructureChecker checker) {
        AtomQueryPropertyChecker aqpcChecker = null;
        if (checker instanceof AtomQueryPropertyChecker) {
            aqpcChecker = (AtomQueryPropertyChecker)checker;
        }
        ArrayList<String> items = new ArrayList<String>();
        if (aqpcChecker != null) {
            if (aqpcChecker.isAromaticityChecking()) {
                items.add(this.getAromaticityCheck().getText());
            }
            if (aqpcChecker.isConnectionCountChecking()) {
                items.add(this.getConnectionCountCheck().getText());
            }
            if (aqpcChecker.isExplicitConnectionCountChecking()) {
                items.add(this.getExplicitConnectionCountCheck().getText());
            }
            if (aqpcChecker.isHydrogenCountChecking()) {
                items.add(this.getHydrogenCountCheck().getText());
            }
            if (aqpcChecker.isImplicitHydrogenCountChecking()) {
                items.add(this.getImplicitHydrogenCountCheck().getText());
            }
            if (aqpcChecker.isRingBondCountChecking()) {
                items.add(this.getRingBondCountCheck().getText());
            }
            if (aqpcChecker.isRingCountChecking()) {
                items.add(this.getRingCountCheck().getText());
            }
            if (aqpcChecker.isSmallestRingSizeChecking()) {
                items.add(this.getSmallestRingSizeCheck().getText());
            }
            if (aqpcChecker.isSubstitutionCountChecking()) {
                items.add(this.getSubstitutionCountCheck().getText());
            }
            if (aqpcChecker.isUnsaturationChecking()) {
                items.add(this.getUnsaturationCheck().getText());
            }
        }
        if (items.isEmpty()) {
            return "No options selected.";
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < items.size(); ++i) {
            builder.append((String)items.get(i));
            if (i < items.size() - 2) {
                builder.append(", ");
                continue;
            }
            if (i >= items.size() - 1) continue;
            builder.append(" and ");
        }
        return builder.toString();
    }
}

