/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.modules.checker.editors;

import chemaxon.checkers.StructureChecker;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class BasicCheckerEditor {
    protected static final CellConstraints CC = new CellConstraints();
    protected JPanel component = null;
    protected JLabel captionLabel = null;
    protected JTextField nameText = null;
    protected JLabel descriptionLabel = null;

    protected BasicCheckerEditor(boolean renamable) {
        this.setRenamable(renamable);
    }

    protected JPanel getComponent() {
        if (this.component == null) {
            this.component = new JPanel();
            this.component.setBackground(Color.LIGHT_GRAY);
            this.component.setLayout((LayoutManager)new FormLayout("4dlu, min, 2dlu, fill:min:grow, 4dlu", "4dlu, min, 2dlu, min, 2dlu, pref, 8dlu"));
            this.component.add((Component)this.getCaptionLabel(), CC.xy(2, 2));
            this.component.add((Component)this.getNameText(), CC.xy(4, 2));
            this.component.add((Component)this.getDescriptionLabel(), CC.xyw(2, 4, 3));
            Component custom = this.getCustomComponent();
            if (custom != null) {
                this.component.add(custom, CC.xyw(2, 6, 4));
            }
        }
        return this.component;
    }

    public Component getUndecoratedEditorComponent() {
        return this.getCustomComponent();
    }

    protected JLabel getCaptionLabel() {
        if (this.captionLabel == null) {
            this.captionLabel = new JLabel();
            this.captionLabel.setForeground(Color.RED);
            this.captionLabel.setOpaque(false);
        }
        return this.captionLabel;
    }

    protected JTextField getNameText() {
        if (this.nameText == null) {
            this.nameText = new JTextField();
            this.nameText.setBorder(null);
            this.nameText.setFont(this.getCaptionLabel().getFont());
            this.nameText.setOpaque(false);
        }
        return this.nameText;
    }

    protected JLabel getDescriptionLabel() {
        if (this.descriptionLabel == null) {
            this.descriptionLabel = new JLabel();
            this.descriptionLabel.setOpaque(false);
        }
        return this.descriptionLabel;
    }

    protected Component getCustomComponent() {
        return null;
    }

    public String getConfigurationInfo(StructureChecker checker) {
        return "";
    }

    public boolean isRenamable() {
        return this.getNameText().isEditable();
    }

    protected void setRenamable(boolean renamable) {
        this.getNameText().setFocusable(renamable);
        this.getNameText().setEditable(renamable);
        if (renamable) {
            this.getNameText().setBorder(BorderFactory.createLineBorder(new Color(210, 210, 210)));
        } else {
            this.getNameText().setBorder(null);
        }
    }
}

