/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.modules.checker.editors;

import chemaxon.checkers.result.StructureCheckerResult;
import chemaxon.checkers.runner.CheckerRunner;
import chemaxon.fixers.StructureFixer;
import chemaxon.marvin.sketch.swing.checker.editor.CheckerResultEditor;
import chemaxon.marvin.sketch.swing.modules.checker.CheckerResultWrapper;
import chemaxon.marvin.sketch.swing.modules.checker.editors.BasicCheckerEditor;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class DefaultCheckerResultEditor
extends BasicCheckerEditor
implements CheckerResultEditor {
    private static final Color HIGLIGHT_COLOR = new Color(255, 200, 0, 50);
    private static final Color SELECTED_HIGLIGHT_COLOR = new Color(205, 150, 50, 100);
    private StructureCheckerResult result = null;
    private JPanel fixerPanel = null;
    private final ButtonGroup fixOptionGroup = new ButtonGroup();
    private final List<JRadioButton> fixOptionsList = new ArrayList<JRadioButton>();
    private final AbstractAction checkerAction = new AbstractAction(){
        private static final long serialVersionUID = -4493123073215656664L;

        @Override
        public void actionPerformed(ActionEvent e) {
            int index = DefaultCheckerResultEditor.this.fixOptionsList.indexOf(e.getSource());
            if (DefaultCheckerResultEditor.this.result instanceof CheckerResultWrapper) {
                ((CheckerResultWrapper)DefaultCheckerResultEditor.this.result).setSelectedIndex(index);
            }
        }
    };

    public DefaultCheckerResultEditor() {
        super(false);
    }

    @Override
    protected JPanel getComponent() {
        if (this.component == null) {
            this.component = new JPanel(){
                private static final long serialVersionUID = -326069507445534456L;

                @Override
                protected void paintComponent(Graphics g) {
                    if (DefaultCheckerResultEditor.this.result instanceof CheckerResultWrapper && ((CheckerResultWrapper)DefaultCheckerResultEditor.this.result).isHighlighted()) {
                        Graphics2D g2 = (Graphics2D)g.create();
                        g2.setColor(this.getBackground().equals(Color.LIGHT_GRAY) ? SELECTED_HIGLIGHT_COLOR : HIGLIGHT_COLOR);
                        g2.setBackground(Color.WHITE);
                        g2.clearRect(0, 0, this.getWidth(), this.getHeight());
                        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
                        g2.dispose();
                    } else {
                        super.paintComponent(g);
                    }
                }
            };
            this.component.setBackground(Color.LIGHT_GRAY);
            this.component.setLayout((LayoutManager)new FormLayout("4dlu, min, 2dlu, fill:min:grow, 4dlu", "4dlu, min, 2dlu, min, 2dlu, pref, 8dlu"));
            this.component.add((Component)this.getCaptionLabel(), CC.xy(2, 2));
            this.component.add((Component)this.getNameText(), CC.xy(4, 2));
            this.component.add((Component)this.getDescriptionLabel(), CC.xyw(2, 4, 3));
            this.component.add(this.getCustomComponent(), CC.xyw(2, 6, 3));
        }
        return this.component;
    }

    @Override
    public JComponent getEditorComponent(StructureCheckerResult result) {
        JRadioButton radioButton;
        this.result = result;
        this.getCaptionLabel().setIcon(result.getSource().getDescriptor().getIcon());
        this.getNameText().setText(result.getSource().getDescriptor().getName());
        this.getDescriptionLabel().setText(result.getDescription());
        List<Object> fixers = Collections.emptyList();
        if (result instanceof CheckerResultWrapper) {
            CheckerRunner runner = ((CheckerResultWrapper)result).getRunner();
            fixers = runner.getFixers(((CheckerResultWrapper)result).getResult());
        }
        while (fixers.size() > this.fixOptionsList.size()) {
            radioButton = new JRadioButton();
            radioButton.setOpaque(false);
            radioButton.addActionListener(this.checkerAction);
            this.fixOptionsList.add(radioButton);
            this.fixOptionGroup.add(radioButton);
            this.getFixerPanel().add(radioButton);
        }
        while (fixers.size() < this.fixOptionsList.size()) {
            radioButton = this.fixOptionsList.remove(this.fixOptionsList.size() - 1);
            this.fixOptionGroup.remove(radioButton);
            this.getFixerPanel().remove(radioButton);
            radioButton.removeActionListener(this.checkerAction);
        }
        for (int i = 0; i < fixers.size(); ++i) {
            this.fixOptionsList.get(i).setText(((StructureFixer)fixers.get(i)).getName());
            this.fixOptionsList.get(i).setToolTipText(((StructureFixer)fixers.get(i)).getDescription());
        }
        if (result instanceof CheckerResultWrapper && ((CheckerResultWrapper)result).getSelectedIndex() > -1 && ((CheckerResultWrapper)result).getSelectedIndex() < this.fixOptionsList.size()) {
            this.fixOptionsList.get(((CheckerResultWrapper)result).getSelectedIndex()).setSelected(true);
        }
        this.getFixerPanel().setVisible(!this.fixOptionsList.isEmpty());
        return this.getComponent();
    }

    @Override
    protected Component getCustomComponent() {
        return this.getFixerPanel();
    }

    private JPanel getFixerPanel() {
        if (this.fixerPanel == null) {
            this.fixerPanel = new JPanel();
            this.fixerPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.BLACK), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
            this.fixerPanel.setBackground(Color.WHITE);
            this.fixerPanel.setLayout(new BoxLayout(this.fixerPanel, 1));
            this.fixerPanel.setAlignmentX(0.0f);
        }
        return this.fixerPanel;
    }

    public StructureCheckerResult getResult() {
        return this.result;
    }

    public int getPreferredHeight() {
        return this.component == null || this.component.getPreferredSize() == null ? 120 : (int)this.component.getPreferredSize().getHeight();
    }
}

