/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.modules.checker.editors;

import chemaxon.checkers.RgroupReferenceErrorChecker;
import chemaxon.checkers.StructureChecker;
import chemaxon.marvin.sketch.swing.modules.checker.editors.DefaultCheckerEditor;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class RgroupReferenceErrorCheckerEditor
extends DefaultCheckerEditor {
    private RgroupReferenceErrorChecker checker = null;
    private JPanel controlPanel = null;
    private JCheckBox missingRatomCheck = null;
    private JCheckBox missingRgroupCheck = null;
    private JCheckBox selfReferenceCheck = null;

    @Override
    public String getConfigurationInfo(StructureChecker checker) {
        RgroupReferenceErrorChecker citem = null;
        if (checker instanceof RgroupReferenceErrorChecker) {
            citem = (RgroupReferenceErrorChecker)checker;
        }
        ArrayList<String> items = new ArrayList<String>();
        if (citem != null) {
            if (citem.isSearchMissingRatom()) {
                items.add(this.getMissingRatomCheck().getText());
            }
            if (citem.isSearchMissingRgroup()) {
                items.add(this.getMissingRgroupCheck().getText());
            }
            if (citem.isSearchSelfReference()) {
                items.add(this.getSelfReferenceCheck().getText());
            }
        }
        if (items.isEmpty()) {
            return "No options selected.";
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < items.size(); ++i) {
            builder.append((String)items.get(i));
            if (i < items.size() - 2) {
                builder.append(", ");
                continue;
            }
            if (i >= items.size() - 1) continue;
            builder.append(" and ");
        }
        return builder.toString();
    }

    @Override
    protected Component getCustomComponent() {
        if (this.controlPanel == null) {
            this.controlPanel = new JPanel();
            this.controlPanel.setBorder(BorderFactory.createLineBorder(Color.BLACK));
            this.controlPanel.setBackground(Color.WHITE);
            this.controlPanel.setLayout((LayoutManager)new FormLayout("4dlu, min, 2dlu, min, 2dlu, min, 4dlu", "4dlu, min, 2dlu, min, 4dlu"));
            this.controlPanel.add((Component)this.getMissingRatomCheck(), CC.xy(2, 2));
            this.controlPanel.add((Component)this.getMissingRgroupCheck(), CC.xy(4, 2));
            this.controlPanel.add((Component)this.getSelfReferenceCheck(), CC.xy(2, 4));
        }
        return this.controlPanel;
    }

    @Override
    public JComponent getEditorComponent(StructureChecker checker) {
        if (checker instanceof RgroupReferenceErrorChecker) {
            this.checker = (RgroupReferenceErrorChecker)checker;
            this.getMissingRatomCheck().setSelected(this.checker.isSearchMissingRatom());
            this.getMissingRgroupCheck().setSelected(this.checker.isSearchMissingRgroup());
            this.getSelfReferenceCheck().setSelected(this.checker.isSearchSelfReference());
        }
        return super.getEditorComponent(checker);
    }

    private JCheckBox getMissingRatomCheck() {
        if (this.missingRatomCheck == null) {
            this.missingRatomCheck = new JCheckBox(new AbstractAction("Missing R-atom"){
                private static final long serialVersionUID = 1036761704516029160L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    RgroupReferenceErrorCheckerEditor.this.checker.setSearchMissingRatom(RgroupReferenceErrorCheckerEditor.this.getMissingRatomCheck().isSelected());
                }
            });
            this.missingRatomCheck.setOpaque(false);
        }
        return this.missingRatomCheck;
    }

    private JCheckBox getMissingRgroupCheck() {
        if (this.missingRgroupCheck == null) {
            this.missingRgroupCheck = new JCheckBox(new AbstractAction("Missing R-group"){
                private static final long serialVersionUID = 6526899122680225814L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    RgroupReferenceErrorCheckerEditor.this.checker.setSearchMissingRgroup(RgroupReferenceErrorCheckerEditor.this.getMissingRgroupCheck().isSelected());
                }
            });
            this.missingRgroupCheck.setOpaque(false);
        }
        return this.missingRgroupCheck;
    }

    private JCheckBox getSelfReferenceCheck() {
        if (this.selfReferenceCheck == null) {
            this.selfReferenceCheck = new JCheckBox(new AbstractAction("Self reference"){
                private static final long serialVersionUID = -8580069809558446657L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    RgroupReferenceErrorCheckerEditor.this.checker.setSearchSelfReference(RgroupReferenceErrorCheckerEditor.this.getSelfReferenceCheck().isSelected());
                }
            });
            this.selfReferenceCheck.setOpaque(false);
        }
        return this.selfReferenceCheck;
    }
}

