/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.modules.checker.editors;

import chemaxon.checkers.StructureChecker;
import chemaxon.checkers.SubstructureChecker;
import chemaxon.formats.MolFormatException;
import chemaxon.marvin.sketch.swing.modules.checker.editors.DefaultCheckerEditor;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class SubstructureCheckerEditor
extends DefaultCheckerEditor {
    private JPanel contentPanel = null;
    private JTextField smartsField = null;
    private SubstructureChecker checker = null;

    public SubstructureCheckerEditor() {
        super(true);
        this.getNameText().getDocument().addDocumentListener(new DocumentListener(){

            private void handleChanges(DocumentEvent e) {
                if (SubstructureCheckerEditor.this.checker != null) {
                    SubstructureCheckerEditor.this.checker.getDescriptor().setCustomName(SubstructureCheckerEditor.this.getNameText().getText());
                }
                SubstructureCheckerEditor.this.updateValidationStatus();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.handleChanges(e);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.handleChanges(e);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.handleChanges(e);
            }
        });
    }

    private JTextField getSmartsField() {
        if (this.smartsField == null) {
            this.smartsField = new JTextField();
            this.smartsField.getDocument().addDocumentListener(new DocumentListener(){

                private void handleChanges() {
                    try {
                        SubstructureCheckerEditor.this.checker.setReactionSmarts(SubstructureCheckerEditor.this.smartsField.getText());
                    }
                    catch (MolFormatException molFormatException) {
                        // empty catch block
                    }
                    SubstructureCheckerEditor.this.updateValidationStatus();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.handleChanges();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.handleChanges();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.handleChanges();
                }
            });
        }
        return this.smartsField;
    }

    @Override
    protected Component getCustomComponent() {
        if (this.contentPanel == null) {
            CellConstraints cc = new CellConstraints();
            this.contentPanel = new JPanel((LayoutManager)new FormLayout("4dlu, min, 2dlu, fill:min:grow, 4dlu", "4dlu, min, 4dlu"));
            this.contentPanel.setBorder(BorderFactory.createLineBorder(Color.BLACK));
            this.contentPanel.setBackground(Color.WHITE);
            this.contentPanel.add((Component)new JLabel("SMARTS"), cc.xy(2, 2));
            this.contentPanel.add((Component)this.getSmartsField(), cc.xy(4, 2));
        }
        return this.contentPanel;
    }

    @Override
    public JComponent getEditorComponent(StructureChecker checker) {
        if (checker instanceof SubstructureChecker) {
            this.checker = (SubstructureChecker)checker;
            this.getSmartsField().setText(((SubstructureChecker)checker).getReactionSmarts());
        }
        return super.getEditorComponent(checker);
    }
}

