/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.modules.periodic;

import chemaxon.marvin.common.swing.MolPanel;
import chemaxon.marvin.sketch.AtomSM;
import chemaxon.marvin.sketch.MolEditor;
import chemaxon.marvin.sketch.SketchMode;
import chemaxon.marvin.sketch.swing.SketchPanel;
import chemaxon.marvin.sketch.swing.modules.PeriodicSystemDialogImpl;
import chemaxon.marvin.sketch.swing.modules.periodic.AliasBuilder;
import chemaxon.marvin.sketch.swing.modules.periodic.CustomPropertyBuilder;
import chemaxon.marvin.sketch.swing.modules.periodic.PseudoBuilder;
import chemaxon.marvin.sketch.swing.modules.periodic.RGroupBuilder;
import chemaxon.marvin.sketch.swing.modules.periodic.SmartsBuilder;
import chemaxon.marvin.sketch.swing.modules.periodic.ValueBuilder;
import chemaxon.marvin.uif.action.support.ToggleButtonBinding;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.DefaultComponentFactory;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.layout.Sizes;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class AdvancedPanel
extends JPanel
implements PeriodicSystemDialogImpl.ToggleListener {
    private SketchPanel sketchPanel;
    private static final String GENERIC_TITLE_KEY = "GenericTitle";
    private static final String QUERY_PROP_TITLE_KEY = "QueryPropTitle";
    private static final String SPECIAL_TITLE_KEY = "SpecialTitle";
    private static final String GROUPS_TITLE_KEY = "GroupsTitle";
    private static final String RGROUPS_TITLE_KEY = "RGroupsTitle";
    private static final String CUSTOM_TITLE_KEY = "CustomTitle";
    private static ResourceBundle RESOURCES;
    private MouseListener advancedInfoMouseListener = null;
    private JTextArea advancedInfo;
    private Insets margin = new Insets(1, 1, 1, 1);
    private Vector<JToggleButton> advancedButtons = new Vector();
    private JTextField customPropertyValue;
    private JToggleButton rgroupButton;
    private JToggleButton aliasButton;
    private JToggleButton pseudoButton;
    private JToggleButton smartsButton;
    private JToggleButton valueButton;
    private JToggleButton noSelectionButton;
    private ButtonGroup group;
    private CustomPropertyBuilder customPropertyBuilder = null;
    private static final String ALIAS_KEY = "AliasButtonText";
    private static final String PSEUDO_KEY = "PseudoButtonText";
    private static final String SMARTS_KEY = "SMARTSButtonText";
    private static final String VALUE_KEY = "ValueButtonText";
    private static final String R_GROUP_KEY = "RGroupButtonText";
    private final Color highlightErrorColor = new Color(255, 200, 200);
    private PeriodicSystemDialogImpl.ToggleListener toggleListener = null;

    public AdvancedPanel(SketchPanel sketchPanel) {
        RESOURCES = MolPanel.getResourceBundle(this.getClass().getName());
        CellConstraints cc = new CellConstraints();
        this.sketchPanel = sketchPanel;
        this.setBorder(Borders.TABBED_DIALOG_BORDER);
        ColumnSpec[] cspec = new ColumnSpec[34];
        cspec[0] = new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0);
        for (int i = 0; i < 16; ++i) {
            cspec[2 * i + 1] = FormFactory.DEFAULT_COLSPEC;
            cspec[2 * i + 2] = new ColumnSpec((Size)Sizes.DLUX3);
        }
        cspec[33] = new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0);
        RowSpec[] rspec = new RowSpec[25];
        rspec[0] = FormFactory.DEFAULT_ROWSPEC;
        rspec[1] = FormFactory.LINE_GAP_ROWSPEC;
        rspec[2] = new RowSpec("fill:max(pref;40dlu):grow");
        rspec[3] = FormFactory.UNRELATED_GAP_ROWSPEC;
        for (int i = 0; i < 3; ++i) {
            rspec[i * 6 + 4] = FormFactory.DEFAULT_ROWSPEC;
            rspec[i * 6 + 5] = new RowSpec((Size)Sizes.DLUX3);
            rspec[i * 6 + 6] = FormFactory.DEFAULT_ROWSPEC;
            rspec[i * 6 + 7] = new RowSpec((Size)Sizes.DLUX3);
            rspec[i * 6 + 8] = FormFactory.DEFAULT_ROWSPEC;
            rspec[i * 6 + 9] = FormFactory.UNRELATED_GAP_ROWSPEC;
        }
        rspec[22] = FormFactory.DEFAULT_ROWSPEC;
        rspec[23] = FormFactory.LINE_GAP_ROWSPEC;
        rspec[24] = FormFactory.DEFAULT_ROWSPEC;
        this.setLayout((LayoutManager)new FormLayout(cspec, rspec));
        DefaultComponentFactory compFactory = DefaultComponentFactory.getInstance();
        JLabel title1 = compFactory.createTitle(RESOURCES.getString(QUERY_PROP_TITLE_KEY));
        JLabel title2 = compFactory.createTitle(RESOURCES.getString(RGROUPS_TITLE_KEY));
        JLabel title3 = compFactory.createTitle(RESOURCES.getString(CUSTOM_TITLE_KEY));
        JLabel title4 = compFactory.createTitle(RESOURCES.getString(SPECIAL_TITLE_KEY));
        JLabel title5 = compFactory.createTitle(RESOURCES.getString(GENERIC_TITLE_KEY));
        JLabel title6 = compFactory.createTitle(RESOURCES.getString(GROUPS_TITLE_KEY));
        this.add((Component)title5, cc.xywh(2, 5, 9, 1));
        this.add((Component)title1, cc.xywh(14, 5, 19, 1));
        this.add((Component)title6, cc.xywh(2, 11, 19, 1));
        this.add((Component)title4, cc.xywh(24, 11, 9, 1));
        this.add((Component)title2, cc.xywh(2, 17, 19, 1));
        this.add((Component)title3, cc.xywh(2, 23, 19, 1));
        this.createAdvancedInfo(cc);
        this.createAdvancedInfoMouseListener();
        this.createGenericAtoms(cc);
        this.createAtomQueryPropertyButtons(cc);
        this.createRGroupButtons(cc);
        this.createPeriodicGroupButtons(cc);
        this.createCustomPropertyPanel(cc);
        this.createSpecialNodes(cc);
    }

    public void setToggleListener(PeriodicSystemDialogImpl.ToggleListener listener) {
        this.toggleListener = listener;
    }

    private void fireToggleAction() {
        if (this.toggleListener != null) {
            this.toggleListener.toggleActionPerformed();
        }
    }

    @Override
    public void toggleActionPerformed() {
        this.releaseAll();
    }

    private void releaseAll() {
        for (JToggleButton b : this.advancedButtons) {
            b.setSelected(false);
        }
        this.clearButtonGroupSelection();
        this.customPropertyBuilder = null;
    }

    private void clearButtonGroupSelection() {
        this.noSelectionButton.setSelected(true);
    }

    private void releaseAll(JToggleButton exceptThis) {
        this.releaseAll();
        exceptThis.setSelected(true);
    }

    private void createAdvancedInfo(CellConstraints cc) {
        JPanel advancedInfoPanel = new JPanel();
        advancedInfoPanel.setLayout(new BorderLayout());
        advancedInfoPanel.setBorder(new CompoundBorder(new LineBorder(Color.DARK_GRAY), new EmptyBorder(5, 5, 5, 5)));
        DefaultComponentFactory compFactory = DefaultComponentFactory.getInstance();
        JLabel title = compFactory.createTitle("Description");
        this.advancedInfo = new JTextArea();
        this.advancedInfo.setEditable(false);
        this.advancedInfo.setLineWrap(true);
        this.advancedInfo.setWrapStyleWord(true);
        this.advancedInfo.setPreferredSize(new Dimension(230, 50));
        Color col = advancedInfoPanel.getBackground();
        this.advancedInfo.setBackground(col);
        this.add((Component)title, cc.xywh(2, 1, 12, 1));
        advancedInfoPanel.add(this.advancedInfo);
        this.add((Component)advancedInfoPanel, cc.xywh(2, 3, 31, 1));
    }

    private void createAdvancedInfoMouseListener() {
        this.advancedInfoMouseListener = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (e.getSource() instanceof JComponent) {
                    JComponent c = (JComponent)e.getSource();
                    String bname = c.getName();
                    String tttext = c.getToolTipText() != null ? c.getToolTipText() + ". " : "";
                    AdvancedPanel.this.advancedInfo.setText(tttext + RESOURCES.getString(bname));
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                AdvancedPanel.this.advancedInfo.setText(" ");
            }
        };
    }

    private MolAtom createAliasAtom(String alias) {
        MolAtom a1 = new MolAtom(136);
        a1.setAliasstr(alias);
        return a1;
    }

    private void createAdvancedAtomAction(String name, MolAtom a, String tooltip, int col, int row, CellConstraints cc) {
        this.createAdvancedAtomAction(name, name, a, tooltip, col, row, cc);
    }

    private void createAdvancedAtomAction(String name, String key, MolAtom a, String tooltip, int col, int row, CellConstraints cc) {
        AdvancedAtomAction action = new AdvancedAtomAction(this.sketchPanel.getEditor(), a);
        action.putValue("Name", name);
        JToggleButton b = new JToggleButton(action);
        b.setName(key);
        b.setToolTipText(tooltip);
        b.setMargin(this.margin);
        b.addMouseListener(this.advancedInfoMouseListener);
        ToggleButtonBinding.bind(b, action);
        this.advancedButtons.addElement(b);
        b.setEnabled(action.isAllowed());
        this.add((Component)b, cc.xywh(col, row, 1, 1));
    }

    private void createGenericAtoms(CellConstraints cc) {
        this.createAdvancedAtomAction("A", new MolAtom(131), "Any atom except H", 2, 7, cc);
        this.createAdvancedAtomAction("AH", this.createAliasAtom("AH"), "Any atom including H", 2, 9, cc);
        this.createAdvancedAtomAction("Q", new MolAtom(132), "Hetero atom - Any atom except C and H", 4, 7, cc);
        this.createAdvancedAtomAction("QH", this.createAliasAtom("QH"), "Any atom except C", 4, 9, cc);
        this.createAdvancedAtomAction("M", this.createAliasAtom("M"), "Any metal", 6, 7, cc);
        this.createAdvancedAtomAction("MH", this.createAliasAtom("MH"), "Any metal or H", 6, 9, cc);
        this.createAdvancedAtomAction("X", this.createAliasAtom("X"), "Any halogen", 8, 7, cc);
        this.createAdvancedAtomAction("XH", this.createAliasAtom("XH"), "Any halogen or H", 8, 9, cc);
    }

    private void createAtomQueryPropertyButtons(CellConstraints cc) {
        this.createAdvancedAtomAction(".H+", this.createAtomWithQProp("H", 257), "Total number of attached Hydrogens", 14, 7, cc);
        this.createAdvancedAtomAction(".H-", this.createAtomWithQProp("H", 255), "Total number of attached Hydrogens", 14, 9, cc);
        MolAtom a1 = new MolAtom(0);
        a1.setValenceProp(257);
        this.createAdvancedAtomAction(".v+", a1, "Valence - sum of bond orders", 16, 7, cc);
        MolAtom a2 = new MolAtom(0);
        a2.setValenceProp(255);
        this.createAdvancedAtomAction(".v-", a2, "Valence - sum of bond orders", 16, 9, cc);
        this.createAdvancedAtomAction(".X+", this.createAtomWithQProp("X", 257), "Number of connections", 18, 7, cc);
        this.createAdvancedAtomAction(".X-", this.createAtomWithQProp("X", 255), "Number of connections", 18, 9, cc);
        this.createAdvancedAtomAction(".R+", this.createAtomWithQProp("R", 257), "Ring count", 20, 7, cc);
        this.createAdvancedAtomAction(".R-", this.createAtomWithQProp("R", 255), "Ring count", 20, 9, cc);
        this.createAdvancedAtomAction(".r+", this.createAtomWithQProp("r", 257), "Smallest ring size", 22, 7, cc);
        this.createAdvancedAtomAction(".r-", this.createAtomWithQProp("r", 255), "Smallest ring size", 22, 9, cc);
        this.createAdvancedAtomAction(".rb+", this.createAtomWithQProp("rb", 257), "Ring bond count", 24, 7, cc);
        this.createAdvancedAtomAction(".rb-", this.createAtomWithQProp("rb", 255), "Ring bond count", 24, 9, cc);
        this.createAdvancedAtomAction(".s+", this.createAtomWithQProp("s", 257), "Substitution count", 26, 7, cc);
        this.createAdvancedAtomAction(".s-", this.createAtomWithQProp("s", 255), "Substitution count", 26, 9, cc);
        this.createAdvancedAtomAction(".h+", this.createAtomWithQProp("h", 257), "Number of implicit hydrogens", 28, 7, cc);
        this.createAdvancedAtomAction(".h-", this.createAtomWithQProp("h", 255), "Number of implicit hydrogens", 28, 9, cc);
        this.createAdvancedAtomAction(".D+", this.createAtomWithQProp("D", 257), "Number of explicit connections", 30, 7, cc);
        this.createAdvancedAtomAction(".D-", this.createAtomWithQProp("D", 255), "Number of explicit connections", 30, 9, cc);
        this.createAdvancedAtomAction(".u", this.createAtomWithQProp("u", 1), "Unsaturated atom", 32, 7, cc);
        MolAtom a = new MolAtom(0);
        a.setQueryAromaticity(1);
        this.createAdvancedAtomAction(".a/A", a, "Aromatic/Aliphatic", 32, 9, cc);
    }

    private void createRGroupButtons(CellConstraints cc) {
        int row = 19;
        for (int i = 0; i < 32; ++i) {
            int col = 2 + i % 16 * 2;
            if (i == 16) {
                row += 2;
            }
            MolAtom a = new MolAtom(134);
            a.setRgroup(i + 1);
            this.createAdvancedAtomAction("R" + (i + 1), "RGroupDescription", a, "R-group " + (i + 1), col, row, cc);
        }
    }

    private void createPeriodicGroupButtons(CellConstraints cc) {
        MolAtom testa = new MolAtom(136);
        testa.setAliasstr("G1");
        int row = 13;
        for (int i = 0; i < 18; ++i) {
            int col = 2 + i % 9 * 2;
            if (i == 9) {
                row += 2;
            }
            String name = "G" + (i + 1);
            MolAtom a = new MolAtom(136);
            a.setAliasstr(name);
            this.createAdvancedAtomAction(name, "GroupDescription", a, "Group " + (i + 1), col, row, cc);
        }
    }

    private void createSpecialNodes(CellConstraints cc) {
        MolAtom lp = new MolAtom(130);
        this.createAdvancedAtomAction("LP", lp, "Lone Pair", 24, 13, cc);
        MolAtom a = new MolAtom(136);
        a.setAliasstr("Pol");
        this.createAdvancedAtomAction("Pol", a, "Pseudo atom 'Pol'", 26, 13, cc);
        MolAtom ma = new MolAtom(133);
        this.createAdvancedAtomAction("*", ma, "* atom: unspecified end group in polymers", 28, 13, cc);
        String[] homologyGroups = new String[]{"alkyl", "alkenyl", "alkynyl", "aryl", "heteroaryl", "aliphaticHeterocyclyl", "cycloalkyl", "fusedhetero", "halogen", "X", "protecting", "unknown", "actinide", "lanthanide", "othermetal", "metal", "transitionmetal", "acyl", "alkalimetal"};
        JComboBox<String> combo = new JComboBox<String>(homologyGroups);
        this.add(combo, cc.xywh(24, 15, 9, 1));
        combo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox cb = (JComboBox)e.getSource();
                String input = (String)cb.getSelectedItem();
                AdvancedPanel.this.fireToggleAction();
                AdvancedPanel.this.releaseAll();
                MolAtom a = new MolAtom(136);
                a.setAliasstr(input);
                SketchMode sketchMode = AdvancedPanel.this.sketchPanel.getEditor().createSM(new Molecule(null, a));
                AdvancedPanel.this.sketchPanel.setSketchMode(sketchMode, false, false, true, false);
            }
        });
    }

    private MolAtom createAtomWithQProp(String name, int x) {
        MolAtom a = new MolAtom(0);
        a.setQProp(name, x);
        return a;
    }

    private void createCustomPropertyPanel(CellConstraints cc) {
        JPanel panel4 = new JPanel();
        panel4.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.DEFAULT_COLSPEC, FormFactory.UNRELATED_GAP_COLSPEC, new ColumnSpec("max(default;40dlu)"), FormFactory.RELATED_GAP_COLSPEC, new ColumnSpec("max(default;40dlu)"), FormFactory.RELATED_GAP_COLSPEC, new ColumnSpec("max(default;40dlu)"), FormFactory.RELATED_GAP_COLSPEC, new ColumnSpec("max(default;40dlu)"), FormFactory.RELATED_GAP_COLSPEC, new ColumnSpec("max(default;40dlu)"), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0)}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.UNRELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        JLabel label1 = new JLabel("Type:");
        panel4.add((Component)label1, cc.xy(1, 1));
        this.group = new ButtonGroup();
        this.rgroupButton = this.createCustomPropertyButton(this.createRGroupAction(), "R-group");
        this.group.add(this.rgroupButton);
        panel4.add((Component)this.rgroupButton, cc.xy(3, 1));
        this.aliasButton = this.createCustomPropertyButton(this.createAliasAction(), "Converts the Value to atom label type");
        this.group.add(this.aliasButton);
        panel4.add((Component)this.aliasButton, cc.xy(5, 1));
        this.pseudoButton = this.createCustomPropertyButton(this.createPseudoAction(), "Converts the Value to Pseudo atom type");
        this.group.add(this.pseudoButton);
        panel4.add((Component)this.pseudoButton, cc.xy(7, 1));
        this.smartsButton = this.createCustomPropertyButton(this.createSMARTSAction(), "Converts the Value to SMARTS query");
        this.group.add(this.smartsButton);
        panel4.add((Component)this.smartsButton, cc.xy(9, 1));
        this.valueButton = this.createCustomPropertyButton(this.createValueAction(), "Converts the Value to Atom Value");
        this.group.add(this.valueButton);
        panel4.add((Component)this.valueButton, cc.xy(11, 1));
        this.noSelectionButton = new JToggleButton();
        this.group.add(this.noSelectionButton);
        JLabel label2 = new JLabel("Value:");
        panel4.add((Component)label2, cc.xy(1, 3));
        this.customPropertyValue = new JTextField();
        this.customPropertyValue.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                AdvancedPanel.this.customPropertyActionPerformed();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                AdvancedPanel.this.customPropertyActionPerformed();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        panel4.add((Component)this.customPropertyValue, cc.xywh(3, 3, 11, 1));
        this.add((Component)panel4, cc.xywh(2, 25, 31, 1));
    }

    private JToggleButton createCustomPropertyButton(Action action, String tooltip) {
        JToggleButton button = new JToggleButton(action);
        button.setName(action.getValue("Name").toString());
        button.setToolTipText(tooltip);
        button.addMouseListener(this.advancedInfoMouseListener);
        return button;
    }

    private void customPropertyActionPerformed() {
        String input = this.customPropertyValue.getText();
        Molecule mol = null;
        if (this.customPropertyBuilder != null) {
            try {
                mol = this.customPropertyBuilder.buildMolecule(input, this.sketchPanel.getEditor().getMolDim());
            }
            catch (SecurityException sex) {
                this.sketchPanel.getErrorDisplay().firewallError(sex, null);
            }
            catch (Throwable ex) {
                this.sketchPanel.getErrorDisplay().error(ex);
            }
        }
        if (mol == null) {
            mol = new Molecule();
            this.customPropertyValue.setBackground(this.highlightErrorColor);
        } else {
            this.customPropertyValue.setBackground(UIManager.getColor("TextField.background"));
        }
        SketchMode sketchMode = this.sketchPanel.getEditor().createSM(mol);
        this.sketchPanel.setSketchMode(sketchMode, false, false, true, false);
    }

    private boolean isCustomPropertyAllowed(CustomPropertyBuilder builder) {
        return this.sketchPanel.getEditor().isAllowed(builder.buildRepresentativeMolecule());
    }

    private Action createRGroupAction() {
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AdvancedPanel.this.fireToggleAction();
                AdvancedPanel.this.releaseAll(AdvancedPanel.this.rgroupButton);
                AdvancedPanel.this.customPropertyBuilder = new RGroupBuilder();
                AdvancedPanel.this.customPropertyActionPerformed();
            }
        };
        action.putValue("Name", RESOURCES.getString(R_GROUP_KEY));
        action.setEnabled(this.isCustomPropertyAllowed(new RGroupBuilder()));
        return action;
    }

    private Action createAliasAction() {
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AdvancedPanel.this.fireToggleAction();
                AdvancedPanel.this.releaseAll(AdvancedPanel.this.aliasButton);
                AdvancedPanel.this.customPropertyBuilder = new AliasBuilder();
                AdvancedPanel.this.customPropertyActionPerformed();
            }
        };
        action.putValue("Name", RESOURCES.getString(ALIAS_KEY));
        action.setEnabled(this.isCustomPropertyAllowed(new AliasBuilder()));
        return action;
    }

    private Action createPseudoAction() {
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AdvancedPanel.this.fireToggleAction();
                AdvancedPanel.this.releaseAll(AdvancedPanel.this.pseudoButton);
                AdvancedPanel.this.customPropertyBuilder = new PseudoBuilder();
                AdvancedPanel.this.customPropertyActionPerformed();
            }
        };
        action.putValue("Name", RESOURCES.getString(PSEUDO_KEY));
        action.setEnabled(this.isCustomPropertyAllowed(new PseudoBuilder()));
        return action;
    }

    private Action createSMARTSAction() {
        AbstractAction smartsAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AdvancedPanel.this.fireToggleAction();
                AdvancedPanel.this.releaseAll(AdvancedPanel.this.smartsButton);
                AdvancedPanel.this.customPropertyBuilder = new SmartsBuilder();
                AdvancedPanel.this.customPropertyActionPerformed();
            }
        };
        smartsAction.putValue("Name", RESOURCES.getString(SMARTS_KEY));
        smartsAction.setEnabled(this.isCustomPropertyAllowed(new SmartsBuilder()));
        return smartsAction;
    }

    private Action createValueAction() {
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AdvancedPanel.this.fireToggleAction();
                AdvancedPanel.this.releaseAll(AdvancedPanel.this.valueButton);
                AdvancedPanel.this.customPropertyBuilder = new ValueBuilder();
                AdvancedPanel.this.customPropertyActionPerformed();
            }
        };
        action.putValue("Name", RESOURCES.getString(VALUE_KEY));
        action.setEnabled(this.isCustomPropertyAllowed(new ValueBuilder()));
        return action;
    }

    class AdvancedAtomAction
    extends AbstractAction {
        private AtomSM sketchMode;

        public AdvancedAtomAction(MolEditor medit, MolAtom a) {
            this.sketchMode = new AtomSM(medit, a);
        }

        public MolAtom getAtom() {
            return this.sketchMode.getAtom();
        }

        public boolean isAllowed() {
            return AdvancedPanel.this.sketchPanel.getEditor().isAllowed(this.sketchMode.getMol());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AdvancedPanel.this.sketchPanel.setSketchMode(this.sketchMode, false, false, true, false);
            String name = this.getValue("Name").toString();
            AdvancedPanel.this.fireToggleAction();
            AdvancedPanel.this.releaseAll();
            for (JToggleButton b : AdvancedPanel.this.advancedButtons) {
                if (!name.equals(b.getAction().getValue("Name"))) continue;
                b.setSelected(true);
                return;
            }
        }
    }
}

