/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.modules.periodic;

import chemaxon.marvin.paint.internal.ColorCollection;
import chemaxon.marvin.sketch.swing.modules.periodic.ElementColorizerHandler;
import chemaxon.struc.PeriodicSystem;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class AtomIconFactory {
    private static String ICON_RESOURCE_BIG = "/chemaxon/icons/marvin/empty24.png";
    private static String ICON_RESOURCE_SMALL = "/chemaxon/icons/marvin/empty16.png";
    private static int ICON_SIZE_BIG = 24;
    private static int ICON_SIZE_SMALL = 16;
    private static int FONT_SIZE_BIG = 13;
    private static int FONT_SIZE_SMALL = 9;
    private static final Font BIG_FONT = new Font("Tahoma", 1, FONT_SIZE_BIG);
    private static final Font SMALL_FONT = new Font("Tahoma", 1, FONT_SIZE_SMALL);
    private static final RenderingHints renderHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    private static Color highlightColor = new Color(252, 163, 17, 105);
    private static ImageIcon smallShape;
    private static ImageIcon bigShape;

    public Icon getIcon(int atomNumber, boolean large) {
        return large ? this.createIcon(atomNumber, ICON_SIZE_BIG, AtomIconFactory.getBigShape(), BIG_FONT) : this.createIcon(atomNumber, ICON_SIZE_SMALL, AtomIconFactory.getSmallShape(), SMALL_FONT);
    }

    public Icon getIcon(int atomNumber, ElementColorizerHandler colorizer) {
        AtomIconFactory.getBigShape();
        BufferedImage image = new BufferedImage(ICON_SIZE_BIG, ICON_SIZE_BIG, 6);
        this.drawIcon(image, PeriodicSystem.getSymbol(atomNumber), false, colorizer.getForegroundColor(atomNumber), colorizer.getBackgroundColor(atomNumber));
        return new ImageIcon(image);
    }

    public Icon getSelectedIcon(int atomNumber, ElementColorizerHandler colorizer) {
        AtomIconFactory.getBigShape();
        BufferedImage image = new BufferedImage(ICON_SIZE_BIG, ICON_SIZE_BIG, 6);
        this.drawIcon(image, PeriodicSystem.getSymbol(atomNumber), true, colorizer.getForegroundColor(atomNumber), colorizer.getBackgroundColor(atomNumber));
        return new ImageIcon(image);
    }

    private void drawIcon(Image image, String text, boolean highlight, Color foregroundColor, Color backgroundColor) {
        Graphics g = image.getGraphics();
        if (bigShape != null) {
            g.drawImage(bigShape.getImage(), 0, 0, bigShape.getIconWidth(), bigShape.getIconHeight(), null);
        }
        if (highlight) {
            g.setColor(highlightColor);
            g.fillRect(0, 0, ICON_SIZE_BIG, ICON_SIZE_BIG);
        } else {
            g.setColor(backgroundColor);
            g.fillRect(0, 0, ICON_SIZE_BIG, ICON_SIZE_BIG);
        }
        g.setColor(foregroundColor);
        ((Graphics2D)g).setRenderingHints(renderHints);
        g.setFont(BIG_FONT);
        Rectangle2D rect = g.getFontMetrics().getStringBounds(text, g);
        g.drawString(text, (int)(((double)ICON_SIZE_BIG - rect.getWidth()) / 2.0) + 1, (int)(((double)ICON_SIZE_BIG - rect.getHeight()) / 2.0) + g.getFontMetrics().getAscent());
    }

    private static ImageIcon getSmallShape() {
        if (smallShape == null) {
            smallShape = AtomIconFactory.loadIcon(ICON_RESOURCE_SMALL);
        }
        return smallShape;
    }

    private static ImageIcon getBigShape() {
        if (bigShape == null) {
            bigShape = AtomIconFactory.loadIcon(ICON_RESOURCE_BIG);
        }
        return bigShape;
    }

    private static ImageIcon loadIcon(String url) {
        return new ImageIcon(AtomIconFactory.class.getResource(url));
    }

    private Icon createIcon(int atno, int size, Icon shape, Font font) {
        Color cpk = ColorCollection.getColor(atno, false);
        String text = PeriodicSystem.getSymbol(atno);
        BufferedImage result = new BufferedImage(size, size, 6);
        Graphics2D g = result.createGraphics();
        if (shape != null) {
            shape.paintIcon(null, g, 0, 0);
        }
        g.setColor(cpk);
        g.setRenderingHints(renderHints);
        g.setFont(font);
        Rectangle2D rect = g.getFontMetrics().getStringBounds(text, g);
        g.drawString(text, (int)(((double)size - rect.getWidth()) / 2.0) + 1, (int)(((double)size - rect.getHeight()) / 2.0) + g.getFontMetrics().getAscent());
        g.dispose();
        return new ImageIcon(result);
    }
}

