/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.modules.periodic;

import chemaxon.marvin.paint.internal.ColorCollection;
import chemaxon.marvin.sketch.swing.modules.periodic.PeriodicSystemPanel;
import chemaxon.struc.PeriodicSystem;
import java.awt.Color;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;

public class ElementColorizerHandler {
    public static final int CPK_MODE = 0;
    public static final int BLOCK_MODE = 1;
    public static final int AGGREGATION_MODE = 2;
    public static final int METAL_MODE = 3;
    private ElementColorizer colorizer;

    public void colorize(Vector<JLabel> labels, int mode) {
        switch (mode) {
            case 0: {
                this.colorizer = new CPKColorizer();
                break;
            }
            case 1: {
                this.colorizer = new BlockColorizer();
                break;
            }
            case 2: {
                this.colorizer = new AggregationColorizer();
                break;
            }
            case 3: {
                this.colorizer = new MetalColorizer();
                break;
            }
            default: {
                this.colorizer = new ElementColorizer();
            }
        }
        this.colorizer.colorizeLabels(labels);
    }

    public Color getForegroundColor(int atno) {
        return this.colorizer.getForegroundColor(atno);
    }

    public Color getBackgroundColor(int atno) {
        return this.colorizer.getBackgroundColor(atno);
    }

    class MetalColorizer
    extends ElementColorizer {
        private static final String ALKALI_METAL = "Alkali metal";
        private static final String ALKALINE_EARTH_METAL = "Alkaline earth metal";
        private static final String OTHER_METAL = "Other metal";
        private static final String METALLOID = "Metalloid";
        private static final String TRANSITION_METAL = "Transition metal";
        private static final String NONMETAL = "Nonmetal";

        MetalColorizer() {
        }

        @Override
        public Color getBackgroundColor(int atno) {
            if (PeriodicSystem.isAlkaliMetal(atno)) {
                return this.white;
            }
            if (PeriodicSystem.isAlkalineEarthMetal(atno)) {
                return this.blue;
            }
            if (PeriodicSystem.isMetalloid(atno)) {
                return this.red;
            }
            if (PeriodicSystem.isTransitionMetal(atno)) {
                return this.orange;
            }
            if (PeriodicSystem.isMetal(atno)) {
                return this.green;
            }
            return this.yellow;
        }

        @Override
        protected void colorizeLabel(JLabel label, int i) {
            this.setBorder(label);
            switch (i) {
                case 0: {
                    label.setText(ALKALI_METAL);
                    label.setBackground(this.white);
                    break;
                }
                case 1: {
                    label.setText(ALKALINE_EARTH_METAL);
                    label.setBackground(this.blue);
                    break;
                }
                case 4: {
                    label.setText(OTHER_METAL);
                    label.setBackground(this.green);
                    break;
                }
                case 2: {
                    label.setText(METALLOID);
                    label.setBackground(this.red);
                    break;
                }
                case 3: {
                    label.setText(TRANSITION_METAL);
                    label.setBackground(this.orange);
                    break;
                }
                case 5: {
                    label.setText(NONMETAL);
                    label.setBackground(this.yellow);
                    break;
                }
                default: {
                    this.emptyLabel(label);
                }
            }
        }
    }

    class AggregationColorizer
    extends ElementColorizer {
        public static final int GAS = 0;
        public static final int LIQUID = 1;
        public static final int SOLID = 2;
        private static final String GAS_TEXT = "Gas";
        private static final String LIQUID_TEXT = "Liquid";
        private static final String SOLID_TEXT = "Solid";

        AggregationColorizer() {
        }

        @Override
        public Color getBackgroundColor(int atno) {
            int row = PeriodicSystemPanel.getRow(atno);
            Color color = atno == 1 || atno == 7 || atno == 8 || atno == 9 || atno == 17 ? this.yellow : (PeriodicSystemPanel.getColumn(atno) == 18 ? this.yellow : (atno == 35 || atno == 80 ? this.red : this.green));
            return new Color(color.getRed(), color.getGreen(), color.getBlue(), row <= 7 ? row * 10 + 35 : 45);
        }

        @Override
        protected void colorizeLabel(JLabel label, int i) {
            this.setBorder(label);
            switch (i) {
                case 0: {
                    label.setText(GAS_TEXT);
                    label.setBackground(this.yellow);
                    break;
                }
                case 1: {
                    label.setText(LIQUID_TEXT);
                    label.setBackground(this.red);
                    break;
                }
                case 2: {
                    label.setText(SOLID_TEXT);
                    label.setBackground(this.green);
                    break;
                }
                default: {
                    this.emptyLabel(label);
                }
            }
        }
    }

    class BlockColorizer
    extends ElementColorizer {
        private static final String S_BLOCK = "s Block";
        private static final String P_BLOCK = "p Block";
        private static final String D_BLOCK = "d Block";
        private static final String F_BLOCK = "f Block";

        BlockColorizer() {
        }

        @Override
        public Color getBackgroundColor(int atno) {
            int c = PeriodicSystemPanel.getColumn(atno);
            int row = PeriodicSystemPanel.getRow(atno);
            Color color = row > 7 ? this.red : (c < 3 ? this.blue : (c < 13 ? this.yellow : this.green));
            return new Color(color.getRed(), color.getGreen(), color.getBlue(), row <= 7 ? row * 10 + 35 : 45);
        }

        @Override
        protected void colorizeLabel(JLabel label, int i) {
            this.setBorder(label);
            switch (i) {
                case 0: {
                    label.setText(S_BLOCK);
                    label.setBackground(this.blue);
                    break;
                }
                case 1: {
                    label.setText(P_BLOCK);
                    label.setBackground(this.green);
                    break;
                }
                case 2: {
                    label.setText(D_BLOCK);
                    label.setBackground(this.yellow);
                    break;
                }
                case 3: {
                    label.setText(F_BLOCK);
                    label.setBackground(this.red);
                    break;
                }
                default: {
                    this.emptyLabel(label);
                }
            }
        }
    }

    class CPKColorizer
    extends ElementColorizer {
        private static final String NONE = "None";

        CPKColorizer() {
        }

        @Override
        public Color getForegroundColor(int atno) {
            return ColorCollection.getColor(atno, false);
        }

        @Override
        protected void colorizeLabel(JLabel label, int i) {
            this.setBorder(label);
            switch (i) {
                case 0: {
                    label.setText(NONE);
                    label.setBackground(null);
                    break;
                }
                default: {
                    this.emptyLabel(label);
                }
            }
        }
    }

    class ElementColorizer {
        int alpha = 45;
        Color blue = new Color(0, 159, 200, this.alpha);
        Color orange = new Color(255, 126, 0, this.alpha);
        Color yellow = new Color(255, 190, 0, this.alpha);
        Color green = new Color(0, 164, 59, this.alpha);
        Color red = new Color(190, 0, 0, this.alpha);
        Color white = new Color(255, 255, 255, this.alpha);
        Color black = new Color(0, 0, 0, 255);

        ElementColorizer() {
        }

        public Color getForegroundColor(int atno) {
            return this.black;
        }

        public Color getBackgroundColor(int atno) {
            return new Color(255, 255, 255, 0);
        }

        public void colorizeLabels(Vector<JLabel> labels) {
            for (int i = 0; i < labels.size(); ++i) {
                JLabel label = labels.get(i);
                this.colorizeLabel(label, i);
            }
        }

        protected void colorizeLabel(JLabel label, int i) {
            this.emptyLabel(label);
        }

        protected void emptyLabel(JLabel label) {
            label.setBackground(UIManager.getColor("Label.background"));
            label.setBorder(null);
            label.setText(null);
        }

        protected void setBorder(JLabel label) {
            label.setBorder(LineBorder.createGrayLineBorder());
        }
    }
}

