/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.modules.periodic;

import chemaxon.marvin.common.swing.MolPanel;
import chemaxon.marvin.sketch.AtomSM;
import chemaxon.marvin.sketch.swing.SketchPanel;
import chemaxon.marvin.sketch.swing.modules.PeriodicSystemDialogImpl;
import chemaxon.marvin.sketch.swing.modules.periodic.AtomAction;
import chemaxon.marvin.sketch.swing.modules.periodic.AtomIconFactory;
import chemaxon.marvin.sketch.swing.modules.periodic.ElementColorizerHandler;
import chemaxon.marvin.sketch.swing.modules.periodic.PeriodicSystemPM;
import chemaxon.marvin.uif.action.support.ToggleButtonBinding;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import chemaxon.struc.PeriodicSystem;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.DefaultComponentFactory;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.layout.Sizes;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;

public class PeriodicSystemPanel
extends JPanel
implements PeriodicSystemPM,
PeriodicSystemDialogImpl.ToggleListener {
    private static final String COLOR_TITLE_KEY = "ColorTitle";
    private static final String COLOR_H_TITLE_KEY = "ColorLegendTitle";
    private static final String GROUP_KEY = "Group";
    private static final String MISSING_RESOURCE_MSG_KEY = "MissingResourcesError";
    private static final String MISSING_RESOURCE_TITLE_KEY = "MissingResourcesTitle";
    private static final String ATOM_LIST_TEXT = "AtomListText";
    private static final String ATOM_LIST_TOOLTIP = "AtomListTooltip";
    private static final String NOT_LIST_TEXT = "NOTListText";
    private static final String NOT_LIST_TOOLTIP = "NOTListTooltip";
    private static final String CLEAR_LIST_TEXT = "ClearListText";
    private static final String CLEAR_LIST_TOOLTIP = "ClearListTooltip";
    private static ResourceBundle RESOURCES;
    private Insets margin = new Insets(1, 1, 1, 1);
    private JToggleButton listButton;
    private JToggleButton xListButton;
    private Molecule listMolecule;
    private Molecule xListMolecule;
    private Vector<Integer> atomlist = new Vector();
    private Vector<Integer> notlist = new Vector();
    private Vector<JToggleButton> atomButtons = new Vector();
    private Vector<AtomAction> atomActions = new Vector();
    private Vector<JLabel> elementColorLabels;
    private SketchPanel sketchPanel;
    private ElementInfoPanel elementInfoPanel;
    private PeriodicSystemDialogImpl.ToggleListener toggleListener = null;

    public PeriodicSystemPanel(SketchPanel panel) {
        RESOURCES = MolPanel.getResourceBundle(this.getClass().getName());
        this.sketchPanel = panel;
        CellConstraints cc = new CellConstraints();
        this.setBorder(Borders.TABBED_DIALOG_BORDER);
        ColumnSpec[] cs = new ColumnSpec[40];
        cs[0] = new ColumnSpec(ColumnSpec.CENTER, (Size)Sizes.DEFAULT, 1.0);
        for (int i = 0; i < 19; ++i) {
            cs[2 * i + 1] = new ColumnSpec(ColumnSpec.CENTER, (Size)Sizes.PREFERRED, 0.0);
            cs[2 * i + 2] = new ColumnSpec((Size)Sizes.DLUX2);
        }
        cs[2] = FormFactory.LABEL_COMPONENT_GAP_COLSPEC;
        cs[39] = new ColumnSpec(ColumnSpec.CENTER, (Size)Sizes.DEFAULT, 1.0);
        RowSpec[] rs = new RowSpec[23];
        rs[0] = new RowSpec(RowSpec.BOTTOM, (Size)Sizes.DEFAULT, 1.0);
        for (int i = 0; i < 11; ++i) {
            rs[2 * i + 1] = new RowSpec((Size)Sizes.DLUX2);
            rs[2 * i + 2] = new RowSpec(RowSpec.CENTER, (Size)Sizes.PREFERRED, 0.0);
        }
        rs[15] = FormFactory.RELATED_GAP_ROWSPEC;
        rs[21] = FormFactory.UNRELATED_GAP_ROWSPEC;
        rs[22] = new RowSpec(RowSpec.FILL, (Size)Sizes.PREFERRED, 0.0);
        this.setLayout((LayoutManager)new FormLayout(cs, rs));
        this.createAtomButtons(cc, 1, 2);
        this.createGroupLabels(cc, 1, 2);
        this.createListButtons(cc);
        this.createPeriodLabels(cc, 1, 2);
        this.elementInfoPanel = new ElementInfoPanel();
        JScrollPane scpane = new JScrollPane(this.elementInfoPanel);
        this.add((Component)scpane, cc.xywh(8, 1, 19, 5));
        this.add((Component)this.createCustomizePanel(cc), cc.xywh(1, 23, 40, 1));
        this.setIconColorSchema(String.valueOf(0));
    }

    public void setToggleListener(PeriodicSystemDialogImpl.ToggleListener listener) {
        this.toggleListener = listener;
    }

    private void fireToggleAction() {
        if (this.toggleListener != null) {
            this.toggleListener.toggleActionPerformed();
        }
    }

    @Override
    public void toggleActionPerformed() {
        this.releaseAll();
    }

    @Override
    public void atomActionPerformed(int atomNumber) {
        if (this.listButton.isSelected()) {
            this.toggleAtomInList(this.atomlist, atomNumber, this.listMolecule);
        } else if (this.xListButton.isSelected()) {
            this.toggleAtomInList(this.notlist, atomNumber, this.xListMolecule);
        } else {
            this.sketchPanel.setSketchMode(this.createSketchMode(atomNumber), false, false, true, false);
            this.fireToggleAction();
            this.releaseAll(this.atomButtons.get(atomNumber - 1));
        }
    }

    private void toggleAtomInList(List<Integer> atomList, int atomNumber, Molecule mol) {
        if (atomList.contains(atomNumber)) {
            atomList.remove((Object)atomNumber);
        } else {
            atomList.add(atomNumber);
        }
        this.setSkechMode(atomList, mol);
    }

    private boolean isAtomActionAllowed(int atomNumber) {
        return this.sketchPanel.getEditor().isAllowed(this.createSketchMode(atomNumber).getMol());
    }

    private AtomSM createSketchMode(int atomNumber) {
        MolAtom molAtom = new MolAtom(atomNumber);
        molAtom.setElectronProp(-3);
        return new AtomSM(this.sketchPanel.getEditor(), molAtom);
    }

    private int[] getListArray(List<Integer> listVector) {
        Collections.sort(listVector);
        int[] list = new int[listVector.size()];
        int i = 0;
        for (int a : listVector) {
            list[i++] = a;
        }
        return list;
    }

    private void releaseAll() {
        for (JToggleButton b : this.atomButtons) {
            b.setSelected(false);
        }
        this.listButton.setSelected(false);
        this.xListButton.setSelected(false);
    }

    private void releaseAll(JToggleButton button) {
        for (JToggleButton b : this.atomButtons) {
            if (b == button) continue;
            b.setSelected(false);
        }
        if (button != this.listButton) {
            this.listButton.setSelected(false);
        }
        if (button != this.xListButton) {
            this.xListButton.setSelected(false);
        }
    }

    public void setMolecule(Molecule mol) {
        this.releaseAll();
        if (mol != null && mol.isAtom()) {
            MolAtom atom = mol.getAtom(0);
            for (JToggleButton b : this.atomButtons) {
                AtomAction action = (AtomAction)b.getAction();
                if (atom.getAtno() != action.getAtomNumber()) continue;
                b.setSelected(true);
                return;
            }
        }
    }

    private void createAtomButtons(CellConstraints cc, int rd, int cd) throws NullPointerException {
        try {
            int i = 1;
            while (i <= PeriodicSystem.getElementCount()) {
                int row = PeriodicSystemPanel.getRow(i);
                int col = PeriodicSystemPanel.getColumn(i);
                AtomAction action = new AtomAction(this, i);
                JToggleButton b = new JToggleButton(action){

                    @Override
                    public Icon getSelectedIcon() {
                        return (Icon)this.getAction().getValue("SelectedIcon");
                    }
                };
                b.setToolTipText(PeriodicSystem.getName(i));
                ToggleButtonBinding.bind(b, action);
                b.setText(null);
                b.setMargin(this.margin);
                b.setBorder(null);
                b.setEnabled(this.isAtomActionAllowed(i));
                final int atno = i++;
                b.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseEntered(MouseEvent e) {
                        PeriodicSystemPanel.this.elementInfoPanel.update(atno);
                    }
                });
                this.add((Component)b, cc.xywh(2 * col + cd, 2 * row + rd, 1, 1));
                this.atomButtons.addElement(b);
                this.atomActions.addElement(action);
            }
        }
        catch (NullPointerException e) {
            JOptionPane.showMessageDialog(this.sketchPanel, RESOURCES.getString(MISSING_RESOURCE_MSG_KEY), RESOURCES.getString(MISSING_RESOURCE_TITLE_KEY), 0);
            throw e;
        }
    }

    static int getRow(int i) {
        int r = PeriodicSystem.getRow(i);
        if (i > 57 && i < 72) {
            r += 2;
        } else if (i > 89 && i < 104) {
            r += 2;
        }
        return r;
    }

    static int getColumn(int i) {
        int c = PeriodicSystem.getColumn(i);
        if (i > 57 && i < 72) {
            c += i - 57;
        } else if (i > 89 && i < 104) {
            c += i - 89;
        }
        return c;
    }

    private void createGroupLabels(CellConstraints cc, int rd, int cd) {
        DefaultComponentFactory compFactory = DefaultComponentFactory.getInstance();
        for (int i = 1; i <= 18; ++i) {
            int row = 0;
            if (i == 2 || i > 12 && i < 18) {
                row = 2;
            } else if (i > 2 && i < 13) {
                row = 6;
            }
            JLabel l = compFactory.createLabel("" + i);
            l.setToolTipText(RESOURCES.getString(GROUP_KEY + i));
            this.add((Component)l, cc.xy(i * 2 + cd, row + rd));
        }
    }

    private void createPeriodLabels(CellConstraints cc, int rd, int cd) {
        DefaultComponentFactory compFactory = DefaultComponentFactory.getInstance();
        for (int i = 1; i <= 7; ++i) {
            JLabel l = compFactory.createLabel("" + i);
            this.add((Component)l, cc.xy(cd, 2 * i + rd));
        }
    }

    private void createListButtons(CellConstraints cc) {
        this.createAtomListButton(cc);
        this.createNOTListButton(cc);
        this.createClearListButton(cc);
    }

    private void listModeActionPerformed(Vector<Integer> list, Molecule molecule) {
        for (int i : list) {
            this.atomButtons.get(i - 1).setSelected(true);
        }
        this.setSkechMode(list, molecule);
    }

    private void setSkechMode(List<Integer> list, Molecule molecule) {
        molecule.getAtom(0).setList(this.getListArray(list));
        if (list.isEmpty()) {
            this.setEmptyMoleculeSM();
        } else {
            this.sketchPanel.setSketchMode(this.sketchPanel.getEditor().createSM(molecule), false, false, true, false);
        }
        this.fireToggleAction();
    }

    private void createAtomListButton(CellConstraints cc) {
        MolAtom a = new MolAtom(128);
        AtomSM so = new AtomSM(this.sketchPanel.getEditor(), a);
        this.listMolecule = so.getMol();
        this.listButton = new JToggleButton(RESOURCES.getString(ATOM_LIST_TEXT));
        this.listButton.setToolTipText(RESOURCES.getString(ATOM_LIST_TOOLTIP));
        this.listButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!PeriodicSystemPanel.this.listButton.isSelected()) {
                    PeriodicSystemPanel.this.releaseAll();
                    PeriodicSystemPanel.this.setEmptyMoleculeSM();
                } else {
                    PeriodicSystemPanel.this.releaseAll();
                    PeriodicSystemPanel.this.listButton.setSelected(true);
                    PeriodicSystemPanel.this.listModeActionPerformed(PeriodicSystemPanel.this.atomlist, PeriodicSystemPanel.this.listMolecule);
                }
            }
        });
        boolean allowed = this.sketchPanel.getEditor().isAllowed(this.listMolecule);
        this.listButton.setEnabled(allowed);
        this.add((Component)this.listButton, cc.xywh(2, 17, 7, 1));
    }

    private void createNOTListButton(CellConstraints cc) {
        MolAtom a = new MolAtom(129);
        AtomSM so = new AtomSM(this.sketchPanel.getEditor(), a);
        this.xListMolecule = so.getMol();
        this.xListButton = new JToggleButton(RESOURCES.getString(NOT_LIST_TEXT));
        this.xListButton.setToolTipText(RESOURCES.getString(NOT_LIST_TOOLTIP));
        this.xListButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!PeriodicSystemPanel.this.xListButton.isSelected()) {
                    PeriodicSystemPanel.this.releaseAll();
                    PeriodicSystemPanel.this.setEmptyMoleculeSM();
                } else {
                    PeriodicSystemPanel.this.releaseAll(PeriodicSystemPanel.this.xListButton);
                    PeriodicSystemPanel.this.listModeActionPerformed(PeriodicSystemPanel.this.notlist, PeriodicSystemPanel.this.xListMolecule);
                }
            }
        });
        boolean allowed = this.sketchPanel.getEditor().isAllowed(this.xListMolecule);
        this.xListButton.setEnabled(allowed);
        this.add((Component)this.xListButton, cc.xywh(2, 19, 7, 1));
    }

    private void createClearListButton(CellConstraints cc) {
        JButton clearListButton = new JButton(RESOURCES.getString(CLEAR_LIST_TEXT));
        clearListButton.setToolTipText(RESOURCES.getString(CLEAR_LIST_TOOLTIP));
        clearListButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PeriodicSystemPanel.this.listButton.isSelected()) {
                    PeriodicSystemPanel.this.atomlist.clear();
                    PeriodicSystemPanel.this.releaseAll(PeriodicSystemPanel.this.listButton);
                } else if (PeriodicSystemPanel.this.xListButton.isSelected()) {
                    PeriodicSystemPanel.this.notlist.clear();
                    PeriodicSystemPanel.this.releaseAll(PeriodicSystemPanel.this.xListButton);
                } else {
                    return;
                }
                PeriodicSystemPanel.this.setEmptyMoleculeSM();
            }
        });
        this.add((Component)clearListButton, cc.xywh(2, 21, 7, 1));
    }

    private void setEmptyMoleculeSM() {
        this.sketchPanel.useDefaultSelectionMode();
        this.fireToggleAction();
    }

    private JPanel createCustomizePanel(CellConstraints cc) {
        JPanel panel = new JPanel();
        ColumnSpec[] cspec = new ColumnSpec[]{FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.UNRELATED_GAP_COLSPEC, new ColumnSpec("max(default;50dlu)"), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec("max(default;50dlu)"), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec("max(default;50dlu)"), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0)};
        RowSpec[] rspec = new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, new RowSpec(RowSpec.FILL, (Size)Sizes.DEFAULT, 1.0)};
        panel.setLayout((LayoutManager)new FormLayout(cspec, rspec));
        DefaultComponentFactory compFactory = DefaultComponentFactory.getInstance();
        JLabel title1 = compFactory.createTitle(RESOURCES.getString(COLOR_TITLE_KEY));
        panel.add((Component)title1, cc.xy(1, 1));
        ActionListener colorActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PeriodicSystemPanel.this.setIconColorSchema(e.getActionCommand());
            }
        };
        ButtonGroup colorgroup = new ButtonGroup();
        JRadioButton color1 = new JRadioButton("CPK", true);
        color1.setActionCommand(String.valueOf(0));
        color1.addActionListener(colorActionListener);
        colorgroup.add(color1);
        panel.add((Component)color1, cc.xy(1, 3));
        JRadioButton color2 = new JRadioButton("Blocks");
        color2.setActionCommand(String.valueOf(1));
        color2.addActionListener(colorActionListener);
        colorgroup.add(color2);
        panel.add((Component)color2, cc.xy(1, 5));
        JRadioButton color3 = new JRadioButton("Standard state");
        color3.setActionCommand(String.valueOf(2));
        color3.addActionListener(colorActionListener);
        colorgroup.add(color3);
        panel.add((Component)color3, cc.xy(3, 3));
        JRadioButton color4 = new JRadioButton("Metals/Nonmetals");
        color4.setActionCommand(String.valueOf(3));
        color4.addActionListener(colorActionListener);
        colorgroup.add(color4);
        panel.add((Component)color4, cc.xy(3, 5));
        JLabel title2 = compFactory.createTitle(RESOURCES.getString(COLOR_H_TITLE_KEY));
        panel.add((Component)title2, cc.xy(5, 1));
        JLabel label1 = new JLabel();
        panel.add((Component)label1, cc.xy(5, 3));
        this.initColorLabel(label1);
        JLabel label2 = new JLabel();
        panel.add((Component)label2, cc.xy(5, 5));
        this.initColorLabel(label2);
        JLabel label3 = new JLabel();
        panel.add((Component)label3, cc.xy(7, 3));
        this.initColorLabel(label3);
        JLabel label4 = new JLabel();
        panel.add((Component)label4, cc.xy(7, 5));
        this.initColorLabel(label4);
        JLabel label5 = new JLabel();
        panel.add((Component)label5, cc.xy(9, 3));
        this.initColorLabel(label5);
        JLabel label6 = new JLabel();
        panel.add((Component)label6, cc.xy(9, 5));
        this.initColorLabel(label6);
        return panel;
    }

    private void initColorLabel(JLabel label) {
        if (this.elementColorLabels == null) {
            this.elementColorLabels = new Vector();
        }
        label.setOpaque(true);
        label.setHorizontalAlignment(0);
        this.elementColorLabels.add(label);
    }

    private void setIconColorSchema(String s) {
        int mode = Integer.parseInt(s);
        ElementColorizerHandler ech = new ElementColorizerHandler();
        ech.colorize(this.elementColorLabels, mode);
        AtomIconFactory factory = new AtomIconFactory();
        for (AtomAction action : this.atomActions) {
            action.putValue("SmallIcon", factory.getIcon(action.getAtomNumber(), ech));
            action.putValue("SwingLargeIconKey", factory.getIcon(action.getAtomNumber(), ech));
            action.putValue("SelectedIcon", factory.getSelectedIcon(action.getAtomNumber(), ech));
        }
        this.revalidate();
        this.repaint();
    }

    static class ElementInfoPanel
    extends JPanel {
        private static final long serialVersionUID = -5253173971526415109L;
        private JLabel symbol = new JLabel();
        private JLabel name = new JLabel();
        private JLabel mass = new JLabel();
        private JLabel electroneg = new JLabel();
        private JLabel ox = new JLabel();
        private static final String ELEMENT_NAME = "ElementName";
        private static final String ELEMENT_AT_NO = "ElementAtNo";
        private static final String ELEMENT_MASS = "ElementMass";
        private static final String ELEMENT_ELECTRONEGATIVITY = "ElementElectronegativity";
        private static final String ELEMENT_OXIDATION = "ElementOxidation";

        public ElementInfoPanel() {
            ColumnSpec[] cs = new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC};
            RowSpec[] rs = new RowSpec[11];
            for (int i = 0; i < 5; ++i) {
                rs[2 * i] = FormFactory.NARROW_LINE_GAP_ROWSPEC;
                rs[2 * i + 1] = FormFactory.DEFAULT_ROWSPEC;
            }
            rs[10] = FormFactory.LINE_GAP_ROWSPEC;
            CellConstraints cc = new CellConstraints();
            DefaultComponentFactory compFactory = DefaultComponentFactory.getInstance();
            this.setLayout((LayoutManager)new FormLayout(cs, rs));
            this.add((Component)compFactory.createTitle(RESOURCES.getString(ELEMENT_NAME)), cc.xy(2, 2));
            this.add((Component)this.symbol, cc.xy(4, 2));
            this.add((Component)compFactory.createTitle(RESOURCES.getString(ELEMENT_AT_NO)), cc.xy(2, 4));
            this.add((Component)this.name, cc.xy(4, 4));
            this.add((Component)compFactory.createTitle(RESOURCES.getString(ELEMENT_MASS)), cc.xy(2, 6));
            this.add((Component)this.mass, cc.xy(4, 6));
            this.add((Component)compFactory.createTitle(RESOURCES.getString(ELEMENT_ELECTRONEGATIVITY)), cc.xy(2, 8));
            this.add((Component)this.electroneg, cc.xy(4, 8));
            this.add((Component)compFactory.createTitle(RESOURCES.getString(ELEMENT_OXIDATION)), cc.xy(2, 10));
            this.add((Component)this.ox, cc.xy(4, 10));
        }

        public void update(int atomNo) {
            if (atomNo > PeriodicSystem.getElementCount()) {
                return;
            }
            this.symbol.setText(PeriodicSystem.getName(atomNo) + " (" + PeriodicSystem.getSymbol(atomNo) + ")");
            this.name.setText("" + atomNo);
            this.mass.setText("" + PeriodicSystem.getMass(atomNo));
            this.electroneg.setText("" + (double)MolAtom.electronegOf(atomNo) / 10.0);
            String os = "";
            int oxstates = MolAtom.numoxstatesOf(atomNo);
            if (oxstates != 0) {
                for (int j = 0; j < oxstates; ++j) {
                    int o = MolAtom.oxstateOf(atomNo, j);
                    if (j > 0) {
                        os = os + ',';
                    }
                    os = os + String.valueOf(o);
                }
            }
            this.ox.setText(os);
        }
    }
}

