/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.modules.periodic;

import chemaxon.formats.MFileFormat;
import chemaxon.formats.MolInputStream;
import chemaxon.marvin.io.MolImportModule;
import chemaxon.marvin.sketch.swing.modules.periodic.CustomPropertyBuilder;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class SmartsBuilder
implements CustomPropertyBuilder {
    @Override
    public Molecule buildMolecule(String input, int dim) {
        Molecule mol;
        block4: {
            mol = null;
            try {
                mol = this.readMol(input);
            }
            catch (IOException ex) {
                if (input.startsWith("[")) break block4;
                String tryThisInput = "[" + input + "]";
                try {
                    mol = this.readMol(tryThisInput);
                    return mol;
                }
                catch (Exception exception) {
                    return null;
                }
            }
        }
        this.fixMolecule(mol, dim);
        return mol;
    }

    private Molecule readMol(String smarts) throws IOException {
        Molecule mol = new Molecule();
        MolInputStream mis = new MolInputStream((InputStream)new ByteArrayInputStream(smarts.getBytes()), "smarts");
        MolImportModule mii = MFileFormat.SMARTS.createImportModule();
        mii.initMolImport(mis);
        mii.readMol(mol);
        return mol;
    }

    private void fixMolecule(Molecule m, int dim) {
        if (m != null && m.getAtomCount() > 1) {
            m.clean(dim, null);
            m.valenceCheck();
            DPoint3 center = m.calcCenter();
            m.setLocation(center);
        }
    }

    @Override
    public Molecule buildRepresentativeMolecule() {
        MolAtom a = new MolAtom(6);
        a.setQuerystr("[]");
        return new Molecule(null, a);
    }
}

