/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.modules.services;

import chemaxon.marvin.services.ServiceDescriptor;
import chemaxon.marvin.services.ServiceDescriptorEditor;
import chemaxon.marvin.services.ServiceDescriptorEditorProvider;
import chemaxon.marvin.services.ServiceDescriptorTools;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ServiceDescriptorEditorPanel
extends JPanel {
    private static final long serialVersionUID = 4354286078444737316L;
    private final Set<Class<ServiceDescriptor>> supportedDescriptorClasses;
    private final Map<Class<ServiceDescriptor>, ServiceDescriptorEditor<ServiceDescriptor>> editorMap = new HashMap<Class<ServiceDescriptor>, ServiceDescriptorEditor<ServiceDescriptor>>();
    private final Map<Class<ServiceDescriptor>, String> descriptorNameMap = new HashMap<Class<ServiceDescriptor>, String>();
    private ServiceDescriptor descriptor = null;
    private JTextField serviceNameText = null;
    private JTextField serviceDescriptionText = null;
    private JComboBox serviceTypeCombo = null;
    private JPanel cardPanel = null;
    private final Action acceptAction;
    private final Action cancelAction;
    private boolean innerEditorValid = false;
    private boolean nameEditedManually = false;
    private boolean descriptionEditedManually = false;
    private ServiceDescriptorEditor<ServiceDescriptor> currentEditor = null;
    private PropertyChangeListener preferredNameChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (!ServiceDescriptorEditorPanel.this.nameEditedManually) {
                ServiceDescriptorEditorPanel.this.getServiceNameText().setText(evt.getNewValue() == null ? "" : evt.getNewValue().toString());
            }
        }
    };
    private PropertyChangeListener preferredDescriptionChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (!ServiceDescriptorEditorPanel.this.descriptionEditedManually) {
                ServiceDescriptorEditorPanel.this.getServiceDescriptionText().setText(evt.getNewValue() == null ? "" : evt.getNewValue().toString());
            }
        }
    };

    public ServiceDescriptorEditorPanel() {
        this(null, null);
    }

    public ServiceDescriptorEditorPanel(Action acceptAction, Action cancelAction) {
        this.acceptAction = acceptAction;
        this.cancelAction = cancelAction;
        ServiceDescriptorEditorProvider provider = ServiceDescriptorTools.getDefaultServiceDescriptorEditorProvider();
        if (provider != null) {
            this.supportedDescriptorClasses = provider.getSupportedDescriptors();
            for (Class<ServiceDescriptor> descriptorClass : this.supportedDescriptorClasses) {
                try {
                    ServiceDescriptor instance = descriptorClass.newInstance();
                    ServiceDescriptorEditor<ServiceDescriptor> editor = provider.getEditor(descriptorClass);
                    editor.getEditor().addPropertyChangeListener("EditorValid", new PropertyChangeListener(){

                        @Override
                        public void propertyChange(PropertyChangeEvent evt) {
                            if (evt.getNewValue() instanceof Boolean) {
                                ServiceDescriptorEditorPanel.this.innerEditorValid = (Boolean)evt.getNewValue();
                                ServiceDescriptorEditorPanel.this.updateAcceptAction();
                            }
                        }
                    });
                    this.editorMap.put(descriptorClass, editor);
                    this.descriptorNameMap.put(descriptorClass, instance.getSimpleName());
                }
                catch (Exception e) {}
            }
        } else {
            this.supportedDescriptorClasses = Collections.unmodifiableSet(new HashSet());
        }
        this.initialize();
    }

    private void updateAcceptAction() {
        if (this.acceptAction != null) {
            boolean valid = this.getServiceNameText().getText().trim().length() > 0;
            this.acceptAction.setEnabled(this.innerEditorValid && valid);
        }
    }

    private void initialize() {
        CellConstraints cc = new CellConstraints();
        this.setLayout(new BorderLayout());
        JPanel north = new JPanel();
        north.setLayout((LayoutManager)new FormLayout("pref, 2dlu, fill:min:grow", "min, 2dlu, min, 2dlu, min"));
        north.add((Component)new JLabel("Service name:"), cc.xy(1, 1));
        north.add((Component)this.getServiceNameText(), cc.xy(3, 1));
        north.add((Component)new JLabel("Service description:"), cc.xy(1, 3));
        north.add((Component)this.getServiceDescriptionText(), cc.xy(3, 3));
        north.add((Component)new JLabel("Service type:"), cc.xy(1, 5));
        north.add((Component)this.getServiceTypeCombo(), cc.xy(3, 5));
        JPanel south = new JPanel();
        south.setLayout((LayoutManager)new FormLayout("fill:min:grow, pref, 4dlu, pref, fill:min:grow", "min"));
        if (this.acceptAction != null) {
            this.acceptAction.setEnabled(false);
            south.add((Component)new JButton(this.acceptAction), cc.xy(2, 1));
        }
        if (this.cancelAction != null) {
            south.add((Component)new JButton(this.cancelAction), cc.xy(4, 1));
        }
        this.add((Component)north, "North");
        this.add((Component)south, "South");
        this.add((Component)this.getCardPanel(), "Center");
    }

    private JTextField getServiceNameText() {
        if (this.serviceNameText == null) {
            this.serviceNameText = new JTextField(){

                @Override
                protected void paintComponent(Graphics g) {
                    super.paintComponent(g);
                    if (this.getText() == null || this.getText().trim().length() < 1 && !this.hasFocus()) {
                        Graphics2D g2 = (Graphics2D)g.create();
                        g2.setColor(Color.GRAY);
                        g2.setFont(this.getFont());
                        g2.drawString("<Enter Service name>", 10, g2.getFontMetrics().getHeight() + (this.getHeight() - g2.getFontMetrics().getHeight()) / 2 - 3);
                        g2.dispose();
                    }
                }
            };
            this.serviceNameText.getDocument().addDocumentListener(new DocumentListener(){

                private void handleChanges(DocumentEvent e) {
                    if (ServiceDescriptorEditorPanel.this.serviceNameText.hasFocus()) {
                        if (ServiceDescriptorEditorPanel.this.serviceNameText.getText() == null || ServiceDescriptorEditorPanel.this.serviceNameText.getText().trim().length() < 1) {
                            ServiceDescriptorEditorPanel.this.nameEditedManually = false;
                        } else {
                            ServiceDescriptorEditorPanel.this.nameEditedManually = true;
                        }
                    }
                    ServiceDescriptorEditorPanel.this.updateAcceptAction();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.handleChanges(e);
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.handleChanges(e);
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.handleChanges(e);
                }
            });
        }
        return this.serviceNameText;
    }

    private JTextField getServiceDescriptionText() {
        if (this.serviceDescriptionText == null) {
            this.serviceDescriptionText = new JTextField(){

                @Override
                protected void paintComponent(Graphics g) {
                    super.paintComponent(g);
                    if (this.getText() == null || this.getText().trim().length() < 1 && !this.hasFocus()) {
                        Graphics2D g2 = (Graphics2D)g.create();
                        g2.setColor(Color.GRAY);
                        g2.setFont(this.getFont());
                        g2.drawString("<Optional Description>", 10, g2.getFontMetrics().getHeight() + (this.getHeight() - g2.getFontMetrics().getHeight()) / 2 - 3);
                        g2.dispose();
                    }
                }
            };
            this.serviceDescriptionText.getDocument().addDocumentListener(new DocumentListener(){

                private void handleChanges(DocumentEvent e) {
                    if (ServiceDescriptorEditorPanel.this.serviceDescriptionText.hasFocus()) {
                        if (ServiceDescriptorEditorPanel.this.serviceDescriptionText.getText() == null || ServiceDescriptorEditorPanel.this.serviceDescriptionText.getText().trim().length() < 1) {
                            ServiceDescriptorEditorPanel.this.descriptionEditedManually = false;
                        } else {
                            ServiceDescriptorEditorPanel.this.descriptionEditedManually = true;
                        }
                    }
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.handleChanges(e);
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.handleChanges(e);
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.handleChanges(e);
                }
            });
        }
        return this.serviceDescriptionText;
    }

    private JPanel getCardPanel() {
        if (this.cardPanel == null) {
            this.cardPanel = new JPanel(new CardLayout());
            for (Class<ServiceDescriptor> editorClass : this.editorMap.keySet()) {
                this.cardPanel.add((Component)this.editorMap.get(editorClass).getEditor(), editorClass.getName());
            }
        }
        return this.cardPanel;
    }

    private JComboBox getServiceTypeCombo() {
        if (this.serviceTypeCombo == null) {
            this.serviceTypeCombo = new JComboBox<Object>(this.supportedDescriptorClasses.toArray());
            this.serviceTypeCombo.setRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                    if (ServiceDescriptorEditorPanel.this.descriptorNameMap.containsKey(value)) {
                        label.setText((String)ServiceDescriptorEditorPanel.this.descriptorNameMap.get(value));
                    }
                    return label;
                }
            });
            this.serviceTypeCombo.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        ServiceDescriptorEditorPanel.this.innerEditorValid = false;
                        if (ServiceDescriptorEditorPanel.this.currentEditor != null && ServiceDescriptorEditorPanel.this.currentEditor.getPropertyChangeSupport() != null) {
                            ServiceDescriptorEditorPanel.this.currentEditor.getPropertyChangeSupport().removePropertyChangeListener("PreferredName", ServiceDescriptorEditorPanel.this.preferredNameChangeListener);
                            ServiceDescriptorEditorPanel.this.currentEditor.getPropertyChangeSupport().removePropertyChangeListener("PreferredDescription", ServiceDescriptorEditorPanel.this.preferredDescriptionChangeListener);
                            ServiceDescriptorEditorPanel.this.currentEditor.getEditor().putClientProperty("UserSettings", null);
                        }
                        ServiceDescriptorEditorPanel.this.updatePanel();
                        if (ServiceDescriptorEditorPanel.this.currentEditor != null && ServiceDescriptorEditorPanel.this.currentEditor.getPropertyChangeSupport() != null) {
                            ServiceDescriptorEditorPanel.this.currentEditor.getPropertyChangeSupport().addPropertyChangeListener("PreferredName", ServiceDescriptorEditorPanel.this.preferredNameChangeListener);
                            ServiceDescriptorEditorPanel.this.currentEditor.getPropertyChangeSupport().addPropertyChangeListener("PreferredDescription", ServiceDescriptorEditorPanel.this.preferredDescriptionChangeListener);
                            ServiceDescriptorEditorPanel.this.currentEditor.getEditor().putClientProperty("UserSettings", ServiceDescriptorEditorPanel.this.getClientProperty("UserSettings"));
                        }
                    }
                }
            });
        }
        return this.serviceTypeCombo;
    }

    public void setDescriptor(ServiceDescriptor descriptor) throws IllegalArgumentException {
        if (descriptor == null || this.supportedDescriptorClasses.contains(descriptor.getClass())) {
            this.descriptor = descriptor;
            if (descriptor != null) {
                this.getServiceTypeCombo().setSelectedItem(descriptor.getClass());
            }
            if (this.currentEditor != null && this.currentEditor.getPropertyChangeSupport() != null) {
                this.currentEditor.getPropertyChangeSupport().addPropertyChangeListener("PreferredName", this.preferredNameChangeListener);
                this.currentEditor.getPropertyChangeSupport().addPropertyChangeListener("PreferredDescription", this.preferredDescriptionChangeListener);
            }
        } else {
            StringBuilder msg = new StringBuilder("Only the following descriptors are supported: ");
            Class[] classes = this.supportedDescriptorClasses.toArray(new Class[this.supportedDescriptorClasses.size()]);
            for (int i = 0; i < classes.length; ++i) {
                msg.append(classes[i]);
                if (i + 1 >= classes.length) continue;
                msg.append(", ");
            }
            throw new IllegalArgumentException(msg.toString());
        }
        this.updatePanel();
    }

    public ServiceDescriptor getDescriptor() {
        if (this.currentEditor != null) {
            ServiceDescriptor descriptor = this.currentEditor.getDescriptor();
            if (descriptor != null) {
                descriptor.setName(this.getServiceNameText().getText());
                descriptor.setDescription(this.getServiceDescriptionText().getText().trim().length() > 0 ? this.getServiceDescriptionText().getText() : null);
            }
            return descriptor;
        }
        return this.descriptor;
    }

    private void updatePanel() {
        if (this.descriptor == null) {
            this.nameEditedManually = false;
            this.descriptionEditedManually = false;
            this.getServiceNameText().setText("");
            this.getServiceDescriptionText().setText("");
            this.getServiceTypeCombo().setEnabled(true);
        } else {
            this.nameEditedManually = true;
            this.descriptionEditedManually = true;
            this.getServiceNameText().setText(this.descriptor.getName());
            if (this.descriptor.getProperty("description") != null) {
                this.getServiceDescriptionText().setText(this.descriptor.getProperty("description"));
            } else {
                this.getServiceDescriptionText().setText("");
            }
            this.getServiceTypeCombo().setEnabled(false);
        }
        if (this.getServiceTypeCombo().getSelectedItem() != null) {
            ((CardLayout)this.getCardPanel().getLayout()).show(this.getCardPanel(), ((Class)this.getServiceTypeCombo().getSelectedItem()).getName());
            this.currentEditor = this.editorMap.get(this.getServiceTypeCombo().getSelectedItem());
            if (this.currentEditor != null) {
                try {
                    this.currentEditor.setDescriptor(this.descriptor);
                }
                catch (Exception e) {
                    this.currentEditor = null;
                    JOptionPane.showMessageDialog(this, e.getMessage(), "Can not open service editor", 0);
                }
            }
        } else {
            this.currentEditor = null;
        }
    }
}

