/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.modules.services;

import chemaxon.marvin.services.ServiceDescriptor;
import chemaxon.marvin.services.ServiceDescriptorReader;
import chemaxon.marvin.services.ServiceDescriptorWriter;
import chemaxon.marvin.sketch.swing.modules.services.ServiceDescriptorEditorPanel;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;

public class ServicePreferencesPanel
extends JPanel {
    private static final long serialVersionUID = -7130351847011872809L;
    private static final String LIST_PANEL = "listPanel";
    private static final String EDITOR_PANEL = "addPanel";
    private JToolBar toolbar = null;
    private JButton moveUpButton = null;
    private JButton moveDownButton = null;
    private JButton addButton = null;
    private JButton removeButton = null;
    private JButton importButton = null;
    private JButton exportButton = null;
    private JList servicesList = null;
    private JPanel listPanel = null;
    private ServiceDescriptorEditorPanel editorPanel = null;
    private JFileChooser fileChooser = null;
    private final ServiceDescriptorReader serviceDescriptorReader;
    private final ServiceDescriptorWriter serviceDescriptorWriter;
    private int editedItemIndex = -1;
    private final Action MOVE_UP_ACTION = new AbstractAction("", new ImageIcon(this.getClass().getResource("/chemaxon/icons/marvin/services/up.png"))){

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultListModel model = (DefaultListModel)ServicePreferencesPanel.this.getServicesList().getModel();
            int pos = ServicePreferencesPanel.this.getServicesList().getSelectedIndex();
            int length = ServicePreferencesPanel.this.getServicesList().getSelectedIndices().length;
            if (pos > 0) {
                Object item = model.remove(pos - 1);
                model.add(pos + length - 1, item);
            }
            ServicePreferencesPanel.this.updateActions();
        }
    };
    private final Action MOVE_DOWN_ACTION = new AbstractAction("", new ImageIcon(this.getClass().getResource("/chemaxon/icons/marvin/services/down.png"))){

        @Override
        public void actionPerformed(ActionEvent e) {
            int length;
            DefaultListModel model = (DefaultListModel)ServicePreferencesPanel.this.getServicesList().getModel();
            int pos = ServicePreferencesPanel.this.getServicesList().getSelectedIndex();
            if (pos + (length = ServicePreferencesPanel.this.getServicesList().getSelectedIndices().length) - 1 < model.getSize() - 1) {
                Object item = model.remove(pos + length);
                model.add(pos, item);
                ServicePreferencesPanel.this.getServicesList().setSelectionInterval(pos + 1, pos + length);
            }
            ServicePreferencesPanel.this.updateActions();
        }
    };
    private final Action ACCEPT_ACTION = new AbstractAction("Accept"){

        @Override
        public void actionPerformed(ActionEvent e) {
            ServiceDescriptor descriptor = ServicePreferencesPanel.this.getEditorPanel().getDescriptor();
            if (descriptor != null) {
                if (ServicePreferencesPanel.this.editedItemIndex == -1) {
                    ((DefaultListModel)ServicePreferencesPanel.this.getServicesList().getModel()).addElement(descriptor);
                } else {
                    ((DefaultListModel)ServicePreferencesPanel.this.getServicesList().getModel()).setElementAt(descriptor, ServicePreferencesPanel.this.editedItemIndex);
                }
            }
            ((CardLayout)ServicePreferencesPanel.this.getLayout()).show(ServicePreferencesPanel.this, ServicePreferencesPanel.LIST_PANEL);
        }
    };
    private final Action CANCEL_ACTION = new AbstractAction("Cancel"){

        @Override
        public void actionPerformed(ActionEvent e) {
            ((CardLayout)ServicePreferencesPanel.this.getLayout()).show(ServicePreferencesPanel.this, ServicePreferencesPanel.LIST_PANEL);
        }
    };
    private final Action ADD_ACTION = new AbstractAction("", new ImageIcon(this.getClass().getResource("/chemaxon/icons/marvin/services/add.png"))){

        @Override
        public void actionPerformed(ActionEvent e) {
            ServicePreferencesPanel.this.editedItemIndex = -1;
            ServicePreferencesPanel.this.editDescriptor(null);
        }
    };
    private final Action REMOVE_ACTION = new AbstractAction("", new ImageIcon(this.getClass().getResource("/chemaxon/icons/marvin/services/remove.png"))){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ServicePreferencesPanel.this.getServicesList().getSelectedIndex() != -1) {
                Object[] values = ServicePreferencesPanel.this.getServicesList().getSelectedValues();
                if (JOptionPane.showConfirmDialog(ServicePreferencesPanel.this, "Do you want to remove selected " + (values.length > 1 ? "Services?" : "Service?"), "Remove Service Configuration", 0) == 0) {
                    for (Object value : values) {
                        ((DefaultListModel)ServicePreferencesPanel.this.getServicesList().getModel()).removeElement(value);
                    }
                }
            }
        }
    };
    private final Action IMPORT_ACTION = new AbstractAction("", new ImageIcon(this.getClass().getResource("/chemaxon/icons/marvin/services/open.png"))){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ServicePreferencesPanel.this.getFileChooser() != null && ServicePreferencesPanel.this.serviceDescriptorReader != null && ServicePreferencesPanel.this.getFileChooser().showOpenDialog(ServicePreferencesPanel.this) == 0) {
                try {
                    ServicePreferencesPanel.this.loadConfiguration(ServicePreferencesPanel.this.serviceDescriptorReader, new FileInputStream(ServicePreferencesPanel.this.getFileChooser().getSelectedFile()));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
        }
    };
    private final Action EXPORT_ACTION = new AbstractAction("", new ImageIcon(this.getClass().getResource("/chemaxon/icons/marvin/services/save.png"))){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ServicePreferencesPanel.this.getFileChooser() != null && ServicePreferencesPanel.this.serviceDescriptorWriter != null && ServicePreferencesPanel.this.getFileChooser().showSaveDialog(ServicePreferencesPanel.this) == 0) {
                try {
                    ServicePreferencesPanel.this.saveConfiguration(ServicePreferencesPanel.this.serviceDescriptorWriter, new FileOutputStream(ServicePreferencesPanel.this.getFileChooser().getSelectedFile()));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
        }
    };

    public ServicePreferencesPanel(ServiceDescriptorReader reader, ServiceDescriptorWriter writer, InputStream configuration) {
        this.serviceDescriptorReader = reader;
        this.serviceDescriptorWriter = writer;
        this.initialize();
        if (configuration != null && reader != null) {
            this.loadConfiguration(reader, configuration);
        }
    }

    private void initialize() {
        this.setLayout(new CardLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)this.getListPanel(), LIST_PANEL);
        this.add((Component)this.getEditorPanel(), EDITOR_PANEL);
        ((CardLayout)this.getLayout()).show(this, LIST_PANEL);
        this.updateActions();
    }

    private JPanel getListPanel() {
        if (this.listPanel == null) {
            this.listPanel = new JPanel(new BorderLayout());
            this.listPanel.add(new JScrollPane(this.getServicesList(), 20, 31));
            this.listPanel.add((Component)this.getToolbar(), "East");
        }
        return this.listPanel;
    }

    public ServiceDescriptorEditorPanel getEditorPanel() {
        if (this.editorPanel == null) {
            this.editorPanel = new ServiceDescriptorEditorPanel(this.ACCEPT_ACTION, this.CANCEL_ACTION);
        }
        return this.editorPanel;
    }

    private JFileChooser getFileChooser() {
        if (this.fileChooser == null) {
            try {
                this.fileChooser = new JFileChooser();
                this.fileChooser.setFileFilter(new FileFilter(){

                    @Override
                    public boolean accept(File f) {
                        return f.isDirectory() || f.getAbsolutePath().toLowerCase().endsWith(".xml");
                    }

                    @Override
                    public String getDescription() {
                        return "Marvin Services Configuration (*.xml)";
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.fileChooser;
    }

    private JList getServicesList() {
        if (this.servicesList == null) {
            this.servicesList = new JList(new DefaultListModel());
            this.servicesList.setCellRenderer(new ServiceDescriptorListCellRenderer());
            this.servicesList.setSelectionMode(1);
            this.servicesList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    ServicePreferencesPanel.this.updateActions();
                }
            });
            this.servicesList.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getButton() == 1 && e.getClickCount() == 2) {
                        ServicePreferencesPanel.this.editedItemIndex = ServicePreferencesPanel.this.servicesList.getSelectedIndex();
                        ServicePreferencesPanel.this.editDescriptor((ServiceDescriptor)ServicePreferencesPanel.this.servicesList.getSelectedValue());
                    }
                }
            });
            this.servicesList.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        ServicePreferencesPanel.this.editedItemIndex = ServicePreferencesPanel.this.servicesList.getSelectedIndex();
                        ServicePreferencesPanel.this.editDescriptor((ServiceDescriptor)ServicePreferencesPanel.this.servicesList.getSelectedValue());
                    }
                }
            });
        }
        return this.servicesList;
    }

    public void loadConfiguration(ServiceDescriptorReader reader, InputStream input) {
        List<ServiceDescriptor> descriptors = reader.readServiceDescriptors(input);
        ((DefaultListModel)this.getServicesList().getModel()).clear();
        for (ServiceDescriptor descriptor : descriptors) {
            ((DefaultListModel)this.getServicesList().getModel()).addElement(descriptor);
        }
    }

    public void saveConfiguration(ServiceDescriptorWriter writer, OutputStream output) {
        ArrayList<ServiceDescriptor> descriptors = new ArrayList<ServiceDescriptor>(this.getServicesList().getModel().getSize());
        for (int i = 0; i < this.getServicesList().getModel().getSize(); ++i) {
            if (!(this.getServicesList().getModel().getElementAt(i) instanceof ServiceDescriptor)) continue;
            descriptors.add((ServiceDescriptor)this.getServicesList().getModel().getElementAt(i));
        }
        writer.writeServiceDescriptors(descriptors, output);
    }

    private JToolBar getToolbar() {
        if (this.toolbar == null) {
            this.toolbar = new JToolBar(1);
            this.toolbar.add(this.getMoveUpButton());
            this.toolbar.add(this.getMoveDownButton());
            this.toolbar.add(this.getAddButton());
            this.toolbar.add(this.getRemoveButton());
            this.toolbar.add(this.getImportButton());
            this.toolbar.add(this.getExportButton());
            this.toolbar.setFloatable(false);
            this.toolbar.setRollover(true);
            this.toolbar.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        }
        return this.toolbar;
    }

    private void updateActions() {
        int index = this.getServicesList().getSelectedIndex();
        this.REMOVE_ACTION.setEnabled(index != -1);
        this.MOVE_UP_ACTION.setEnabled(index > 0);
        this.MOVE_DOWN_ACTION.setEnabled(index > -1 && index + this.getServicesList().getSelectedIndices().length - 1 < this.getServicesList().getModel().getSize() - 1);
    }

    private JButton getMoveUpButton() {
        if (this.moveUpButton == null) {
            this.moveUpButton = new JButton(this.MOVE_UP_ACTION);
            this.moveUpButton.setToolTipText("Move selected Service upwards in list");
        }
        return this.moveUpButton;
    }

    private JButton getMoveDownButton() {
        if (this.moveDownButton == null) {
            this.moveDownButton = new JButton(this.MOVE_DOWN_ACTION);
            this.moveDownButton.setToolTipText("Move selected Service downwards in list");
        }
        return this.moveDownButton;
    }

    private JButton getAddButton() {
        if (this.addButton == null) {
            this.addButton = new JButton(this.ADD_ACTION);
            this.addButton.setToolTipText("Add new Service...");
        }
        return this.addButton;
    }

    private JButton getRemoveButton() {
        if (this.removeButton == null) {
            this.removeButton = new JButton(this.REMOVE_ACTION);
            this.removeButton.setToolTipText("Remove selected Service");
        }
        return this.removeButton;
    }

    private JButton getImportButton() {
        if (this.importButton == null) {
            this.importButton = new JButton(this.IMPORT_ACTION);
            this.importButton.setToolTipText("Import Service Configuration from file");
        }
        return this.importButton;
    }

    private JButton getExportButton() {
        if (this.exportButton == null) {
            this.exportButton = new JButton(this.EXPORT_ACTION);
            this.exportButton.setToolTipText("Export Service Configuration to file");
        }
        return this.exportButton;
    }

    private void editDescriptor(ServiceDescriptor descriptor) {
        try {
            this.getEditorPanel().setDescriptor(descriptor);
            ((CardLayout)this.getLayout()).show(this, EDITOR_PANEL);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void clear() {
        ((DefaultListModel)this.getServicesList().getModel()).clear();
    }

    private static final class ServiceDescriptorListCellRenderer
    extends DefaultListCellRenderer {
        private ServiceDescriptorListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof ServiceDescriptor) {
                StringBuilder labelBuilder = new StringBuilder("<html><body>");
                if (((ServiceDescriptor)value).isAvailable()) {
                    labelBuilder.append("<b>");
                } else {
                    labelBuilder.append("<i><b><font color=\"gray\">");
                }
                labelBuilder.append(((ServiceDescriptor)value).getName());
                if (((ServiceDescriptor)value).isAvailable()) {
                    labelBuilder.append("</b>");
                } else {
                    labelBuilder.append("</b></i></font>");
                }
                labelBuilder.append("<br/><i><font color=\"gray\">");
                labelBuilder.append(((ServiceDescriptor)value).getSimpleName());
                labelBuilder.append("</font></i></body></html>");
                label.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
                label.setText(labelBuilder.toString());
                label.setToolTipText(((ServiceDescriptor)value).getDescription());
                label.setIcon(((ServiceDescriptor)value).getIcon());
            }
            return label;
        }
    }
}

