/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.modules.symbolsdialog.impl;

import java.awt.Font;
import java.lang.ref.SoftReference;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

final class CharacterMap {
    private static final Map<String, SoftReference<CharacterMap>> instances = new HashMap<String, SoftReference<CharacterMap>>();
    private final Font font;
    private Map<Character.UnicodeBlock, Block> blocks;
    private int[] characters;

    CharacterMap() {
        this(null);
    }

    CharacterMap(Font font) {
        this.font = font;
        this.blocks = new LinkedHashMap<Character.UnicodeBlock, Block>();
    }

    public static synchronized CharacterMap lookup(String family) {
        CharacterMap result;
        SoftReference<CharacterMap> ref = instances.get(family);
        CharacterMap characterMap = result = ref != null ? ref.get() : null;
        if (result == null) {
            result = new CharacterMap(new Font(family, 0, 1));
            instances.put(family, new SoftReference<CharacterMap>(result));
        }
        return result;
    }

    private void enumerateCharacters() {
        if (this.characters != null) {
            return;
        }
        if (this.font == null) {
            this.characters = new int[0];
            return;
        }
        int[] result = new int[100];
        int index = 0;
        Block currentBlock = null;
        for (int i = 0; i <= 0x10FFFF; ++i) {
            Character.UnicodeBlock block;
            int type;
            if (Character.isISOControl(i) || !Character.isDefined(i) || !this.font.canDisplay(i) || (type = Character.getType(i)) == 16 || type == 15 || type == 14 || type == 13 || (block = Character.UnicodeBlock.of(i)) == null) continue;
            if (currentBlock == null || !block.equals(currentBlock.getBlock())) {
                currentBlock = this.createAndAdd(block, index);
            }
            currentBlock.setEnd(index);
            result = CharacterMap.add(result, index, i);
            ++index;
        }
        this.characters = Arrays.copyOf(result, Math.max(0, index));
    }

    private Block createAndAdd(Character.UnicodeBlock block, int index) {
        Block result = new Block(block, index);
        this.blocks.put(block, result);
        return result;
    }

    private static int[] add(int[] t, int index, int value) {
        int[] result = t;
        if (index >= t.length) {
            result = Arrays.copyOf(t, t.length * 3 / 2 + 1);
        }
        result[index] = value;
        return result;
    }

    public Collection<Character.UnicodeBlock> getSupportedBlocks() {
        this.enumerateCharacters();
        return Collections.unmodifiableCollection(this.blocks.keySet());
    }

    public int getCharacter(int i) {
        this.enumerateCharacters();
        return this.characters[i];
    }

    public int indexOf(int character) {
        this.enumerateCharacters();
        return Math.max(-1, Arrays.binarySearch(this.characters, character));
    }

    public int getBlockStart(Character.UnicodeBlock block) {
        this.enumerateCharacters();
        return this.blocks.get(block).getStart();
    }

    public int getBlockEnd(Character.UnicodeBlock block) {
        this.enumerateCharacters();
        return this.blocks.get(block).getEnd();
    }

    public int getCharacterCount() {
        this.enumerateCharacters();
        return this.characters.length;
    }

    public Font getFont() {
        return this.font;
    }

    private static class Block {
        private final int start;
        private int end;
        private final Character.UnicodeBlock block;

        public Block(Character.UnicodeBlock block, int start) {
            this.block = block;
            this.start = start;
            this.end = start;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        public void setEnd(int end) {
            this.end = end;
        }

        public Character.UnicodeBlock getBlock() {
            return this.block;
        }
    }
}

