/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.modules.symbolsdialog.impl;

import chemaxon.marvin.sketch.swing.modules.symbolsdialog.impl.CharacterModel;
import chemaxon.marvin.sketch.swing.modules.symbolsdialog.impl.LRUModel;
import chemaxon.marvin.uif.util.Utils;
import chemaxon.marvin.uif.util.swing.AbstractView;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;

final class LRUView
extends AbstractView {
    private static final int COLUM_COUNT = 6;
    private static int MAX_ACTION_COUNT = 24;
    private List<JButton> buttons;
    private LRUModel model;

    public LRUView(CharacterModel model, Component owner) {
        this.model = new LRUModel(model, owner, MAX_ACTION_COUNT);
    }

    private void initComponents() {
        this.buttons = new ArrayList<JButton>();
        Action[] actions = this.model.getSymbolActions();
        for (int i = 0; i < Math.min(MAX_ACTION_COUNT, actions.length); ++i) {
            this.buttons.add(LRUView.createButton(actions[i]));
        }
    }

    private static JButton createButton(Action action) {
        JButton result = new JButton(action){

            @Override
            public Dimension getPreferredSize() {
                Dimension d = super.getPreferredSize();
                if (d == null) {
                    return null;
                }
                d.height = d.width = Math.max(d.width, d.height);
                return d;
            }
        };
        result.putClientProperty("JButton.buttonType", "toolbar");
        if (!Utils.isLafAqua()) {
            result.setMargin(new Insets(0, 0, 0, 0));
        }
        result.setAlignmentY(0.5f);
        result.setAlignmentX(0.5f);
        result.putClientProperty(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        result.setFocusable(false);
        result.setRolloverEnabled(true);
        result.addActionListener(new PopupHandler());
        return result;
    }

    @Override
    protected JComponent buildComponent() {
        this.initComponents();
        JPanel result = new JPanel();
        result.setLayout(new BoxLayout(result, 1));
        result.add(this.createButtonPane());
        return result;
    }

    private Component createButtonPane() {
        JToolBar result = new JToolBar();
        result.setBorder(BorderFactory.createEmptyBorder());
        result.setFloatable(false);
        result.setRollover(true);
        result.setLayout(new GridLayout(0, 6, 0, 0));
        for (JButton button : this.buttons) {
            result.add(button);
        }
        return result;
    }

    public Action getMoreAction() {
        return this.model.getMoreSymbolsAction();
    }

    private static class PopupHandler
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            JPopupMenu popup = (JPopupMenu)SwingUtilities.getAncestorOfClass(JPopupMenu.class, (Component)e.getSource());
            if (popup != null) {
                popup.setVisible(false);
            }
        }
    }
}

