/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.modules.symbolsdialog.impl;

import chemaxon.marvin.sketch.swing.modules.symbolsdialog.impl.SymbolsPM;
import chemaxon.marvin.sketch.swing.modules.symbolsdialog.impl.UnicodeBlockNames;
import chemaxon.marvin.sketch.swing.modules.symbolsdialog.spi.Symbol;
import chemaxon.marvin.uif.util.swing.AbstractView;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;

final class SymbolsView
extends AbstractView {
    private static final int DEFAULT_FONT_SIZE = 18;
    private static final int ROW_COUNT = 4;
    private final SymbolsPM model;
    private JComboBox fontChooser;
    private JComboBox sectionChooser;
    private JTable characters;
    private JTable lruSymbols;
    private JTextField infoField;
    private JLabel recentLabel;
    private JLabel fontLabel;
    private JLabel sectionLabel;
    private JLabel infoLabel;
    private JScrollPane recentPane;
    private JScrollPane charactersPanel;

    public SymbolsView(SymbolsPM model) {
        this.model = model;
    }

    private void initComponents() {
        this.fontChooser = new JComboBox(this.model.getFonts());
        this.fontLabel = new JLabel("Font:");
        this.fontLabel.setLabelFor(this.fontChooser);
        this.fontLabel.setDisplayedMnemonic('f');
        this.fontLabel.setDisplayedMnemonicIndex(0);
        this.sectionChooser = new JComboBox(this.model.getSubsets());
        this.sectionChooser.setRenderer(new UnicodeBlockRenderer(this.sectionChooser.getRenderer()));
        this.sectionChooser.setPrototypeDisplayValue(Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS_SUPPLEMENT);
        this.sectionLabel = new JLabel("Subset:");
        this.sectionLabel.setLabelFor(this.sectionChooser);
        this.sectionLabel.setDisplayedMnemonic('u');
        this.sectionLabel.setDisplayedMnemonicIndex(1);
        this.characters = SymbolsView.configure(this.model.getCharacters(), 4, this.model.getRowSelection(), this.model.getColumnSelection());
        this.lruSymbols = SymbolsView.configure(this.model.getLRUSymbols(), 1, this.model.getLRURowSelection(), this.model.getLRUColumnSelection());
        this.lruSymbols.setInputVerifier(this.model.getLRUVerifier());
        this.infoField = new JTextField(this.model.getCharacterCode(), null, 6);
        this.infoField.addFocusListener(new FocusHandler());
        this.infoField.setInputVerifier(this.model.getCharacterCodeVerifier());
        this.infoLabel = new JLabel("Unicode (hex):");
        this.infoLabel.setDisplayedMnemonic('C');
        this.infoLabel.setLabelFor(this.infoField);
        this.recentLabel = new JLabel("Recently used symbols:");
        this.recentLabel.setDisplayedMnemonic('R');
        this.recentLabel.setLabelFor(this.lruSymbols);
        this.recentLabel.setAlignmentY(0.0f);
        this.recentLabel.setAlignmentX(0.0f);
        this.recentPane = new JScrollPane(this.lruSymbols, 22, 31);
        this.recentPane.getVerticalScrollBar().setEnabled(false);
        this.charactersPanel = new JScrollPane(this.characters, 22, 31);
        SymbolsView.scrollToSelcetion(this.characters);
    }

    private static JTable configure(TableModel model, int rowCount, ListSelectionModel rowSelection, ListSelectionModel columnSelection) {
        CharacterTable table = new CharacterTable(model, rowCount);
        table.setSelectionModel(rowSelection);
        table.getColumnModel().setSelectionModel(columnSelection);
        table.setTableHeader(null);
        table.setRowHeight(32);
        table.setCellSelectionEnabled(true);
        table.setDefaultRenderer(Symbol.class, new FontRenderer());
        table.setAutoscrolls(true);
        return table;
    }

    private void initEventHandling() {
        this.lruSymbols.addMouseListener(this.model.getDoubleClickHandler());
        this.characters.addMouseListener(this.model.getDoubleClickHandler());
        this.characters.getSelectionModel().addListSelectionListener(new ScrollHandler(this.characters));
        this.characters.getColumnModel().getSelectionModel().addListSelectionListener(new ScrollHandler(this.characters));
    }

    @Override
    public JComponent getInitialFocusedComponent() {
        return this.characters;
    }

    public Action getDefaultAction() {
        return this.model.getInsertAction();
    }

    @Override
    protected JComponent buildComponent() {
        this.initComponents();
        this.initEventHandling();
        JPanel result = new JPanel();
        result.setLayout(new BoxLayout(result, 1));
        result.add(this.createSelectorPanel());
        result.add(Box.createVerticalStrut(6));
        result.add(this.createLRUPanel());
        result.add(Box.createVerticalStrut(4));
        result.add(this.createInformationPanel());
        return result;
    }

    private Component createLRUPanel() {
        JPanel result = new JPanel();
        result.setLayout((LayoutManager)new FormLayout("default:grow", "default, 2dlu, default"));
        CellConstraints cc = new CellConstraints();
        result.add((Component)this.recentLabel, cc.xy(1, 1));
        result.add((Component)this.recentPane, cc.xy(1, 3));
        return result;
    }

    private Component createInformationPanel() {
        JPanel result = new JPanel();
        result.setLayout((LayoutManager)new FormLayout("default, 4dlu, default", "default"));
        CellConstraints cc = new CellConstraints();
        result.add((Component)this.infoLabel, cc.xy(1, 1));
        result.add((Component)this.infoField, cc.xy(3, 1));
        return result;
    }

    private Component createSelectorPanel() {
        JPanel result = new JPanel();
        result.setLayout((LayoutManager)new FormLayout("default, 4dlu, default, 20dlu:grow, default, 4dlu, default", "default, 2dlu, default"));
        CellConstraints cc = new CellConstraints();
        result.add((Component)this.fontLabel, cc.xy(1, 1));
        result.add((Component)this.fontChooser, cc.xy(3, 1));
        result.add((Component)this.sectionLabel, cc.xy(5, 1));
        result.add((Component)this.sectionChooser, cc.xy(7, 1));
        result.add((Component)this.charactersPanel, cc.xyw(1, 3, 7));
        return result;
    }

    private static void scrollToSelcetion(JTable table) {
        table.scrollRectToVisible(table.getCellRect(table.getSelectedRow(), 0, true));
    }

    private static class UnicodeBlockRenderer
    implements ListCellRenderer {
        private final ListCellRenderer delegate;

        public UnicodeBlockRenderer(ListCellRenderer delegate) {
            this.delegate = delegate;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            return this.delegate.getListCellRendererComponent(list, UnicodeBlockNames.lookupName((Character.UnicodeBlock)value), index, isSelected, cellHasFocus);
        }
    }

    private static class FocusHandler
    extends FocusAdapter {
        @Override
        public void focusGained(FocusEvent e) {
            if (e.getComponent() instanceof JTextComponent) {
                ((JTextComponent)e.getComponent()).selectAll();
            }
        }
    }

    private static class ScrollHandler
    implements ListSelectionListener {
        private JTable table;

        public ScrollHandler(JTable table) {
            this.table = table;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            if (this.table.getSelectedRow() != -1 && this.table.getSelectedColumn() != -1) {
                SymbolsView.scrollToSelcetion(this.table);
            }
        }
    }

    private static class FontRenderer
    extends DefaultTableCellRenderer {
        public FontRenderer() {
            this.setHorizontalAlignment(0);
            this.setVerticalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Symbol symbol = (Symbol)value;
            String str = symbol != null ? Symbol.newString(symbol.getCharacter()) : null;
            Component result = super.getTableCellRendererComponent(table, str, isSelected, hasFocus, row, column);
            if (symbol != null && !result.getFont().getFamily().equals(symbol.getFontFamily())) {
                result.setFont(new Font(symbol.getFontFamily(), 0, 18));
            }
            return result;
        }
    }

    private static final class CharacterTable
    extends JTable {
        private final int rowCount;

        public CharacterTable(TableModel dm, int rowCount) {
            super(dm);
            this.rowCount = rowCount;
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            Dimension preferredSize = super.getPreferredScrollableViewportSize();
            if (preferredSize == null) {
                return null;
            }
            Insets insets = this.getInsets();
            int dy = insets.top + insets.bottom;
            preferredSize.height = Math.min(this.rowCount, this.getRowCount()) * this.getRowHeight() + dy;
            return preferredSize;
        }

        @Override
        public void changeSelection(int rowIndex, int columnIndex, boolean toggle, boolean extend) {
            if (this.getValueAt(rowIndex, columnIndex) != null) {
                super.changeSelection(rowIndex, columnIndex, toggle, extend);
            }
        }
    }
}

