/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.templates;

import chemaxon.marvin.sketch.MoleculeSM;
import chemaxon.marvin.sketch.SketchMode;
import chemaxon.marvin.sketch.swing.SketchPanel;
import chemaxon.marvin.sketch.swing.actions.AbstractSketchModeAction;
import chemaxon.marvin.sketch.swing.templates.TemplateDisplayOption;
import chemaxon.marvin.sketch.swing.templates.TemplateIconFactory;
import chemaxon.marvin.sketch.templates.Template;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import chemaxon.struc.sgroup.DataSgroup;

public class TemplateAction
extends AbstractSketchModeAction {
    private static final long serialVersionUID = 1L;
    private SketchPanel sketchPanel;
    private Template template;
    private Molecule mol = null;
    private int behavior = 0;
    private TemplateDisplayOption displayOptions;

    public TemplateAction(Template template) {
        this(null, template);
    }

    public TemplateAction(SketchPanel sketchPanel, Template template) {
        super(sketchPanel);
        this.sketchPanel = sketchPanel;
        this.template = template;
        this.putValue("Name", template.getLongName());
        this.initShortDescription(template);
    }

    public void setDisplayOptions(TemplateDisplayOption options) {
        this.displayOptions = options;
    }

    public void setName(String s) {
        this.template.setLongName(s);
        this.putValue("Name", s);
        this.initShortDescription(this.template);
    }

    @Override
    public Object getValue(String key) {
        if ("SmallIcon".equals(key)) {
            return TemplateIconFactory.getInstance().getIcon(this.getTemplate(), this.displayOptions);
        }
        if ("SwingLargeIconKey".equals(key)) {
            return TemplateIconFactory.getInstance().getIcon(this.getTemplate(), this.displayOptions);
        }
        return super.getValue(key);
    }

    public Template getTemplate() {
        return this.template;
    }

    public Molecule getMol() {
        if (this.sketchPanel != null && this.sketchPanel.getTemplateHandler().getTemplateBehavior() != this.behavior) {
            this.mol = null;
        }
        this.initMolecule();
        return this.mol;
    }

    private void initShortDescription(Template t) {
        String name = t.getLongName();
        name = "".equals(name) ? "no name" : name;
        String abbrev = t.getLeftAbbreviation();
        if (abbrev != null) {
            name = name + " (" + abbrev + ")";
        }
        this.putValue("ShortDescription", name);
    }

    public void actionPerformed(SketchPanel panel) {
        this.sketchPanel = panel;
        panel.setSketchMode(this.createSketchMode(), false, false, false, false);
    }

    private void initMolecule() {
        if (this.mol == null) {
            Molecule m = this.template.getMolecule();
            this.mol = m.getDocument() != null && !m.getDocument().isSimpleMolecule() ? m.cloneMoleculeWithDocument() : m.cloneMolecule();
            this.fixDimension();
            TemplateAction.removeSgroupLigands(this.mol);
            if (this.sketchPanel != null) {
                this.sketchPanel.prepareMol(this.mol);
            }
            DPoint3 center = new DPoint3();
            this.mol.calcCenter(center);
            this.mol.setLocation(center);
            this.mol.moveTo(this.mol.getLocation());
            this.mol.setProperty("sgroupState", "contract");
            this.mol.contractSgroups();
        }
    }

    private void fixDimension() {
        this.behavior = this.sketchPanel == null ? 0 : this.sketchPanel.getTemplateHandler().getTemplateBehavior();
        switch (this.behavior) {
            case 1: {
                this.mol = this.mol.cloneMolecule();
                this.mol.clean(2, null);
                return;
            }
            case 2: {
                this.mol = this.mol.cloneMolecule();
                this.mol.clean(3, null);
                return;
            }
        }
        if (this.mol.getDim() == 0) {
            this.mol = this.mol.cloneMolecule();
            this.mol.clean(2, null);
        }
    }

    private static void removeSgroupLigands(Molecule m) {
        MolAtom[] ligands = m.getSgroupLigands();
        if (ligands != null && m.getSgroupCount() > 0 && !(m.getSgroup(0) instanceof DataSgroup)) {
            for (int i = 0; i < ligands.length; ++i) {
                m.removeAtom(ligands[i]);
            }
        }
    }

    @Override
    protected SketchMode createSketchMode() {
        return new MoleculeSM(this.sketchPanel.getEditor(), this.getMol());
    }
}

