/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.templates;

import chemaxon.marvin.MolPrinter;
import chemaxon.marvin.sketch.swing.templates.TemplateDisplayOption;
import chemaxon.marvin.sketch.templates.Template;
import chemaxon.struc.Molecule;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class TemplateIconFactory {
    private MolPrinter painter = new MolPrinter();

    private TemplateIconFactory() {
        this.painter.setTransparent(true);
        this.painter.setImplicitH("off");
    }

    public synchronized Icon getIcon(Template template, TemplateDisplayOption options) {
        Molecule mol = template.getMolecule();
        mol = this.fixMolecule(mol);
        this.painter.setScale(this.getSimpleMoleculeScale(options, mol));
        if (options.getDisplayMode() == 1) {
            mol.setProperty("sgroupState", "expand");
            mol.expandSgroups();
        } else if (options.getDisplayMode() == 2) {
            mol.setProperty("sgroupState", "contract");
            mol.contractSgroups();
        }
        if (options.getSize() < 30) {
            this.painter.setMolTemplate(mol);
        } else {
            this.painter.setMol(mol);
        }
        this.painter.setAtomSize(options.getAtomSize());
        this.painter.setBackgroundColor(options.getBackground());
        return this.createIcon(options.getSize(), template.getLeftAbbreviation() != null);
    }

    private Molecule fixMolecule(Molecule mol) {
        if (mol != null && mol.getDim() == 0) {
            mol = mol.cloneMolecule();
            mol.clean(2, null);
        }
        return mol;
    }

    private double getSimpleMoleculeScale(TemplateDisplayOption options, Molecule m) {
        if (m.isAtom() || m.isBond()) {
            return options.getSimpleMoleculeScale();
        }
        return -1.0;
    }

    private Icon createIcon(int size, boolean b) {
        BufferedImage result = new BufferedImage(size, size, 6);
        Graphics2D g = result.createGraphics();
        g.setClip(0, 0, size, size);
        Dimension dim = new Dimension(size, size);
        if (this.painter.getScale() == -1.0) {
            double scale = this.painter.maxScale(dim);
            if (scale > 28.0) {
                scale = 28.0;
            }
            this.painter.setScale(scale);
        }
        this.painter.paint(g, dim);
        if (b) {
            this.markAsGroup(g, size);
        }
        g.dispose();
        return new ImageIcon(result);
    }

    private void markAsGroup(Graphics2D g, int size) {
        g.setColor(Color.blue);
        int x1 = 0;
        int x2 = 1;
        int x3 = 4;
        int x4 = 5;
        int y1 = size - 1;
        int y2 = size - 8;
        g.drawLine(x2, y2, x1, y2);
        g.drawLine(x1, y2, x1, y1);
        g.drawLine(x1, y1, x2, y1);
        g.drawLine(x3, y1, x4, y1);
        g.drawLine(x4, y1, x4, y2);
        g.drawLine(x4, y2, x3, y2);
    }

    public static TemplateIconFactory getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private static class SingletonHolder {
        private static final TemplateIconFactory INSTANCE = new TemplateIconFactory();

        private SingletonHolder() {
        }
    }
}

