/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.templates;

import chemaxon.marvin.sketch.swing.SketchPanel;
import chemaxon.marvin.sketch.swing.TemplateDialogFactory;
import chemaxon.marvin.sketch.swing.templates.TemplateAction;
import chemaxon.marvin.sketch.templates.Template;
import chemaxon.marvin.sketch.templates.TemplateLibrary;
import chemaxon.marvin.sketch.templates.TemplateLibraryListener;
import chemaxon.marvin.sketch.templates.TemplateSet;
import chemaxon.marvin.util.MarvinModule;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class TemplatePresentationModel
implements TemplateLibraryListener {
    public static final String TEMPLATE_ACTIONS_CHANGED = "templateActions";
    public static final String TEMPLATE_TOOLBAR_ACTIONS_CHANGED = "templateToolBarActions";
    public static final String TEMPLATE_STRUCTURE_CHANGED = "templateStructure";
    public static final String TREE_SELECTION_STARTED = "treeSelectionStarted";
    public static final String TREE_SELECTION_FINISHED = "treeSelectionFinished";
    public static final String REMOVE_TEMPLATE_SET_ENABLED = "removeTemplateSetEnabled";
    private DefaultTreeModel templateSetTreeModel = null;
    private TemplateLibrary library = null;
    private TemplateSet selectedTemplateSet = null;
    private ArrayList<TemplateAction> selectedTemplateActions = new ArrayList();
    private DefaultTreeSelectionModel templateSetTreeSelectionModel = null;
    private EventListenerList listenerList;
    private ArrayList<Template> toolbarTemplates = new ArrayList();
    private ArrayList<TemplateAction> toolbarTemplateActions = new ArrayList();
    private int maxToolBarActionCount = 30;
    private int maxTemplateCount = 100;
    private SketchPanel sketchPanel;

    public TemplatePresentationModel(SketchPanel sketchPanel) {
        this.sketchPanel = sketchPanel;
        this.listenerList = new EventListenerList();
    }

    public void setTemplateLibrary(TemplateLibrary library) {
        this.library = library;
        library.addTemplateLibraryListener(this);
    }

    public int getMaxTemplateCount() {
        return this.maxTemplateCount;
    }

    public void setMaxTemplateCount(int maxTemplateCount) {
        this.maxTemplateCount = maxTemplateCount;
    }

    public int getMaxToolBarActionCount() {
        return this.maxToolBarActionCount;
    }

    public void setMaxToolBarActionCount(int maxToolBarActionCount) {
        this.maxToolBarActionCount = maxToolBarActionCount;
        this.createToolbarTemplateActions();
    }

    public TemplateSet getSelectedTemplateSet() {
        return this.selectedTemplateSet;
    }

    public synchronized List<TemplateAction> getSelectedTemplateActions() {
        return new ArrayList<TemplateAction>(this.selectedTemplateActions);
    }

    public synchronized ArrayList<TemplateAction> getToolbarTemplateActions() {
        return new ArrayList<TemplateAction>(this.toolbarTemplateActions);
    }

    public DefaultTreeModel getTemplateSetTreeModel() {
        if (this.library == null) {
            return null;
        }
        if (this.templateSetTreeModel == null) {
            this.createTemplateSetTreeModel();
        }
        return this.templateSetTreeModel;
    }

    public TreeSelectionModel getTemplateTreeSelectionModel() {
        if (this.templateSetTreeSelectionModel == null) {
            this.templateSetTreeSelectionModel = new DefaultTreeSelectionModel();
            this.templateSetTreeSelectionModel.setSelectionMode(1);
            this.templateSetTreeSelectionModel.addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent e) {
                    TemplatePresentationModel.this.treeSelectionValueChanged(e.getNewLeadSelectionPath());
                }
            });
        }
        return this.templateSetTreeSelectionModel;
    }

    public void clearToolbarTemplates() {
        this.toolbarTemplateActions.clear();
        this.toolbarTemplates.clear();
    }

    public void addToolbarTemplates(ArrayList<Template> templates) {
        if (templates != null && templates.size() > 0) {
            this.toolbarTemplates.addAll(templates);
            this.createToolbarTemplateActions();
        }
    }

    private synchronized void createToolbarTemplateActions() {
        this.toolbarTemplateActions.clear();
        for (Template t : this.toolbarTemplates) {
            if (this.toolbarTemplateActions.size() >= this.maxToolBarActionCount) continue;
            TemplateAction a = new TemplateAction(this.sketchPanel, t);
            this.toolbarTemplateActions.add(a);
        }
        this.fireTemplateToolBarActionsChanged();
    }

    public void setToolbarTemplates(ArrayList<Template> templates) {
        this.clearToolbarTemplates();
        this.addToolbarTemplates(templates);
    }

    private TemplateSet convertNode(TreePath path) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        Object o = node.getUserObject();
        if (o instanceof TemplateSet) {
            return (TemplateSet)o;
        }
        return null;
    }

    public void treeSelectionValueChanged(TreePath selectionPath) {
        this.firePropertyChange(TREE_SELECTION_STARTED, null, null);
        if (selectionPath == null) {
            this.selectedTemplateSet = null;
            this.firePropertyChange(TREE_SELECTION_FINISHED, null, null);
            return;
        }
        if (this.selectedTemplateSet != null) {
            this.selectedTemplateSet.unload();
        }
        this.selectedTemplateSet = this.convertNode(selectionPath);
        boolean b = this.selectedTemplateSet != null && this.library.getTemplateSetLocation(this.selectedTemplateSet).getTemplateSet() == this.selectedTemplateSet;
        this.firePropertyChange(REMOVE_TEMPLATE_SET_ENABLED, !b, b);
        if (this.selectedTemplateSet == null) {
            this.firePropertyChange(TREE_SELECTION_FINISHED, null, null);
            return;
        }
        this.selectedTemplateActions.clear();
        ArrayList<Template> templates = this.selectedTemplateSet.getTemplates(this.maxTemplateCount);
        for (Template t : templates) {
            TemplateAction a = new TemplateAction(this.sketchPanel, t);
            this.selectedTemplateActions.add(a);
        }
        this.fireTemplateActionsChanged();
        this.firePropertyChange(TREE_SELECTION_FINISHED, null, null);
    }

    public void addPopupMenu(final JComponent component, final TemplateAction action) {
        component.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger() && TemplatePresentationModel.this.sketchPanel.arePopupMenusEnabled()) {
                    JPopupMenu popup = TemplatePresentationModel.this.createPopup(component, action);
                    popup.show(component, e.getX(), e.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger() && TemplatePresentationModel.this.sketchPanel.arePopupMenusEnabled()) {
                    JPopupMenu popup = TemplatePresentationModel.this.createPopup(component, action);
                    popup.show(component, e.getX(), e.getY());
                }
            }
        });
    }

    private JPopupMenu createPopup(final JComponent component, final TemplateAction action) {
        JPopupMenu popup = new JPopupMenu();
        JMenuItem renameMI = new JMenuItem("Properties");
        renameMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TemplateDialogFactory df = (TemplateDialogFactory)MarvinModule.load("sketch.swing.TemplateDialogFactoryImpl", TemplatePresentationModel.this.sketchPanel);
                if (df != null) {
                    df.setSketchPanel(TemplatePresentationModel.this.sketchPanel);
                    df.showTemplatePropertiesDialog(component, action);
                }
            }
        });
        JMenuItem removeMI = new JMenuItem("Remove");
        removeMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TemplatePresentationModel.this.sketchPanel.removeMyTemplate(action.getTemplate());
            }
        });
        popup.add(renameMI);
        popup.addSeparator();
        popup.add(removeMI);
        return popup;
    }

    public void addListener(PropertyChangeListener listener) {
        this.listenerList.add(PropertyChangeListener.class, listener);
    }

    private void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        Object[] listeners = this.listenerList.getListenerList();
        PropertyChangeEvent event = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] == PropertyChangeListener.class) {
                event = new PropertyChangeEvent(this, propertyName, oldValue, newValue);
            }
            ((PropertyChangeListener)listeners[i + 1]).propertyChange(event);
        }
    }

    private void fireTemplateActionsChanged() {
        this.firePropertyChange(TEMPLATE_ACTIONS_CHANGED, null, null);
    }

    private void fireTemplateToolBarActionsChanged() {
        this.firePropertyChange(TEMPLATE_TOOLBAR_ACTIONS_CHANGED, null, null);
    }

    @Override
    public void templateSetStructureChanged() {
        this.createTemplateSetTreeModel();
        this.firePropertyChange(TEMPLATE_STRUCTURE_CHANGED, null, this.templateSetTreeModel);
    }

    private void createTemplateSetTreeModel() {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("Template categories");
        this.addTemplateSets(root, this.library.getTemplateSets());
        this.templateSetTreeModel = new DefaultTreeModel(root);
    }

    private void addTemplateSets(DefaultMutableTreeNode parent, ArrayList<TemplateSet> templateSets) {
        for (TemplateSet set : templateSets) {
            DefaultMutableTreeNode child = new DefaultMutableTreeNode(set);
            parent.add(child);
            this.addTemplateSets(child, set.getTemplateSets());
        }
    }

    @Override
    public void templateSetChanged(int i) {
        if (this.templateSetTreeSelectionModel != null && this.templateSetTreeSelectionModel.getLeadSelectionPath() != null) {
            this.treeSelectionValueChanged(this.templateSetTreeSelectionModel.getLeadSelectionPath());
        }
        this.fireTemplateToolBarActionsChanged();
    }
}

