/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.templates;

import chemaxon.marvin.sketch.swing.templates.TemplateHandler;
import chemaxon.marvin.sketch.templates.Template;
import chemaxon.marvin.sketch.templates.TemplateLibraryListener;
import chemaxon.marvin.sketch.templates.TemplateSet;
import chemaxon.marvin.sketch.templates.TemplateSetLocation;
import chemaxon.marvin.util.Environment;
import chemaxon.struc.Molecule;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class TemplateLibrary {
    private ArrayList<TemplateSetLocation> templateSetLocations;
    private ArrayList<TemplateSet> templateSets = null;
    private int myTemplatesIndex = -1;
    private boolean myTemplatesFound = false;
    private List<WeakReference<TemplateLibraryListener>> listenerList;
    private ReferenceQueue<TemplateLibraryListener> queue;

    private TemplateLibrary() {
        try {
            this.init();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void clear() {
        this.init();
    }

    public int getTemplateSetCount() {
        return this.templateSetLocations.size();
    }

    public TemplateSet getTemplateSet(int i) {
        assert (i < this.templateSetLocations.size());
        assert (i >= 0);
        return this.templateSetLocations.get(i).getTemplateSet();
    }

    private boolean containsLocation(String name, String location) {
        for (int i = 0; i < this.templateSetLocations.size(); ++i) {
            if (!this.templateSetLocations.get(i).getName().equals(name) || !this.templateSetLocations.get(i).getLocation().equals(location)) continue;
            return true;
        }
        return false;
    }

    public TemplateSetLocation getTemplateSetLocation(String name) {
        for (int i = 0; i < this.templateSetLocations.size(); ++i) {
            if (!this.templateSetLocations.get(i).getName().equals(name)) continue;
            return this.templateSetLocations.get(i);
        }
        return null;
    }

    public TemplateSetLocation getTemplateSetLocation(TemplateSet set) {
        for (int i = 0; i < this.templateSetLocations.size(); ++i) {
            if (!this.templateSetLocations.get(i).getLocation().equals(set.getIdentifier())) continue;
            return this.templateSetLocations.get(i);
        }
        return null;
    }

    public int getTemplateSetLocationIndex(TemplateSet set) {
        for (int i = 0; i < this.templateSetLocations.size(); ++i) {
            if (!this.templateSetLocations.get(i).getLocation().equals(set.getIdentifier())) continue;
            return i;
        }
        return -1;
    }

    public TemplateSetLocation getTemplateSetLocation(int i) {
        return this.templateSetLocations.get(i);
    }

    public void replaceTemplateSets(int i1, int i2) {
        TemplateSetLocation tloc1 = this.getTemplateSetLocation(i1);
        TemplateSetLocation tloc2 = this.getTemplateSetLocation(i2);
        this.templateSetLocations.set(i1, tloc2);
        this.templateSetLocations.set(i2, tloc1);
        tloc1.setIndex(i2);
        tloc2.setIndex(i1);
        this.fixMyTemplatesIndex();
        this.fireTemplateStructureChanged();
    }

    public void setTemplateSet(int i, String name, String path) {
        TemplateSetLocation location = new TemplateSetLocation(name, path);
        location.setIndex(i);
        if (i >= this.getTemplateSetCount()) {
            this.templateSetLocations.add(location);
            if (this.templateSets != null) {
                this.templateSets.add(location.getTemplateSet());
            }
        } else if (i == this.myTemplatesIndex) {
            this.templateSetLocations.add(this.templateSetLocations.get(this.myTemplatesIndex));
            this.templateSetLocations.set(i, location);
            this.myTemplatesIndex = this.getTemplateSetCount() - 1;
            if (this.templateSets != null) {
                this.templateSets.set(i, location.getTemplateSet());
                this.templateSets.add(this.getMyTemplates());
            }
        } else {
            this.templateSetLocations.set(i, location);
            if (this.templateSets != null) {
                this.templateSets.set(i, location.getTemplateSet());
            }
        }
        this.fireTemplateSetChanged(i);
    }

    public ArrayList<TemplateSet> getTemplateSets() {
        if (this.templateSets == null) {
            this.templateSets = new ArrayList();
            for (TemplateSetLocation loc : this.templateSetLocations) {
                this.templateSets.add(loc.getTemplateSet());
            }
        }
        return this.templateSets;
    }

    private void init() {
        this.templateSetLocations = new ArrayList();
        this.listenerList = new CopyOnWriteArrayList<WeakReference<TemplateLibraryListener>>();
        this.queue = new ReferenceQueue();
        this.templateSets = null;
    }

    public void setMyTemplates(ArrayList<Template> templates, boolean save) {
        if (!this.isMyTemplatesEnabled()) {
            return;
        }
        this.getMyTemplatesSet().setTemplates(templates);
        if (!save) {
            return;
        }
        try {
            this.getMyTemplatesSet().save();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean isMyTemplatesEnabled() {
        return TemplateHandler.myTemplatesEnabled && !Environment.UNTRUSTED;
    }

    public void setMyTemplatesProperty(String molString) {
        if (!this.myTemplatesFound) {
            if (this.myTemplatesIndex == -1) {
                this.myTemplatesIndex = this.templateSetLocations.size();
            }
            this.setMyTemplates(TemplateSetLocation.convertToTemplates(molString), true);
        }
    }

    public void addToMyTemplates(Molecule m) {
        if (!this.isMyTemplatesEnabled()) {
            return;
        }
        ArrayList<Template> templates = this.getMyTemplates().getTemplates();
        Template template = Template.createTemplate(m);
        template.setEditable(true);
        templates.add(template);
        this.setMyTemplates(templates, true);
        this.fireTemplateSetChanged(this.myTemplatesIndex);
    }

    public void removeMyTemplate(Template t) {
        if (!this.isMyTemplatesEnabled()) {
            return;
        }
        ArrayList<Template> templates = this.getMyTemplates().getTemplates();
        if (templates.remove(t)) {
            this.setMyTemplates(templates, true);
            this.fireTemplateSetChanged(this.myTemplatesIndex);
        }
    }

    public void resetMyTemplates() {
        if (!this.isMyTemplatesEnabled()) {
            return;
        }
        this.setMyTemplates(this.getMyTemplates().getTemplates(), true);
        this.fireTemplateSetChanged(this.myTemplatesIndex);
    }

    public TemplateSetLocation getMyTemplatesSet() {
        if (!this.isMyTemplatesEnabled()) {
            return null;
        }
        return this.templateSetLocations.get(this.myTemplatesIndex);
    }

    public int getMyTemplatesIdentifier() {
        return this.myTemplatesIndex;
    }

    public TemplateSet getMyTemplates() {
        TemplateSetLocation loc = this.getMyTemplatesSet();
        if (loc != null) {
            return loc.getTemplateSet();
        }
        return null;
    }

    public void refreshTemplates(TemplateSet set) {
        int tsi = this.getTemplateSetLocationIndex(set);
        TemplateSetLocation templateSet = this.templateSetLocations.get(tsi);
        TemplateSetLocation newSet = new TemplateSetLocation(templateSet.getName(), templateSet.getLocation());
        this.templateSetLocations.set(tsi, newSet);
        this.fireTemplateStructureChanged();
    }

    private void fireTemplateSetChanged(int id) {
        for (WeakReference<TemplateLibraryListener> ref : this.listenerList) {
            TemplateLibraryListener o = (TemplateLibraryListener)ref.get();
            if (o == null) continue;
            o.templateSetChanged(id);
        }
    }

    private void fireTemplateStructureChanged() {
        this.templateSets = null;
        for (WeakReference<TemplateLibraryListener> ref : this.listenerList) {
            TemplateLibraryListener o = (TemplateLibraryListener)ref.get();
            if (o == null) continue;
            o.templateSetStructureChanged();
        }
    }

    public void addTemplateLibraryListener(TemplateLibraryListener l) {
        if (l == null) {
            return;
        }
        this.listenerList.add(new WeakReference<TemplateLibraryListener>(l, this.queue));
        this.clearListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTemplateLibraryListener(TemplateLibraryListener l) {
        if (l == null) {
            return;
        }
        List<WeakReference<TemplateLibraryListener>> list = this.listenerList;
        synchronized (list) {
            for (int i = this.listenerList.size() - 1; i >= 0; --i) {
                if (this.listenerList.get(i).get() != l) continue;
                this.listenerList.remove(i);
                break;
            }
        }
        this.clearListeners();
    }

    public void addCustomTemplateSet(String name, String path, int index) {
        if (this.containsLocation(name, path)) {
            return;
        }
        TemplateSetLocation loc = new TemplateSetLocation(name, path);
        loc.setIndex(index);
        this.templateSetLocations.add(loc);
        if ("My Templates".equals(name)) {
            this.myTemplatesIndex = this.templateSetLocations.size() - 1;
            loc.setEditable(true);
            if (loc.isValidTemplateSet()) {
                this.myTemplatesFound = true;
            }
        }
        this.fireTemplateStructureChanged();
    }

    public void sortTemplateSets() {
        Collections.sort(this.templateSetLocations);
        this.fixMyTemplatesIndex();
    }

    private void fixMyTemplatesIndex() {
        if (!this.isMyTemplatesEnabled()) {
            return;
        }
        for (int i = 0; i < this.templateSetLocations.size(); ++i) {
            if (!"My Templates".equals(this.templateSetLocations.get(i).getName())) continue;
            this.myTemplatesIndex = i;
            return;
        }
    }

    public void removeTemplateSet(TemplateSet set) {
        TemplateSetLocation loc = this.getTemplateSetLocation(set.getName());
        this.templateSetLocations.remove(loc);
        this.fireTemplateStructureChanged();
    }

    public void removeTemplateSet(int i) {
        this.templateSetLocations.remove(i);
        this.fireTemplateSetChanged(i);
        this.fireTemplateStructureChanged();
    }

    public static TemplateLibrary getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private void clearListeners() {
        Reference<TemplateLibraryListener> ref;
        while ((ref = this.queue.poll()) != null) {
            this.listenerList.remove(ref);
        }
    }

    private static class SingletonHolder {
        public static final TemplateLibrary INSTANCE = new TemplateLibrary();

        private SingletonHolder() {
        }
    }
}

