/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.templates;

import chemaxon.marvin.sketch.templates.TemplateSet;

public class TemplatePath {
    private TemplatePath parentPath;
    private transient TemplateSet lastPathComponent;

    public TemplatePath(TemplateSet[] path) {
        if (path == null || path.length == 0) {
            throw new IllegalArgumentException("path in TemplatePath must be non null and not empty.");
        }
        this.lastPathComponent = path[path.length - 1];
        if (path.length > 1) {
            this.parentPath = new TemplatePath(path, path.length - 1);
        }
    }

    public TemplatePath(TemplateSet singlePath) {
        if (singlePath == null) {
            throw new IllegalArgumentException("path in TemplatePath must be non null.");
        }
        this.lastPathComponent = singlePath;
        this.parentPath = null;
    }

    protected TemplatePath(TemplatePath parent, TemplateSet lastElement) {
        if (lastElement == null) {
            throw new IllegalArgumentException("path in TemplatePath must be non null.");
        }
        this.parentPath = parent;
        this.lastPathComponent = lastElement;
    }

    protected TemplatePath(TemplateSet[] path, int length) {
        this.lastPathComponent = path[length - 1];
        if (length > 1) {
            this.parentPath = new TemplatePath(path, length - 1);
        }
    }

    public Object[] getPath() {
        int i = this.getPathCount();
        Object[] result = new Object[i--];
        TemplatePath path = this;
        while (path != null) {
            result[i--] = path.lastPathComponent;
            path = path.parentPath;
        }
        return result;
    }

    public TemplateSet getLastPathComponent() {
        return this.lastPathComponent;
    }

    public int getPathCount() {
        int result = 0;
        TemplatePath path = this;
        while (path != null) {
            ++result;
            path = path.parentPath;
        }
        return result;
    }

    public Object getPathComponent(int element) {
        int pathLength = this.getPathCount();
        if (element < 0 || element >= pathLength) {
            throw new IllegalArgumentException("Index " + element + " is out of the specified range");
        }
        TemplatePath path = this;
        for (int i = pathLength - 1; i != element; --i) {
            path = path.parentPath;
        }
        return path.lastPathComponent;
    }

    public TemplatePath getParentPath() {
        return this.parentPath;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof TemplatePath) {
            TemplatePath oTreePath = (TemplatePath)o;
            if (this.getPathCount() != oTreePath.getPathCount()) {
                return false;
            }
            TemplatePath path = this;
            while (path != null) {
                if (!path.lastPathComponent.equals(oTreePath.lastPathComponent)) {
                    return false;
                }
                oTreePath = oTreePath.parentPath;
                path = path.parentPath;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.lastPathComponent.hashCode();
    }
}

