/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.templates;

import chemaxon.formats.MFileFormatUtil;
import chemaxon.formats.MolExporter;
import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolImporter;
import chemaxon.formats.MolInputStream;
import chemaxon.marvin.io.MRecordImporter;
import chemaxon.marvin.io.MRecordParseException;
import chemaxon.marvin.sketch.templates.Template;
import chemaxon.marvin.sketch.templates.TemplateIOException;
import chemaxon.marvin.sketch.templates.TemplateSet;
import chemaxon.marvin.util.Environment;
import chemaxon.struc.MDocument;
import chemaxon.struc.Molecule;
import chemaxon.util.DotfileUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;

public class TemplateSetLocation
implements Comparable<TemplateSetLocation> {
    private int index = -1;
    private String name;
    private String location;
    private TemplateSet templateSet = null;
    private boolean editable = false;
    private static ArrayList<String> knownMoleculeExtensions = new ArrayList<String>(Arrays.asList(MFileFormatUtil.getMolfileFormats()));

    public TemplateSetLocation(String name, String location) {
        this(name, location, false);
    }

    public TemplateSetLocation(String name, String location, boolean editable) {
        this.name = name;
        this.location = location;
        this.editable = editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public static ArrayList<Template> importTemplates(String path, int maxCount) throws TemplateIOException {
        ArrayList<Template> mols = new ArrayList<Template>();
        try {
            URL url = TemplateSetLoader.getURL(path);
            if (url == null) {
                return mols;
            }
            if (path.endsWith(".csmol") || path.endsWith(".t")) {
                TemplateSetLocation.readMoleculeStream("csmol", maxCount, mols, url);
            } else if (path.endsWith(".mrv") || path.endsWith("mytemplates")) {
                TemplateSetLocation.readMoleculeStream("mrv", maxCount, mols, url);
            } else {
                TemplateSetLocation.readMoleculeStream(maxCount, mols, url);
            }
        }
        catch (FileNotFoundException fnfex) {
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return mols;
    }

    private static void readMoleculeStream(String format2, int maxCount, ArrayList<Template> mols, URL url) throws IOException {
        MRecordImporter importer;
        try {
            importer = new MRecordImporter(new MolInputStream(url.openStream(), format2), null);
        }
        catch (MolFormatException ex) {
            return;
        }
        Molecule mol = null;
        for (int i = 0; i < maxCount; ++i) {
            try {
                mol = importer.readMol(null);
            }
            catch (MRecordParseException e) {
                e.printStackTrace();
            }
            if (mol == null) break;
            mols.add(Template.createTemplate(mol));
        }
    }

    private static void readMoleculeStream(int maxCount, ArrayList<Template> mols, URL url) throws IOException {
        Molecule mol;
        MolImporter importer = new MolImporter(url.openStream());
        for (int i = 0; (mol = importer.read()) != null && i < maxCount; ++i) {
            mols.add(Template.createTemplate(mol));
        }
    }

    public static ArrayList<Template> convertToTemplates(String molString) throws TemplateIOException {
        ArrayList<Template> mols = new ArrayList<Template>();
        if ("".equals(molString)) {
            return mols;
        }
        try {
            MDocument mDocument;
            ByteArrayInputStream inputStream = new ByteArrayInputStream(molString.getBytes());
            MolInputStream mis = new MolInputStream((InputStream)inputStream, null, null, null);
            String options = "Xsg,S";
            MRecordImporter importer = new MRecordImporter(mis, options);
            while ((mDocument = importer.readDoc()) != null) {
                Molecule m = (Molecule)mDocument.getMainMoleculeGraph();
                mols.add(Template.createTemplate(m));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (MRecordParseException re) {
            re.printStackTrace();
        }
        return mols;
    }

    public static String getValidPath(String path) {
        try {
            URL url = new URL(path);
            File f = new File(url.getFile());
            return url.getProtocol() + ":" + f.getPath();
        }
        catch (MalformedURLException malformedURLException) {
            return "";
        }
    }

    public TemplateSet getTemplateSet() {
        if (this.templateSet == null) {
            this.createTemplateSet();
            this.templateSet.setEditable(this.editable);
        }
        return this.templateSet;
    }

    public String getName() {
        return this.name;
    }

    public String getLocation() {
        return this.location;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public boolean isValidTemplateSet() {
        this.initTemplateSet();
        TemplateSetLoader loader = new TemplateSetLoader(this.location);
        boolean b = loader.isValidURL();
        this.templateSet = null;
        return b;
    }

    private void createTemplateSet() {
        TemplateSetLoader loader = new TemplateSetLoader(this.location);
        if (!loader.isValidURL()) {
            this.initTemplateSet();
            throw new TemplateIOException(null, this.location);
        }
        loader.load();
        this.templateSet = loader.getSet();
        this.templateSet.setName(this.name);
    }

    private void initTemplateSet() {
        if (this.templateSet == null) {
            this.templateSet = new TemplateSet(this.location);
            this.templateSet.setName(this.name);
            this.templateSet.setLocation(this.location);
        }
    }

    public void setTemplates(ArrayList<Template> templates) {
        if (!this.editable) {
            return;
        }
        this.initTemplateSet();
        this.templateSet.setTemplates(templates);
    }

    public void save() throws IOException {
        if (!this.editable) {
            return;
        }
        OutputStream os = DotfileUtil.create("marvin.mytemplates");
        TemplateSet set = this.getTemplateSet();
        MolExporter molExporter = new MolExporter(os, "mrv");
        for (Template t : set.getTemplates()) {
            molExporter.write(t.getMolecule());
        }
        molExporter.close();
        os.close();
    }

    @Override
    public int compareTo(TemplateSetLocation o) {
        int i = this.index == o.index ? this.getName().compareTo(o.getName()) : (this.index == -1 ? 1 : (o.index == -1 ? -1 : this.index - o.index));
        return i;
    }

    private static boolean isKnownFormat(File f) {
        int extIndex = f.getPath().lastIndexOf(".");
        return extIndex != -1 && knownMoleculeExtensions.contains(f.getPath().substring(extIndex + 1));
    }

    static {
        knownMoleculeExtensions.add("t");
    }

    private static class TemplateSetLoader {
        private URL url;
        private TemplateSet set;

        TemplateSetLoader(String path) {
            this.url = TemplateSetLoader.getURL(path);
            this.set = new TemplateSet(path);
        }

        public TemplateSet getSet() {
            return this.set;
        }

        private static URL getURL(String path) {
            URL url;
            block2: {
                try {
                    url = new URL(path);
                }
                catch (MalformedURLException e) {
                    url = TemplateSetLoader.getResourceURL(path);
                    if (url != null) break block2;
                    url = TemplateSetLoader.getDotFileURL(path);
                }
            }
            return url;
        }

        private static URL getResourceURL(String path) {
            URL codebase;
            URL url = null;
            url = TemplateSetLoader.class.getResource(path.startsWith("/") ? path : "/".concat(path));
            if (url == null && (codebase = Environment.getCodeBase()) != null) {
                try {
                    url = new URL(codebase, path.startsWith("/") ? path.substring(1) : path);
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            return url;
        }

        private static URL getDotFileURL(String path) {
            File file = DotfileUtil.getDotFile(path);
            if (file.exists()) {
                try {
                    return file.toURI().toURL();
                }
                catch (MalformedURLException e) {
                }
            } else if (!Environment.UNTRUSTED) {
                try {
                    file.getParentFile().mkdirs();
                    file.createNewFile();
                    return file.toURI().toURL();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return null;
        }

        public boolean isValidURL() {
            return this.url != null;
        }

        public void load() {
            if (!this.isValidURL()) {
                return;
            }
            if (this.url.getProtocol().equals("file")) {
                File f = new File(this.url.getFile());
                this.processFile(f, this.set);
            } else {
                this.set.setName(this.url.getFile());
                this.set.setLocation(this.url.toString());
            }
        }

        private boolean processFile(File f, TemplateSet templateSet) {
            if (f.isDirectory()) {
                File[] files;
                templateSet.setName(f.getName());
                templateSet.setLocation(this.url.getProtocol() + ":" + f.getPath());
                templateSet.setContainsTemplates(false);
                ArrayList<TemplateSet> templateSets = new ArrayList<TemplateSet>();
                templateSet.setTemplateSets(templateSets);
                for (File fi : files = f.listFiles()) {
                    TemplateSet newSet = new TemplateSet(this.set.getIdentifier());
                    if (!this.processFile(fi, newSet)) continue;
                    templateSets.add(newSet);
                }
                return true;
            }
            templateSet.setName(f.getName());
            templateSet.setLocation(this.url.getProtocol() + ":" + f.getPath());
            return TemplateSetLocation.isKnownFormat(f);
        }
    }
}

