/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.space;

import chemaxon.marvin.alignment.AlignmentProperties;
import chemaxon.marvin.alignment.NodeColor;
import chemaxon.marvin.alignment.Pharmacophore3D;
import java.awt.Color;

public class Colors {
    public static final int CPK_MODE = 1;
    public static final int CONSTANT_MODE = 2;
    public static final int RESIDUE_MODE = 3;
    public static final int CHAIN_MODE = 4;
    public static final int SS_MODE = 5;
    public static final byte[] white = new byte[]{127, 127, 127, 127};
    public static final byte[] black = new byte[]{0, 0, 0, 127};
    public static final byte[] blue = new byte[]{0, 0, 127, 127};
    public static final byte[] green = new byte[]{0, 127, 0, 127};
    public static final byte[] red = new byte[]{127, 0, 0, 127};
    public static final byte[] yellow = new byte[]{127, 127, 0, 127};
    public static final byte[] lightyellow = new byte[]{127, 127, 100, 127};
    public static final byte[] orange = new byte[]{127, 74, 13, 127};
    public static final byte[] gray = new byte[]{38, 38, 38, 127};
    public static final byte[] brown = new byte[]{102, 38, 38, 127};
    public static final byte[] pink = new byte[]{127, 38, 102, 127};
    public static final byte[] silver = new byte[]{95, 95, 95, 127};
    public static final byte[] lightgray = new byte[]{89, 89, 89, 127};
    public static final byte[] pink2 = new byte[]{110, 22, 77, 127};
    public static final byte[] darkgreen = new byte[]{38, 63, 38, 127};
    public static final byte[] lightblue = new byte[]{63, 97, 114, 127};
    public static final byte[] iron = new byte[]{68, 45, 0, 127};
    public static final byte[] ochre = new byte[]{111, 99, 28, 127};
    public static final byte[] darkpurple = new byte[]{67, 15, 103, 127};
    public static final byte[] darkblue = new byte[]{13, 26, 83, 127};
    public static final byte[] mauve = new byte[]{80, 62, 89, 127};
    public static final byte[] cyan = new byte[]{0, 109, 109, 127};
    public static final byte[] greenishblue = new byte[]{38, 63, 79, 127};
    public static final byte[] metalish = new byte[]{74, 76, 77};
    public static final float[] whiteF = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
    public static final float[] blackF = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
    public static final float[] blueF = new float[]{0.0f, 0.0f, 1.0f, 1.0f};
    public static final float[] greenF = new float[]{0.0f, 1.0f, 0.0f, 1.0f};
    public static final float[] redF = new float[]{1.0f, 0.0f, 0.0f, 1.0f};
    public static final float[] yellowF = new float[]{1.0f, 1.0f, 0.0f, 1.0f};
    public static final float[] orangeF = new float[]{1.0f, 0.58f, 0.1f, 1.0f};
    public static final float[] lightorange = new float[]{1.0f, 0.9f, 0.0f, 1.0f};
    public static final float[] grayF = new float[]{0.3f, 0.3f, 0.3f, 1.0f};
    public static final float[] brownF = new float[]{0.8f, 0.3f, 0.3f, 1.0f};
    public static final float[] pinkF = new float[]{1.0f, 0.3f, 0.8f};
    public static final float[] pink2F = new float[]{0.867f, 0.176f, 0.604f};
    public static final float[] cyanF = new float[]{0.0f, 0.86f, 0.86f};
    public static final float[] darkgreenF = new float[]{0.3f, 0.5f, 0.3f, 1.0f};
    public static final float[] lightblueF = new float[]{0.561f, 0.62f, 0.733f, 1.0f};
    public static final float[] lightgrayF = new float[]{0.7f, 0.7f, 0.7f, 1.0f};
    public static final float[] silverF = new float[]{0.75f, 0.75f, 0.75f};
    public static final float[] ironF = new float[]{0.533f, 0.35f, 0.0f, 1.0f};
    public static final float[] ochreF = new float[]{0.874f, 0.78f, 0.22f};
    public static final float[] darkpurpleF = new float[]{0.528f, 0.118f, 0.811f};
    public static final float[] darkblueF = new float[]{0.102f, 0.205f, 0.6535f};
    public static final float[] mauveF = new float[]{0.63f, 0.488f, 0.7f};
    public static final float[] resred = new float[]{0.9f, 0.04f, 0.04f, 1.0f};
    public static final float[] resredbrown = new float[]{0.45f, 0.0f, 0.0f, 1.0f};
    public static final float[] resyellow = new float[]{0.9f, 0.9f, 0.3f, 1.0f};
    public static final float[] resdarkyellow = new float[]{0.72f, 0.63f, 0.26f, 1.0f};
    public static final float[] resorange = new float[]{1.0f, 0.58f, 0.1f, 1.0f};
    public static final float[] resdarkorange = new float[]{0.72f, 0.55f, 0.04f, 1.0f};
    public static final float[] reslightblue = new float[]{0.5f, 0.76f, 0.9f, 1.0f};
    public static final float[] resmidblue = new float[]{0.16f, 0.57f, 0.79f, 1.0f};
    public static final float[] resdarkblue = new float[]{0.1f, 0.06f, 0.55f, 1.0f};
    public static final float[] rescyan = new float[]{0.0f, 0.86f, 0.86f};
    public static final float[] resdarkcyan = new float[]{0.0f, 0.65f, 0.63f};
    public static final float[] respink = new float[]{0.7f, 0.35f, 0.7f};
    public static final float[] respaleblue = new float[]{0.5f, 0.5f, 0.82f, 1.0f};
    public static final float[] resflesh = new float[]{0.86f, 0.58f, 0.51f, 1.0f};
    public static final float[] resgreen = new float[]{0.06f, 0.51f, 0.2f, 1.0f};
    public static final float[] reslightgreen = new float[]{0.35f, 0.77f, 0.47f, 1.0f};
    public static final float[] resgraygreen = new float[]{0.25f, 0.44f, 0.22f, 1.0f};
    public static final float[] magentaF = new float[]{1.0f, 0.0f, 1.0f, 1.0f};
    public static final float[] setorcyanF = new float[]{0.0f, 1.0f, 1.0f, 1.0f};
    public static final float[] setorblueF = new float[]{0.23f, 0.23f, 1.0f, 1.0f};
    public static final float[] setorfleshF = new float[]{1.0f, 0.47f, 0.415f, 1.0f};
    public static final float[] setormagentaF = new float[]{1.0f, 0.16f, 1.0f, 1.0f};
    public static final float[] adenosine = new float[]{0.67f, 0.84f, 0.957f};
    public static final float[] cytosine = new float[]{0.24f, 0.588f, 0.835f};
    public static final float[] guanosine = new float[]{0.035f, 0.302f, 0.486f};
    public static final float[] thymidine = new float[]{0.455f, 0.427f, 0.55f};
    public static final float[] uridine = new float[]{0.086f, 0.478f, 0.663f};
    public static final byte[] resredB = new byte[]{114, 5, 5, 127};
    public static final byte[] resredbrownB = new byte[]{57, 0, 0, 127};
    public static final byte[] resyellowB = new byte[]{114, 114, 38, 127};
    public static final byte[] resdarkyellowB = new byte[]{91, 80, 33, 127};
    public static final byte[] resorangeB = new byte[]{127, 74, 13, 127};
    public static final byte[] resdarkorangeB = new byte[]{91, 70, 5, 127};
    public static final byte[] reslightblueB = new byte[]{63, 97, 114, 127};
    public static final byte[] resmidblueB = new byte[]{20, 72, 100, 127};
    public static final byte[] resdarkblueB = new byte[]{13, 7, 70, 127};
    public static final byte[] rescyanB = new byte[]{0, 109, 109, 127};
    public static final byte[] resdarkcyanB = new byte[]{0, 83, 80, 127};
    public static final byte[] respinkB = new byte[]{89, 44, 89, 127};
    public static final byte[] respaleblueB = new byte[]{63, 63, 104, 127};
    public static final byte[] resfleshB = new byte[]{109, 74, 65, 127};
    public static final byte[] resgreenB = new byte[]{8, 65, 25, 127};
    public static final byte[] reslightgreenB = new byte[]{44, 98, 60, 127};
    public static final byte[] resgraygreenB = new byte[]{32, 56, 28, 127};
    public static final byte[] magenta = new byte[]{127, 0, 127, 127};
    public static final byte[] setorcyan = new byte[]{0, 127, 127, 127};
    public static final byte[] setorblue = new byte[]{30, 30, 127, 127};
    public static final byte[] setorflesh = new byte[]{127, 60, 53, 1};
    public static final byte[] setormagenta = new byte[]{127, 20, 127, 127};
    public static final byte[] adenosineB = new byte[]{85, 107, 122, 127};
    public static final byte[] cytosineB = new byte[]{30, 75, 106, 127};
    public static final byte[] guanosineB = new byte[]{4, 38, 62, 127};
    public static final byte[] thymidineB = new byte[]{58, 54, 70, 127};
    public static final byte[] uridineB = new byte[]{11, 61, 84, 127};
    public static final byte[] unknownB = new byte[]{1, 40, 63, 127};
    public static final float[] unknown = new float[]{0.008f, 0.314f, 0.494f};
    public static final float[] ambient = new float[]{0.2f, 0.2f, 0.2f, 1.0f};
    public static final float[] diffuse = new float[]{0.8f, 0.8f, 0.8f, 1.0f};
    public static final float[] specular = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
    public static final float[] emission = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
    public static final float[][] carbonColorsF = new float[][]{lightgrayF, grayF, greenF, cyanF};
    public static final byte[][] carbonColors = new byte[][]{lightgray, gray, green, cyan};
    public static byte[] helixColor = new byte[]{127, 0, 0, 127};
    public static byte[] sheetColor = new byte[]{0, 127, 0, 127};
    public static byte[] turnColor = new byte[]{0, 109, 109, 127};
    public static byte[] coilColor = new byte[]{127, 127, 127, 127};
    public static byte[] hColor = new byte[]{127, 127, 127, 127};
    public static float[] hColorF = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
    public static byte[] cColor = new byte[]{89, 89, 89, 127};
    public static float[] cColorF = new float[]{0.7f, 0.7f, 0.7f, 1.0f};
    public static byte[] nColor = new byte[]{0, 0, 127, 127};
    public static float[] nColorF = new float[]{0.0f, 0.0f, 1.0f, 1.0f};
    public static byte[] oColor = new byte[]{127, 0, 0, 127};
    public static float[] oColorF = new float[]{1.0f, 0.0f, 0.0f, 1.0f};
    public static byte[] sColor = new byte[]{127, 127, 0, 127};
    public static float[] sColorF = new float[]{1.0f, 1.0f, 0.0f, 1.0f};
    public static byte[] pColor = new byte[]{127, 74, 13, 127};
    public static float[] pColorF = new float[]{1.0f, 0.58f, 0.1f, 1.0f};
    public static byte[] unknownAtom = new byte[]{110, 22, 77, 127};
    public static float[] unknownAtomF = new float[]{0.867f, 0.176f, 0.604f};
    public static byte[] selected = new byte[]{127, 38, 102, 127};
    public static float[] selectedF = new float[]{1.0f, 0.3f, 0.8f};
    public static boolean setorColors = false;
    public static float[][] residueColors = new float[][]{grayF, resmidblue, rescyan, resred, resred, resyellow, resdarkcyan, resredbrown, resredbrown, lightgrayF, respaleblue, resgraygreen, reslightgreen, reslightblue, resdarkyellow, resdarkblue, resflesh, resorange, resdarkorange, respink, resgreen, whiteF, adenosine, cytosine, guanosine, blueF, thymidine, uridine, unknown};
    public static byte[][] residueColorsB = new byte[][]{gray, resmidblueB, rescyanB, resredB, resredB, resyellowB, resdarkcyanB, resredbrownB, resredbrownB, lightgray, respaleblueB, resgraygreenB, reslightgreenB, reslightblueB, resdarkyellowB, resdarkblueB, resfleshB, resorangeB, resdarkorangeB, respinkB, resgreenB, white, adenosineB, cytosineB, guanosineB, blue, thymidineB, uridineB, unknownB};
    public static byte[][] SETORResidueColors = new byte[][]{setorflesh, blue, setorcyan, red, white, yellow, setorcyan, red, white, white, setorblue, setorflesh, setorflesh, blue, yellow, setormagenta, setorflesh, setorcyan, setorcyan, setormagenta, setormagenta, setorflesh, red, blue, green, white, yellow, magenta, white};

    public static String toHexString(Color c) {
        String ret = "#";
        if (c.getRed() < 10) {
            ret = ret + "0";
        }
        ret = ret + Integer.toHexString(c.getRed());
        if (c.getGreen() < 10) {
            ret = ret + "0";
        }
        ret = ret + Integer.toHexString(c.getGreen());
        if (c.getBlue() < 10) {
            ret = ret + "0";
        }
        ret = ret + Integer.toHexString(c.getBlue());
        return ret;
    }

    public static float[] brighter(float[] c) {
        float[] nc = new float[]{c[0] + 0.4f > 1.0f ? 1.0f : c[0] + 0.4f, c[1] + 0.4f > 1.0f ? 1.0f : c[1] + 0.4f, c[2] + 0.4f > 1.0f ? 1.0f : c[2] + 0.4f, c.length == 4 ? c[3] : 1.0f};
        return nc;
    }

    public static byte[] brighter(byte[] c) {
        byte[] nc = new byte[]{(byte)(c[0] + 50 > 127 ? 127 : (byte)(c[0] + 50)), (byte)(c[1] + 50 > 127 ? 127 : (byte)(c[1] + 50)), (byte)(c[2] + 50 > 127 ? 127 : (byte)(c[2] + 50)), c.length == 4 ? c[3] : (byte)127};
        return nc;
    }

    public static void brighter(byte[] c1, byte[] c2) {
        c1[0] = (byte)(c2[0] + 50 > 127 ? 127 : (byte)(c2[0] + 50));
        c1[1] = (byte)(c2[1] + 50 > 127 ? 127 : (byte)(c2[1] + 50));
        c1[2] = (byte)(c2[2] + 50 > 127 ? 127 : (byte)(c2[2] + 50));
        c1[3] = c2.length == 4 ? c2[3] : 127;
    }

    public static byte[] brighter(byte[] c, byte bf) {
        byte[] nc = new byte[]{(byte)(c[0] + bf > 127 ? 127 : (byte)(c[0] + bf)), (byte)(c[1] + bf > 127 ? 127 : (byte)(c[1] + bf)), (byte)(c[2] + bf > 127 ? 127 : (byte)(c[2] + bf)), c.length == 4 ? c[3] : (byte)127};
        return nc;
    }

    public static byte[] darker(byte[] c) {
        byte[] nc = new byte[]{c[0] - 50 < 0 ? (byte)0 : (byte)(c[0] - 50), c[1] - 50 < 0 ? (byte)0 : (byte)(c[1] - 50), c[2] - 50 < 0 ? (byte)0 : (byte)(c[2] - 50), c.length == 4 ? c[3] : (byte)127};
        return nc;
    }

    public static void darker(byte[] c1, byte[] c2) {
        c1[0] = c2[0] - 50 < 0 ? (byte)0 : (byte)(c2[0] - 50);
        c1[1] = c2[1] - 50 < 0 ? (byte)0 : (byte)(c2[1] - 50);
        c1[2] = c2[2] - 50 < 0 ? (byte)0 : (byte)(c2[2] - 50);
        c1[3] = c2.length == 4 ? c2[3] : 127;
    }

    public static boolean equals(byte[] c1, byte[] c2) {
        return c1[0] == c2[0] && c1[1] == c2[1] && c1[2] == c2[2];
    }

    public static void checkRange(byte[] c) {
        int n = c[0] < 0 ? 0 : (c[0] = c[0] > 127 ? 127 : c[0]);
        int n2 = c[1] < 0 ? 0 : (c[1] = c[1] > 127 ? 127 : c[1]);
        c[2] = c[2] < 0 ? 0 : (c[2] > 127 ? 127 : c[2]);
    }

    public static void checkRange(float[] c) {
        float f = c[0] < 0.0f ? 0.0f : (c[0] = c[0] > 1.0f ? 1.0f : c[0]);
        float f2 = c[1] < 0.0f ? 0.0f : (c[1] = c[1] > 1.0f ? 1.0f : c[1]);
        c[2] = c[2] < 0.0f ? 0.0f : (c[2] > 1.0f ? 1.0f : c[2]);
    }

    public static float[] getOpenGLDefaultAmbient() {
        return ambient;
    }

    public static float[] getOpenGLDefaultDiffuse() {
        return diffuse;
    }

    public static float[] getOpenGLDefaultEmission() {
        return emission;
    }

    public static float[] getOpenGLDefaultSpecular() {
        return specular;
    }

    public static float getOpenGLDefaultShininess() {
        return 0.0f;
    }

    public static float[] getDefaultAmbient() {
        return grayF;
    }

    public static float[] getDefaultSpecular() {
        return whiteF;
    }

    public static float getDefaultShininess() {
        return 100.0f;
    }

    public static byte[] getCPKByteColor(int atomtype) {
        switch (atomtype) {
            case 1: {
                return hColor;
            }
            case 6: {
                return cColor;
            }
            case 7: {
                return nColor;
            }
            case 8: {
                return oColor;
            }
            case 9: {
                return lightblue;
            }
            case 11: {
                return ochre;
            }
            case 12: {
                return darkgreen;
            }
            case 15: {
                return pColor;
            }
            case 16: {
                return sColor;
            }
            case 17: {
                return green;
            }
            case 19: {
                return darkpurple;
            }
            case 20: {
                return greenishblue;
            }
            case 26: {
                return iron;
            }
            case 29: {
                return darkblue;
            }
            case 30: {
                return metalish;
            }
            case 35: {
                return brown;
            }
            case 53: {
                return mauve;
            }
        }
        return unknownAtom;
    }

    public static float[] getCPKColor(int atomtype) {
        switch (atomtype) {
            case 1: {
                return hColorF;
            }
            case 6: {
                return cColorF;
            }
            case 7: {
                return nColorF;
            }
            case 8: {
                return oColorF;
            }
            case 9: {
                return reslightblue;
            }
            case 11: {
                return ochreF;
            }
            case 12: {
                return darkgreenF;
            }
            case 15: {
                return pColorF;
            }
            case 16: {
                return sColorF;
            }
            case 17: {
                return greenF;
            }
            case 19: {
                return darkpurpleF;
            }
            case 20: {
                return grayF;
            }
            case 26: {
                return ironF;
            }
            case 29: {
                return darkblueF;
            }
            case 30: {
                return grayF;
            }
            case 35: {
                return brownF;
            }
            case 53: {
                return mauveF;
            }
        }
        return unknownAtomF;
    }

    public static byte[] getChainColor(int chainNo) {
        switch (chainNo) {
            case 0: {
                return white;
            }
            case 1: {
                return orange;
            }
            case 2: {
                return green;
            }
            case 3: {
                return lightblue;
            }
            case 4: {
                return mauve;
            }
            case 5: {
                return brown;
            }
            case 6: {
                return darkblue;
            }
            case 7: {
                return yellow;
            }
            case 8: {
                return gray;
            }
            case 9: {
                return ochre;
            }
            case 10: {
                return greenishblue;
            }
            case 11: {
                return mauve;
            }
            case 12: {
                return resredB;
            }
            case 13: {
                return darkpurple;
            }
            case 14: {
                return lightgray;
            }
            case 15: {
                return darkgreen;
            }
            case 16: {
                return resfleshB;
            }
            case 17: {
                return blue;
            }
            case 18: {
                return resgraygreenB;
            }
            case 19: {
                return resredbrownB;
            }
            case 20: {
                return resdarkorangeB;
            }
        }
        return pink;
    }

    public static float[] getResidueColor(int residue) {
        if (residue < 0 || residue > 27) {
            return unknown;
        }
        return residueColors[residue];
    }

    public static byte[] getResidueByteColor(int residue) {
        if (setorColors) {
            return Colors.getSETORResidueColor(residue);
        }
        if (residue < 0 || residue > 27) {
            return unknownB;
        }
        return residueColorsB[residue];
    }

    public static byte[] getSETORResidueColor(int residue) {
        if (residue < 0 || residue > 27) {
            return white;
        }
        return SETORResidueColors[residue];
    }

    public static float[] getResidueColor(String res) {
        if (setorColors) {
            return Colors.getSETORResidueColor(res);
        }
        if (res.equalsIgnoreCase("A")) {
            return adenosine;
        }
        if (res.equalsIgnoreCase("+A")) {
            return adenosine;
        }
        if (res.equalsIgnoreCase("C")) {
            return cytosine;
        }
        if (res.equalsIgnoreCase("+C")) {
            return cytosine;
        }
        if (res.equalsIgnoreCase("G")) {
            return guanosine;
        }
        if (res.equalsIgnoreCase("+G")) {
            return guanosine;
        }
        if (res.equalsIgnoreCase("T")) {
            return thymidine;
        }
        if (res.equalsIgnoreCase("+T")) {
            return thymidine;
        }
        if (res.equalsIgnoreCase("I")) {
            return blueF;
        }
        if (res.equalsIgnoreCase("+I")) {
            return blueF;
        }
        if (res.equalsIgnoreCase("U")) {
            return uridine;
        }
        if (res.equalsIgnoreCase("+U")) {
            return uridine;
        }
        if (res.equalsIgnoreCase("ALA")) {
            return grayF;
        }
        if (res.equalsIgnoreCase("ARG")) {
            return resmidblue;
        }
        if (res.equalsIgnoreCase("ASN")) {
            return rescyan;
        }
        if (res.equalsIgnoreCase("ASP")) {
            return resred;
        }
        if (res.equalsIgnoreCase("ASX")) {
            return resred;
        }
        if (res.equalsIgnoreCase("CYS")) {
            return resyellow;
        }
        if (res.equalsIgnoreCase("GLN")) {
            return resdarkcyan;
        }
        if (res.equalsIgnoreCase("GLU")) {
            return resredbrown;
        }
        if (res.equalsIgnoreCase("GLX")) {
            return resredbrown;
        }
        if (res.equalsIgnoreCase("GLY")) {
            return lightgrayF;
        }
        if (res.equalsIgnoreCase("HIS")) {
            return respaleblue;
        }
        if (res.equalsIgnoreCase("ILE")) {
            return resgraygreen;
        }
        if (res.equalsIgnoreCase("LEU")) {
            return reslightgreen;
        }
        if (res.equalsIgnoreCase("LYS")) {
            return reslightblue;
        }
        if (res.equalsIgnoreCase("MET")) {
            return resdarkyellow;
        }
        if (res.equalsIgnoreCase("PHE")) {
            return resdarkblue;
        }
        if (res.equalsIgnoreCase("PRO")) {
            return resflesh;
        }
        if (res.equalsIgnoreCase("SER")) {
            return resorange;
        }
        if (res.equalsIgnoreCase("THR")) {
            return resdarkorange;
        }
        if (res.equalsIgnoreCase("TRP")) {
            return respink;
        }
        if (res.equalsIgnoreCase("TYR")) {
            return resgreen;
        }
        if (res.equalsIgnoreCase("VAL")) {
            return whiteF;
        }
        if (!res.equalsIgnoreCase("UNK")) {
            System.out.println("no color for residue: " + res);
        }
        return unknown;
    }

    public static float[] getSETORResidueColor(String res) {
        if (res.equalsIgnoreCase("A")) {
            return redF;
        }
        if (res.equalsIgnoreCase("+A")) {
            return redF;
        }
        if (res.equalsIgnoreCase("C")) {
            return blueF;
        }
        if (res.equalsIgnoreCase("+C")) {
            return blueF;
        }
        if (res.equalsIgnoreCase("G")) {
            return greenF;
        }
        if (res.equalsIgnoreCase("+G")) {
            return greenF;
        }
        if (res.equalsIgnoreCase("T")) {
            return yellowF;
        }
        if (res.equalsIgnoreCase("+T")) {
            return yellowF;
        }
        if (res.equalsIgnoreCase("I")) {
            return whiteF;
        }
        if (res.equalsIgnoreCase("+I")) {
            return whiteF;
        }
        if (res.equalsIgnoreCase("U")) {
            return magentaF;
        }
        if (res.equalsIgnoreCase("+U")) {
            return magentaF;
        }
        if (res.equalsIgnoreCase("ALA")) {
            return setorfleshF;
        }
        if (res.equalsIgnoreCase("ARG")) {
            return blueF;
        }
        if (res.equalsIgnoreCase("ASN")) {
            return setorcyanF;
        }
        if (res.equalsIgnoreCase("ASP")) {
            return redF;
        }
        if (res.equalsIgnoreCase("ASX")) {
            return whiteF;
        }
        if (res.equalsIgnoreCase("CYS")) {
            return yellowF;
        }
        if (res.equalsIgnoreCase("GLN")) {
            return setorcyanF;
        }
        if (res.equalsIgnoreCase("GLU")) {
            return redF;
        }
        if (res.equalsIgnoreCase("GLX")) {
            return whiteF;
        }
        if (res.equalsIgnoreCase("GLY")) {
            return whiteF;
        }
        if (res.equalsIgnoreCase("HIS")) {
            return setorblueF;
        }
        if (res.equalsIgnoreCase("ILE")) {
            return setorfleshF;
        }
        if (res.equalsIgnoreCase("LEU")) {
            return setorfleshF;
        }
        if (res.equalsIgnoreCase("LYS")) {
            return blueF;
        }
        if (res.equalsIgnoreCase("MET")) {
            return yellowF;
        }
        if (res.equalsIgnoreCase("PHE")) {
            return setormagentaF;
        }
        if (res.equalsIgnoreCase("PRO")) {
            return setorfleshF;
        }
        if (res.equalsIgnoreCase("SER")) {
            return setorcyanF;
        }
        if (res.equalsIgnoreCase("THR")) {
            return setorcyanF;
        }
        if (res.equalsIgnoreCase("TRP")) {
            return setormagentaF;
        }
        if (res.equalsIgnoreCase("TYR")) {
            return setormagentaF;
        }
        if (res.equalsIgnoreCase("VAL")) {
            return setorfleshF;
        }
        if (!res.equalsIgnoreCase("UNK")) {
            System.out.println("no color for residue: " + res);
        }
        return whiteF;
    }

    public static byte[] getSecondaryTypeColor(int sstype) {
        switch (sstype) {
            case 2: {
                return helixColor;
            }
            case 3: 
            case 4: {
                return sheetColor;
            }
            case 1: {
                return turnColor;
            }
        }
        return coilColor;
    }

    public static float[] dreidingTypeToColor(int i1) {
        try {
            if (--i1 == 8 || i1 == 7 || i1 == 57 || i1 == 5 || i1 == 41 || i1 == 40 || i1 == 39) {
                return Colors.getCPKColor(6);
            }
            if (i1 == 6 || i1 == 37) {
                return pinkF;
            }
            if (i1 == 12 || i1 == 11 || i1 == 9 || i1 == 10) {
                return Colors.getCPKColor(7);
            }
            if (i1 == 16 || i1 == 15 || i1 == 13 || i1 == 14 || i1 == 59) {
                return Colors.getCPKColor(8);
            }
            if (i1 == 21 || i1 == 43) {
                return Colors.getCPKColor(16);
            }
            if (i1 == 22) {
                return Colors.getCPKColor(17);
            }
            if (i1 == 27) {
                return Colors.getCPKColor(35);
            }
            if (i1 == 32) {
                return Colors.getCPKColor(53);
            }
            if (i1 == 17) {
                return Colors.getCPKColor(9);
            }
            if (++i1 == Pharmacophore3D.ALIPHATIC_RINGCENTER) {
                return magentaF;
            }
            if (i1 == Pharmacophore3D.AROMATIC_RINGCENTER) {
                return greenF;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return Colors.getCPKColor(i1);
    }

    public static float[] pharmaTypeToColor(int i1) {
        System.err.println("pharmaTypeToColor");
        NodeColor nc = NodeColor.create(AlignmentProperties.ColoringScheme.PHARMACOPHORE);
        if (nc.isSameType(i1, Pharmacophore3D.ACCP)) {
            return redF;
        }
        if (nc.isSameType(i1, Pharmacophore3D.AROMATIC_ATOM)) {
            return pinkF;
        }
        if (nc.isSameType(i1, Pharmacophore3D.DONR)) {
            return blueF;
        }
        if (nc.isSameType(i1, Pharmacophore3D.H)) {
            return whiteF;
        }
        if (nc.isSameType(i1, Pharmacophore3D.LP)) {
            return greenF;
        }
        if (nc.isSameType(i1, Pharmacophore3D.NEG)) {
            return cyanF;
        }
        if (nc.isSameType(i1, Pharmacophore3D.POS)) {
            return orangeF;
        }
        if (nc.isSameType(i1, Pharmacophore3D.HYDR)) {
            return grayF;
        }
        if (i1 == Pharmacophore3D.ALIPHATIC_RINGCENTER) {
            return magentaF;
        }
        if (i1 == Pharmacophore3D.AROMATIC_RINGCENTER) {
            return greenF;
        }
        return null;
    }

    public static float[] fallbackColoring(int i) {
        float[][] colors = new float[][]{blueF, cyanF, orangeF, pinkF, redF, magentaF, greenF};
        while (i >= colors.length) {
            i -= colors.length;
        }
        return colors[i];
    }
}

