/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.space;

import chemaxon.marvin.space.GraphicComponent;
import java.awt.Color;

public class ComponentElement {
    private GraphicComponent component;
    int componentPartId = -1;
    int atomicElementType;
    int atomicElementIndex;
    String description = null;
    float[] coordinates = null;
    Color color = null;

    public ComponentElement(GraphicComponent component, int atomicElementType, int atomicElementIndex) {
        this.component = component;
        this.atomicElementType = atomicElementType;
        this.atomicElementIndex = atomicElementIndex;
    }

    public ComponentElement(GraphicComponent component, int atomicElementType, Integer atomicElementIndexObject) {
        this.component = component;
        this.atomicElementType = atomicElementType;
        this.atomicElementIndex = atomicElementIndexObject;
    }

    public ComponentElement(GraphicComponent component, int componentPartId, int atomicElementType, int atomicElementIndex) {
        this.component = component;
        this.componentPartId = componentPartId;
        this.atomicElementType = atomicElementType;
        this.atomicElementIndex = atomicElementIndex;
    }

    public ComponentElement(GraphicComponent component, int componentPartId, int atomicElementType, Integer atomicElementIndexObject) {
        this.component = component;
        this.componentPartId = componentPartId;
        this.atomicElementType = atomicElementType;
        this.atomicElementIndex = atomicElementIndexObject;
    }

    public ComponentElement(ComponentElement element) {
        this.component = element.component;
        this.componentPartId = element.componentPartId;
        this.atomicElementType = element.atomicElementType;
        this.atomicElementIndex = element.atomicElementIndex;
    }

    public boolean isComponentPart() {
        return this.componentPartId >= 0;
    }

    public int getComponentPartId() {
        return this.componentPartId;
    }

    public int getElementType() {
        return this.atomicElementType;
    }

    public int getElementIndex() {
        return this.atomicElementIndex;
    }

    public void getCoordinates(float[] c) {
        if (this.coordinates != null) {
            c[0] = this.coordinates[0];
            c[1] = this.coordinates[1];
            c[2] = this.coordinates[2];
            return;
        }
        this.component.getCoordinates(this, c);
    }

    public void setCoordinates(float[] c) {
        if (this.coordinates == null) {
            this.coordinates = new float[3];
        }
        this.coordinates[0] = c[0];
        this.coordinates[1] = c[1];
        this.coordinates[2] = c[2];
    }

    public String getDescription() {
        if (this.description != null) {
            return this.description;
        }
        return this.component.getDescription(this);
    }

    public void setDescription(String d) {
        this.description = d;
    }

    public boolean isVisible() {
        return this.component.isVisible(this);
    }

    public GraphicComponent getComponent() {
        return this.component;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color c) {
        this.color = c;
    }

    public String toString() {
        return "GraphicComponent index: " + this.component.getId().getComponentIndex() + " componentPartId: " + this.componentPartId + " atomicElementType: " + this.atomicElementType + " atomicElementIndex: " + this.atomicElementIndex;
    }
}

