/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.space;

import chemaxon.marvin.space.Colors;
import chemaxon.marvin.space.CoordinateComponent;
import chemaxon.marvin.space.Event;
import chemaxon.marvin.space.GraphicCell;
import chemaxon.marvin.space.GraphicComponent;
import chemaxon.marvin.space.MSpaceEventHandler;
import chemaxon.marvin.space.UOID;
import chemaxon.marvin.space.drawing.DrawableFactory;
import chemaxon.marvin.space.drawing.gl.def.GLDefaultDrawableFactory;
import chemaxon.marvin.space.gui.JMSpaceProgressBar;
import chemaxon.marvin.space.util.GLText;
import chemaxon.marvin.space.util.ImageUtils;
import com.sun.opengl.util.TileRenderer;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.nio.Buffer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCanvas;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.glu.GLU;
import javax.swing.JPanel;

public class GraphicScene
extends JPanel
implements GLEventListener {
    public static String GLInfo;
    public static final int MODE_STANDING = 1;
    public static final int MODE_MOVING = 2;
    public static final int VERBOSE_LEVEL_NONE = 0;
    public static final int VERBOSE_LEVEL_BASIC = 1;
    public static final int VERBOSE_LEVEL_DEVEL = 2;
    public static final int SCENE_RANGE = 1;
    public static final int CELL_RANGE = 2;
    public static final int COMPONENT_RANGE = 3;
    private MSpaceEventHandler eventHandler;
    private JMSpaceProgressBar progressBar = null;
    private int rowCount = 1;
    private int columnCount = 1;
    private int activeCell = -1;
    private GraphicCell[] cells;
    private int cellCount = this.rowCount * this.columnCount;
    private int needsRefresh = -1;
    private int needsReset = this.cellCount;
    private boolean initialized = false;
    private boolean antialias = false;
    private boolean synchronousMode = false;
    private int verboseLevel = 0;
    private int motionmode = 1;
    private int width = 0;
    private int height = 0;
    private Color backgroundColor = new Color(0, 0, 0);
    private boolean backgroundColorChanged = false;
    private int transparentBackground = 0;
    private boolean smoothBackground = false;
    private double rx;
    private double ry;
    private double rz;
    private GL gl;
    private GLU glu;
    private GLAutoDrawable glAutoDrawable;
    private GLCanvas canvas;
    private GLCapabilities capabilities = new GLCapabilities();
    private GLText gltext = null;
    private Properties globalDrawProperties = new Properties();

    public static void printProperties() {
        System.out.println("sun.java2d.noddraw: " + System.getProperty("sun.java2d.noddraw"));
        System.out.println("jogl.GLContext.noopt: " + System.getProperty("jogl.GLContext.noopt"));
        System.out.println("sun.awt.noerasebackground: " + System.getProperty("sun.awt.noerasebackground"));
    }

    public GraphicScene() throws Exception {
        this(1, 1);
    }

    public GraphicScene(int rowCount, int columnCount) throws Exception {
        this.rowCount = rowCount;
        this.columnCount = columnCount;
        this.cellCount = rowCount * columnCount;
        this.capabilities.setHardwareAccelerated(true);
        this.capabilities.setDoubleBuffered(true);
        this.capabilities.setAlphaBits(8);
        this.canvas = new GLCanvas(this.capabilities);
        this.canvas.addGLEventListener((GLEventListener)this);
        this.setLayout(new BorderLayout());
        this.add((Component)this.canvas);
        this.eventHandler = new MSpaceEventHandler(this);
        this.canvas.addMouseListener((MouseListener)this.eventHandler);
        this.canvas.addMouseMotionListener((MouseMotionListener)this.eventHandler);
        this.canvas.addMouseWheelListener((MouseWheelListener)this.eventHandler);
        this.canvas.addKeyListener((KeyListener)this.eventHandler);
        this.initDrawProperties();
        this.initCells();
        this.setActiveCell(0);
        this.needsRefresh = this.cellCount;
        this.needsReset = this.cellCount;
    }

    public void setProgressBar(JMSpaceProgressBar progressBar) {
        this.progressBar = progressBar;
    }

    public boolean isVerbose() {
        return this.verboseLevel != 0;
    }

    public int getVerboseLevel() {
        return this.verboseLevel;
    }

    public void setVerbose(boolean flag) {
        this.verboseLevel = flag ? 1 : 0;
        for (int i = 0; i < this.cells.length; ++i) {
            this.cells[i].setVerbose(flag);
        }
        if (this.isVerbose()) {
            GraphicScene.printProperties();
        }
    }

    public void setVerbose(int level) {
        this.verboseLevel = level;
        for (int i = 0; i < this.cells.length; ++i) {
            this.cells[i].setVerbose(level);
        }
        if (this.isVerbose()) {
            GraphicScene.printProperties();
        }
    }

    public void setDropTarget(DropTargetListener dl) {
        this.canvas.setDropTarget(new DropTarget((Component)this.canvas, dl));
    }

    public void processAwtEvent(AWTEvent evt, String evtID, String evtValue) {
        this.eventHandler.putEventToQueue(new Event(evt, evtID, evtValue));
        this.needsRefresh(this.cellCount);
    }

    public void processEvent(String evtID, String evtValue) {
        this.eventHandler.putEventToQueue(new Event(evtID, evtValue));
        this.needsRefresh(this.cellCount);
    }

    public void processCellEvent(String evtID, String evtValue) {
        this.eventHandler.putEventToQueue(new Event(evtID, evtValue, 2));
        this.needsRefresh(this.activeCell);
    }

    public void processComponentEvent(Object component, String evtID, String evtValue) {
        this.eventHandler.putEventToQueue(new Event(component, evtID, evtValue));
        this.needsRefresh(this.activeCell);
    }

    public MSpaceEventHandler getEventHandler() {
        return this.eventHandler;
    }

    public void setMotionMode(int mode) {
        if (this.motionmode == mode) {
            return;
        }
        this.motionmode = mode;
        for (int i = 0; i < this.cellCount; ++i) {
            this.cells[i].setMotionMode(mode);
        }
    }

    public void setSynchronousMode(boolean state) {
        this.synchronousMode = state;
    }

    public void measureFrameRate() {
    }

    public int getViewportWidth() {
        return this.width;
    }

    public int getViewportHeight() {
        return this.height;
    }

    public void setSceneSize(int rowCount, int columnCount) throws Exception {
        if (rowCount <= 0 || columnCount <= 0) {
            return;
        }
        int oldrc = this.rowCount;
        int oldcc = this.columnCount;
        this.rowCount = rowCount;
        this.columnCount = columnCount;
        this.cellCount = rowCount * columnCount;
        this.deactivateActiveCell();
        this.initCells(oldrc, oldcc);
        this.setContexts();
        this.setSize(super.getWidth(), super.getHeight());
        if (this.cellCount == 1) {
            this.setActiveCell(0);
        }
        this.needsRefresh(this.cellCount);
    }

    public void createNewCell() throws Exception {
        int i;
        for (i = 0; i < this.cells.length; ++i) {
            if (this.cells[i].getComponentCount() != 0) continue;
            this.setActiveCell(i);
            return;
        }
        if (this.rowCount < this.columnCount) {
            this.setSceneSize(this.rowCount + 1, this.columnCount);
        } else {
            this.setSceneSize(this.rowCount, this.columnCount + 1);
        }
        for (i = 0; i < this.cells.length; ++i) {
            if (this.cells[i].getComponentCount() != 0) continue;
            this.setActiveCell(i);
            return;
        }
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        if (width <= 0 || height <= 0) {
            return;
        }
        super.setBounds(x, y, width, height);
        if (this.canvas == null) {
            return;
        }
        int cellWidth = width / this.columnCount;
        int cellHeight = height / this.rowCount;
        this.width = cellWidth * this.columnCount;
        this.height = cellHeight * this.rowCount;
        this.canvas.setSize(this.width, this.height);
        for (int i = 0; i < this.cellCount; ++i) {
            this.cells[i].setOrigin(this.getCellColumn(i) * width / this.columnCount, (this.rowCount - 1 - this.getCellRow(i)) * height / this.rowCount);
            this.cells[i].setSize(cellWidth, cellHeight);
        }
        this.eventHandler.sceneSizeChanged();
        this.needsRefresh(this.cellCount);
    }

    @Override
    public void setSize(int sizex, int sizey) {
        if (sizex <= 0 || sizey <= 0) {
            return;
        }
        int cellWidth = sizex / this.columnCount;
        int cellHeight = sizey / this.rowCount;
        this.width = cellWidth * this.columnCount;
        this.height = cellHeight * this.rowCount;
        super.setSize(sizex, sizey);
        this.canvas.setSize(this.width, this.height);
        for (int i = 0; i < this.cellCount; ++i) {
            this.cells[i].setOrigin(this.getCellColumn(i) * this.width / this.columnCount, (this.rowCount - 1 - this.getCellRow(i)) * this.height / this.rowCount);
            this.cells[i].setSize(cellWidth, cellHeight);
        }
        this.eventHandler.sceneSizeChanged();
        if (this.isGLInitialized()) {
            this.glAutoDrawable.display();
        }
    }

    public void setNearEdgeTolerance(int tolerance) {
        for (int i = 0; i < this.cellCount; ++i) {
            this.cells[i].setNearEdgeTolerance(tolerance);
        }
    }

    public int getCellTop() {
        if (this.activeCell == -1) {
            return this.height;
        }
        return this.cells[this.activeCell].getTop();
    }

    public int getCellButtom() {
        if (this.activeCell == -1) {
            return 0;
        }
        return this.cells[this.activeCell].getBottom();
    }

    public int getCellLeft() {
        if (this.activeCell == -1) {
            return 0;
        }
        return this.cells[this.activeCell].getLeft();
    }

    public int getCellRight() {
        if (this.activeCell == -1) {
            return this.width;
        }
        return this.cells[this.activeCell].getRight();
    }

    public int getCellWidth() {
        return this.width / this.columnCount;
    }

    public int getCellHeight() {
        return this.height / this.rowCount;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public int getCellCount() {
        return this.cellCount;
    }

    private int getCellIndex(int rowIndex, int columnIndex, int columnCount) {
        return rowIndex * columnCount + columnIndex;
    }

    private int getCellRow(int cellIndex) {
        return cellIndex / this.columnCount;
    }

    private int getCellColumn(int cellIndex) {
        return cellIndex % this.columnCount;
    }

    private int getCellIndex(int rowIndex, int columnIndex) {
        return rowIndex * this.columnCount + columnIndex;
    }

    public int getGraphicComponentCount() {
        int cc = 0;
        for (int i = 0; i < this.cells.length; ++i) {
            cc += this.cells[i].getComponentCount();
        }
        return cc;
    }

    public boolean addComponent(GraphicComponent component) throws Exception {
        int cellIndex;
        int n = cellIndex = this.activeCell != -1 ? this.activeCell : 0;
        if (!this.isAbleToAddComponent(component, cellIndex)) {
            return false;
        }
        int ci = this.cells[cellIndex].addComponent(component);
        component.setProgressBar(this.progressBar);
        if (this.isGLInitialized()) {
            component.setGL(this.gl, this.glu);
        }
        component.setId(cellIndex, ci);
        this.needsRefresh(cellIndex);
        return true;
    }

    public boolean addComponentToEmptyCell(GraphicComponent gc) throws Exception {
        this.createNewCell();
        return this.addComponent(gc);
    }

    public boolean addComponent(GraphicComponent component, int cellIndex) throws Exception {
        int ci = this.cells[cellIndex].addComponent(component);
        if (this.isGLInitialized()) {
            component.setGL(this.gl, this.glu);
        }
        component.setId(cellIndex, ci);
        this.needsRefresh(cellIndex);
        return true;
    }

    public CoordinateComponent addCoordinateSystem(int cellIndex) throws Exception {
        CoordinateComponent gc = new CoordinateComponent();
        gc.setName("Coordinate System");
        this.addComponent(gc, cellIndex);
        return gc;
    }

    public void removeSelectedComponents() {
        if (this.activeCell == -1) {
            return;
        }
        this.cells[this.activeCell].removeSelectedComponents();
        this.eventHandler.updateSelectionBar();
        this.needsRefresh(this.activeCell);
    }

    public void removeUnselectedComponents() {
        if (this.activeCell == -1) {
            return;
        }
        this.cells[this.activeCell].removeUnselectedComponents();
        this.eventHandler.updateSelectionBar();
        this.needsRefresh(this.activeCell);
    }

    public void removeUnselectedMonitors() {
        for (int j = 0; j < this.cellCount; ++j) {
            this.cells[j].removeUnselectedMonitors();
        }
        this.eventHandler.updateSelectionBar();
        this.needsRefresh(this.cellCount);
    }

    public void removeAllComponents() {
        this.eventHandler.clearSelectionBar();
        for (int j = 0; j < this.cellCount; ++j) {
            this.cells[j].removeAllComponents();
        }
        this.eventHandler.checkPaletteChooser();
        this.eventHandler.updateIsoSpinner();
        this.needsRefresh(this.cellCount);
    }

    public void removeAllComponents(Class c) {
        if (this.activeCell == -1) {
            return;
        }
        this.cells[this.activeCell].removeComponent(c);
        this.needsRefresh(this.activeCell);
    }

    public void removeComponent(GraphicComponent component) {
        this.cells[component.getId().getCellIndex()].removeComponent(component);
        this.needsRefresh(component.getId().getCellIndex());
        this.eventHandler.checkPaletteChooser();
        this.eventHandler.updateIsoSpinner();
    }

    public void removeComponent(UOID componentId) {
        this.cells[componentId.getCellIndex()].removeComponent(componentId.getComponentIndex());
        this.needsRefresh(componentId.getCellIndex());
    }

    public boolean containsComponent(GraphicComponent gc) {
        for (int i = 0; i < this.cells.length; ++i) {
            if (!this.cells[i].containsComponent(gc)) continue;
            return true;
        }
        return false;
    }

    private boolean isAbleToAddComponent(GraphicComponent component, int cellIndex) {
        if (this.cells == null) {
            System.err.println("cells have not been initialized");
            return false;
        }
        if (component == null) {
            System.err.println("component have not been initialized");
            return false;
        }
        if (cellIndex >= this.cellCount || cellIndex < 0) {
            System.err.println("cellIndex is out of range");
            return false;
        }
        if (this.cells[cellIndex] == null) {
            System.err.println("cells[" + cellIndex + "] have not been initialized");
            return false;
        }
        return true;
    }

    public void setActiveCell(int i) {
        if (this.activeCell >= 0) {
            this.cells[this.activeCell].setInactive();
        }
        this.activeCell = i;
        this.cells[this.activeCell].setActive();
        this.needsRefresh(this.activeCell);
    }

    public void deactivateActiveCell() {
        if (this.activeCell >= 0) {
            this.cells[this.activeCell].setInactive();
            this.activeCell = -1;
        }
    }

    public GraphicCell getCell(int cellIndex) {
        return this.cells[cellIndex];
    }

    public int getActiveCellIndex() {
        return this.activeCell;
    }

    public GraphicCell getActiveCell() {
        return this.activeCell == -1 ? null : this.cells[this.activeCell];
    }

    public boolean isActiveCell(int cellIndex) {
        return this.cellCount == 1 || cellIndex == this.activeCell;
    }

    public boolean hasSelectedComponent() {
        if (this.activeCell == -1) {
            return false;
        }
        return this.cells[this.activeCell].hasSelectedComponent();
    }

    public boolean hasSelectedComponentElement() {
        if (this.activeCell == -1) {
            return false;
        }
        return this.cells[this.activeCell].hasSelectedComponentElement();
    }

    public GraphicComponent getGraphicComponent(int componentIndex) {
        if (this.activeCell == -1) {
            return null;
        }
        return this.cells[this.activeCell].getComponent(componentIndex);
    }

    public GraphicComponent getGraphicComponent(int cellIndex, int componentIndex) {
        if (cellIndex < 0 || this.cells.length <= cellIndex) {
            return null;
        }
        return this.cells[cellIndex].getComponent(componentIndex);
    }

    public GraphicComponent getGraphicComponent(UOID id) {
        return this.cells[id.getCellIndex()].getComponent(id.getComponentIndex());
    }

    public void hideSelectedComponents() {
        if (this.activeCell == -1) {
            return;
        }
        this.cells[this.activeCell].hideSelectedComponents();
        this.needsRefresh(this.activeCell);
    }

    public void hideUnselectedComponents() {
        if (this.activeCell == -1) {
            return;
        }
        this.cells[this.activeCell].hideUnselectedComponents();
        this.needsRefresh(this.activeCell);
    }

    public void fadeSelectedComponents() {
        if (this.activeCell == -1) {
            return;
        }
        this.cells[this.activeCell].fadeSelectedComponents();
        this.needsRefresh(this.activeCell);
    }

    public void fadeUnselectedComponents() {
        if (this.activeCell == -1) {
            return;
        }
        this.cells[this.activeCell].fadeUnselectedComponents();
        this.needsRefresh(this.activeCell);
    }

    public void showAllComponents() {
        if (this.activeCell == -1) {
            return;
        }
        this.cells[this.activeCell].showAllComponents();
        this.needsRefresh(this.activeCell);
    }

    public void showFaded() {
        if (this.activeCell == -1) {
            return;
        }
        this.cells[this.activeCell].showFaded();
        this.needsRefresh(this.activeCell);
    }

    public void hideAllMonitors() {
        if (this.activeCell == -1) {
            return;
        }
        this.cells[this.activeCell].hideAllMonitors();
        this.needsRefresh(this.activeCell);
    }

    public void showAllMonitors() {
        if (this.activeCell == -1) {
            return;
        }
        this.cells[this.activeCell].showAllMonitors();
        this.needsRefresh(this.activeCell);
    }

    public void showAllComponents(Class c) {
        if (this.activeCell == -1) {
            return;
        }
        this.cells[this.activeCell].showAllComponents(c);
        this.needsRefresh(this.activeCell);
    }

    public void hideAllComponents(Class c) {
        if (this.activeCell == -1) {
            return;
        }
        this.cells[this.activeCell].hideAllComponents(c);
        this.needsRefresh(this.activeCell);
    }

    public ArrayList getAllComponents(Class c) {
        if (this.activeCell == -1) {
            return null;
        }
        ArrayList<GraphicComponent> list = new ArrayList<GraphicComponent>();
        GraphicCell cell = this.cells[this.activeCell];
        for (int i = 0; i < cell.getComponentCount(); ++i) {
            if (!cell.getComponent(i).getClass().equals(c)) continue;
            list.add(cell.getComponent(i));
        }
        return list;
    }

    public String getDrawProperty(String name) {
        return (String)this.globalDrawProperties.get(name);
    }

    public String getCellDrawProperty(String name) {
        if (this.activeCell == -1) {
            return "";
        }
        return this.cells[this.activeCell].getCellDrawProperty(name);
    }

    public String getCellDrawProperty(int cellIdx, String name) {
        return this.cells[cellIdx].getCellDrawProperty(name);
    }

    public void setCellDrawProperty(int cellIndex, String propertyName, String propertyValue) throws Exception {
        this.cells[cellIndex].setDrawProperty(propertyName, propertyValue);
        this.needsRefresh(cellIndex);
    }

    public void setDrawProperty(Properties properties) throws Exception {
        Enumeration<Object> keys = properties.keys();
        while (keys.hasMoreElements()) {
            String k = (String)keys.nextElement();
            String v = properties.getProperty(k);
            this.setDrawProperty(k, v);
        }
    }

    public void setDrawProperty(String propertyName, String propertyValue) throws Exception {
        this.globalDrawProperties.setProperty(propertyName, propertyValue);
        for (int j = 0; j < this.cellCount; ++j) {
            this.cells[j].setDrawProperty(propertyName, propertyValue);
        }
        this.needsRefresh(this.cellCount);
    }

    public void setDrawProperty(String propertyName, String propertyValue, int range) throws Exception {
        switch (range) {
            case 1: {
                this.setDrawProperty(propertyName, propertyValue);
                break;
            }
            case 2: {
                if (this.activeCell == -1) break;
                this.cells[this.activeCell].setDrawProperty(propertyName, propertyValue);
                break;
            }
        }
    }

    public void resetSettings() throws Exception {
        this.initDrawProperties();
        this.processEvent("Colors.HelixColor", "#ff0000");
        this.processEvent("Colors.SheetColor", "#00ff00");
        this.processEvent("Colors.CoilColor", "#ffffff");
        for (int i = 0; i < this.cellCount; ++i) {
            this.cells[i].setCellDrawProperties(this.globalDrawProperties);
        }
        this.resetView();
    }

    private void initDrawProperties() {
        this.globalDrawProperties.setProperty("Ligand.DrawType", "BallAndStick");
        this.globalDrawProperties.setProperty("Ligand.Hydrogens", "false");
        this.globalDrawProperties.setProperty("Ligand.LonePairs", "false");
        this.globalDrawProperties.setProperty("Ligand.ColorType", "CPK");
        this.globalDrawProperties.setProperty("Ligand.StickRadius", "0.3");
        this.globalDrawProperties.setProperty("MacroMolecule.DrawType", "Wire");
        this.globalDrawProperties.setProperty("MacroMolecule.LonePairs", "false");
        this.globalDrawProperties.setProperty("MacroMolecule.ColorType", "CPK");
        this.globalDrawProperties.setProperty("Water.DrawType", "Wire");
        this.globalDrawProperties.setProperty("Water.ColorType", "CPK");
        this.globalDrawProperties.setProperty("Water.Hydrogens", "true");
        this.globalDrawProperties.setProperty("Water.BallRadius", "0.4");
        this.globalDrawProperties.setProperty("Ion.DrawType", "Spacefill");
        this.globalDrawProperties.setProperty("Ion.ColorType", "CPK");
        this.globalDrawProperties.setProperty("PharmacophorePoint.DrawType", "Transparent");
        this.globalDrawProperties.setProperty("PharmacophoreArrow.DrawType", "Solid");
        this.globalDrawProperties.setProperty("Surface.DrawType", "Solid");
        this.globalDrawProperties.setProperty("Surface.ColorType", "Constant");
        this.globalDrawProperties.setProperty("Surface.ProbeRadius", "1.4");
        this.globalDrawProperties.setProperty("Surface.Simplification", "false");
        this.globalDrawProperties.setProperty("Surface.AutoResolution", "true");
        this.globalDrawProperties.setProperty("Surface.Resolution", "0.55");
        this.globalDrawProperties.setProperty("Surface.IsoValue", "0.018");
        this.globalDrawProperties.setProperty("SecondaryStructure.DrawType", "Cartoon");
        this.globalDrawProperties.setProperty("SecondaryStructure.ColorType", "SecondaryStructure");
        this.globalDrawProperties.setProperty("Quality", "Medium");
        this.globalDrawProperties.setProperty("Label.OnlyOnHeavyAtoms", Boolean.FALSE.toString());
    }

    public void resetView() {
        this.needsReset(this.activeCell);
    }

    public void resetAll() {
        this.needsReset = this.cellCount;
    }

    public void setAntialias(boolean state) {
        if (this.antialias == state) {
            return;
        }
        this.antialias = state;
        for (int i = 0; i < this.cellCount; ++i) {
            this.cells[i].setAntialias(state);
        }
        this.needsRefresh(this.cellCount);
    }

    public boolean isAntialiasEnabled() {
        return this.antialias;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color newColor) {
        this.backgroundColor = newColor;
        this.backgroundColorChanged = true;
        for (int i = 0; i < this.cells.length; ++i) {
            this.cells[i].setBackgroundColor(this.backgroundColor);
        }
        this.needsRefresh(this.cellCount);
    }

    public boolean isTransparentBackgroundEnabled() {
        return this.transparentBackground == 0;
    }

    public void setTransparentBackground(boolean b) {
        this.transparentBackground = b ? 0 : 1;
        this.backgroundColorChanged = true;
        this.needsRefresh(this.cellCount);
    }

    public boolean isSmoothBackgroundEnabled() {
        return this.smoothBackground;
    }

    public void setSmoothBackground(boolean b) {
        this.smoothBackground = b;
        for (int i = 0; i < this.cells.length; ++i) {
            this.cells[i].setSmoothBackgroud(b);
        }
        this.needsRefresh(this.cellCount);
    }

    public void reshape(GLAutoDrawable glAutoDrawable, int x, int y, int width, int height) {
        int cellWidth = width / this.columnCount;
        int cellHeight = height / this.rowCount;
        this.width = cellWidth * this.columnCount;
        this.height = cellHeight * this.rowCount;
        for (int i = 0; i < this.cellCount; ++i) {
            this.cells[i].setSize(cellWidth, cellHeight);
        }
        this.needsRefresh(this.cellCount);
    }

    public void displayChanged(GLAutoDrawable glAutoDrawable, boolean b, boolean b1) {
    }

    public boolean isGLInitialized() {
        return this.gl != null && this.glAutoDrawable != null;
    }

    public GL getGL() {
        return this.gl;
    }

    public GLAutoDrawable getGLAutoDrawable() {
        return this.glAutoDrawable;
    }

    public GLCanvas getGLCanvas() {
        return this.canvas;
    }

    public GLCapabilities getGLCapabilities() {
        return this.capabilities;
    }

    public String getGLInfo(boolean extended) {
        String capab = "OpenGL Renderer = " + this.gl.glGetString(7937) + "\nOpenGL Version = " + this.gl.glGetString(7938) + "\nOpenGL Vendor = " + this.gl.glGetString(7936);
        if (extended || this.verboseLevel == 2) {
            capab = capab + "\nOpenGL Extensions  = " + this.gl.glGetString(7939);
        }
        return capab;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(GLAutoDrawable glAutoDrawable) {
        try {
            if (this.initialized) {
                System.out.println("Init is being called by " + Thread.currentThread().getName());
                System.out.println("GL: " + this.gl);
                System.out.println("Multiple call to GLeventListener's init.");
                throw new RuntimeException("Exception in GL initialization: GL is already initialized");
            }
            if (this.progressBar != null) {
                // empty if block
            }
            this.gl = glAutoDrawable.getGL();
            this.setProgress(2);
            this.glu = new GLU();
            this.setProgress(4);
            this.glAutoDrawable = glAutoDrawable;
            this.setProgress(6);
            this.setContexts();
            this.setProgress(8);
            this.initLights();
            this.setProgress(10);
            DrawableFactory.Set(new GLDefaultDrawableFactory(this.gl, this.glu));
            this.gl.glShadeModel(7425);
            this.gl.glColorMaterial(1032, 4609);
            this.gl.glPolygonMode(1032, 6914);
            this.gl.glDepthFunc(515);
            this.gl.glClearAccum(0.0f, 0.0f, 0.0f, 0.0f);
            this.gl.glBlendFunc(770, 771);
            this.setProgress(15);
            this.gl.glLineWidth(1.0f);
            this.gl.glPointSize(1.0f);
            this.gl.glEnable(2929);
            this.gl.glEnable(2848);
            this.gl.glEnable(2832);
            this.gl.glEnable(2977);
            this.gl.glEnableClientState(32884);
            this.gl.glEnableClientState(32885);
            this.gl.glEnable(3089);
            this.gl.glEnable(2903);
            this.setProgress(25);
            float[] bgc = new float[4];
            this.backgroundColor.getRGBComponents(bgc);
            this.gl.glClearColor(bgc[0], bgc[1], bgc[2], (float)this.transparentBackground);
            this.setProgress(30);
            this.gl.glFogi(2917, 9729);
            this.gl.glFogfv(2918, bgc, 0);
            this.gl.glFogf(2914, 0.5f);
            this.setProgress(40);
            this.initialized = true;
            GLInfo = this.getGLInfo(false);
            if (this.verboseLevel != 0) {
                System.out.println(GLInfo);
            }
            this.resetView();
            this.setProgress(100);
        }
        catch (OutOfMemoryError ome) {
            this.eventHandler.handleMyErrors(ome);
        }
        catch (Throwable t) {
            this.eventHandler.handleMyErrors(t, "Initialization Error");
        }
        finally {
            if (this.progressBar != null) {
                this.progressBar.stop();
            }
        }
    }

    private void setProgress(int i) {
        if (this.progressBar != null) {
            this.progressBar.setProgress(i);
        }
    }

    private void initCells() throws Exception {
        if (this.cells == null) {
            this.cells = new GraphicCell[this.cellCount];
            for (int i = 0; i < this.cellCount; ++i) {
                this.cells[i] = new GraphicCell();
                this.cells[i].setCellDrawProperties(this.globalDrawProperties);
                this.cells[i].setBackgroundColor(this.backgroundColor);
            }
        } else {
            int i;
            int stay = this.cells.length < this.cellCount ? this.cells.length : this.cellCount;
            GraphicCell[] newcells = new GraphicCell[this.cellCount];
            for (i = 0; i < stay; ++i) {
                newcells[i] = this.cells[i];
            }
            while (i < this.cellCount) {
                newcells[i] = new GraphicCell();
                newcells[i].setCellDrawProperties(this.globalDrawProperties);
                newcells[i].setBackgroundColor(this.backgroundColor);
                ++i;
            }
            this.cells = newcells;
        }
    }

    private void initCells(int oldRowCount, int oldColumnCount) throws Exception {
        if (this.cells == null) {
            this.cells = new GraphicCell[this.cellCount];
            for (int i = 0; i < this.cellCount; ++i) {
                this.cells[i] = new GraphicCell();
                this.cells[i].setCellDrawProperties(this.globalDrawProperties);
                this.cells[i].setBackgroundColor(this.backgroundColor);
                this.cells[i].setSmoothBackgroud(this.smoothBackground);
            }
        } else {
            int i;
            GraphicCell[] newcells = new GraphicCell[this.cellCount];
            int rc = this.rowCount < oldRowCount ? this.rowCount : oldRowCount;
            int cc = this.columnCount < oldColumnCount ? this.columnCount : oldColumnCount;
            for (i = 0; i < rc * cc; ++i) {
                newcells[i] = this.cells[i];
            }
            for (i = 0; i < this.cellCount; ++i) {
                if (newcells[i] != null) continue;
                newcells[i] = new GraphicCell();
                newcells[i].setCellDrawProperties(this.globalDrawProperties);
                newcells[i].setBackgroundColor(this.backgroundColor);
                newcells[i].setSmoothBackgroud(this.smoothBackground);
            }
            if (this.cells.length > newcells.length) {
                if (this.columnCount < oldColumnCount) {
                    for (i = 0; i < rc; ++i) {
                        for (int j = cc; j < oldColumnCount; ++j) {
                            GraphicCell cell = this.cells[this.getCellIndex(i, j, oldColumnCount)];
                            Iterator ci = cell.getComponentIterator();
                            while (ci.hasNext()) {
                                GraphicComponent gc = (GraphicComponent)ci.next();
                                ci.remove();
                                this.removeComponent(gc);
                                this.eventHandler.updateSelectionBar(gc);
                            }
                        }
                    }
                } else {
                    for (i = rc; i < oldRowCount; ++i) {
                        for (int j = 0; j < cc; ++j) {
                            GraphicCell cell = this.cells[this.getCellIndex(i, j, oldColumnCount)];
                            Iterator ci = cell.getComponentIterator();
                            while (ci.hasNext()) {
                                GraphicComponent gc = (GraphicComponent)ci.next();
                                ci.remove();
                                this.removeComponent(gc);
                                this.eventHandler.updateSelectionBar(gc);
                            }
                        }
                    }
                }
            }
            this.cells = newcells;
        }
    }

    private void initLights() {
        float[] pos = new float[]{0.0f, 0.0f, 1.0f, 0.0f};
        this.gl.glLightModelf(2898, 1.0f);
        this.gl.glLightfv(16384, 4611, pos, 0);
        this.gl.glEnable(2896);
        this.gl.glEnable(16384);
        this.gl.glMaterialfv(1032, 4608, Colors.grayF, 0);
        this.gl.glMaterialfv(1032, 4609, Colors.grayF, 0);
        this.gl.glMaterialfv(1032, 4610, Colors.grayF, 0);
        this.gl.glMaterialf(1032, 5633, 100.0f);
    }

    private void setContexts() {
        for (int j = 0; j < this.cellCount; ++j) {
            this.cells[j].setContexts(this.getCellRow(j), this.getCellColumn(j), j, this.getCellColumn(j) * this.width / this.columnCount, (this.rowCount - 1 - this.getCellRow(j)) * this.height / this.rowCount, this.gl, this.glu);
        }
    }

    public void display(GLAutoDrawable glAutoDrawable) {
        try {
            int evc = this.eventHandler.getEventCount();
            int evi = 0;
            while (!this.eventHandler.isReady()) {
                this.eventHandler.processNextEvent();
                this.setProgress(evi++ * evc / 10);
            }
            if (this.backgroundColorChanged) {
                float[] bgc = new float[4];
                this.backgroundColor.getRGBComponents(bgc);
                this.gl.glClearColor(bgc[0], bgc[1], bgc[2], (float)this.transparentBackground);
                this.gl.glFogfv(2918, bgc, 0);
            }
            if (this.needsReset == this.cellCount) {
                for (int i = 0; i < this.cellCount; ++i) {
                    this.cells[i].resetView();
                }
                this.needsRefresh(this.cellCount);
                this.needsReset = -1;
            } else if (this.needsReset > -1) {
                this.cells[this.needsReset].resetView();
                this.needsRefresh(this.needsReset);
                this.needsReset = -1;
            }
            if (this.synchronousMode || this.needsRefresh == this.cellCount || this.needsRefresh == -1) {
                for (int i = 0; i < this.cellCount; ++i) {
                    this.cells[i].draw();
                }
                this.refreshed();
            } else {
                this.cells[this.needsRefresh].draw();
                this.refreshed();
            }
            if (this.cellCount > 1) {
                this.drawBorders();
            }
        }
        catch (OutOfMemoryError ome) {
            this.eventHandler.handleMyErrors(ome);
        }
        catch (Throwable t) {
            this.eventHandler.handleMyErrors(t, "Rendering Error");
        }
    }

    public void refresh() {
        this.glAutoDrawable.display();
    }

    public void redraw() {
        this.needsRefresh(this.cellCount);
        this.glAutoDrawable.display();
    }

    private void drawBorders() {
        for (int i = 0; i < this.cellCount; ++i) {
            this.cells[i].drawBorders();
        }
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.glAutoDrawable != null) {
            this.glAutoDrawable.display();
        }
    }

    private void drawUnlicensedPainting() {
        if (this.gl == null) {
            return;
        }
        if (this.gltext == null) {
            this.gltext = new GLText(this.gl, this.glu);
            this.gltext.setFont(6);
            this.gltext.setBackgroundColor(Colors.lightyellow);
            this.gltext.setBorderColor(Colors.lightyellow);
            this.gltext.setForegroundColor(Colors.black);
        }
        this.gl.glScissor(0, 0, this.width, this.height);
        this.gl.glViewport(0, 0, this.width, this.height);
        this.gltext.drawLabel2D(10, 10, this.width, this.height, "No valid license key has been found for MarvinSpace.\nPlease contact sales@chemaxon.com to obtain a license key.");
    }

    private void needsRefresh(int i) {
        if (i == -1 || this.needsRefresh == i) {
            return;
        }
        this.needsRefresh = this.needsRefresh > -1 ? this.cellCount : i;
    }

    private void needsReset(int i) {
        if (i == -1 || this.needsReset == i) {
            return;
        }
        this.needsReset = this.needsReset > -1 ? this.cellCount : i;
    }

    private void refreshed() {
        this.needsRefresh = this.activeCell;
    }

    public BufferedImage getBufferedImage() {
        return ImageUtils.readPixels(this.gl, 0, 0, this.canvas.getWidth(), this.canvas.getHeight());
    }

    public int createImage(Buffer buf, int imageWidth, int imageHeight) {
        if (this.activeCell < 0 || this.activeCell >= this.cells.length) {
            return -1;
        }
        int[] ib = new int[2];
        this.gl.glGetIntegerv(3386, ib, 0);
        int tileWidth = imageWidth;
        int tileHeight = imageHeight;
        TileRenderer renderer = new TileRenderer();
        renderer.setTileSize(tileWidth, tileHeight, 0);
        renderer.setImageSize(imageWidth, imageHeight);
        renderer.setImageBuffer(32992, 5121, buf);
        GraphicCell cell = this.cells[this.activeCell];
        renderer.trPerspective((double)cell.getFovY(), (double)((float)imageWidth / (float)imageHeight), (double)cell.getNearClip(), (double)cell.getFarClip());
        do {
            renderer.beginTile(this.gl);
            this.gl.glClear(16640);
            this.cells[this.activeCell].drawComponents();
        } while (renderer.endTile(this.gl));
        return 0;
    }

    public void activateContainerCell(GraphicComponent component) {
        for (int i = 0; i < this.cells.length; ++i) {
            Iterator ci = this.cells[i].getComponentIterator();
            while (ci.hasNext()) {
                GraphicComponent gc = (GraphicComponent)ci.next();
                if (gc != component) continue;
                this.setActiveCell(i);
                return;
            }
        }
    }

    public UOID locateObject(int x, int y) {
        int whichCell = this.locateCell(x, y);
        if (whichCell != this.activeCell) {
            return this.cells[whichCell].getId();
        }
        return this.cells[this.activeCell].locateObject(x, this.height - y);
    }

    public UOID locateObject(int x, int y, Class componentClass) {
        int whichCell = this.locateCell(x, y);
        if (whichCell != this.activeCell) {
            return this.cells[whichCell].getId();
        }
        return this.cells[this.activeCell].locateObject(x, this.height - y, componentClass);
    }

    public UOID locateCellId(int x, int y) {
        int whichCell = this.locateCell(x, y);
        return this.cells[whichCell].getId();
    }

    public int locateCell(int x, int y) {
        if (x < 0 || y < 0 || x > this.width - 1 || y > this.height - 1) {
            return this.cellCount - 1;
        }
        if (x < 0) {
            x = 0;
        }
        if (x > this.width - 1) {
            x = this.width - 1;
        }
        if (y < 0) {
            y = 0;
        }
        if (y > this.height - 1) {
            y = this.height - 1;
        }
        int column = x / (this.width / this.columnCount);
        int row = y / (this.height / this.rowCount);
        return this.getCellIndex(row, column);
    }

    public GraphicComponent getControllableObject(String type) {
        if (this.activeCell != -1) {
            return this.cells[this.activeCell].getControllableObject(type);
        }
        return null;
    }

    public boolean locationNearEdgeX(int x, int y) {
        if (this.activeCell == -1) {
            return false;
        }
        return this.cells[this.activeCell].locationNearEdgeX(x, this.height - y);
    }

    public boolean locationNearEdgeY(int x, int y) {
        if (this.activeCell == -1) {
            return false;
        }
        return this.cells[this.activeCell].locationNearEdgeY(x, y);
    }

    public boolean locationNearEdge(int x, int y) {
        if (this.activeCell == -1) {
            return false;
        }
        return this.locationNearEdgeX(x, y) || this.locationNearEdgeY(x, y);
    }

    public void clearSelection(int index) {
        this.cells[index].clearSelections();
        this.needsRefresh(index);
        this.firePropertyChange("selection", null, null);
    }

    public void exclusiveSelection(UOID id) {
        this.cells[id.getCellIndex()].exclusiveSelection(id.getComponentIndex());
        this.needsRefresh(id.getCellIndex());
        this.firePropertyChange("selection", null, null);
    }

    public void extendSelection(UOID id) {
        this.cells[id.getCellIndex()].extendSelection(id.getComponentIndex());
        this.needsRefresh(id.getCellIndex());
        this.firePropertyChange("selection", null, null);
    }

    public void invertSelection(UOID id) {
        this.cells[id.getCellIndex()].invertSelection(id.getComponentIndex());
        this.needsRefresh(id.getCellIndex());
        this.firePropertyChange("selection", null, null);
    }

    public boolean componentBecameSelected(int cellIdx) {
        return this.cells[cellIdx].componentBecameSelected();
    }

    public boolean componentBecameUnselected(int cellIdx) {
        return this.cells[cellIdx].componentBecameUnselected();
    }

    public float[] getTransformationCenter() {
        if (this.activeCell == -1) {
            return null;
        }
        return this.cells[this.activeCell].getTransformationCenter();
    }

    public double getShiftX(int cellIndex) {
        return this.getActiveCell().getShiftX() / 30.0 * (double)this.width;
    }

    public double getShiftY(int cellIndex) {
        return this.getActiveCell().getShiftY() / 30.0 * (double)this.width;
    }

    public void setTransformationCenter(UOID id) {
        if (this.activeCell == -1) {
            return;
        }
        if (this.synchronousMode) {
            GraphicComponent gc = this.cells[id.getCellIndex()].getComponent(id.getComponentIndex());
            float[] c = new float[3];
            gc.getCoordinates(c);
            for (int i = 0; i < this.cellCount; ++i) {
                this.cells[i].setTransformationCenter(c[0], c[1], c[2]);
            }
            this.needsRefresh(this.cellCount);
        } else {
            this.cells[id.getCellIndex()].setTransformationCenter(id);
            this.needsRefresh(id.getCellIndex());
        }
    }

    public void setTransformationCenter(float[] c) {
        if (this.activeCell == -1 || c == null) {
            return;
        }
        if (this.synchronousMode) {
            for (int i = 0; i < this.cellCount; ++i) {
                this.cells[i].setTransformationCenter(c[0], c[1], c[2]);
            }
            this.needsRefresh(this.cellCount);
        } else {
            this.cells[this.activeCell].setTransformationCenter(c[0], c[1], c[2]);
            this.needsRefresh(this.activeCell);
        }
    }

    public void zoom(double factor) {
        if (this.activeCell == -1) {
            return;
        }
        if (this.synchronousMode) {
            for (int i = 0; i < this.cellCount; ++i) {
                this.cells[i].zoom(factor);
            }
            this.needsRefresh(this.cellCount);
        } else {
            this.cells[this.activeCell].zoom(factor);
            this.needsRefresh(this.activeCell);
        }
    }

    public void zoomAnimated(double f, int n) {
        f /= (double)n;
        for (int i = 0; i < n; ++i) {
            this.zoom(f);
            this.refresh();
        }
    }

    public void rotate(double rx, double ry, double rz) {
        if (this.activeCell == -1) {
            return;
        }
        this.rx = rx;
        this.ry = ry;
        this.rz = rz;
        if (this.synchronousMode) {
            for (int i = 0; i < this.cellCount; ++i) {
                this.cells[i].rotate(rx, ry, rz);
            }
            this.needsRefresh(this.cellCount);
        } else {
            this.cells[this.activeCell].rotate(rx, ry, rz);
            this.needsRefresh(this.activeCell);
        }
    }

    public void rotateTo(float[] rm) {
        if (this.activeCell == -1) {
            return;
        }
        if (this.synchronousMode) {
            for (int i = 0; i < this.cellCount; ++i) {
                this.cells[i].setRotateMatrix(rm);
            }
            this.needsRefresh(this.cellCount);
        } else {
            this.cells[this.activeCell].setRotateMatrix(rm);
            this.needsRefresh(this.activeCell);
        }
    }

    void rotateAnimated(double rx, double ry, double rz) {
        double sx = rx < 0.0 ? -1.0 : 1.0;
        double sy = ry < 0.0 ? -1.0 : 1.0;
        double sz = rz < 0.0 ? -1.0 : 1.0;
        rx *= sx;
        ry *= sy;
        rz *= sz;
        while (rx > 0.0 || ry > 0.0 || rz > 0.0) {
            float a = this.eventHandler.rotationAngle;
            double x = rx > 0.0 ? (double)a : 0.0;
            double y = ry > 0.0 ? (double)a : 0.0;
            double z = rz > 0.0 ? (double)a : 0.0;
            rx -= x;
            ry -= y;
            rz -= z;
            this.rotate(sx * x, sy * y, sz * z);
            this.refresh();
        }
    }

    void rotateAnimated(double rx, double ry, double rz, int n) {
        for (int i = 0; i < n; ++i) {
            this.rotate(rx / (double)n, ry / (double)n, rz / (double)n);
            this.refresh();
        }
    }

    void rotateWeakening() {
        if (this.rx > 10.0) {
            this.rx = 10.0;
        }
        if (this.rx < -10.0) {
            this.rx = -10.0;
        }
        if (this.ry > 10.0) {
            this.ry = 10.0;
        }
        if (this.ry < -10.0) {
            this.ry = -10.0;
        }
        if (this.rz > 10.0) {
            this.rz = 10.0;
        }
        if (this.rz < -10.0) {
            this.rz = -10.0;
        }
        double r = Math.abs(this.rx) > Math.abs(this.ry) ? Math.abs(this.rx) : Math.abs(this.ry);
        r = Math.abs(this.rz) > r ? Math.abs(this.rz) : r;
        int n = 30 + (int)(2.0 * r);
        double nx = this.rx / (double)n;
        double ny = this.ry / (double)n;
        double nz = this.rz / (double)n;
        for (int i = 0; i < n; ++i) {
            this.rotate(this.rx, this.ry, this.rz);
            this.refresh();
            this.rx -= nx;
            this.ry -= ny;
            this.rz -= nz;
        }
    }

    public void shift(double shiftx, double shifty) {
        if (this.activeCell == -1) {
            return;
        }
        shiftx = shiftx / (double)this.width * 30.0;
        shifty = shifty / (double)this.height * 30.0;
        if (this.synchronousMode) {
            for (int i = 0; i < this.cellCount; ++i) {
                this.cells[i].shift(shiftx, shifty);
            }
            this.needsRefresh(this.cellCount);
        } else {
            this.cells[this.activeCell].shift(shiftx, shifty);
            this.needsRefresh(this.activeCell);
        }
    }

    public void shiftAnimated(double shiftx, double shifty, int n) {
        shiftx /= (double)n;
        shifty /= (double)n;
        for (int i = 0; i < n; ++i) {
            this.shift(shiftx, shifty);
            this.refresh();
        }
    }

    static {
        System.setProperty("sun.java2d.noddraw", "true");
        System.setProperty("jogl.GLContext.noopt", "true");
        System.setProperty("sun.awt.noerasebackground", "true");
        String jver = System.getProperty("java.version");
        System.setProperty(jver.startsWith("1.3") ? "com.apple.macos.useScreenMenuBar" : "apple.laf.useScreenMenuBar", "true");
        GLInfo = "";
    }
}

