/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.space;

import chemaxon.common.util.GeomCalc;
import chemaxon.marvin.space.BoundingBox;
import chemaxon.marvin.space.Colors;
import chemaxon.marvin.space.ComponentElement;
import chemaxon.marvin.space.GraphicComponent;
import chemaxon.marvin.space.MacroMoleculeComponent;
import chemaxon.marvin.space.UOID;
import chemaxon.marvin.space.UsableObject;
import chemaxon.marvin.space.render.Renderer;
import chemaxon.marvin.space.render.UniformSphere;
import chemaxon.struc.MacroMolecule;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MoleculeIterators;
import chemaxon.struc.PeriodicSystem;
import java.awt.Color;
import java.util.HashMap;
import java.util.Properties;
import javax.media.opengl.GL;
import javax.media.opengl.glu.GLU;

public class IonVisualizer
implements MoleculeIterators.MoleculeInterface,
MacroMoleculeComponent.MoleculeVisualizer,
UsableObject {
    protected static final int DEFAULT_H_PRECISION = 5;
    protected static final int DEFAULT_M_PRECISION = 4;
    protected static final int DEFAULT_L_PRECISION = 3;
    protected static final double DEFAULT_BALL_RADIUS = 0.4;
    protected static final double DEFAULT_LINE_WIDTH = 2.0;
    protected static final Color DEFAULT_COLOR = new Color(135, 30, 206);
    public static final int DRAW_TYPE_DOTTED = 1;
    public static final int DRAW_TYPE_WIRE = 2;
    public static final int DRAW_TYPE_BALL = 3;
    public static final int DRAW_TYPE_SPACEFILL = 4;
    protected static HashMap drawTypes = new HashMap();
    protected Properties drawProperties;
    protected String name;
    MacroMolecule.HeteroComponent ion;
    double x;
    double y;
    double z;
    double radius;
    double ballRadius;
    double lineWidth;
    int atNo;
    MacroMoleculeComponent mmc;
    GL gl;
    GLU glu;
    protected BoundingBox boundingBox;
    private int drawType;
    private int colorType;
    private int quality;
    private boolean visible;
    private boolean highlighted;
    int precision;
    protected UniformSphere ball;
    protected boolean selected;
    protected int displaylist;
    protected int ballDlist;
    protected int wireDlist;
    protected boolean needRecreateBall;
    protected boolean needRecreateDisplayList;
    protected boolean needRecreateWire;
    protected boolean initialized;
    MoleculeIterators.AtomIteratorInterface atoms;
    MoleculeIterators.AtomPropertyInterface atomProps;
    protected Color color;
    private Color cpkcolor;

    public IonVisualizer(MacroMolecule.HeteroComponent hc, MacroMoleculeComponent mmc) {
        drawTypes.put("Dotted", new Integer(1));
        drawTypes.put("Wire", new Integer(2));
        drawTypes.put("Ball", new Integer(3));
        drawTypes.put("Spacefill", new Integer(4));
        this.drawProperties = new Properties();
        this.ion = null;
        this.ballRadius = 0.4;
        this.lineWidth = 2.0;
        this.mmc = null;
        this.gl = null;
        this.glu = null;
        this.boundingBox = new BoundingBox();
        this.drawType = 4;
        this.colorType = 1;
        this.quality = 2;
        this.visible = true;
        this.highlighted = false;
        this.precision = 4;
        this.ball = null;
        this.selected = false;
        this.displaylist = -1;
        this.ballDlist = -1;
        this.wireDlist = -1;
        this.needRecreateBall = true;
        this.needRecreateDisplayList = true;
        this.needRecreateWire = true;
        this.initialized = false;
        this.atoms = null;
        this.atomProps = null;
        this.color = DEFAULT_COLOR;
        this.ion = hc;
        this.mmc = mmc;
        this.atoms = this.ion.getAtomIterator(false);
        this.atomProps = this.ion.getAtomProperty();
        if (this.atoms.getCount() != 1) {
            System.out.println("Not exactly 1 atom in ION! " + this.atoms.getCount());
            this.x = 0.0;
            this.y = 0.0;
            this.z = 0.0;
            this.atNo = 1;
            this.radius = 1.0;
            byte[] c = Colors.unknownAtom;
            this.cpkcolor = new Color(c[0] * 2, c[1] * 2, c[2] * 2);
        } else {
            MolAtom ma = hc.getMolecule().getAtom(0);
            this.x = ma.getX();
            this.y = ma.getY();
            this.z = ma.getZ();
            this.atNo = ma.getAtno();
            this.radius = PeriodicSystem.getCovalentRadius(this.atNo);
            if (this.radius == 0.0) {
                this.radius = 2.0;
            }
            byte[] c = Colors.getCPKByteColor(this.atNo);
            this.cpkcolor = new Color(c[0] * 2, c[1] * 2, c[2] * 2);
        }
        this.setBoundingBox();
        this.name = this.ion.getName();
    }

    @Override
    public void onRemove() {
        this.gl.glDeleteLists(this.displaylist, 1);
        this.gl.glDeleteLists(this.ballDlist, 1);
        this.gl.glDeleteLists(this.wireDlist, 1);
    }

    @Override
    public UOID getId() {
        return this.mmc.getUsableObjectId(this);
    }

    @Override
    public boolean isGraphicComponent() {
        return false;
    }

    @Override
    public GraphicComponent getGraphicComponent() {
        return this.mmc;
    }

    public ComponentElement getComponentElement() {
        return this.mmc.getComponentElement(this);
    }

    @Override
    public MacroMoleculeComponent getMacroMoleculeComponent() {
        return this.mmc;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String toString() {
        return this.name;
    }

    @Override
    public void setName(String n) {
        this.name = n;
    }

    private double getRadius() {
        if (this.drawType == 4 || this.drawType == 1) {
            return this.radius;
        }
        return this.ballRadius;
    }

    @Override
    public void setGL(GL gl, GLU glu) {
        this.gl = gl;
        this.glu = glu;
    }

    private void setBoundingBox() {
        float e = 2.0f;
        this.boundingBox.setMin((float)this.x - e, (float)this.y - e, (float)this.z - e);
        this.boundingBox.setMax((float)this.x + e, (float)this.y + e, (float)this.z + e);
        this.boundingBox.ready();
    }

    @Override
    public boolean hasTransparentPart() {
        return false;
    }

    @Override
    public void drawTransparentPart() {
    }

    @Override
    public void draw() {
        if (!this.visible) {
            return;
        }
        if (!this.initialized) {
            this.initDraw();
            this.initialized = true;
        }
        this.generateNecessaryDisplayLists();
        if (this.drawType == 2) {
            if (this.highlighted) {
                this.gl.glLineWidth((float)this.lineWidth + 1.0f);
            } else {
                this.gl.glLineWidth((float)this.lineWidth);
            }
            this.gl.glCallList(this.wireDlist);
            this.gl.glLineWidth(1.0f);
        } else {
            if (this.highlighted) {
                this.gl.glMaterialfv(1028, 4608, Colors.yellowF, 0);
                this.gl.glMaterialfv(1028, 4610, Colors.whiteF, 0);
                this.gl.glMaterialf(1028, 5633, 30.0f);
            }
            if (this.drawType == 1) {
                this.gl.glPolygonMode(1032, 6912);
                this.gl.glDisable(2884);
                this.gl.glPointSize(2.0f);
            }
            this.gl.glCallList(this.displaylist);
            if (this.drawType == 1) {
                this.gl.glPolygonMode(1032, 6914);
                this.gl.glEnable(2884);
            }
            if (this.highlighted) {
                this.gl.glMaterialfv(1032, 4608, Colors.grayF, 0);
                this.gl.glMaterialfv(1032, 4610, Colors.grayF, 0);
                this.gl.glMaterialf(1032, 5633, 100.0f);
            }
        }
    }

    @Override
    public void initDraw() {
        this.setListIndices();
        this.generateBallDlist();
        this.needRecreateBall = false;
        this.generateDisplayList();
        this.needRecreateDisplayList = false;
        this.generateWireDlist();
        this.needRecreateWire = false;
    }

    private void generateNecessaryDisplayLists() {
        if (this.needRecreateDisplayList && this.drawType != 2) {
            this.generateDisplayList();
            this.needRecreateDisplayList = false;
        }
        if (this.needRecreateBall && this.drawType != 2) {
            this.generateBallDlist();
            this.needRecreateBall = false;
        }
        if (this.needRecreateWire && this.drawType == 2) {
            this.generateWireDlist();
            this.needRecreateWire = false;
        }
    }

    private void setListIndices() {
        this.displaylist = this.gl.glGenLists(1);
        this.ballDlist = this.gl.glGenLists(1);
        this.wireDlist = this.gl.glGenLists(1);
    }

    private void generateWireDlist() {
        this.gl.glNewList(this.wireDlist, 4864);
        this.gl.glDisable(2896);
        this.gl.glEnable(3042);
        this.setColor();
        this.atoms.reset();
        while (this.atoms.hasNext()) {
            this.gl.glPushMatrix();
            this.gl.glTranslated((double)this.atoms.getX(), (double)this.atoms.getY(), (double)this.atoms.getZ());
            this.gl.glBegin(1);
            this.gl.glVertex3d(this.ballRadius, 0.0, 0.0);
            this.gl.glVertex3d(-this.ballRadius, 0.0, 0.0);
            this.gl.glVertex3d(0.0, this.ballRadius, 0.0);
            this.gl.glVertex3d(0.0, -this.ballRadius, 0.0);
            this.gl.glVertex3d(0.0, 0.0, this.ballRadius);
            this.gl.glVertex3d(0.0, 0.0, -this.ballRadius);
            this.gl.glEnd();
            this.gl.glPopMatrix();
            this.atoms.next();
        }
        this.gl.glEnable(2896);
        this.gl.glDisable(3042);
        this.gl.glLineWidth(1.0f);
        this.gl.glEndList();
    }

    private void generateDisplayList() {
        this.gl.glNewList(this.displaylist, 4864);
        this.gl.glPushMatrix();
        this.setColor();
        this.gl.glTranslated(this.x, this.y, this.z);
        if (this.drawType != 4 && this.drawType != 1) {
            this.gl.glScaled(this.ballRadius, this.ballRadius, this.ballRadius);
        }
        this.gl.glCallList(this.ballDlist);
        this.gl.glPopMatrix();
        this.gl.glEndList();
    }

    private void setColor() {
        if (this.selected) {
            this.gl.glColor3bv(Colors.selected, 0);
        } else if (this.colorType == 1) {
            this.gl.glColor3f((float)this.cpkcolor.getRed() / 255.0f, (float)this.cpkcolor.getGreen() / 255.0f, (float)this.cpkcolor.getBlue() / 255.0f);
        } else {
            this.gl.glColor3f((float)this.color.getRed() / 255.0f, (float)this.color.getGreen() / 255.0f, (float)this.color.getBlue() / 255.0f);
        }
    }

    private void generateBallDlist() {
        this.ball = Renderer.spheres.getUniformSphere(this.precision, 1.0f);
        this.ball.generateRendererDisplayList(this.ballDlist, this.gl);
    }

    @Override
    public int getAtomCount(boolean enumerateHydrogens) {
        return this.atoms.getCount();
    }

    @Override
    public MoleculeIterators.AtomIteratorInterface getAtomIterator(boolean enumerateHydrogens) {
        return this.atoms;
    }

    @Override
    public MoleculeIterators.AtomPropertyInterface getAtomProperty() {
        return this.atomProps;
    }

    @Override
    public int getBondCount(boolean enumerateHydrogens) {
        return 0;
    }

    @Override
    public MoleculeIterators.BondIteratorInterface getBondIterator(boolean enumerateHydrogens) {
        return null;
    }

    @Override
    public BoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    @Override
    public Color getColor() {
        if (this.colorType == 2) {
            return this.color;
        }
        return this.cpkcolor;
    }

    @Override
    public boolean isSelectedAtom(int i) {
        return this.selected;
    }

    @Override
    public void select() {
        if (this.selected) {
            return;
        }
        this.selected = true;
        this.needRecreateDisplayList = true;
        this.needRecreateWire = true;
        this.mmc.notifySelection();
    }

    @Override
    public void selectComponentElementsInside(BoundingBox bb) {
        if (bb.contains((float)this.x, (float)this.y, (float)this.z)) {
            this.select();
        }
    }

    @Override
    public void selectAtom(int i) {
        if (this.selected) {
            return;
        }
        this.selected = true;
        this.needRecreateDisplayList = true;
        this.needRecreateWire = true;
    }

    @Override
    public int selectedAtomCount() {
        return this.selected ? 1 : 0;
    }

    @Override
    public String getDescription(ComponentElement ce) {
        return this.ion.getName();
    }

    @Override
    public ComponentElement[] getLabelInformation(String labelType) {
        if (labelType.equalsIgnoreCase("molecule")) {
            return new ComponentElement[]{this.mmc.getComponentElement(this)};
        }
        return new ComponentElement[0];
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    @Override
    public void unSelect() {
        if (!this.selected) {
            return;
        }
        this.selected = false;
        this.needRecreateDisplayList = true;
        this.needRecreateWire = true;
        this.mmc.notifyUnSelection();
    }

    @Override
    public void drawAtomSelection(int mode) {
        double e;
        switch (this.drawType) {
            case 1: 
            case 4: {
                e = this.getRadius();
                break;
            }
            default: {
                e = this.ballRadius;
            }
        }
        double s = e * Math.sqrt(2.0) / 2.0;
        this.atoms.reset();
        while (this.atoms.hasNext()) {
            if (this.isAtomVisible(this.atoms.current())) {
                if (mode == 7170) {
                    this.gl.glPushName(this.atoms.current());
                }
                this.gl.glPushMatrix();
                this.gl.glTranslated(this.x, this.y, this.z);
                this.gl.glMultMatrixf(GeomCalc.getMatrix(this.mmc.irm), 0);
                this.gl.glTranslated(-this.x, -this.y, -this.z);
                this.gl.glBegin(6);
                this.gl.glVertex3d(this.x, this.y, this.z);
                this.gl.glVertex3d(this.x - e, this.y, this.z);
                this.gl.glVertex3d(this.x - s, this.y - s, this.z);
                this.gl.glVertex3d(this.x, this.y - e, this.z);
                this.gl.glVertex3d(this.x + s, this.y - s, this.z);
                this.gl.glVertex3d(this.x + e, this.y, this.z);
                this.gl.glVertex3d(this.x + s, this.y + s, this.z);
                this.gl.glVertex3d(this.x, this.y + e, this.z);
                this.gl.glVertex3d(this.x - s, this.y + s, this.z);
                this.gl.glVertex3d(this.x - e, this.y, this.z);
                this.gl.glEnd();
                this.gl.glPopMatrix();
                if (mode == 7170) {
                    this.gl.glPopName();
                }
            }
            this.atoms.next();
        }
    }

    @Override
    public void unSelectAtom(int i) {
        if (!this.selected) {
            return;
        }
        this.selected = false;
        this.needRecreateDisplayList = true;
        this.needRecreateWire = true;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public boolean isAtomVisible(int i) {
        return this.isVisible();
    }

    @Override
    public int getVisibleAtomCount() {
        return this.visible ? 1 : 0;
    }

    @Override
    public void setVisible(boolean v) {
        if (this.visible == v) {
            return;
        }
        this.visible = v;
        this.mmc.setBoundingBox();
    }

    @Override
    public void showFaded() {
    }

    @Override
    public void hideSelected() {
        if (this.selected) {
            this.selected = false;
            this.setVisible(false);
        }
    }

    @Override
    public void hideUnselected() {
        if (!this.selected) {
            this.setVisible(false);
        }
    }

    @Override
    public void fadeSelected() {
    }

    @Override
    public void fadeUnselected() {
    }

    @Override
    public boolean isAtomFaded(int i) {
        return false;
    }

    @Override
    public boolean isHighlighted() {
        return this.highlighted;
    }

    @Override
    public void setHighlighted(boolean v) {
        if (this.highlighted == v) {
            return;
        }
        this.highlighted = v;
    }

    @Override
    public int getColorType() {
        return this.colorType;
    }

    private void setQuality(String propertyName) {
        if (propertyName.equalsIgnoreCase("medium") && this.quality != 2) {
            this.setQuality(2);
        } else if (propertyName.equalsIgnoreCase("high") && this.quality != 3) {
            this.setQuality(3);
        } else if (propertyName.equalsIgnoreCase("low") && this.quality != 1) {
            this.setQuality(1);
        }
    }

    private void setQuality(int quality) {
        if (this.quality == quality) {
            return;
        }
        this.quality = quality;
        if (quality == 3) {
            this.precision = 5;
        } else if (quality == 2) {
            this.precision = 4;
        } else if (quality == 1) {
            this.precision = 3;
        }
        this.needRecreateBall = true;
    }

    private void setDrawType(String drawType) {
        int dt = -1;
        try {
            dt = (Integer)drawTypes.get(drawType);
        }
        catch (Exception e) {
            System.out.println("Unexpected type of draw: " + drawType);
        }
        if (this.drawType == dt || dt == -1) {
            return;
        }
        this.drawType = dt;
        this.needRecreateDisplayList = true;
    }

    private void setColorType(String propertyValue) {
        int ct = -1;
        ct = propertyValue.equals("CPK") ? 1 : 2;
        if (this.colorType == ct || ct == -1) {
            return;
        }
        this.colorType = ct;
        this.needRecreateDisplayList = true;
        this.needRecreateWire = true;
    }

    @Override
    public void setColor(Color color) {
        this.color = color;
        this.needRecreateDisplayList = true;
        this.needRecreateWire = true;
    }

    @Override
    public String getDrawProperty(String propertyName) {
        return this.drawProperties.getProperty(propertyName);
    }

    @Override
    public void setDrawProperty(String propertyName, String propertyValue) {
        if (propertyName.equals("Quality")) {
            this.setDrawProperty("Ion.Quality", propertyValue);
            return;
        }
        if (propertyName.startsWith("Colors.CPK") && this.selected) {
            this.needRecreateDisplayList = true;
        }
        if (!propertyName.startsWith("Ion")) {
            return;
        }
        this.drawProperties.setProperty(propertyName, propertyValue);
        if (propertyName.equals("Ion.DrawType")) {
            this.setDrawType(propertyValue);
        } else if (propertyName.equals("Ion.ColorType")) {
            this.setColorType(propertyValue);
        } else if (propertyName.equals("Ion.Color")) {
            this.setColor(Color.decode(propertyValue));
        } else if (propertyName.equals("Ion.Quality")) {
            this.setQuality(propertyValue);
        } else if (propertyName.equals("Ion.BallRadius")) {
            this.ballRadius = Float.valueOf(propertyValue).floatValue();
            this.needRecreateBall = true;
            this.needRecreateWire = true;
            this.needRecreateDisplayList = true;
        } else if (propertyName.equals("Ion.LineWidth")) {
            this.lineWidth = Float.valueOf(propertyValue).floatValue();
            this.needRecreateBall = true;
            this.needRecreateWire = true;
        } else if (propertyName.equals("Ion.Visible")) {
            this.setVisible(Boolean.valueOf(propertyValue));
        }
    }
}

