/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.space;

import chemaxon.marvin.space.MSpaceEasy;
import chemaxon.marvin.space.gui.ErrorDialog;
import chemaxon.util.FindCodeBase;
import com.sun.opengl.impl.NativeLibLoader;
import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.cert.Certificate;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.media.opengl.GLDrawableFactory;

public class MSpaceInstaller {
    static String userHome = System.getProperty("user.home");
    static String osName = System.getProperty("os.name");
    static String jogl = System.mapLibraryName("jogl");
    static String jogl_cg = System.mapLibraryName("jogl_cg");
    static String jogl_awt = System.mapLibraryName("jogl_awt");
    static String gluegen = System.mapLibraryName("gluegen-rt");
    static String jogl_drihack = System.mapLibraryName("jogl_drihack");
    static String lineSeparator = System.getProperty("line.separator");
    private static String errorMessage = "Installation failed, please report at http://www.chemaxon.com/forum/forum32.html.";
    public static String joglVersion = "";
    private NativeLibInfo nativeLibInfo;
    private String[] nativeLibNames;
    private String[] nativeJarNames;
    private String details = "";
    private boolean verbose = false;
    private String mspaceDir;
    private String joglDir;
    private File joglFile;
    private File joglAwtFile;
    private File gluegenFile;
    private static final NativeLibInfo[] allNativeLibInfo = new NativeLibInfo[]{new NativeLibInfo("win", "x86", "windows-i586", "", ".dll"), new NativeLibInfo("win", "amd64", "windows-amd64", "", ".dll"), new NativeLibInfo("win", "x86_64", "windows-amd64", "", ".dll"), new NativeLibInfo("mac", "ppc", "macosx-ppc", "lib", ".jnilib"), new NativeLibInfo("mac", "i386", "macosx-universal", "lib", ".jnilib"), new NativeLibInfo("mac", "x86_64", "macosx-universal", "lib", ".jnilib"), new NativeLibInfo("linux", "i386", "linux-i586", "lib", ".so"), new NativeLibInfo("linux", "x86", "linux-i586", "lib", ".so"), new NativeLibInfo("linux", "amd64", "linux-amd64", "lib", ".so"), new NativeLibInfo("linux", "x86_64", "linux-amd64", "lib", ".so"), new NativeLibInfo("sunos", "sparc", "solaris-sparc", "lib", ".so"), new NativeLibInfo("sunos", "sparcv9", "solaris-sparcv9", "lib", ".so"), new NativeLibInfo("sunos", "x86", "solaris-i586", "lib", ".so"), new NativeLibInfo("sunos", "amd64", "solaris-amd64", "lib", ".so"), new NativeLibInfo("sunos", "x86_64", "solaris-amd64", "lib", ".so")};

    public MSpaceInstaller(boolean verbose) throws Exception {
        this.verbose = verbose;
        try {
            String implementationVersion;
            String osName = System.getProperty("os.name").toLowerCase();
            String osArch = System.getProperty("os.arch").toLowerCase();
            if (!this.checkOSAndArch(osName, osArch)) {
                this.error("Init failed : Unsupported os / arch ( " + osName + " / " + osArch + " )");
            }
            String userHome = System.getProperty("user.home");
            this.mspaceDir = userHome + File.separator;
            this.mspaceDir = this.mspaceDir + (File.separator.equals("/") ? ".chemaxon" : "chemaxon");
            this.mspaceDir = this.mspaceDir + File.separator + "lib";
            ClassLoader classloader = this.getClass().getClassLoader();
            classloader.loadClass("javax.media.opengl.GL");
            Package p = Package.getPackage("javax.media.opengl");
            if (p == null) {
                this.error("Package information is not available for javax.media.opengl");
            }
            if ((implementationVersion = p.getImplementationVersion()) != null) {
                this.joglDir = "jogl_" + implementationVersion.replace(':', '_');
                this.mspaceDir = this.mspaceDir + File.separator + this.joglDir + File.separator + osArch;
                joglVersion = "Jogl Version = " + implementationVersion;
            } else {
                this.error("Implementation version could not be determined. (Probably jogl.jar is not in the classpath, or older version found.)");
            }
            File msFile = new File(this.mspaceDir);
            if (!msFile.exists() && !msFile.mkdirs()) {
                this.error("Unable to create directories for target: " + msFile);
            }
            this.nativeJarNames = new String[]{this.nativeLibInfo.formatNativeJarName("jogl-natives-{0}-" + implementationVersion + ".jar"), this.nativeLibInfo.formatNativeJarName("gluegen-rt-natives-{0}-" + implementationVersion + ".jar")};
            this.joglFile = new File(this.mspaceDir + File.separator + jogl);
            this.joglAwtFile = new File(this.mspaceDir + File.separator + jogl_awt);
            this.gluegenFile = new File(this.mspaceDir + File.separator + gluegen);
        }
        catch (Exception e) {
            this.error(e);
        }
    }

    private void error(String errormsg) throws Exception {
        System.out.println(errormsg);
        this.details = this.details + errormsg;
        ErrorDialog err = new ErrorDialog(null, "Error", errorMessage, this.details, false);
        err.setVisible(true);
        throw new Exception(errormsg);
    }

    private void error(Exception e) throws Exception {
        e.printStackTrace();
        this.details = this.details + e.getMessage();
        ErrorDialog err = new ErrorDialog(null, "Error", errorMessage, this.details, false);
        err.setVisible(true);
        throw e;
    }

    public void install(URL codeBase, boolean verbose) throws Exception {
        this.verbose = verbose;
        this.report("Native directory is " + this.mspaceDir);
        if (!this.joglLibrariesFound()) {
            this.report("Jogl libraries not found at " + this.mspaceDir);
            if (codeBase.getPath().indexOf("javaws") != -1 && codeBase.getPath().indexOf("cache") != -1) {
                System.out.println("Codebase seems a javaws cache path, Jogl is loaded by the default Jogl loader.");
                return;
            }
            for (int i = 0; i < this.nativeJarNames.length; ++i) {
                URL[] locations = new URL[]{new URL(codeBase, this.nativeJarNames[i]), new URL(codeBase, "lib/" + this.nativeJarNames[i])};
                this.findJarFile(locations, this.nativeJarNames[i]);
                this.loadFromJar(new File(this.mspaceDir + File.separator + this.nativeJarNames[i]));
            }
        }
        if (this.joglLibrariesFound()) {
            try {
                this.loadJoglLibraries();
            }
            catch (Exception e) {
                this.error(e);
            }
            catch (Throwable t) {
                this.error(t.getMessage());
            }
        }
    }

    public void install(boolean verbose) throws Exception {
        this.verbose = verbose;
        this.report("Native directory is " + this.mspaceDir);
        if (!this.joglLibrariesFound()) {
            this.report("Jogl libraries not found at " + this.mspaceDir);
            String userDir = FindCodeBase.getCodeBaseDir();
            if (MSpaceEasy.isURL(userDir)) {
                URL codeBase = new URL(userDir);
                this.install(codeBase, verbose);
                return;
            }
            if (userDir.indexOf("javaws") != -1 && userDir.indexOf("cache") != -1) {
                System.out.println("Codebase seems a javaws cache path, Jogl is loaded by the default Jogl loader.");
                return;
            }
            for (int i = 0; i < this.nativeJarNames.length; ++i) {
                String[] locations = new String[]{userDir + File.separator + "lib", userDir, userDir + File.separator + ".." + File.separator + "lib"};
                this.report("Searching for " + this.nativeJarNames[i]);
                int jfi = this.findJarFile(locations, this.nativeJarNames[i]);
                if (jfi <= -1) continue;
                this.loadFromJar(new File(locations[jfi] + File.separator + this.nativeJarNames[i]));
            }
        }
        if (this.joglLibrariesFound()) {
            try {
                this.loadJoglLibraries();
            }
            catch (Throwable t) {
                this.error("Error loading native libraries: " + t.getMessage());
            }
        } else {
            this.error("Installation failed");
        }
    }

    private boolean checkOSAndArch(String osName, String osArch) {
        for (int i = 0; i < allNativeLibInfo.length; ++i) {
            NativeLibInfo info = allNativeLibInfo[i];
            if (!info.matchesOSAndArch(osName, osArch)) continue;
            this.nativeLibInfo = info;
            return true;
        }
        return false;
    }

    private void report(String report) {
        if (this.verbose) {
            System.out.println(report);
        }
        this.details = this.details + report + lineSeparator;
    }

    private boolean joglLibrariesFound() {
        return this.joglFile.exists() && this.joglAwtFile.exists() && this.gluegenFile.exists();
    }

    private void loadJoglLibraries() throws Throwable {
        block6: {
            boolean isOSX;
            NativeLibLoader.disableLoading();
            com.sun.gluegen.runtime.NativeLibLoader.disableLoading();
            this.report("NativeLibLoader disabled.");
            String osName2 = System.getProperty("os.name").toLowerCase();
            String osArch = System.getProperty("os.arch").toLowerCase();
            if (!osName2.startsWith("win") || !osArch.equals("amd64") && !osArch.equals("x86_64")) {
                System.load(this.gluegenFile.getPath());
            }
            Class<?> driHackClass = null;
            if (this.nativeLibInfo.mayNeedDRIHack()) {
                driHackClass = Class.forName("com.sun.opengl.impl.x11.DRIHack");
                driHackClass.getMethod("begin", new Class[0]).invoke(null, new Object[0]);
            }
            System.load(this.joglFile.getPath());
            if (this.nativeLibInfo.mayNeedDRIHack()) {
                driHackClass.getMethod("end", new Class[0]).invoke(null, new Object[0]);
            }
            if (!(isOSX = osName.startsWith("Mac"))) {
                try {
                    Toolkit.getDefaultToolkit();
                    System.loadLibrary("jawt");
                }
                catch (UnsatisfiedLinkError e) {
                    e.printStackTrace();
                    if (e.getMessage().indexOf("already loaded") != -1) break block6;
                    throw e;
                }
            }
        }
        System.load(this.joglAwtFile.getPath());
        this.report("Jogl libraries have been loaded.");
    }

    private int isJarFile(String[] locations) {
        for (int i = 0; i < locations.length; ++i) {
            File f;
            if (locations[i].endsWith(this.nativeJarNames[0]) && (f = new File(locations[i])).exists()) {
                this.report("Native jar file found: " + locations[i]);
                return i;
            }
            this.report("Native jar file not found at " + locations[i]);
        }
        return -1;
    }

    private int findJarFile(String[] locations, String nativeJarName) {
        for (int i = 0; i < locations.length; ++i) {
            String s = locations[i] + File.separator + nativeJarName;
            File f = new File(s);
            if (f.exists()) {
                this.report("Native jar file found: " + s);
                return i;
            }
            this.report("Native jar file does not exist: " + s);
        }
        return -1;
    }

    private int findJarFile(URL[] locations, String nativeJarName) {
        URL sourceURL = null;
        URLConnection connection = null;
        for (int i = 0; i < locations.length; ++i) {
            sourceURL = locations[i];
            try {
                connection = sourceURL.openConnection();
                MSpaceInstaller.installFile(connection, this.mspaceDir + File.separator + nativeJarName, this.verbose);
                this.report("Jar file has been saved from " + locations[i]);
                return i;
            }
            catch (Exception e) {
                this.report("Jar file not found at " + locations[i]);
                this.report(e.getMessage());
                continue;
            }
        }
        return -1;
    }

    private void loadFromJar(File localJarFile) throws Exception {
        int i;
        JarFile jf = new JarFile(localJarFile);
        if (!this.findNativeEntries(jf)) {
            this.report("Native libraries not found in jar file");
            return;
        }
        byte[] buf = new byte[8192];
        for (i = 0; i < this.nativeLibNames.length; ++i) {
            JarEntry entry = jf.getJarEntry(this.nativeLibNames[i]);
            if (entry == null) {
                this.report("Error looking up jar entry " + this.nativeLibNames[i]);
                return;
            }
            if (this.checkNativeCertificates(jf, entry, buf)) continue;
            this.report("Native library " + this.nativeLibNames[i] + " isn't properly signed or has other errors");
        }
        for (i = 0; i < this.nativeLibNames.length; ++i) {
            this.report("Installing native file " + this.nativeLibNames[i]);
            if (!this.installFile(this.mspaceDir, jf, this.nativeLibNames[i], buf)) {
                return;
            }
            this.report("ok");
        }
        jf.close();
    }

    private boolean findNativeEntries(JarFile jf) {
        ArrayList<String> list = new ArrayList<String>();
        Enumeration<JarEntry> e = jf.entries();
        while (e.hasMoreElements()) {
            JarEntry entry = e.nextElement();
            if (!this.nativeLibInfo.matchesNativeLib(entry.getName())) continue;
            list.add(entry.getName());
        }
        if (list.isEmpty()) {
            return false;
        }
        this.nativeLibNames = list.toArray(new String[0]);
        return true;
    }

    private boolean checkNativeCertificates(JarFile jar, JarEntry entry, byte[] buf) {
        try {
            int len;
            InputStream is = jar.getInputStream(entry);
            while ((len = is.read(buf)) > 0) {
            }
            is.close();
            Certificate[] nativeCerts = entry.getCertificates();
            Certificate[] joglCerts = GLDrawableFactory.class.getProtectionDomain().getCodeSource().getCertificates();
            if (nativeCerts == null || nativeCerts.length == 0) {
                return false;
            }
            int checked = 0;
            block3: for (int i = 0; i < joglCerts.length; ++i) {
                for (int j = 0; j < nativeCerts.length; ++j) {
                    if (!nativeCerts[j].equals(joglCerts[i])) continue;
                    ++checked;
                    continue block3;
                }
            }
            return checked == joglCerts.length;
        }
        catch (Exception e) {
            this.report(e.getMessage());
            return false;
        }
    }

    private boolean installFile(String installDir, JarFile jar, String fileName, byte[] buf) {
        try {
            JarEntry entry = jar.getJarEntry(fileName);
            if (entry == null) {
                this.report("Error finding native library " + fileName);
                return false;
            }
            InputStream is = jar.getInputStream(entry);
            BufferedOutputStream out = null;
            File outputFile = new File(installDir, fileName);
            try {
                out = new BufferedOutputStream(new FileOutputStream(outputFile));
            }
            catch (Exception e) {
                this.report("Error opening file " + fileName + " for writing");
                return false;
            }
            try {
                int len;
                while ((len = is.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
            }
            catch (IOException ioe) {
                this.report("Error writing file " + fileName + " to disk");
                ioe.printStackTrace();
                outputFile.delete();
                return false;
            }
            out.flush();
            out.close();
            return true;
        }
        catch (Exception e2) {
            e2.printStackTrace();
            this.report("Error writing file " + fileName + " to disk");
            return false;
        }
    }

    public static void installFile(URLConnection connection, String destFileName, boolean verbose) throws Exception {
        File destFile = new File(destFileName);
        if (!destFile.exists()) {
            int i;
            if (verbose) {
                System.out.println("installing " + connection.getURL().toString() + " to " + destFileName);
            }
            destFile.getParentFile().mkdirs();
            InputStream is = connection.getInputStream();
            FileOutputStream fos = new FileOutputStream(destFile);
            byte[] buff = new byte[8192];
            BufferedInputStream in = new BufferedInputStream(is, buff.length);
            BufferedOutputStream out = new BufferedOutputStream(fos, buff.length);
            while ((i = in.read(buff, 0, buff.length)) != -1) {
                out.write(buff, 0, i);
            }
            in.close();
            out.close();
        } else {
            System.err.println("File " + destFileName + " already exists.");
        }
    }

    private static class NativeLibInfo {
        private String osName;
        private String osArch;
        private String osNameAndArchPair;
        private String nativePrefix;
        private String nativeSuffix;

        public NativeLibInfo(String osName, String osArch, String osNameAndArchPair, String nativePrefix, String nativeSuffix) {
            this.osName = osName;
            this.osArch = osArch;
            this.osNameAndArchPair = osNameAndArchPair;
            this.nativePrefix = nativePrefix;
            this.nativeSuffix = nativeSuffix;
        }

        public boolean matchesOSAndArch(String osName, String osArch) {
            return osName.toLowerCase().startsWith(this.osName) && (this.osArch == null || osArch.toLowerCase().equals(this.osArch));
        }

        public boolean matchesNativeLib(String nativeLibraryName) {
            return nativeLibraryName.toLowerCase().endsWith(this.nativeSuffix);
        }

        public String formatNativeJarName(String nativeJarPattern) {
            return MessageFormat.format(nativeJarPattern, this.osNameAndArchPair);
        }

        public String getNativeLibName(String baseName) {
            return this.nativePrefix + baseName + this.nativeSuffix;
        }

        public boolean isMacOS() {
            return this.osName.equals("mac");
        }

        public boolean mayNeedDRIHack() {
            return !this.isMacOS() && !this.osName.equals("win");
        }
    }
}

