/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.space;

import chemaxon.marvin.modules.mprop.VolumetricData;
import chemaxon.marvin.space.Colors;
import chemaxon.marvin.space.GraphicComponent;
import chemaxon.marvin.space.MacroMoleculeComponent;
import chemaxon.marvin.space.ProgressBarInterface;
import chemaxon.marvin.space.SurfaceColoring;
import chemaxon.marvin.space.SurfaceComponent;
import chemaxon.marvin.space.UsableObject;
import chemaxon.marvin.space.grid.AtomGrid;
import chemaxon.marvin.space.grid.AtomTypeColorGrid;
import chemaxon.marvin.space.grid.ElectrostaticPotentialGrid;
import chemaxon.marvin.space.grid.Grid;
import chemaxon.marvin.space.grid.MarchingCubes;
import chemaxon.marvin.space.util.Palette;
import chemaxon.marvin.util.CallbackIface;
import chemaxon.marvin.util.ColorPaletteUtil;
import chemaxon.struc.MoleculeIterators;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import javax.media.opengl.GL;
import javax.media.opengl.glu.GLU;

public class MolecularSurfaceComponent
extends GraphicComponent
implements CallbackIface,
UsableObject {
    public static final int SURFACE_TYPE_VDW = 1;
    public static final int SURFACE_TYPE_CONNOLLY = 2;
    public static final int SURFACE_TYPE_SAS = 3;
    public static final int SURFACE_TYPE_BLOBBY = 4;
    public static final int SURFACE_TYPE_GAUSSIAN = 5;
    protected static final float[] highPrecisions = new float[]{0.25f, 0.35f, 0.45f, 0.6f, 0.7f, 0.8f, 1.0f};
    protected static final float[] mediumPrecisions = new float[]{0.35f, 0.45f, 0.55f, 0.7f, 0.8f, 0.9f, 1.2f};
    protected static final float[] lowPrecisions = new float[]{0.45f, 0.55f, 0.65f, 0.8f, 0.9f, 1.0f, 1.4f};
    protected static final int[] precisionThresholds = new int[]{500, 1000, 2500, 5000, 10000, 20000};
    protected static final int SURFACE_SMOOTHNESS = 2;
    protected static final boolean SURFACE_SIMPLIFICATION_ENABLED = false;
    protected static final boolean AUTO_RESOLUTION_ENABLED = true;
    public static final float DEFAULT_RESOLUTION = 0.55f;
    public static final float DEFAULT_PROBE_RADIUS = 1.4f;
    public static final float DEFAULT_ISOVALUE = 0.018f;
    public static final int SURFACE_COLOR_TYPE_CONSTANT = 1;
    public static final int SURFACE_COLOR_TYPE_ATOMTYPE = 2;
    public static final int SURFACE_COLOR_TYPE_RESIDUE = 3;
    public static final int SURFACE_COLOR_TYPE_CHAIN = 4;
    public static final int SURFACE_COLOR_TYPE_EP = 5;
    public static final int SURFACE_COLOR_TYPE_SS = 6;
    public static final int SURFACE_COLOR_GRID_MAPPING = 7;
    public static final int SURFACE_COLOR_PROPERTY_MAPPING = 8;
    public static final int SURFACE_COLOR_TYPE_B_FACTOR = 9;
    public static final int SURFACE_COLOR_TYPE_RAINBOW = 10;
    SurfaceComponent surface;
    AtomGrid atomGrid;
    ArrayList molecules;
    ArrayList atomProperties = null;
    float isoValue = 0.018f;
    boolean showGrid = false;
    Grid volumetricData = null;
    ElectrostaticPotentialGrid epPropertyGrid;
    AtomTypeColorGrid acg;
    SurfaceColoring surfaceColoring;
    protected int paletteId = 0;
    protected byte[][] customPaletteColors = null;
    boolean surfaceColoringInitialized = false;
    protected float surfaceGridPrecision = 0.55f;
    protected int surfaceSmoothnessFactor = 2;
    protected boolean surfaceSimplificationEnabled = false;
    protected float surfaceSimplificationTolerance = 0.0f;
    protected boolean automaticSettingOfGridSize = true;
    protected int atomCount;
    protected int surfaceType = 0;
    protected int surfaceColorType = 1;
    private double probeRadius = 1.4f;
    private double minValue;
    private double maxValue;
    private boolean coordinatesChanged = false;
    private ProgressBarInterface progressBar = null;

    public MolecularSurfaceComponent() {
    }

    public MolecularSurfaceComponent(MoleculeIterators.MoleculeInterface mi, VolumetricData vd) throws Exception {
        this.surfaceType = 5;
        this.atomGrid = new AtomGrid(vd);
        this.modifiesOrigin = false;
        this.molecules = new ArrayList();
        this.molecules.add(mi);
        this.setBoundingBox();
        this.boundingBox.extend(2.0f);
        this.computeSurface();
    }

    public MolecularSurfaceComponent(MoleculeIterators.MoleculeInterface mi, VolumetricData vd, float isoValue) throws Exception {
        this.surfaceType = 5;
        this.atomGrid = new AtomGrid(vd);
        this.isoValue = isoValue;
        this.modifiesOrigin = false;
        this.molecules = new ArrayList();
        this.molecules.add(mi);
        this.setBoundingBox();
        this.boundingBox.extend(2.0f);
        this.computeSurface();
    }

    public MolecularSurfaceComponent(ArrayList molecules) {
        this.molecules = molecules;
        this.modifiesOrigin = false;
        this.setBoundingBox();
    }

    public MolecularSurfaceComponent(ArrayList molecules, String surfaceType) throws Exception {
        this.molecules = molecules;
        this.surfaceType = MolecularSurfaceComponent.getSurfaceType(surfaceType);
        this.modifiesOrigin = false;
        this.setBoundingBox();
        this.fillAtomGrid();
        this.computeSurface();
    }

    public static String getSurfaceTypeString(int surfaceType) {
        switch (surfaceType) {
            case 1: {
                return "van der Waals";
            }
            case 2: {
                return "Connolly";
            }
            case 3: {
                return "Solvent accessible";
            }
            case 4: {
                return "Blobby";
            }
            case 5: {
                return "Gaussian cube";
            }
        }
        return "Unknown";
    }

    public static int getSurfaceType(String type) {
        String t = type.toLowerCase();
        if (t.indexOf("van") >= 0 && t.indexOf("der") > 0 && t.indexOf("waals") > 0) {
            return 1;
        }
        if (t.equals("connolly")) {
            return 2;
        }
        if (t.indexOf("solvent") >= 0 && t.indexOf("accessible") > 0) {
            return 3;
        }
        if (t.equals("blobby")) {
            return 4;
        }
        if (t.startsWith("gaussian")) {
            return 5;
        }
        return 0;
    }

    @Override
    public void onRemoveGraphicComponent() {
        super.onRemoveGraphicComponent();
        this.surface.onRemoveGraphicComponent();
        this.atomGrid = null;
        this.surfaceColoring = null;
        this.molecules.clear();
        this.molecules = null;
        this.atomProperties = null;
        this.volumetricData = null;
        this.surface = null;
    }

    @Override
    public void setProgressBar(ProgressBarInterface PB) {
        this.progressBar = PB;
    }

    @Override
    public void receiveNotificationOnCoordinateChange(GraphicComponent gc) {
        this.coordinatesChanged = true;
    }

    @Override
    public boolean isControllable(String type) {
        if (!this.active) {
            return false;
        }
        if (type.equalsIgnoreCase("Resize")) {
            return true;
        }
        return type.equalsIgnoreCase("Shift");
    }

    @Override
    public void translate(float[] v) {
        this.surface.boundingBox.translate(v);
    }

    @Override
    public void resize(double x, double y, double z) {
        x /= 10.0;
        y /= 10.0;
        z /= 10.0;
        if (!this.surface.isClipped()) {
            this.surface.clipSurface(this.boundingBox);
        }
        if ((double)this.surface.boundingBox.minx() - x <= (double)this.surface.boundingBox.maxx() + x) {
            this.surface.boundingBox.setMinX(this.surface.boundingBox.minx() - (float)x);
            this.surface.boundingBox.setMaxX(this.surface.boundingBox.maxx() + (float)x);
        }
        if ((double)this.surface.boundingBox.miny() - y <= (double)this.surface.boundingBox.maxy() + y) {
            this.surface.boundingBox.setMinY(this.surface.boundingBox.miny() - (float)y);
            this.surface.boundingBox.setMaxY(this.surface.boundingBox.maxy() + (float)y);
        }
        if ((double)this.surface.boundingBox.minz() - z <= (double)this.surface.boundingBox.maxz() + z) {
            this.surface.boundingBox.setMinZ(this.surface.boundingBox.minz() - (float)z);
            this.surface.boundingBox.setMaxZ(this.surface.boundingBox.maxz() + (float)z);
        }
    }

    public boolean surfaceOf(GraphicComponent gc) {
        for (MacroMoleculeComponent.MoleculeVisualizer mv : this.molecules) {
            if (mv.getMacroMoleculeComponent() == null && mv == gc) {
                return true;
            }
            if (mv.getMacroMoleculeComponent() != gc) continue;
            return true;
        }
        return false;
    }

    public void setMolecules(ArrayList molecules) {
        this.molecules = molecules;
        this.setBoundingBox();
    }

    @Override
    public void draw() {
        this.gl.glBegin(1);
        this.gl.glVertex3f(0.0f, 0.0f, 0.0f);
        this.gl.glEnd();
        if (this.visible && this.coordinatesChanged && this.motionMode == 1) {
            try {
                this.boundingBox.clear();
                this.setBoundingBox();
                this.fillAtomGrid();
                try {
                    this.computeSurface();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (this.surfaceColorType != 1) {
                    try {
                        int type = this.surfaceColorType;
                        this.surfaceColorType = 1;
                        this.surfaceColoringInitialized = false;
                        this.coloringMolecularSurface(type);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                this.coordinatesChanged = false;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.surface.draw();
    }

    @Override
    public void drawTransparentPart() {
        if (this.active) {
            this.surface.getBoundingBox().draw(this.gl);
        }
        if (this.surface.hasTransparentPart()) {
            this.surface.drawTransparentPart();
        }
    }

    @Override
    public Color getColor() {
        return this.surface.getColor();
    }

    @Override
    public void setColor(Color c) {
        super.setColor(c);
        this.surface.setColor(c);
    }

    public SurfaceComponent getSurface() {
        return this.surface;
    }

    public int getSurfaceType() {
        return this.surfaceType;
    }

    public void setSurfaceType(String s) throws Exception {
        this.surfaceType = MolecularSurfaceComponent.getSurfaceType(s);
        if (this.surfaceType == 3) {
            this.boundingBox.extend((float)this.probeRadius);
        }
        this.fillAtomGrid();
        this.computeSurface();
    }

    public int getSurfaceSmoothnessFactor() {
        return this.surfaceSmoothnessFactor;
    }

    public void setSurfaceSimplificationEnabled(boolean b) {
        this.surfaceSimplificationEnabled = b;
    }

    public boolean getSurfaceSimplificationEnabled() {
        return this.surfaceSimplificationEnabled;
    }

    public float getSurfaceThreshold() {
        return this.isoValue;
    }

    public double getProbeRadius() {
        return this.probeRadius;
    }

    public void setProbeRadius(double r) {
        this.probeRadius = r;
    }

    @Override
    public void setVisible(boolean state) {
        super.setVisible(state);
        this.surface.setVisible(state);
    }

    public double getSurfacePrecision() {
        return this.surfaceGridPrecision;
    }

    public void setSurfacePrecision(String quality) throws Exception {
        if (quality.equalsIgnoreCase("high")) {
            this.renderingQuality = 3;
        } else if (quality.equalsIgnoreCase("medium")) {
            this.renderingQuality = 2;
        } else if (quality.equalsIgnoreCase("low")) {
            this.renderingQuality = 1;
        }
        this.surfaceGridPrecision = this.getPrecision();
        this.fillAtomGrid();
        this.computeSurface();
        int type = this.surfaceColorType;
        this.surfaceColorType = 1;
        this.coloringMolecularSurface(type);
    }

    public void setSurfacePrecision(float v) {
        this.automaticSettingOfGridSize = false;
        this.surfaceGridPrecision = v;
    }

    public void setSurfacePrecision() {
        this.automaticSettingOfGridSize = true;
        this.surfaceGridPrecision = this.getPrecision();
    }

    private float getPrecision() {
        return this.automaticSettingOfGridSize ? MolecularSurfaceComponent.getPrecision(this.renderingQuality, MolecularSurfaceComponent.getPrecisionCategory(this.atomCount)) : this.surfaceGridPrecision;
    }

    private static int getPrecisionCategory(int atomCount) {
        int i;
        for (i = 0; i < precisionThresholds.length; ++i) {
            if (atomCount >= precisionThresholds[i]) continue;
            return i;
        }
        return i;
    }

    private static float getPrecision(int quality, int i) {
        switch (quality) {
            case 3: {
                return highPrecisions[i];
            }
            case 1: {
                return lowPrecisions[i];
            }
        }
        return mediumPrecisions[i];
    }

    @Override
    public void setDrawProperty(String propertyName, String propertyValue) throws Exception {
        if (propertyName.equals("Quality")) {
            this.setDrawProperty("Surface.Quality", propertyValue);
            return;
        }
        if (propertyName.startsWith("Colors.")) {
            if (this.surfaceColoring != null) {
                this.surfaceColoring.updateColors();
            }
        } else if (propertyName.startsWith("Palette.")) {
            double value = Double.parseDouble(propertyValue);
            if (propertyName.equalsIgnoreCase("Palette.Minimum")) {
                this.setPaletteMinimum(value);
            } else if (propertyName.equalsIgnoreCase("Palette.Maximum")) {
                this.setPaletteMaximum(value);
            } else if (propertyName.equalsIgnoreCase("Palette.Lower")) {
                this.setNegativeCriterium(value);
            } else if (propertyName.equalsIgnoreCase("Palette.Upper")) {
                this.setPositiveCriterium(value);
            }
        } else if (!propertyName.startsWith("Surface.")) {
            return;
        }
        this.storeDrawProperty(propertyName, propertyValue);
        if (propertyName.equals("Surface.Quality")) {
            if (propertyValue.equalsIgnoreCase("low")) {
                this.renderingQuality = 1;
            } else if (propertyValue.equalsIgnoreCase("high")) {
                this.renderingQuality = 3;
            } else if (propertyValue.equalsIgnoreCase("medium")) {
                this.renderingQuality = 2;
            }
            if (this.surface == null) {
                this.surfaceGridPrecision = this.getPrecision();
            }
            this.refreshColoring();
        } else if (propertyName.equals("Surface.ColorType")) {
            this.coloringMolecularSurface(propertyValue);
        } else if (propertyName.equals("Surface.DrawType")) {
            this.surface.setDrawType(propertyValue);
        } else if (propertyName.equals("Surface.Color")) {
            this.surface.setColor(Color.decode(propertyValue));
            this.refreshColoring();
        } else if (propertyName.equals("Surface.Palette")) {
            this.setPalette(ColorPaletteUtil.getBuiltInPaletteId(propertyValue));
        } else if (propertyName.equals("Surface.Simplification")) {
            this.setSurfaceSimplificationEnabled(Boolean.valueOf(propertyValue));
        } else if (propertyName.equals("Surface.AutoResolution")) {
            if (Boolean.valueOf(propertyValue).booleanValue()) {
                this.setSurfacePrecision();
            } else {
                this.automaticSettingOfGridSize = false;
            }
        } else if (propertyName.equals("Surface.Resolution")) {
            if (!this.automaticSettingOfGridSize) {
                this.setSurfacePrecision(Float.parseFloat(propertyValue));
            }
        } else if (propertyName.equals("Surface.ProbeRadius")) {
            this.setProbeRadius(Double.parseDouble(propertyValue));
        } else if (propertyName.equals("Surface.IsoValue")) {
            float newValue = Float.parseFloat(propertyValue);
            if (this.isoValue < 0.0f) {
                newValue *= -1.0f;
            }
            if (this.isoValue == newValue) {
                return;
            }
            this.isoValue = newValue;
            if (this.surfaceType == 5) {
                this.computeSurface();
            }
        }
    }

    public void refreshColoring() throws Exception {
        int type = this.surfaceColorType;
        this.surfaceColorType = 1;
        this.coloringMolecularSurface(type);
    }

    public int getDrawType() {
        return this.surface.getDrawType();
    }

    @Override
    public boolean hasTransparentPart() {
        return this.active || this.surface.hasTransparentPart();
    }

    public int getColorType() {
        return this.surfaceColorType;
    }

    public void setPalette(int paletteId) {
        this.paletteId = paletteId;
        if (this.surfaceColoring != null) {
            this.surfaceColoring.changeColorMapperColors(paletteId);
            try {
                this.surfaceColoring.updateColors();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        byte[][] p = SurfaceColoring.getBuiltInPalette(paletteId);
        this.surface.setExclusiveColor(p[p.length / 2]);
    }

    public void setPalette(byte[][] colors) {
        this.customPaletteColors = colors;
    }

    public void setExclusiveDrawing(boolean b) {
        if (this.surfaceColoring == null) {
            return;
        }
        this.surfaceColoring.setSmoothColoringToCutoffValues(!b);
        this.surface.setExclusiveDrawing(b);
        try {
            this.surfaceColoring.updateColors();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isVolumeVisible() {
        return this.showGrid;
    }

    public void showVolume(boolean b) {
        if (this.surfaceColorType != 7) {
            return;
        }
        this.showGrid = b;
    }

    public void setNegativeCriterium(double v) throws Exception {
        if (!this.isColorMapperEnabled()) {
            return;
        }
        this.surfaceColoring.setLowerCutoffValue(v);
        this.surfaceColoring.updateColors();
    }

    public void setPositiveCriterium(double v) throws Exception {
        if (!this.isColorMapperEnabled()) {
            return;
        }
        this.surfaceColoring.setUpperCutoffValue(v);
        this.surfaceColoring.updateColors();
    }

    public void setPaletteMinimum(double v) throws Exception {
        if (this.surfaceColorType != 5 && this.surfaceColorType != 7) {
            return;
        }
        this.surfaceColoring.setMinimumValue(v);
        this.surfaceColoring.updateColors();
    }

    public void setPaletteMaximum(double v) throws Exception {
        if (this.surfaceColorType != 5 && this.surfaceColorType != 7) {
            return;
        }
        this.surfaceColoring.setMaximumValue(v);
        this.surfaceColoring.updateColors();
    }

    public Palette getPalette() {
        if (this.surfaceColoring != null) {
            return this.surfaceColoring.pm.getBuiltInPalette();
        }
        return null;
    }

    public String getPaletteString() {
        return ColorPaletteUtil.getBuiltInPaletteString(this.paletteId);
    }

    public double getMinimumMappedValue() {
        return this.minValue;
    }

    public double getMaximumMappedValue() {
        return this.maxValue;
    }

    public boolean isColorMapperEnabled() {
        return this.surfaceColorType == 5 || this.surfaceColorType == 8 || this.surfaceColorType == 7;
    }

    public void mapPropertyToSurface(VolumetricData vd) throws Exception {
        this.mapPropertyToSurface(new Grid(vd));
    }

    public void mapPropertyToSurface(Grid grid) throws Exception {
        this.surfaceColorType = 7;
        this.storeDrawProperty("Surface.ColorType", "GridMapping");
        this.surfaceColoring = new SurfaceColoring(this.molecules, this.surface, this.atomGrid.getStepX());
        this.volumetricData = grid;
        this.surfaceColoring.setPropertyObject(this.volumetricData, 0);
        this.surfaceColoring.setPropertyMethod(Grid.class.getMethod("getLinearWeighted", Float.TYPE, Float.TYPE, Float.TYPE));
        this.surfaceColoring.setBuiltInColorMapperMethod(this.paletteId, true);
        this.surfaceColoring.setProgressBar(this.progressBar);
        this.surfaceColoring.doColoring();
        this.minValue = this.surfaceColoring.getMinimumValue();
        this.maxValue = this.surfaceColoring.getMaximumValue();
    }

    public void updatePropertyMapping() throws Exception {
        if (this.surfaceColorType != 7) {
            return;
        }
        this.surfaceColoring.doColoring();
    }

    public void setAtomPropertyList(ArrayList atomProperties) {
        this.atomProperties = new ArrayList(atomProperties);
    }

    private void setBoundingBox() {
        if (this.molecules == null) {
            return;
        }
        this.boundingBox.clear();
        for (MacroMoleculeComponent.MoleculeVisualizer mv : this.molecules) {
            if (mv == null) continue;
            this.boundingBox.setWithCondition(mv.getBoundingBox());
        }
        this.boundingBox.extend(0.5f);
        this.boundingBox.ready();
    }

    private void fillAtomGrid() throws Exception {
        if (this.atomCount == 0) {
            for (MacroMoleculeComponent.MoleculeVisualizer mv : this.molecules) {
                this.atomCount += mv.getVisibleAtomCount();
            }
            this.surfaceGridPrecision = this.getPrecision();
        }
        if (this.atomGrid == null) {
            this.atomGrid = new AtomGrid(this.boundingBox, this.surfaceGridPrecision, this.surfaceGridPrecision, this.surfaceGridPrecision, (float)this.probeRadius);
            this.isoValue = this.atomGrid.surfaceThreshold;
        } else {
            this.atomGrid.realloc(this.boundingBox);
        }
        int l = 50 / this.molecules.size();
        int li = 0;
        Iterator i = this.molecules.iterator();
        while (i.hasNext()) {
            if (this.progressBar != null) {
                this.atomGrid.setProgressBar(this.progressBar, li, li + l);
                li += l;
            }
            MoleculeIterators.MoleculeInterface mv = (MoleculeIterators.MoleculeInterface)i.next();
            this.atomGrid.setMoleculeInterface(mv);
            this.atomGrid.createGrid(this.surfaceType);
        }
    }

    private void computeSurface() throws Exception {
        MarchingCubes mc = new MarchingCubes(this.atomGrid, this.isoValue);
        if (this.progressBar != null) {
            mc.setProgressBar(this.progressBar, 50, 100);
        }
        mc.setSimplification(this.surfaceSimplificationEnabled);
        mc.setSmoothnessFactor(this.surfaceSmoothnessFactor);
        boolean b = this.surface != null;
        this.surface = mc.generate();
        if (this.surfaceColorType == 1) {
            this.surface.setColor(this.color);
        }
        if (b) {
            this.addDrawProperties(this.drawProperties);
        }
        if (this.gl != null) {
            this.surface.setGL(this.gl, this.glu);
        }
    }

    @Override
    public void select() {
        super.select();
        this.surface.clipSurface(this.boundingBox);
    }

    public void surfaceSimplification() throws Exception {
        if (this.surface == null) {
            return;
        }
        int vc = this.surface.getVertexCount();
        MarchingCubes mc = new MarchingCubes(this.surface);
        if (this.progressBar != null) {
            mc.setProgressBar(this.progressBar, 0, 100);
        }
        if (this.surfaceSimplificationTolerance == 0.0f) {
            this.surfaceSimplificationTolerance = Math.min(Math.min(this.atomGrid.getStepX(), this.atomGrid.getStepY()), this.atomGrid.getStepZ());
        }
        this.surface = mc.reduceTriangleCount(this.surfaceSimplificationTolerance);
        this.surfaceColoringInitialized = false;
        if ((double)((float)this.surface.getVertexCount() / (float)vc) > 0.8) {
            this.surfaceSimplificationTolerance *= 2.0f;
        }
        this.addDrawProperties(this.drawProperties);
        if (this.gl != null) {
            this.surface.setGL(this.gl, this.glu);
        }
    }

    @Override
    public void setGL(GL gl, GLU glu) {
        super.setGL(gl, glu);
        this.surface.setGL(gl, glu);
    }

    @Override
    protected void drawSelection(int mode) {
        if (this.surface != null) {
            this.surface.drawSelection(mode);
        }
    }

    private void coloringMolecularSurface(int type) throws Exception {
        if (this.surfaceColorType == type) {
            return;
        }
        if (this.surface == null) {
            return;
        }
        if (!this.surfaceColoringInitialized) {
            this.surfaceColoring = new SurfaceColoring(this.molecules, this.surface, this.atomGrid.getStepX());
            this.surfaceColoring.setProgressBar(this.progressBar);
            this.surfaceColoringInitialized = true;
        }
        switch (type) {
            case 1: {
                this.surface.coloring(false);
                this.surfaceColorType = type;
                return;
            }
            case 2: {
                this.surfaceColoring.reset();
                if (this.surfaceType == 3) {
                    this.surfaceColoring.setEnrtyRadiusMode(2);
                    this.surfaceColoring.setAtomRadiusExtension((float)this.probeRadius);
                }
                if (this.surfaceType == 5) {
                    this.surfaceColoring.setEnrtyRadiusMode(2);
                    this.surfaceColoring.setAtomRadiusExtension((float)this.probeRadius);
                    this.surfaceColoring.setDistanceRadiusMode(1);
                }
                this.surfaceColoring.doColoring(2);
                break;
            }
            case 3: {
                this.surfaceColoring.reset();
                if (this.surfaceType == 3) {
                    this.surfaceColoring.setEnrtyRadiusMode(2);
                    this.surfaceColoring.setAtomRadiusExtension((float)this.probeRadius);
                }
                if (this.surfaceType == 5) {
                    this.surfaceColoring.setEnrtyRadiusMode(2);
                    this.surfaceColoring.setAtomRadiusExtension((float)this.probeRadius);
                    this.surfaceColoring.setDistanceRadiusMode(1);
                }
                this.surfaceColoring.doColoring(3);
                break;
            }
            case 4: {
                this.surfaceColoring.reset();
                if (this.surfaceType == 3) {
                    this.surfaceColoring.setEnrtyRadiusMode(2);
                    this.surfaceColoring.setAtomRadiusExtension((float)this.probeRadius);
                }
                if (this.surfaceType == 5) {
                    this.surfaceColoring.setEnrtyRadiusMode(2);
                    this.surfaceColoring.setAtomRadiusExtension((float)this.probeRadius);
                    this.surfaceColoring.setDistanceRadiusMode(1);
                }
                this.surfaceColoring.doColoring(4);
                break;
            }
            case 5: {
                this.surfaceColoring.reset();
                if (this.surfaceType == 3) {
                    this.surfaceColoring.setEnrtyRadiusMode(2);
                    this.surfaceColoring.setAtomRadiusExtension((float)this.probeRadius);
                }
                if (this.surfaceType == 5) {
                    this.surfaceColoring.setEnrtyRadiusMode(2);
                    this.surfaceColoring.setAtomRadiusExtension((float)this.probeRadius);
                    this.surfaceColoring.setDistanceRadiusMode(1);
                }
                this.surfaceColoring.setWeightMode(3);
                this.surfaceColoring.setBuiltInColorMapperMethod(this.paletteId, true);
                this.surfaceColoring.setPropertyMethod(MoleculeIterators.AtomPropertyInterface.class.getMethod("getPartialAtomCharge", Integer.TYPE));
                this.surfaceColoring.doColoring();
                this.minValue = this.surfaceColoring.getMinimumValue();
                this.maxValue = this.surfaceColoring.getMaximumValue();
                break;
            }
            case 6: {
                this.surfaceColoring.reset();
                if (this.surfaceType == 3) {
                    this.surfaceColoring.setEnrtyRadiusMode(2);
                    this.surfaceColoring.setAtomRadiusExtension((float)this.probeRadius);
                }
                if (this.surfaceType == 5) {
                    this.surfaceColoring.setEnrtyRadiusMode(2);
                    this.surfaceColoring.setAtomRadiusExtension((float)this.probeRadius);
                    this.surfaceColoring.setDistanceRadiusMode(1);
                }
                this.surfaceColoring.doColoring(5);
                break;
            }
            case 9: {
                this.surfaceColoring.reset();
                if (this.surfaceType == 3) {
                    this.surfaceColoring.setEnrtyRadiusMode(2);
                    this.surfaceColoring.setAtomRadiusExtension((float)this.probeRadius);
                }
                if (this.surfaceType == 5) {
                    this.surfaceColoring.setEnrtyRadiusMode(2);
                    this.surfaceColoring.setAtomRadiusExtension((float)this.probeRadius);
                    this.surfaceColoring.setDistanceRadiusMode(1);
                }
                this.surfaceColoring.setWeightMode(2);
                this.surfaceColoring.setHomogeneousPaletteColors(new byte[][]{Colors.blue, Colors.cyan, Colors.green, Colors.yellow});
                this.surfaceColoring.setPropertyMethod(MoleculeIterators.AtomPropertyInterface.class.getMethod("getBFactor", Integer.TYPE));
                this.surfaceColoring.doColoring();
                break;
            }
            case 10: {
                this.surfaceColoring.reset();
                if (this.surfaceType == 3) {
                    this.surfaceColoring.setEnrtyRadiusMode(2);
                    this.surfaceColoring.setAtomRadiusExtension((float)this.probeRadius);
                }
                if (this.surfaceType == 5) {
                    this.surfaceColoring.setEnrtyRadiusMode(2);
                    this.surfaceColoring.setAtomRadiusExtension((float)this.probeRadius);
                    this.surfaceColoring.setDistanceRadiusMode(1);
                }
                this.surfaceColoring.doColoring(6);
                break;
            }
            case 8: {
                this.surfaceColoring.reset();
                if (this.surfaceType == 3) {
                    this.surfaceColoring.setEnrtyRadiusMode(2);
                    this.surfaceColoring.setAtomRadiusExtension((float)this.probeRadius);
                }
                if (this.surfaceType == 5) {
                    this.surfaceColoring.setEnrtyRadiusMode(2);
                    this.surfaceColoring.setAtomRadiusExtension((float)this.probeRadius);
                    this.surfaceColoring.setDistanceRadiusMode(1);
                }
                this.surfaceColoring.setWeightMode(3);
                if (this.customPaletteColors != null) {
                    this.surfaceColoring.setHomogeneousPaletteColors(this.customPaletteColors);
                } else {
                    this.surfaceColoring.setBuiltInColorMapperMethod(this.paletteId, true);
                }
                this.surfaceColoring.setPropertyObject(this.atomProperties, 1);
                this.surfaceColoring.setPropertyMethod(ArrayList.class.getMethod("get", Integer.TYPE));
                this.surfaceColoring.doColoring();
                this.minValue = this.surfaceColoring.getMinimumValue();
                this.maxValue = this.surfaceColoring.getMaximumValue();
                break;
            }
            case 7: {
                this.surfaceColoring.reset();
                this.surfaceColoring.setSurface(this.surface);
                this.surfaceColoring.setPropertyObject(this.volumetricData, 0);
                this.surfaceColoring.setPropertyMethod(Grid.class.getMethod("getLinearWeighted", Float.TYPE, Float.TYPE, Float.TYPE));
                this.surfaceColoring.setBuiltInColorMapperMethod(this.paletteId, true);
                this.surfaceColoring.doColoring();
                this.minValue = this.surfaceColoring.getMinimumValue();
                this.maxValue = this.surfaceColoring.getMaximumValue();
            }
        }
        this.surfaceColorType = type;
    }

    private void coloringMolecularSurface(String type) throws Exception {
        if (type.equals("Constant")) {
            this.coloringMolecularSurface(1);
        } else if (type.equals("AtomType") || type.equals("CPK")) {
            this.coloringMolecularSurface(2);
        } else if (type.equalsIgnoreCase("ResidueType")) {
            this.coloringMolecularSurface(3);
        } else if (type.equalsIgnoreCase("ChainType")) {
            this.coloringMolecularSurface(4);
        } else if (type.equalsIgnoreCase("ElectrostaticPotential")) {
            this.coloringMolecularSurface(5);
        } else if (type.equalsIgnoreCase("SecondaryStructureType")) {
            this.coloringMolecularSurface(6);
        } else if (type.equalsIgnoreCase("B-factor")) {
            this.coloringMolecularSurface(9);
        } else if (type.equalsIgnoreCase("Rainbow")) {
            this.coloringMolecularSurface(10);
        } else if (type.equalsIgnoreCase("AtomProperty")) {
            this.coloringMolecularSurface(8);
        } else if (type.equalsIgnoreCase("GridMapping")) {
            this.coloringMolecularSurface(7);
        }
    }

    @Override
    public void setRotateMatrix(float[] rotateMatrix) {
        super.setRotateMatrix(rotateMatrix);
        if (this.surface != null) {
            this.surface.setRotateMatrix(rotateMatrix);
        }
    }

    @Override
    public Object callback(String method, Object arg) {
        try {
            if (method.equals("setAtomPropertyList")) {
                this.setAtomPropertyList((ArrayList)arg);
            } else if (method.equals("setDrawProperty")) {
                Object[] args = (Object[])arg;
                this.setDrawProperty((String)args[0], (String)args[1]);
            } else if (method.equals("setPalette")) {
                this.setPalette((byte[][])arg);
            } else if (method.equals("getPalette")) {
                return this.getPalette();
            }
        }
        catch (Exception e) {
            return e;
        }
        return null;
    }
}

