/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.space;

import chemaxon.common.util.ArrayTools;
import chemaxon.common.util.GeomCalc;
import chemaxon.marvin.space.Colors;
import chemaxon.marvin.space.ComponentElement;
import chemaxon.marvin.space.GraphicComponent;
import chemaxon.marvin.space.UsableObject;
import chemaxon.marvin.space.render.Cylinder;
import chemaxon.marvin.space.render.Renderer;
import java.awt.Color;

public class PharmacophoreArrow
extends GraphicComponent
implements UsableObject {
    private static final double DEFAULT_RADIUS = 0.1;
    private static final double DEFAULT_LENGTH = 1.0;
    private static final int DEFAULT_H_PRECISION = 30;
    private static final int DEFAULT_M_PRECISION = 20;
    private static final int DEFAULT_L_PRECISION = 14;
    private static final int DRAW_TYPE_FILLED = 0;
    private static final int DRAW_TYPE_TRANSPARENT = 1;
    private static final int DRAW_TYPE_WIRE = 2;
    public static final String[] DRAW_TYPES = new String[]{"Solid", "Transparent", "Mesh"};
    private static final int[] DRAW_TYPE_VALUES = new int[]{0, 1, 2};
    private byte[] color = new byte[]{127, 127, 0};
    private Color awtColor = Color.YELLOW;
    private double x = 0.0;
    private double y = 0.0;
    private double z = 0.0;
    private int vector;
    private double radius = 0.1;
    private double length = 1.0;
    private boolean highlighted = false;
    private boolean initialized = false;
    private int precision = 20;
    private Cylinder arrowHead;
    private Cylinder arrow;
    private int displayList = -1;
    private int arrowDisplayList = -1;
    private int arrowList = -1;
    private int arrowHeadList = -1;
    private boolean needRecreateDisplayList = true;
    private boolean needRecreateArrow = true;

    public PharmacophoreArrow() {
        this.drawType = 0;
        this.modifiesOrigin = false;
    }

    public PharmacophoreArrow(ComponentElement ce) {
        float[] c = new float[3];
        ce.getCoordinates(c);
        this.x = c[0];
        this.y = c[1];
        this.z = c[2];
        this.vector = GeomCalc.newVector(0.0f, 1.0f, 0.0f);
        this.drawType = 0;
        this.modifiesOrigin = false;
    }

    public PharmacophoreArrow(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.vector = GeomCalc.newVector(0.0f, 1.0f, 0.0f);
        this.drawType = 0;
        this.modifiesOrigin = false;
    }

    @Override
    public void onRemoveGraphicComponent() {
        super.onRemoveGraphicComponent();
        GeomCalc.deleteVector(this.vector);
    }

    public void setPosition(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.vector = GeomCalc.newVector(0.0f, 1.0f, 0.0f);
    }

    @Override
    public void getCoordinates(ComponentElement item, float[] c) {
        c[0] = (float)this.x;
        c[1] = (float)this.y;
        c[2] = (float)this.z;
    }

    @Override
    public String getDescription() {
        return "Pharmacophore arrow";
    }

    @Override
    public String getName() {
        return "Pharmacophore arrow";
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double r) {
        this.radius = r;
        this.needRecreateArrow = true;
    }

    @Override
    public Color getColor() {
        return this.awtColor;
    }

    @Override
    public void select() {
        super.select();
        this.needRecreateDisplayList = true;
    }

    @Override
    public void unSelect() {
        super.unSelect();
        this.needRecreateDisplayList = true;
    }

    public boolean isHighlighted() {
        return this.highlighted;
    }

    public void setHighlighted(boolean flag) {
        this.highlighted = flag;
    }

    @Override
    public void translate(float[] v) {
        this.x += (double)v[0];
        this.y += (double)v[1];
        this.z += (double)v[2];
        this.needRecreateDisplayList = true;
        super.translate(v);
    }

    @Override
    public void rotate(float[] v, float[] center) {
        GeomCalc.rotateX(this.vector, Math.sin((double)v[0] * 0.5), Math.cos((double)v[0] * 0.5));
        GeomCalc.rotateY(this.vector, Math.sin((double)v[1] * 0.5), Math.cos((double)v[1] * 0.5));
        GeomCalc.rotateZ(this.vector, Math.sin((double)v[2] * 0.5), Math.cos((double)v[2] * 0.5));
        this.needRecreateDisplayList = true;
        this.notifyCoordinateChange();
    }

    @Override
    public void resize(double x, double y, double z) {
        z /= 10.0;
        if ((x /= 10.0) != 0.0 || (y /= 10.0) != 0.0) {
            if (this.length + y > 0.1 && this.length + y < 10.0) {
                this.length += y;
            }
            if (this.radius + x > 0.1 && this.radius + x < 1.0) {
                this.radius += x;
            }
            this.needRecreateArrow = true;
        } else if (z != 0.0) {
            if (this.length + z > 0.1 && this.length + z < 10.0) {
                this.length += z;
            }
            this.needRecreateArrow = true;
        }
    }

    @Override
    public boolean isControllable(String type) {
        return this.active;
    }

    @Override
    public boolean hasTransparentPart() {
        return this.drawType != 0;
    }

    @Override
    public void drawTransparentPart() {
        if (!this.visible) {
            return;
        }
        if (!this.initialized) {
            this.initDraw();
            this.initialized = true;
        }
        this.generateNecessaryDisplayLists();
        if (this.highlighted) {
            this.gl.glMaterialfv(1028, 4608, Colors.whiteF, 0);
            this.gl.glMaterialfv(1028, 4610, Colors.whiteF, 0);
            this.gl.glMaterialf(1028, 5633, 30.0f);
        }
        this.gl.glCallList(this.displayList);
        if (this.highlighted) {
            this.gl.glMaterialfv(1032, 4608, Colors.grayF, 0);
            this.gl.glMaterialfv(1032, 4610, Colors.grayF, 0);
            this.gl.glMaterialf(1032, 5633, 100.0f);
        }
    }

    @Override
    public void draw() {
        if (!this.visible || this.drawType != 0) {
            return;
        }
        if (!this.initialized) {
            this.initDraw();
            this.initialized = true;
        }
        this.generateNecessaryDisplayLists();
        if (this.highlighted) {
            this.gl.glMaterialfv(1028, 4608, Colors.whiteF, 0);
            this.gl.glMaterialfv(1028, 4610, Colors.whiteF, 0);
            this.gl.glMaterialf(1028, 5633, 30.0f);
        }
        this.gl.glCallList(this.displayList);
        if (this.highlighted) {
            this.gl.glMaterialfv(1032, 4608, Colors.grayF, 0);
            this.gl.glMaterialfv(1032, 4610, Colors.grayF, 0);
            this.gl.glMaterialf(1032, 5633, 100.0f);
        }
    }

    private void initDraw() {
        this.setListIndices();
        this.generateArrowList();
        this.needRecreateArrow = false;
        this.generateDisplayList();
        this.needRecreateDisplayList = false;
    }

    private void generateNecessaryDisplayLists() {
        if (this.needRecreateDisplayList) {
            this.generateDisplayList();
            this.needRecreateDisplayList = false;
        }
        if (this.needRecreateArrow) {
            this.generateArrowList();
            this.needRecreateArrow = false;
        }
    }

    private void setListIndices() {
        this.displayList = this.gl.glGenLists(1);
        this.arrowDisplayList = this.gl.glGenLists(1);
        this.arrowList = this.gl.glGenLists(1);
        this.arrowHeadList = this.gl.glGenLists(1);
    }

    private void generateDisplayList() {
        this.gl.glNewList(this.displayList, 4864);
        this.gl.glDisable(2884);
        this.gl.glPushMatrix();
        if (this.drawType == 2) {
            this.gl.glPolygonMode(1032, 6913);
            this.gl.glDisable(2884);
            this.gl.glEnable(3042);
        } else if (this.drawType == 1) {
            this.gl.glDisable(2884);
            this.gl.glEnable(3042);
            this.gl.glDepthMask(false);
        }
        if (this.active) {
            byte[] selColor = Colors.selected;
            this.gl.glColor4b(selColor[0], selColor[1], selColor[2], (byte)63);
        } else {
            this.gl.glColor4b(this.color[0], this.color[1], this.color[2], (byte)63);
        }
        this.gl.glTranslated(this.x, this.y, this.z);
        double angle = Math.acos(GeomCalc.getZ(this.vector)) * 180.0 / Math.PI;
        this.gl.glRotated(angle, (double)(-GeomCalc.getY(this.vector)), (double)GeomCalc.getX(this.vector), 0.0);
        if (this.active) {
            byte[] selColor = Colors.selected;
            this.gl.glColor4b(selColor[0], selColor[1], selColor[2], (byte)63);
        } else {
            this.gl.glColor4b(this.color[0], this.color[1], this.color[2], (byte)63);
        }
        this.gl.glCallList(this.arrowDisplayList);
        if (this.drawType == 2) {
            this.gl.glPolygonMode(1032, 6914);
            this.gl.glDisable(3042);
            this.gl.glEnable(2884);
        } else if (this.drawType == 1) {
            this.gl.glEnable(2884);
            this.gl.glDisable(3042);
            this.gl.glDepthMask(true);
        }
        this.gl.glPopMatrix();
        this.gl.glEnable(2884);
        this.gl.glEndList();
    }

    private void generateArrowList() {
        this.arrow = Renderer.cylinders.getCylinder(this.precision, 1, this.radius);
        this.arrow.generateRendererDisplayList(this.arrowList, this.gl);
        this.arrowHead = Renderer.cylinders.getCone(this.precision, this.radius * 1.4);
        this.arrowHead.generateRendererDisplayList(this.arrowHeadList, this.gl);
        this.gl.glNewList(this.arrowDisplayList, 4864);
        this.gl.glPushMatrix();
        this.gl.glScaled(1.0, 1.0, Math.abs(this.length));
        if (this.length < 0.0) {
            this.gl.glRotated(180.0, 1.0, 0.0, 0.0);
        }
        this.gl.glCallList(this.arrowList);
        this.gl.glPopMatrix();
        this.gl.glTranslated(0.0, 0.0, this.length);
        if (this.length < 0.0) {
            this.gl.glRotated(180.0, 1.0, 0.0, 0.0);
        }
        this.gl.glScaled(1.0, 1.0, this.length * 0.2);
        this.gl.glCallList(this.arrowHeadList);
        this.gl.glEndList();
    }

    @Override
    protected void pickObject(int offset, double[] maxZ, float[] modelview) {
        int aIdx = GeomCalc.newVector((float)this.x, (float)this.y, (float)this.z);
        GeomCalc.multVectorWithMatrix(aIdx, modelview);
        this.pickedItem = new ComponentElement((GraphicComponent)this, 1, this.selectBuf.get(offset));
        if (this.isVisible(this.pickedItem)) {
            maxZ[0] = GeomCalc.getZ(aIdx);
        }
        GeomCalc.deleteVector(aIdx);
    }

    public void setDrawType(String type) {
        int id = ArrayTools.indexInArray(DRAW_TYPES, type);
        if (id != -1) {
            this.drawType = DRAW_TYPE_VALUES[id];
            this.needRecreateDisplayList = true;
        }
    }

    public String getDrawType() {
        return DRAW_TYPES[this.drawType];
    }

    public void setRenderingQuality(String quality) {
        if (quality.equalsIgnoreCase("medium") && this.renderingQuality != 2) {
            this.setRenderingQuality(2);
        } else if (quality.equalsIgnoreCase("high") && this.renderingQuality != 3) {
            this.setRenderingQuality(3);
        } else if (quality.equalsIgnoreCase("low") && this.renderingQuality != 1) {
            this.setRenderingQuality(1);
        }
    }

    @Override
    public void setRenderingQuality(int quality) {
        if (this.renderingQuality == quality) {
            return;
        }
        this.renderingQuality = quality;
        if (quality == 3) {
            this.precision = 30;
        } else if (quality == 2) {
            this.precision = 20;
        } else if (quality == 1) {
            this.precision = 14;
        }
        this.needRecreateArrow = true;
    }

    @Override
    public void setDrawProperty(String propertyName, String propertyValue) {
        if (propertyName.equals("Quality")) {
            this.setDrawProperty("PharmacophoreArrow.Quality", propertyValue);
            return;
        }
        if (!propertyName.startsWith("PharmacophoreArrow")) {
            return;
        }
        this.storeDrawProperty(propertyName, propertyValue);
        if (propertyName.equalsIgnoreCase("PharmacophoreArrow.DrawType")) {
            this.setDrawType(propertyValue);
        }
        if (propertyName.equalsIgnoreCase("PharmacophoreArrow.Quality")) {
            this.setRenderingQuality(propertyValue);
        }
    }
}

