/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.space;

import chemaxon.common.util.ArrayTools;
import chemaxon.common.util.GeomCalc;
import chemaxon.marvin.space.Colors;
import chemaxon.marvin.space.ComponentElement;
import chemaxon.marvin.space.GraphicComponent;
import chemaxon.marvin.space.UsableObject;
import chemaxon.marvin.space.render.Renderer;
import chemaxon.marvin.space.render.UniformSphere;
import java.awt.Color;

public class PharmacophorePoint
extends GraphicComponent
implements UsableObject {
    public static final float DEFAULT_RADIUS = 1.0f;
    private static final int DEFAULT_H_PRECISION = 5;
    private static final int DEFAULT_M_PRECISION = 4;
    private static final int DEFAULT_L_PRECISION = 3;
    private static final int DRAW_TYPE_DOTTED = 0;
    private static final int DRAW_TYPE_WIRE = 1;
    private static final int DRAW_TYPE_FILLED = 2;
    private static final int DRAW_TYPE_TRANSPARENT = 3;
    public static final String[] DRAW_TYPES = new String[]{"Dotted", "Mesh", "Solid", "Transparent"};
    private static final int[] DRAW_TYPE_VALUES = new int[]{0, 1, 2, 3};
    public static final int UNKONWN_TYPE = 0;
    public static final int ACCEPTOR_TYPE = 1;
    public static final int DONOR_TYPE = 2;
    public static final int ANIONIC_TYPE = 4;
    public static final int CATIONIC_TYPE = 8;
    public static final int HYDROPHOBIC_TYPE = 16;
    public static final int AROMATIC_TYPE = 32;
    public static final int EXCLUDED_TYPE = 4096;
    private int pharmacophoreType = 0;
    private byte[] color = new byte[3];
    private Color awtColor = Color.WHITE;
    private double x = 0.0;
    private double y = 0.0;
    private double z = 0.0;
    private float radius = 1.0f;
    private boolean highlighted = false;
    private boolean initialized = false;
    int precision = 4;
    private int displaylist = -1;
    private int ballDlist = -1;
    protected boolean needRecreateBall = true;
    protected boolean needRecreateDisplayList = true;
    private static byte[] unknownColor = new byte[]{127, 127, 127};
    private static byte[] anionicColor = new byte[]{102, 0, 0};
    private static byte[] cationicColor = new byte[]{0, 0, 102};
    private static byte[] acceptorColor = new byte[]{127, 0, 0};
    private static byte[] donorColor = new byte[]{0, 0, 127};
    private static byte[] hydrophobicColor = new byte[]{127, 127, 0};
    private static byte[] aromaticColor = new byte[]{0, 127, 0};
    private static byte[] excludedColor = new byte[]{38, 38, 38};

    public PharmacophorePoint() {
        this.drawType = 3;
        this.modifiesOrigin = false;
    }

    public PharmacophorePoint(ComponentElement ce) {
        float[] c = new float[3];
        ce.getCoordinates(c);
        this.x = c[0];
        this.y = c[1];
        this.z = c[2];
        this.drawType = 3;
        this.modifiesOrigin = false;
        this.setBoundingBox();
    }

    public PharmacophorePoint(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.drawType = 3;
        this.modifiesOrigin = false;
        this.setBoundingBox();
    }

    public void setPosition(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.setBoundingBox();
    }

    @Override
    public void getCoordinates(ComponentElement item, float[] c) {
        c[0] = (float)this.x;
        c[1] = (float)this.y;
        c[2] = (float)this.z;
    }

    @Override
    public String getDescription() {
        return this.getTypeName() + "point";
    }

    @Override
    public String getName() {
        return this.getTypeName() + "point";
    }

    private String getTypeName() {
        if (this.pharmacophoreType == 0) {
            return "Unknown ";
        }
        StringBuffer sb = new StringBuffer();
        if (this.isAnionic()) {
            sb.append("Anionic ");
        }
        if (this.isCationic()) {
            sb.append("Cationic ");
        }
        if (this.isAromatic()) {
            sb.append("Aromatic ");
        }
        if (this.isHydrophobic()) {
            sb.append("Hydrophobic ");
        }
        if (this.isAcceptor()) {
            sb.append("Acceptor ");
        }
        if (this.isDonor()) {
            sb.append("Donor ");
        }
        if (this.isExcluded()) {
            sb.append("Excluded ");
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(float r) {
        this.radius = r;
        this.needRecreateBall = true;
    }

    @Override
    public Color getColor() {
        return this.awtColor;
    }

    @Override
    public void select() {
        super.select();
        this.needRecreateDisplayList = true;
    }

    @Override
    public void unSelect() {
        super.unSelect();
        this.needRecreateDisplayList = true;
    }

    public boolean isHighlighted() {
        return this.highlighted;
    }

    public void setHighlighted(boolean flag) {
        this.highlighted = flag;
    }

    @Override
    public void translate(float[] v) {
        this.x += (double)v[0];
        this.y += (double)v[1];
        this.z += (double)v[2];
        this.needRecreateDisplayList = true;
        this.notifyCoordinateChange();
    }

    @Override
    public void resize(double x, double y, double z) {
        y /= 10.0;
        if (((double)this.radius > 0.3 || y > 0.0) && (this.radius < 10.0f || y < 0.0)) {
            this.setRadius(this.radius + (float)y);
        }
    }

    @Override
    public boolean isControllable(String type) {
        if (!this.active) {
            return false;
        }
        if (type.equalsIgnoreCase("Shift")) {
            return true;
        }
        return type.equalsIgnoreCase("Resize");
    }

    @Override
    public boolean hasTransparentPart() {
        return this.drawType != 2;
    }

    @Override
    public void drawTransparentPart() {
        this.drawComponent();
    }

    @Override
    public void draw() {
        if (this.drawType != 2) {
            return;
        }
        this.drawComponent();
    }

    private void drawComponent() {
        if (!this.visible) {
            return;
        }
        if (!this.initialized) {
            this.initDraw();
            this.initialized = true;
        }
        this.generateNecessaryDisplayLists();
        if (this.highlighted) {
            this.gl.glMaterialfv(1028, 4608, Colors.whiteF, 0);
            this.gl.glMaterialfv(1028, 4610, Colors.whiteF, 0);
            this.gl.glMaterialf(1028, 5633, 30.0f);
        }
        this.gl.glCallList(this.displaylist);
        if (this.highlighted) {
            this.gl.glMaterialfv(1032, 4608, Colors.grayF, 0);
            this.gl.glMaterialfv(1032, 4610, Colors.grayF, 0);
            this.gl.glMaterialf(1032, 5633, 100.0f);
        }
    }

    private void setColor() {
        this.color[0] = 0;
        this.color[1] = 0;
        this.color[2] = 0;
        if (this.pharmacophoreType == 0) {
            this.color[0] = unknownColor[0];
            this.color[1] = unknownColor[1];
            this.color[2] = unknownColor[2];
        } else {
            if (this.isAcceptor()) {
                this.blur(acceptorColor, this.color);
            }
            if (this.isDonor()) {
                this.blur(donorColor, this.color);
            }
            if (this.isHydrophobic()) {
                this.blur(hydrophobicColor, this.color);
            }
            if (this.isAromatic()) {
                this.blur(aromaticColor, this.color);
            }
            if (this.isAnionic()) {
                this.blur(anionicColor, this.color);
            }
            if (this.isCationic()) {
                this.blur(cationicColor, this.color);
            }
            if (this.isExcluded()) {
                this.blur(excludedColor, this.color);
            }
            if (this.active) {
                this.blur(Colors.selected, this.color);
            }
        }
        this.awtColor = new Color(this.color[0] * 2, this.color[1] * 2, this.color[2] * 2);
    }

    private void blur(byte[] color, byte[] newColor) {
        if (newColor[0] == 0 && newColor[1] == 0 && newColor[2] == 0) {
            newColor[0] = color[0];
            newColor[1] = color[1];
            newColor[2] = color[2];
            return;
        }
        int c0 = (int)((double)(newColor[0] + color[0]) * 0.6);
        int c1 = (int)((double)(newColor[1] + color[1]) * 0.6);
        int c2 = (int)((double)(newColor[2] + color[2]) * 0.6);
        newColor[0] = (byte)(c0 > 127 ? 127 : (byte)c0);
        newColor[1] = (byte)(c1 > 127 ? 127 : (byte)c1);
        newColor[2] = (byte)(c2 > 127 ? 127 : (byte)c2);
    }

    private void initDraw() {
        this.setListIndices();
        this.generateBallDlist();
        this.needRecreateBall = false;
        this.setColor();
        this.generateDisplayList();
        this.needRecreateDisplayList = false;
    }

    private void generateNecessaryDisplayLists() {
        if (this.needRecreateDisplayList) {
            this.generateDisplayList();
            this.needRecreateDisplayList = false;
        }
        if (this.needRecreateBall) {
            this.generateBallDlist();
            this.needRecreateBall = false;
        }
    }

    private void setListIndices() {
        this.displaylist = this.gl.glGenLists(1);
        this.ballDlist = this.gl.glGenLists(1);
    }

    private void generateDisplayList() {
        this.gl.glNewList(this.displaylist, 4864);
        this.gl.glPushMatrix();
        if (this.drawType == 1) {
            this.gl.glPolygonMode(1032, 6913);
            this.gl.glDisable(2884);
            this.gl.glEnable(3042);
        } else if (this.drawType == 3) {
            this.gl.glDisable(2884);
            this.gl.glEnable(3042);
            this.gl.glDepthMask(false);
        } else if (this.drawType == 0) {
            this.gl.glDisable(2884);
            this.gl.glEnable(3042);
            this.gl.glPolygonMode(1032, 6912);
            this.gl.glPointSize(2.0f);
        }
        this.gl.glTranslated(this.x, this.y, this.z);
        if (this.active) {
            byte[] selColor = Colors.selected;
            this.gl.glColor4b(selColor[0], selColor[1], selColor[2], (byte)63);
        } else {
            this.gl.glColor4b(this.color[0], this.color[1], this.color[2], (byte)63);
        }
        this.gl.glCallList(this.ballDlist);
        if (this.drawType == 1) {
            this.gl.glPolygonMode(1032, 6914);
            this.gl.glDisable(3042);
            this.gl.glEnable(2884);
        } else if (this.drawType == 3) {
            this.gl.glEnable(2884);
            this.gl.glDisable(3042);
            this.gl.glDepthMask(true);
        } else if (this.drawType == 0) {
            this.gl.glEnable(2884);
            this.gl.glPolygonMode(1032, 6914);
            this.gl.glDisable(3042);
        }
        this.gl.glPopMatrix();
        this.gl.glEndList();
    }

    private void generateBallDlist() {
        UniformSphere ball = Renderer.spheres.getUniformSphere(this.precision, this.radius);
        ball.generateRendererDisplayList(this.ballDlist, this.gl);
    }

    private void setBoundingBox() {
        float e = 2.0f;
        this.boundingBox.setMin((float)this.x - e, (float)this.y - e, (float)this.z - e);
        this.boundingBox.setMax((float)this.x + e, (float)this.y + e, (float)this.z + e);
        this.boundingBox.ready();
    }

    @Override
    protected void pickObject(int offset, double[] maxZ, float[] modelview) {
        if (this.isVisible()) {
            int aIdx = GeomCalc.newVector((float)this.x, (float)this.y, (float)this.z);
            GeomCalc.multVectorWithMatrix(aIdx, modelview);
            this.pickedItem = new ComponentElement((GraphicComponent)this, 1, this.selectBuf.get(offset));
            maxZ[0] = GeomCalc.getZ(aIdx);
            GeomCalc.deleteVector(aIdx);
        }
    }

    public void setDrawType(String type) {
        int id = ArrayTools.indexInArray(DRAW_TYPES, type);
        if (id != -1) {
            this.drawType = DRAW_TYPE_VALUES[id];
            this.needRecreateDisplayList = true;
        }
    }

    public String getDrawType() {
        return DRAW_TYPES[this.drawType];
    }

    public boolean isAcceptor() {
        return (this.pharmacophoreType & 1) != 0;
    }

    public void setAcceptor(boolean flag) {
        this.setType(1, flag);
        this.setColor();
        this.needRecreateDisplayList = true;
    }

    public boolean isDonor() {
        return (this.pharmacophoreType & 2) != 0;
    }

    public void setDonor(boolean flag) {
        this.setType(2, flag);
        this.setColor();
        this.needRecreateDisplayList = true;
    }

    public boolean isHydrophobic() {
        return (this.pharmacophoreType & 0x10) != 0;
    }

    public void setHydrophobic(boolean flag) {
        this.setType(16, flag);
        this.setColor();
        this.needRecreateDisplayList = true;
    }

    public boolean isAromatic() {
        return (this.pharmacophoreType & 0x20) != 0;
    }

    public void setAromatic(boolean flag) {
        this.setType(32, flag);
        this.setColor();
        this.needRecreateDisplayList = true;
    }

    public boolean isAnionic() {
        return (this.pharmacophoreType & 4) != 0;
    }

    public void setAnionic(boolean flag) {
        this.setType(4, flag);
        this.setColor();
        this.needRecreateDisplayList = true;
    }

    public boolean isCationic() {
        return (this.pharmacophoreType & 8) != 0;
    }

    public void setCationic(boolean flag) {
        this.setType(8, flag);
        this.setColor();
        this.needRecreateDisplayList = true;
    }

    public boolean isExcluded() {
        return (this.pharmacophoreType & 0x1000) != 0;
    }

    public void setExcluded(boolean flag) {
        this.setType(4096, flag);
        this.setColor();
        this.needRecreateDisplayList = true;
    }

    private void setType(int type, boolean flag) {
        this.pharmacophoreType = flag ? (this.pharmacophoreType |= type) : (this.pharmacophoreType &= ~type);
    }

    public void setRenderingQuality(String quality) {
        if (quality.equalsIgnoreCase("medium") && this.renderingQuality != 2) {
            this.setRenderingQuality(2);
        } else if (quality.equalsIgnoreCase("high") && this.renderingQuality != 3) {
            this.setRenderingQuality(3);
        } else if (quality.equalsIgnoreCase("low") && this.renderingQuality != 1) {
            this.setRenderingQuality(1);
        }
    }

    @Override
    public void setRenderingQuality(int quality) {
        if (this.renderingQuality == quality) {
            return;
        }
        this.renderingQuality = quality;
        if (quality == 3) {
            this.precision = 5;
        } else if (quality == 2) {
            this.precision = 4;
        } else if (quality == 1) {
            this.precision = 3;
        }
        this.needRecreateBall = true;
    }

    @Override
    public void setDrawProperty(String propertyName, String propertyValue) {
        if (propertyName.equals("Quality")) {
            this.setDrawProperty("PharmacophorePoint.Quality", propertyValue);
            return;
        }
        if (!propertyName.startsWith("PharmacophorePoint")) {
            return;
        }
        this.storeDrawProperty(propertyName, propertyValue);
        if (propertyName.equalsIgnoreCase("PharmacophorePoint.DrawType")) {
            this.setDrawType(propertyValue);
        } else if (propertyName.equalsIgnoreCase("PharmacophorePoint.Quality")) {
            this.setRenderingQuality(propertyValue);
        } else if (propertyName.equalsIgnoreCase("PharmacophorePoint.Acceptor")) {
            this.setAcceptor(Boolean.valueOf(propertyValue));
        } else if (propertyName.equalsIgnoreCase("PharmacophorePoint.Donor")) {
            this.setDonor(Boolean.valueOf(propertyValue));
        } else if (propertyName.equalsIgnoreCase("PharmacophorePoint.Hydrophobic")) {
            this.setHydrophobic(Boolean.valueOf(propertyValue));
        } else if (propertyName.equalsIgnoreCase("PharmacophorePoint.Aromatic")) {
            this.setAromatic(Boolean.valueOf(propertyValue));
        } else if (propertyName.equalsIgnoreCase("PharmacophorePoint.Anionic")) {
            this.setAnionic(Boolean.valueOf(propertyValue));
        } else if (propertyName.equalsIgnoreCase("PharmacophorePoint.Cationic")) {
            this.setCationic(Boolean.valueOf(propertyValue));
        } else if (propertyName.equalsIgnoreCase("PharmacophorePoint.Excluded")) {
            this.setExcluded(Boolean.valueOf(propertyValue));
        }
    }
}

