/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.space;

import chemaxon.common.util.GeomCalc;
import chemaxon.marvin.space.Colors;
import chemaxon.marvin.space.ComponentElement;
import chemaxon.marvin.space.GraphicComponent;
import chemaxon.marvin.space.RibbonBSpline;
import chemaxon.marvin.space.SecondaryStructureComponent;
import chemaxon.marvin.space.render.Box;
import chemaxon.marvin.space.render.Cylinder;
import chemaxon.marvin.space.render.Disk;
import chemaxon.marvin.space.render.Renderer;
import chemaxon.marvin.space.render.Sphere;
import chemaxon.marvin.space.util.Palette;
import chemaxon.marvin.space.util.SecondaryStructureDetection;
import chemaxon.struc.MacroMolecule;
import chemaxon.struc.MoleculeIterators;
import java.awt.Color;
import java.util.ArrayList;
import javax.media.opengl.GL;
import javax.media.opengl.glu.GLU;

public class RibbonVisualizer {
    public static final int HELIX = 2;
    public static final int SHEET = 3;
    public static final int TURN = 1;
    public static final int COIL = 0;
    public static final int NUCLEIC = 4;
    public static final int DRAWTYPE_NONE = 0;
    public static final int DRAWTYPE_WIRE = 1;
    public static final int DRAWTYPE_TRACE = 2;
    public static final int DRAWTYPE_TUBE = 3;
    public static final int DRAWTYPE_PIPE_AND_PLANK = 4;
    public static final int DRAWTYPE_RIBBON_LINES = 5;
    public static final int DRAWTYPE_RIBBON_FLAT = 6;
    public static final int DRAWTYPE_CARTOON_SQUARE = 7;
    public static final int DRAWTYPE_CARTOON = 8;
    public static final float DEFAULT_HELIX_DEPTH = 0.3f;
    public static final float DEFAULT_SHEET_DEPTH = 0.4f;
    public static final float DEFAULT_COIL_DEPTH = 0.3f;
    public static final float DEFAULT_ARROW_TOP_WIDTH = 0.3f;
    public static final float DEFAULT_HELIX_ARROW_BASE_WIDTH = 3.8f;
    public static final float DEFAULT_SHEET_ARROW_BASE_WIDTH = 3.8f;
    public static final float DEFAULT_HELIX_WIDTH = 1.2f;
    public static final float DEFAULT_SHEET_WIDTH = 1.2f;
    public static final float DEFAULT_COIL_WIDTH = 0.3f;
    public static final int DEFAULT_THREADS = 6;
    public static final float DEFAULT_HELIX_SHIFT = 2.5f;
    public static final float BROKEN_CHAIN_THRESHOLD = 6.0f;
    public static final float BROKEN_CHAIN_THRESHOLD_NUCLEIC = 8.0f;
    public static int RAINBOW_MODE = 11;
    public static int B_FACTOR_MODE = 12;
    SecondaryStructureComponent ssc = null;
    MoleculeIterators.AtomPropertyInterface props;
    MacroMolecule.NucleicAcid.BackboneAtomIterator batoms = null;
    ComponentElement[] labels;
    private int backboneAtomCount;
    private int[] backboneAtoms;
    private int[] backboneOxygens;
    private int[] backboneAtomTypes;
    private int[] backboneAtomIndices;
    private ArrayList ribbonGeoms = new ArrayList();
    SupplementGeom supGeom = new SupplementGeom();
    int[] vb;
    int[] bh;
    private int quality = 2;
    private int drawType = 8;
    private Palette rainbowPalette = null;
    private int startIndex = 0;
    private Palette bfactorPalette = null;
    private int chainNumber;
    private int colorType = 5;
    private byte[] constantColor = new byte[]{127, 127, 127};
    private GL gl = null;
    private boolean initialised = false;
    int dlist = 0;

    public RibbonVisualizer(MacroMolecule.Protein p, SecondaryStructureComponent ssc) {
        this.ssc = ssc;
        this.props = p.getAtomProperty();
        MacroMolecule.Protein.CAlphaAtomIterator catoms = p.getCAlphaAtomIterator();
        boolean detection = true;
        this.backboneAtomCount = catoms.getCaCoCount();
        if (this.backboneAtomCount == 0) {
            return;
        }
        this.backboneAtoms = new int[this.backboneAtomCount];
        this.backboneOxygens = new int[this.backboneAtomCount];
        this.backboneAtomTypes = new int[this.backboneAtomCount];
        this.backboneAtomIndices = new int[this.backboneAtomCount];
        catoms.reset();
        while (catoms.hasNext()) {
            if (catoms.getSecondaryStructureType() != 0) {
                detection = false;
                break;
            }
            catoms.next();
        }
        if (detection) {
            System.out.println("MarvinSpace is detecting secondary structure.");
            SecondaryStructureDetection sd = new SecondaryStructureDetection();
            int[] bbat = sd.detectSecondaryStructure(p);
            System.arraycopy(bbat, 0, this.backboneAtomTypes, 0, bbat.length);
        }
        int i = 0;
        int chainStart = 0;
        catoms.reset();
        while (catoms.hasNext()) {
            int co;
            if (catoms.getX() != Float.POSITIVE_INFINITY && (co = catoms.getCarbonylOxygen()) != -1) {
                this.backboneAtoms[i] = GeomCalc.newVector(catoms.getX(), catoms.getY(), catoms.getZ());
                this.backboneOxygens[i] = GeomCalc.newVector(this.props.getX(co), this.props.getY(co), this.props.getZ(co));
                if (!detection) {
                    this.backboneAtomTypes[i] = catoms.getSecondaryStructureType();
                }
                this.backboneAtomIndices[i] = catoms.current();
                if (i > 0 && GeomCalc.distance(this.backboneAtoms[i - 1], this.backboneAtoms[i]) > 6.0) {
                    if (i - chainStart > 3) {
                        this.ribbonGeoms.add(new RibbonGeom(false, chainStart, i - 1));
                    }
                    chainStart = i;
                }
                ++i;
            }
            catoms.next();
        }
        if (this.backboneAtomCount - chainStart > 3) {
            this.ribbonGeoms.add(new RibbonGeom(false, chainStart, this.backboneAtomCount - 1));
        }
        this.createLabelInformation(p);
    }

    public RibbonVisualizer(MacroMolecule.NucleicAcid p, SecondaryStructureComponent ssc) {
        this.ssc = ssc;
        this.props = p.getAtomProperty();
        this.batoms = p.getBackboneAtomIterator();
        this.backboneAtomCount = this.batoms.getCount();
        this.backboneAtoms = new int[this.backboneAtomCount];
        this.backboneAtomTypes = new int[this.backboneAtomCount];
        this.backboneAtomIndices = new int[this.backboneAtomCount];
        this.initNucleicGuides();
        int i = 0;
        int chainStart = 0;
        this.batoms.reset();
        while (this.batoms.hasNext()) {
            this.backboneAtoms[i] = GeomCalc.newVector(this.batoms.getX(), this.batoms.getY(), this.batoms.getZ());
            this.backboneAtomTypes[i] = this.batoms.getSecondaryStructureType();
            this.backboneAtomIndices[i] = this.batoms.current();
            if (i > 0 && GeomCalc.distance(this.backboneAtoms[i - 1], this.backboneAtoms[i]) > 8.0) {
                this.ribbonGeoms.add(new RibbonGeom(true, chainStart, i - 1));
                chainStart = i;
            }
            this.batoms.next();
            ++i;
        }
        this.ribbonGeoms.add(new RibbonGeom(true, chainStart, this.backboneAtomCount - 1));
        this.createLabelInformation(p);
    }

    public ComponentElement[] getLabelInformation(String labelType) {
        if (labelType.equalsIgnoreCase("SecondaryStructure")) {
            return this.labels;
        }
        return new ComponentElement[0];
    }

    private void createLabelInformation(MacroMolecule.Protein protein) {
        ComponentElement[] ce = new ComponentElement[this.backboneAtomCount];
        int i = 0;
        MacroMolecule.Protein.HelixIterator hi = protein.getHelixIterator();
        while (hi.hasNext()) {
            MacroMolecule.Protein.Helix h = hi.next();
            MacroMolecule.Protein.CAlphaAtomIterator ha = h.getCAlphaAtomIterator();
            ha.reset();
            ce[i] = new ComponentElement((GraphicComponent)this.ssc, 1, 0);
            ce[i].setDescription(h.getLabel());
            ce[i].setCoordinates(new float[]{ha.getX(), ha.getY(), ha.getZ()});
            byte[] c = Colors.getSecondaryTypeColor(2);
            ce[i].setColor(new Color(c[0] * 2, c[1] * 2, c[2] * 2));
            ++i;
        }
        MacroMolecule.Protein.SheetIterator si = protein.getSheetIterator();
        while (si.hasNext()) {
            MacroMolecule.Protein.Sheet s = si.next();
            MacroMolecule.Protein.CAlphaAtomIterator sa = s.getCAlphaAtomIterator();
            sa.reset();
            ce[i] = new ComponentElement((GraphicComponent)this.ssc, 1, 0);
            ce[i].setDescription(s.getLabel());
            ce[i].setCoordinates(new float[]{sa.getX(), sa.getY(), sa.getZ()});
            byte[] c = Colors.getSecondaryTypeColor(3);
            ce[i].setColor(new Color(c[0] * 2, c[1] * 2, c[2] * 2));
            ++i;
        }
        this.labels = new ComponentElement[i];
        System.arraycopy(ce, 0, this.labels, 0, i);
    }

    private void createLabelInformation(MacroMolecule.NucleicAcid nucleic) {
        this.labels = new ComponentElement[1];
        this.labels[0] = new ComponentElement((GraphicComponent)this.ssc, 1, 0);
        this.labels[0].setDescription(nucleic.getName());
        this.labels[0].setCoordinates(GeomCalc.getFloatVector(this.backboneAtoms[0]));
        byte[] c = Colors.getSecondaryTypeColor(4);
        this.labels[0].setColor(new Color(c[0] * 2, c[1] * 2, c[2] * 2));
    }

    private void initNucleicGuides() {
        this.vb = new int[this.backboneAtomCount];
        this.bh = new int[this.backboneAtomCount];
        int i = 0;
        this.batoms.reset();
        while (this.batoms.hasNext()) {
            int n9 = this.batoms.getAtom("N9");
            int n1 = this.batoms.getAtom("N1");
            int p1 = n9 == -1 ? GeomCalc.newVector(this.props.getX(n1), this.props.getY(n1), this.props.getZ(n1)) : GeomCalc.newVector(this.props.getX(n9), this.props.getY(n9), this.props.getZ(n9));
            int c8 = this.batoms.getAtom("C8");
            int c2 = this.batoms.getAtom("C2");
            int p2 = c8 == -1 ? GeomCalc.newVector(this.props.getX(c2), this.props.getY(c2), this.props.getZ(c2)) : GeomCalc.newVector(this.props.getX(c8), this.props.getY(c8), this.props.getZ(c8));
            int n7 = this.batoms.getAtom("N7");
            int n3 = this.batoms.getAtom("N3");
            int p3 = n7 == -1 ? GeomCalc.newVector(this.props.getX(n3), this.props.getY(n3), this.props.getZ(n3)) : GeomCalc.newVector(this.props.getX(n7), this.props.getY(n7), this.props.getZ(n7));
            this.bh[i] = n9 == -1 ? GeomCalc.newVector(this.props.getX(n1), this.props.getY(n1), this.props.getZ(n1)) : GeomCalc.newVector(this.props.getX(n3), this.props.getY(n3), this.props.getZ(n3));
            GeomCalc.decrease(p3, p1);
            GeomCalc.decrease(p2, p1);
            int a = GeomCalc.cross(p3, p2);
            GeomCalc.normalize(a);
            this.vb[i] = a;
            GeomCalc.deleteVector(p1);
            GeomCalc.deleteVector(p2);
            GeomCalc.deleteVector(p3);
            this.batoms.next();
            ++i;
        }
    }

    public void onRemove() {
        int i;
        for (i = 0; i < this.backboneAtoms.length; ++i) {
            GeomCalc.deleteVector(this.backboneAtoms[i]);
        }
        if (this.backboneOxygens != null) {
            for (i = 0; i < this.backboneOxygens.length; ++i) {
                GeomCalc.deleteVector(this.backboneOxygens[i]);
            }
            this.backboneOxygens = null;
        }
        if (this.ribbonGeoms != null) {
            for (i = 0; i < this.ribbonGeoms.size(); ++i) {
                ((RibbonGeom)this.ribbonGeoms.get(i)).onRemove();
            }
            this.ribbonGeoms.clear();
        }
        this.backboneAtoms = null;
        this.backboneAtomTypes = null;
        this.backboneAtomIndices = null;
        this.rainbowPalette = null;
        this.bfactorPalette = null;
        this.constantColor = null;
        this.ssc = null;
        this.props = null;
    }

    public void refresh() {
        this.initialised = false;
    }

    public void setGL(GL gl, GLU glu) {
        this.gl = gl;
    }

    public void setColorType(int t) {
        if (this.colorType == t) {
            return;
        }
        this.colorType = t;
        this.initialised = false;
    }

    public void setConstantColor(byte r, byte g, byte b) {
        this.constantColor[0] = r;
        this.constantColor[1] = g;
        this.constantColor[2] = b;
        this.initialised = false;
    }

    public void setDrawType(int t) {
        if (this.drawType == t) {
            return;
        }
        this.drawType = t;
        if (this.drawType == 0) {
            return;
        }
        for (int i = 0; i < this.ribbonGeoms.size(); ++i) {
            ((RibbonGeom)this.ribbonGeoms.get(i)).setDrawType(t);
        }
        this.initialised = false;
    }

    public void setQuality(int q) {
        if (this.quality == q) {
            return;
        }
        this.quality = q;
        if (this.drawType == 0) {
            return;
        }
        for (int i = 0; i < this.ribbonGeoms.size(); ++i) {
            ((RibbonGeom)this.ribbonGeoms.get(i)).setQuality(q);
        }
        this.supGeom.qualityChanged();
        this.initialised = false;
    }

    public void setHelixWidth(float v) {
        for (int i = 0; i < this.ribbonGeoms.size(); ++i) {
            ((RibbonGeom)this.ribbonGeoms.get(i)).setHelixWidth(v);
        }
        this.initialised = false;
    }

    public void setHelixDepth(float v) {
        for (int i = 0; i < this.ribbonGeoms.size(); ++i) {
            ((RibbonGeom)this.ribbonGeoms.get(i)).setHelixDepth(v);
        }
        this.initialised = false;
    }

    public void setHelixShift(float v) {
        for (int i = 0; i < this.ribbonGeoms.size(); ++i) {
            ((RibbonGeom)this.ribbonGeoms.get(i)).setHelixShift(v);
        }
        this.initialised = false;
    }

    public void setHelixArrow(boolean draw) {
        for (int i = 0; i < this.ribbonGeoms.size(); ++i) {
            ((RibbonGeom)this.ribbonGeoms.get(i)).setHelixArrow(draw);
        }
        this.initialised = false;
    }

    public void setHelixArrowWidth(float v) {
        for (int i = 0; i < this.ribbonGeoms.size(); ++i) {
            ((RibbonGeom)this.ribbonGeoms.get(i)).setHelixArrowWidth(v);
        }
        this.initialised = false;
    }

    public void setSheetWidth(float v) {
        for (int i = 0; i < this.ribbonGeoms.size(); ++i) {
            ((RibbonGeom)this.ribbonGeoms.get(i)).setSheetWidth(v);
        }
        this.initialised = false;
    }

    public void setSheetDepth(float v) {
        for (int i = 0; i < this.ribbonGeoms.size(); ++i) {
            ((RibbonGeom)this.ribbonGeoms.get(i)).setSheetDepth(v);
        }
        this.initialised = false;
    }

    public void setSheetArrow(boolean draw) {
        for (int i = 0; i < this.ribbonGeoms.size(); ++i) {
            ((RibbonGeom)this.ribbonGeoms.get(i)).setSheetArrow(draw);
        }
        this.initialised = false;
    }

    public void setSheetArrowWidth(float v) {
        for (int i = 0; i < this.ribbonGeoms.size(); ++i) {
            ((RibbonGeom)this.ribbonGeoms.get(i)).setSheetArrowWidth(v);
        }
        this.initialised = false;
    }

    public void setCoilWidth(float v) {
        for (int i = 0; i < this.ribbonGeoms.size(); ++i) {
            ((RibbonGeom)this.ribbonGeoms.get(i)).setCoilWidth(v);
        }
        this.initialised = false;
    }

    public void setCoilDepth(float v) {
        for (int i = 0; i < this.ribbonGeoms.size(); ++i) {
            ((RibbonGeom)this.ribbonGeoms.get(i)).setCoilDepth(v);
        }
        this.initialised = false;
    }

    public void setCoilUniform(boolean cu) {
        for (int i = 0; i < this.ribbonGeoms.size(); ++i) {
            ((RibbonGeom)this.ribbonGeoms.get(i)).setCoilUniform(cu);
        }
        this.initialised = false;
    }

    public void setThreads(int nt) {
        for (int i = 0; i < this.ribbonGeoms.size(); ++i) {
            ((RibbonGeom)this.ribbonGeoms.get(i)).setThreads(nt);
        }
        this.initialised = false;
    }

    public void setChainNumber(int c) {
        this.chainNumber = c;
    }

    public void setRainbowPalette(int startIndex, Palette pal) {
        this.rainbowPalette = pal;
        this.startIndex = startIndex;
    }

    public void setBFactorPalette(Palette pal) {
        this.bfactorPalette = pal;
    }

    public void draw() {
        if (this.drawType == 0) {
            return;
        }
        if (!this.initialised) {
            if (this.dlist == 0) {
                this.dlist = this.gl.glGenLists(1);
            }
            this.supGeom.generate();
            this.generate();
            this.initialised = true;
        }
        this.gl.glCallList(this.dlist);
    }

    private void generate() {
        this.gl.glNewList(this.dlist, 4864);
        this.gl.glDisable(2884);
        this.gl.glColor3bv(this.constantColor, 0);
        if (this.drawType == 1) {
            this.drawWireTrace();
        } else if (this.drawType == 5) {
            for (int i = 0; i < this.ribbonGeoms.size(); ++i) {
                this.drawRibbonLines((RibbonGeom)this.ribbonGeoms.get(i), ((RibbonGeom)this.ribbonGeoms.get((int)i)).nt);
            }
        } else if (this.drawType == 6) {
            for (int i = 0; i < this.ribbonGeoms.size(); ++i) {
                this.drawRibbonFlat((RibbonGeom)this.ribbonGeoms.get(i), ((RibbonGeom)this.ribbonGeoms.get((int)i)).nt);
            }
        } else {
            this.gl.glMaterialfv(1032, 4608, Colors.lightgrayF, 0);
            this.gl.glMaterialfv(1032, 4610, Colors.whiteF, 0);
            this.gl.glMaterialf(1032, 5633, 80.0f);
            if (this.drawType == 7) {
                for (int i = 0; i < this.ribbonGeoms.size(); ++i) {
                    this.drawRibbonSquare((RibbonGeom)this.ribbonGeoms.get(i), 4);
                    this.drawRibbonLines((RibbonGeom)this.ribbonGeoms.get(i), 4);
                }
            } else if (this.drawType == 8 || this.drawType == 3 || this.drawType == 4) {
                for (int i = 0; i < this.ribbonGeoms.size(); ++i) {
                    this.drawRibbonSquare((RibbonGeom)this.ribbonGeoms.get(i), 2 * ((RibbonGeom)this.ribbonGeoms.get((int)i)).nt);
                }
            }
            if (this.drawType == 2 || this.drawType == 4) {
                this.supGeom.draw();
            }
            this.gl.glMaterialfv(1032, 4608, Colors.grayF, 0);
            this.gl.glMaterialfv(1032, 4610, Colors.grayF, 0);
            this.gl.glMaterialf(1032, 5633, 100.0f);
        }
        this.gl.glEnable(2884);
        this.gl.glEndList();
    }

    private void setColor(int i) {
        if (this.colorType == 4) {
            this.gl.glColor3bv(Colors.getChainColor(this.chainNumber), 0);
        } else if (this.colorType == 3) {
            this.gl.glColor3bv(Colors.getResidueByteColor(this.props.getResidueTypeId(this.backboneAtomIndices[i])), 0);
        } else if (this.colorType == 5) {
            this.gl.glColor3bv(Colors.getSecondaryTypeColor(this.backboneAtomTypes[i]), 0);
        } else if (this.colorType == B_FACTOR_MODE) {
            this.gl.glColor3bv(this.bfactorPalette.getByteColor(this.props.getBFactor(this.backboneAtomIndices[i])), 0);
        }
    }

    private void setRainbowColor(float i) {
        this.gl.glColor3bv(this.rainbowPalette.getByteColor((float)this.startIndex + i), 0);
    }

    private void setBFactorColor(int i, float t) {
        float f1 = this.props.getBFactor(this.backboneAtomIndices[i]);
        float f2 = i == this.backboneAtomCount - 1 ? this.props.getBFactor(this.backboneAtomIndices[i]) : this.props.getBFactor(this.backboneAtomIndices[i + 1]);
        this.gl.glColor3bv(this.bfactorPalette.getByteColor((1.0f - t) * f1 + t * f2), 0);
    }

    private void setCAlphaColor(int i) {
        if (this.colorType == RAINBOW_MODE) {
            this.setRainbowColor(i);
        } else if (this.colorType == B_FACTOR_MODE) {
            this.setColor(i);
        } else {
            this.setColor(i);
        }
    }

    private void setVertexColor(int i, float v) {
        if (this.colorType == B_FACTOR_MODE) {
            this.setBFactorColor(i, v);
        } else if (this.colorType == RAINBOW_MODE) {
            this.setRainbowColor((float)i + v);
        }
    }

    private void drawRibbonLines(RibbonGeom ribbonGeom, int nt) {
        this.gl.glDisable(2896);
        this.gl.glEnable(3042);
        this.gl.glLineWidth(2.0f);
        int[][][] xv = ribbonGeom.glv;
        for (int i = 0; i < ribbonGeom.ribbonAtomCount; ++i) {
            if (this.drawType == 4 && this.backboneAtomTypes[i] != 0) continue;
            int ns = ribbonGeom.getSample(i);
            this.setCAlphaColor(ribbonGeom.startIndex + i);
            for (int j = 0; j < nt; ++j) {
                this.gl.glBegin(3);
                for (int k = 0; k < ns + 1; ++k) {
                    if (this.quality != 1) {
                        this.setVertexColor(ribbonGeom.startIndex + i, (float)k / (float)ns);
                    }
                    this.gl.glVertex3fv(GeomCalc.getFloatVector(xv[i][j][k]), 0);
                }
                this.gl.glEnd();
            }
        }
        this.gl.glDisable(3042);
        this.gl.glEnable(2896);
    }

    private void drawRibbonFlat(RibbonGeom ribbonGeom, int nt) {
        int ns;
        int i;
        int[][][] xv = ribbonGeom.glv;
        int[][][] xn = ribbonGeom.gnv;
        for (i = 0; i < ribbonGeom.ribbonAtomCount; ++i) {
            if (this.drawType == 4 && this.backboneAtomTypes[i] != 0) continue;
            ns = ribbonGeom.getSample(i);
            this.setCAlphaColor(ribbonGeom.startIndex + i);
            for (int j = 0; j < nt - 1; ++j) {
                this.gl.glBegin(8);
                for (int k = 0; k < ns + 1; ++k) {
                    if (this.quality != 1) {
                        this.setVertexColor(ribbonGeom.startIndex + i, (float)k / (float)ns);
                    }
                    this.gl.glNormal3fv(GeomCalc.getFloatVector(xn[i][j][k]), 0);
                    this.gl.glVertex3fv(GeomCalc.getFloatVector(xv[i][j][k]), 0);
                    this.gl.glNormal3fv(GeomCalc.getFloatVector(xn[i][j + 1][k]), 0);
                    this.gl.glVertex3fv(GeomCalc.getFloatVector(xv[i][j + 1][k]), 0);
                }
                this.gl.glEnd();
            }
        }
        this.gl.glDisable(2896);
        this.gl.glEnable(3042);
        for (i = 0; i < ribbonGeom.ribbonAtomCount; ++i) {
            ns = ribbonGeom.getSample(i);
            this.setCAlphaColor(ribbonGeom.startIndex + i);
            this.gl.glBegin(1);
            for (int k = 0; k < ns; ++k) {
                if (this.quality != 1) {
                    this.setVertexColor(ribbonGeom.startIndex + i, (float)k / (float)ns);
                }
                this.gl.glNormal3fv(GeomCalc.getFloatVector(xn[i][0][k]), 0);
                this.gl.glVertex3fv(GeomCalc.getFloatVector(xv[i][0][k]), 0);
                this.gl.glNormal3fv(GeomCalc.getFloatVector(xn[i][0][k + 1]), 0);
                this.gl.glVertex3fv(GeomCalc.getFloatVector(xv[i][0][k + 1]), 0);
                this.gl.glNormal3fv(GeomCalc.getFloatVector(xn[i][nt - 1][k]), 0);
                this.gl.glVertex3fv(GeomCalc.getFloatVector(xv[i][nt - 1][k]), 0);
                this.gl.glNormal3fv(GeomCalc.getFloatVector(xn[i][nt - 1][k + 1]), 0);
                this.gl.glVertex3fv(GeomCalc.getFloatVector(xv[i][nt - 1][k + 1]), 0);
            }
            this.gl.glEnd();
        }
        this.gl.glDisable(3042);
        this.gl.glEnable(2896);
    }

    private void drawRibbonSquare(RibbonGeom ribbonGeom, int nt) {
        int[][][] xv = ribbonGeom.glv;
        int[][][] xn = ribbonGeom.gnv;
        for (int i = 0; i < ribbonGeom.ribbonAtomCount; ++i) {
            if (this.drawType == 4 && this.backboneAtomTypes[i] != 0 && this.backboneAtomTypes[i] != 1) {
                int j;
                for (j = i; j < ribbonGeom.ribbonAtomCount && this.backboneAtomTypes[j] == this.backboneAtomTypes[i]; ++j) {
                }
                int xvi = i == 0 ? 0 : i - 1;
                int nsi = ribbonGeom.getSample(xvi);
                int nsj = ribbonGeom.getSample(--j);
                this.supGeom.drawPipeOrPlank(xv[xvi][nt - 1][nsi], xv[j][nt - 1][nsj], i, j, this.backboneAtomTypes[i] == 2);
                i = j;
                continue;
            }
            int ns = ribbonGeom.getSample(i);
            this.setCAlphaColor(ribbonGeom.startIndex + i);
            for (int i1 = 0; i1 < nt; ++i1) {
                int i2 = (i1 + 1) % nt;
                this.gl.glBegin(8);
                for (int k = 0; k < ns + 1; ++k) {
                    if (this.quality != 1) {
                        this.setVertexColor(ribbonGeom.startIndex + i, (float)k / (float)ns);
                    }
                    this.gl.glNormal3fv(GeomCalc.getFloatVector(xn[i][i1][k]), 0);
                    this.gl.glVertex3fv(GeomCalc.getFloatVector(xv[i][i1][k]), 0);
                    this.gl.glNormal3fv(GeomCalc.getFloatVector(xn[i][i2][k]), 0);
                    this.gl.glVertex3fv(GeomCalc.getFloatVector(xv[i][i2][k]), 0);
                }
                this.gl.glEnd();
            }
        }
    }

    private void drawWireTrace() {
        this.gl.glDisable(2896);
        this.gl.glEnable(3042);
        this.gl.glLineWidth(2.0f);
        this.gl.glColor3bv(this.constantColor, 0);
        this.gl.glBegin(3);
        for (int i = 0; i < this.backboneAtomCount; ++i) {
            if (this.colorType != 2) {
                this.setCAlphaColor(i);
            }
            this.gl.glVertex3fv(GeomCalc.getVector(this.backboneAtoms[i]), 0);
        }
        this.gl.glEnd();
        this.gl.glDisable(3042);
        this.gl.glEnable(2896);
    }

    public class SupplementGeom {
        protected static final int DEFAULT_STACK_PRECISION = 1;
        protected static final double DEFAULT_TRACE_RADIUS = 0.2;
        protected static final int DEFAULT_H_TR_SLICE_PRECISION = 10;
        protected static final int DEFAULT_M_TR_SLICE_PRECISION = 8;
        protected static final int DEFAULT_L_TR_SLICE_PRECISION = 6;
        protected static final int DEFAULT_H_TR_JOINT_PRECISION = 12;
        protected static final int DEFAULT_M_TR_JOINT_PRECISION = 10;
        protected static final int DEFAULT_L_TR_JOINT_PRECISION = 8;
        protected static final double DEFAULT_PLANK_WIDTH = 2.0;
        protected static final double DEFAULT_PLANK_THICKNESS = 1.0;
        protected static final double DEFAULT_PIPE_RADIUS = 2.0;
        protected static final int DEFAULT_H_PIPE_SLICE_PRECISION = 20;
        protected static final int DEFAULT_M_PIPE_SLICE_PRECISION = 14;
        protected static final int DEFAULT_L_PIPE_SLICE_PRECISION = 8;
        protected Sphere traceJoint = null;
        protected int traceJointDlist = -1;
        protected int traceOneJointDlist = -1;
        protected int traceJointPrecision = 10;
        protected double traceJointRadius = 0.195;
        protected Cylinder traceCylinder = null;
        protected int traceGlobalCylinderDlist = -1;
        protected int traceOneCylinderDlist = -1;
        protected double traceCylinderRadius = 0.2;
        protected int traceCylinderSlicePrecision = 8;
        protected int traceCylinderStackPrecision = 1;
        protected Box plankBox = null;
        protected int plankOneBoxDlist = -1;
        protected double plankWidth = 2.0;
        protected double plankThickness = 1.0;
        protected Cylinder pipeCylinder = null;
        protected int pipeOneCylinderList = -1;
        protected double pipeRadius = 2.0;
        protected int pipePrecision = 14;
        protected Disk pipeUpperDisk = null;
        protected Disk pipeLowerDisk = null;
        protected int pipeUpperDiskDlist = 0;
        protected int pipeLowerDiskDlist = 0;
        private boolean needRecreateTraceElementLists = true;
        private boolean needRecreateTraceLists = true;
        private boolean needRecreatePipeAndPlankLists = true;
        private boolean needRecreatePipe = true;

        public void generate() {
            if (RibbonVisualizer.this.drawType == 4) {
                if (this.pipeOneCylinderList == -1) {
                    this.plankOneBoxDlist = RibbonVisualizer.this.gl.glGenLists(1);
                    this.pipeOneCylinderList = RibbonVisualizer.this.gl.glGenLists(1);
                    this.pipeUpperDiskDlist = RibbonVisualizer.this.gl.glGenLists(1);
                    this.pipeLowerDiskDlist = RibbonVisualizer.this.gl.glGenLists(1);
                    this.generatePipe();
                    this.generatePlank();
                }
                if (this.needRecreatePipe) {
                    this.generatePipe();
                    this.needRecreatePipe = false;
                }
            } else if (RibbonVisualizer.this.drawType == 2) {
                if (this.traceGlobalCylinderDlist == -1) {
                    this.traceGlobalCylinderDlist = RibbonVisualizer.this.gl.glGenLists(1);
                    this.traceOneCylinderDlist = RibbonVisualizer.this.gl.glGenLists(1);
                    this.traceOneJointDlist = RibbonVisualizer.this.gl.glGenLists(1);
                    this.traceJointDlist = RibbonVisualizer.this.gl.glGenLists(1);
                }
                if (this.needRecreateTraceElementLists) {
                    this.generateTraceElementLists();
                    this.needRecreateTraceElementLists = false;
                }
                if (this.needRecreateTraceLists) {
                    this.generateTraceGlobalCylinderDlist();
                    this.generateTraceJointDlist();
                }
            }
        }

        public void draw() {
            if (RibbonVisualizer.this.drawType == 2) {
                RibbonVisualizer.this.gl.glCallList(this.traceGlobalCylinderDlist);
                RibbonVisualizer.this.gl.glCallList(this.traceJointDlist);
            }
        }

        public void qualityChanged() {
            if (RibbonVisualizer.this.quality == 2) {
                this.traceCylinderSlicePrecision = 8;
                this.traceJointPrecision = 10;
                this.pipePrecision = 14;
            } else if (RibbonVisualizer.this.quality == 3) {
                this.traceCylinderSlicePrecision = 10;
                this.traceJointPrecision = 12;
                this.pipePrecision = 20;
            } else if (RibbonVisualizer.this.quality == 1) {
                this.traceCylinderSlicePrecision = 6;
                this.traceJointPrecision = 8;
                this.pipePrecision = 8;
            }
            this.needRecreatePipe = true;
            this.needRecreateTraceElementLists = true;
        }

        private void generateTraceGlobalCylinderDlist() {
            float th = RibbonVisualizer.this.batoms == null ? 6.0f : 8.0f;
            RibbonVisualizer.this.gl.glNewList(this.traceGlobalCylinderDlist, 4864);
            RibbonVisualizer.this.gl.glColor3bv(RibbonVisualizer.this.constantColor, 0);
            for (int i = 1; i < RibbonVisualizer.this.backboneAtomCount; ++i) {
                RibbonVisualizer.this.setCAlphaColor(i);
                double dist = GeomCalc.distance(RibbonVisualizer.this.backboneAtoms[i], RibbonVisualizer.this.backboneAtoms[i - 1]);
                if (!(dist < (double)th)) continue;
                RibbonVisualizer.this.gl.glPushMatrix();
                this.glTransformYEToV(dist, RibbonVisualizer.this.backboneAtoms[i - 1], RibbonVisualizer.this.backboneAtoms[i]);
                RibbonVisualizer.this.gl.glCallList(this.traceOneCylinderDlist);
                RibbonVisualizer.this.gl.glPopMatrix();
            }
            RibbonVisualizer.this.gl.glEndList();
        }

        private void glTransformYEToV(double distance, int n1, int n2) {
            int directionVector = GeomCalc.sub(n2, n1);
            GeomCalc.normalize(directionVector);
            double angle = Math.acos(GeomCalc.getZ(directionVector)) * 180.0 / Math.PI;
            RibbonVisualizer.this.gl.glTranslated((double)GeomCalc.getX(n1), (double)GeomCalc.getY(n1), (double)GeomCalc.getZ(n1));
            RibbonVisualizer.this.gl.glRotated(angle, (double)(-GeomCalc.getY(directionVector)), (double)GeomCalc.getX(directionVector), 0.0);
            RibbonVisualizer.this.gl.glScaled(1.0, 1.0, distance);
            GeomCalc.deleteVector(directionVector);
        }

        private void generateTraceJointDlist() {
            RibbonVisualizer.this.gl.glNewList(this.traceJointDlist, 4864);
            RibbonVisualizer.this.gl.glColor3bv(RibbonVisualizer.this.constantColor, 0);
            for (int i = 0; i < RibbonVisualizer.this.backboneAtoms.length; ++i) {
                RibbonVisualizer.this.setCAlphaColor(i);
                RibbonVisualizer.this.gl.glPushMatrix();
                RibbonVisualizer.this.gl.glTranslatef(GeomCalc.getX(RibbonVisualizer.this.backboneAtoms[i]), GeomCalc.getY(RibbonVisualizer.this.backboneAtoms[i]), GeomCalc.getZ(RibbonVisualizer.this.backboneAtoms[i]));
                RibbonVisualizer.this.gl.glCallList(this.traceOneJointDlist);
                RibbonVisualizer.this.gl.glPopMatrix();
            }
            RibbonVisualizer.this.gl.glEndList();
        }

        private void generateTraceElementLists() {
            this.traceJoint = Renderer.spheres.getSphere(this.traceJointPrecision, this.traceJointRadius);
            this.traceJoint.generateRendererDisplayList(this.traceOneJointDlist, RibbonVisualizer.this.gl);
            this.traceCylinder = Renderer.cylinders.getCylinder(this.traceCylinderSlicePrecision, this.traceCylinderStackPrecision, this.traceCylinderRadius);
            this.traceCylinder.generateRendererDisplayList(this.traceOneCylinderDlist, RibbonVisualizer.this.gl);
        }

        private void generatePipe() {
            this.pipeCylinder = Renderer.cylinders.getCylinder(this.pipePrecision, 1, this.pipeRadius);
            this.pipeCylinder.generateRendererDisplayList(this.pipeOneCylinderList, RibbonVisualizer.this.gl);
            this.pipeUpperDisk = new Disk(this.pipeRadius, this.pipePrecision, true);
            this.pipeUpperDisk.create();
            this.pipeLowerDisk = new Disk(this.pipeRadius, this.pipePrecision, false);
            this.pipeLowerDisk.create();
            this.pipeUpperDisk.generateRendererDisplayList(this.pipeUpperDiskDlist, RibbonVisualizer.this.gl);
            this.pipeLowerDisk.generateRendererDisplayList(this.pipeLowerDiskDlist, RibbonVisualizer.this.gl);
        }

        private void drawPipeDisk(int n1, int n2, boolean upper) {
            int directionVector = GeomCalc.sub(n2, n1);
            GeomCalc.normalize(directionVector);
            double angle = Math.acos(GeomCalc.getZ(directionVector)) * 180.0 / Math.PI;
            if (!upper) {
                RibbonVisualizer.this.gl.glPushMatrix();
                RibbonVisualizer.this.gl.glTranslated((double)GeomCalc.getX(n1), (double)GeomCalc.getY(n1), (double)GeomCalc.getZ(n1));
                RibbonVisualizer.this.gl.glRotated(angle, (double)(-GeomCalc.getY(directionVector)), (double)GeomCalc.getX(directionVector), 0.0);
                RibbonVisualizer.this.gl.glCallList(this.pipeLowerDiskDlist);
                RibbonVisualizer.this.gl.glPopMatrix();
            } else {
                RibbonVisualizer.this.gl.glFrontFace(2304);
                RibbonVisualizer.this.gl.glPushMatrix();
                RibbonVisualizer.this.gl.glTranslated((double)GeomCalc.getX(n2), (double)GeomCalc.getY(n2), (double)GeomCalc.getZ(n2));
                RibbonVisualizer.this.gl.glRotated(angle, (double)(-GeomCalc.getY(directionVector)), (double)GeomCalc.getX(directionVector), 0.0);
                RibbonVisualizer.this.gl.glCallList(this.pipeUpperDiskDlist);
                RibbonVisualizer.this.gl.glPopMatrix();
                RibbonVisualizer.this.gl.glFrontFace(2305);
            }
            GeomCalc.deleteVector(directionVector);
        }

        private void generatePlank() {
            this.plankBox = new Box((float)this.plankWidth, (float)this.plankThickness, 1.0f, true);
            this.plankBox.create();
            RibbonVisualizer.this.gl.glNewList(this.plankOneBoxDlist, 4864);
            RibbonVisualizer.this.gl.glVertexPointer(3, 5126, 0, this.plankBox.getVertices().position(0));
            RibbonVisualizer.this.gl.glNormalPointer(5126, 0, this.plankBox.getNormals().position(0));
            RibbonVisualizer.this.gl.glDrawArrays(4, 0, this.plankBox.getVertexCount());
            RibbonVisualizer.this.gl.glEndList();
        }

        private void drawPipeOrPlank(int v1, int v2, int pStart, int pEnd, boolean pipe) {
            double dist = GeomCalc.distance(v1, v2);
            if (RibbonVisualizer.this.colorType == 3 || RibbonVisualizer.this.colorType == RAINBOW_MODE || RibbonVisualizer.this.colorType == B_FACTOR_MODE) {
                int directionVector = GeomCalc.sub(v2, v1);
                GeomCalc.normalize(directionVector);
                double angle = Math.acos(GeomCalc.getZ(directionVector)) * 180.0 / Math.PI;
                double distance = dist / (double)(pEnd - pStart + 1);
                int v = GeomCalc.newVector(v2);
                for (int i = pStart; i <= pEnd; ++i) {
                    if (RibbonVisualizer.this.colorType == RAINBOW_MODE) {
                        RibbonVisualizer.this.setRainbowColor(i);
                    } else {
                        RibbonVisualizer.this.setCAlphaColor(i);
                    }
                    if (pipe) {
                        if (i == pStart) {
                            this.drawPipeDisk(v1, v, false);
                        } else if (i == pEnd) {
                            this.drawPipeDisk(v1, v, true);
                        }
                    }
                    RibbonVisualizer.this.gl.glPushMatrix();
                    RibbonVisualizer.this.gl.glTranslated((double)GeomCalc.getX(v1), (double)GeomCalc.getY(v1), (double)GeomCalc.getZ(v1));
                    RibbonVisualizer.this.gl.glRotated(angle, (double)(-GeomCalc.getY(directionVector)), (double)GeomCalc.getX(directionVector), 0.0);
                    RibbonVisualizer.this.gl.glTranslated(0.0, 0.0, (double)(i - pStart) * distance);
                    RibbonVisualizer.this.gl.glScaled(1.0, 1.0, distance);
                    if (pipe) {
                        RibbonVisualizer.this.gl.glCallList(this.pipeOneCylinderList);
                    } else {
                        RibbonVisualizer.this.gl.glCallList(this.plankOneBoxDlist);
                    }
                    RibbonVisualizer.this.gl.glPopMatrix();
                }
                GeomCalc.deleteVector(v);
                GeomCalc.deleteVector(directionVector);
            } else {
                RibbonVisualizer.this.setCAlphaColor(pStart);
                RibbonVisualizer.this.gl.glPushMatrix();
                this.glTransformYEToV(dist, v1, v2);
                if (pipe) {
                    RibbonVisualizer.this.gl.glCallList(this.pipeOneCylinderList);
                } else {
                    RibbonVisualizer.this.gl.glCallList(this.plankOneBoxDlist);
                }
                RibbonVisualizer.this.gl.glPopMatrix();
                if (pipe) {
                    this.drawPipeDisk(v1, v2, true);
                    this.drawPipeDisk(v1, v2, false);
                }
            }
        }
    }

    public class RibbonGeom {
        public static final int LINE = 0;
        public static final int FLAT = 1;
        public static final int SQUARE = 2;
        public static final int CIRCLE = 3;
        public static final int ELLIPSE = 4;
        public static final int DEFAULT_H_HELIX_SAMPLE = 8;
        public static final int DEFAULT_H_SHEET_SAMPLE = 4;
        public static final int DEFAULT_H_COIL_SAMPLE = 5;
        public static final int DEFAULT_H_THREAD = 6;
        public static final int DEFAULT_M_HELIX_SAMPLE = 6;
        public static final int DEFAULT_M_SHEET_SAMPLE = 3;
        public static final int DEFAULT_M_COIL_SAMPLE = 3;
        public static final int DEFAULT_M_THREAD = 5;
        public static final int DEFAULT_L_HELIX_SAMPLE = 3;
        public static final int DEFAULT_L_SHEET_SAMPLE = 3;
        public static final int DEFAULT_L_COIL_SAMPLE = 3;
        public static final int DEFAULT_L_THREAD = 2;
        public static final int MAX_THREADS = 10;
        public static final int MAX_SAMPLE = 13;
        private float helixWidth = 1.2f;
        private float sheetWidth = 1.2f;
        private float coilWidth = 0.3f;
        private float helixShift = 2.5f;
        int[] p;
        int[] q;
        int nt = 6;
        int ns = 6;
        int hs = 6;
        int ss = 3;
        int cs = 3;
        float hd = 0.3f;
        float sd = 0.4f;
        float cd = 0.3f;
        float hatw = 0.3f;
        float habw = 3.8f;
        float sabw = 3.8f;
        int[][][] gpv;
        int[][][] glv;
        int[][][] gnv;
        int[][] bsv;
        int style = 3;
        float[] ca4 = new float[]{-0.707f, 0.707f, 0.707f, -0.707f};
        float[] sa4 = new float[]{0.707f, 0.707f, -0.707f, -0.707f};
        float[] sa = new float[22];
        float[] ca = new float[22];
        boolean drawHelixArrow = true;
        boolean drawSheetArrow = true;
        boolean uniformCoil = true;
        boolean nucleicAcid = false;
        int startIndex;
        int endIndex;
        int ribbonAtomCount;
        boolean tubeMode = false;
        boolean coilOnlyMode = false;

        public RibbonGeom() {
            this(false);
        }

        public RibbonGeom(boolean nucleicAcid) {
            this(nucleicAcid, 0, ribbonVisualizer.backboneAtomCount - 1);
        }

        public RibbonGeom(boolean nucleicAcid, int start, int end) {
            this.nucleicAcid = nucleicAcid;
            this.startIndex = start;
            this.endIndex = end;
            this.ribbonAtomCount = this.endIndex - this.startIndex + 1;
            this.p = new int[this.ribbonAtomCount + 3];
            this.q = new int[this.ribbonAtomCount + 3];
            if (nucleicAcid) {
                this.computeNucleicAcidGuideCoordinates();
            } else {
                this.computeGuideCoordinates();
            }
            this.initArrays();
            this.computeRibbonSpaceCurve();
        }

        protected void onRemove() {
            for (int i = 0; i < this.p.length; ++i) {
                GeomCalc.deleteVector(this.p[i]);
                GeomCalc.deleteVector(this.q[i]);
            }
            this.clearArrays();
            this.p = null;
            this.q = null;
            this.glv = null;
            this.gnv = null;
            this.gpv = null;
            this.bsv = null;
            this.ca4 = null;
            this.sa4 = null;
            this.sa = null;
            this.ca = null;
        }

        private void initArrays() {
            this.glv = new int[this.ribbonAtomCount][20][14];
            this.gnv = new int[this.ribbonAtomCount][20][14];
            this.gpv = new int[this.ribbonAtomCount][10][13];
            this.bsv = new int[this.ribbonAtomCount][20];
        }

        private void clearArrays() {
            for (int i = 0; i < this.glv.length; ++i) {
                int k;
                int j;
                for (j = 0; j < this.glv[i].length; ++j) {
                    for (k = 0; k < this.glv[i][j].length; ++k) {
                        if (this.glv[i][j][k] != 0) {
                            GeomCalc.deleteVector(this.glv[i][j][k]);
                            this.glv[i][j][k] = 0;
                        }
                        if (this.gnv[i][j][k] == 0) continue;
                        GeomCalc.deleteVector(this.gnv[i][j][k]);
                        this.gnv[i][j][k] = 0;
                    }
                    if (this.bsv[i][j] == 0) continue;
                    GeomCalc.deleteVector(this.bsv[i][j]);
                    this.bsv[i][j] = 0;
                }
                for (j = 0; j < this.gpv[i].length; ++j) {
                    for (k = 0; k < this.gpv[i][j].length; ++k) {
                        if (this.gpv[i][j][k] == 0) continue;
                        GeomCalc.deleteVector(this.gpv[i][j][k]);
                        this.gpv[i][j][k] = 0;
                    }
                }
            }
        }

        public void setDrawType(int t) {
            int dt = this.convertDrawType(t);
            if (dt != -1) {
                this.style = dt;
                this.clearArrays();
                this.computeRibbonSpaceCurve();
            }
        }

        public float getThickness(int i) {
            if (this.tubeMode) {
                return this.cd;
            }
            if (RibbonVisualizer.this.backboneAtomTypes[this.startIndex + i] == 2) {
                return this.hd;
            }
            if (RibbonVisualizer.this.backboneAtomTypes[this.startIndex + i] == 3) {
                return this.sd;
            }
            if (RibbonVisualizer.this.backboneAtomTypes[this.startIndex + i] == 4) {
                return this.sd;
            }
            return this.cd;
        }

        public int getSample(int i) {
            if (RibbonVisualizer.this.backboneAtomTypes[this.startIndex + i] == 2) {
                return this.hs;
            }
            if (RibbonVisualizer.this.backboneAtomTypes[this.startIndex + i] == 3) {
                return this.ss;
            }
            if (RibbonVisualizer.this.backboneAtomTypes[this.startIndex + i] == 4) {
                return this.ss;
            }
            return this.cs;
        }

        private void computeGuideCoordinates() {
            int n = 0;
            int flip = 1;
            this.p[n] = GeomCalc.newVector(RibbonVisualizer.this.backboneAtoms[this.startIndex]);
            this.q[n] = GeomCalc.newVector(RibbonVisualizer.this.backboneAtoms[this.startIndex]);
            this.p[++n] = GeomCalc.newVector(RibbonVisualizer.this.backboneAtoms[this.startIndex]);
            this.q[n] = GeomCalc.newVector(RibbonVisualizer.this.backboneAtoms[this.startIndex]);
            ++n;
            int dprev = GeomCalc.newVector();
            int i = this.startIndex;
            while (i < this.endIndex) {
                int a = GeomCalc.sub(RibbonVisualizer.this.backboneAtoms[i + 1], RibbonVisualizer.this.backboneAtoms[i]);
                int b = GeomCalc.sub(RibbonVisualizer.this.backboneOxygens[i], RibbonVisualizer.this.backboneAtoms[i]);
                int c = GeomCalc.cross(a, b);
                int d = GeomCalc.cross(c, a);
                GeomCalc.normalize(c);
                GeomCalc.normalize(d);
                int pp = GeomCalc.half(RibbonVisualizer.this.backboneAtoms[i], RibbonVisualizer.this.backboneAtoms[i + 1]);
                if (RibbonVisualizer.this.backboneAtomTypes[i] == 2) {
                    GeomCalc.scale(c, this.helixShift);
                    GeomCalc.increase(pp, c);
                }
                if (i != 0 && GeomCalc.dot(d, dprev) < 0.0f) {
                    flip *= -1;
                }
                GeomCalc.setVector(dprev, d);
                float w = this.getWidth(i + 1);
                GeomCalc.scale(d, (float)flip * w);
                this.p[n] = GeomCalc.add(pp, d);
                this.q[n] = GeomCalc.sub(pp, d);
                GeomCalc.deleteVector(a);
                GeomCalc.deleteVector(b);
                GeomCalc.deleteVector(c);
                GeomCalc.deleteVector(d);
                GeomCalc.deleteVector(pp);
                ++i;
                ++n;
            }
            GeomCalc.deleteVector(dprev);
            this.p[n] = GeomCalc.newVector(RibbonVisualizer.this.backboneAtoms[this.endIndex]);
            this.q[n] = GeomCalc.newVector(RibbonVisualizer.this.backboneAtoms[this.endIndex]);
            this.p[++n] = GeomCalc.newVector(RibbonVisualizer.this.backboneAtoms[this.endIndex]);
            this.q[n] = GeomCalc.newVector(RibbonVisualizer.this.backboneAtoms[this.endIndex]);
        }

        private void computeNucleicAcidGuideCoordinates() {
            int n = 0;
            int flip = 1;
            this.p[n] = GeomCalc.newVector(RibbonVisualizer.this.backboneAtoms[this.startIndex]);
            this.q[n] = GeomCalc.newVector(RibbonVisualizer.this.backboneAtoms[this.startIndex]);
            this.p[++n] = GeomCalc.newVector(RibbonVisualizer.this.backboneAtoms[this.startIndex]);
            this.q[n] = GeomCalc.newVector(RibbonVisualizer.this.backboneAtoms[this.startIndex]);
            ++n;
            float p2p = 0.0f;
            float p2pprev = 0.0f;
            int dprev = GeomCalc.newVector();
            int i = this.startIndex;
            while (i < this.endIndex) {
                int d = GeomCalc.newVector(RibbonVisualizer.this.vb[i]);
                int pi = GeomCalc.newVector(RibbonVisualizer.this.backboneAtoms[i]);
                int ri = GeomCalc.half(pi, RibbonVisualizer.this.backboneAtoms[i + 1]);
                int a = GeomCalc.sub(RibbonVisualizer.this.backboneAtoms[i + 1], pi);
                int b = GeomCalc.sub(RibbonVisualizer.this.bh[i], ri);
                int B = GeomCalc.sub(ri, RibbonVisualizer.this.bh[i]);
                GeomCalc.normalize(d);
                GeomCalc.normalize(b);
                int c = GeomCalc.cross(a, b);
                GeomCalc.normalize(c);
                if ((double)GeomCalc.dot(c, d) < 0.0) {
                    GeomCalc.scale(d, -1.0f);
                }
                p2p = GeomCalc.dot(d, B);
                int di = GeomCalc.newVector(d);
                GeomCalc.scale(di, 0.5f * (p2p + p2pprev));
                GeomCalc.decrease(pi, di);
                GeomCalc.deleteVector(di);
                if (i != 0 && GeomCalc.dot(d, dprev) < 0.0f) {
                    flip *= -1;
                }
                p2pprev = p2p;
                GeomCalc.setVector(dprev, d);
                float w = this.getWidth(i + 1);
                GeomCalc.scale(d, (float)flip * w);
                this.p[n] = GeomCalc.add(ri, d);
                this.q[n] = GeomCalc.sub(ri, d);
                GeomCalc.deleteVector(d);
                GeomCalc.deleteVector(pi);
                GeomCalc.deleteVector(ri);
                GeomCalc.deleteVector(a);
                GeomCalc.deleteVector(b);
                GeomCalc.deleteVector(B);
                GeomCalc.deleteVector(c);
                ++i;
                ++n;
            }
            GeomCalc.deleteVector(dprev);
            this.p[n] = GeomCalc.newVector(RibbonVisualizer.this.backboneAtoms[this.endIndex]);
            this.q[n] = GeomCalc.newVector(RibbonVisualizer.this.backboneAtoms[this.endIndex]);
            this.p[++n] = GeomCalc.newVector(RibbonVisualizer.this.backboneAtoms[this.endIndex]);
            this.q[n] = GeomCalc.newVector(RibbonVisualizer.this.backboneAtoms[this.endIndex]);
        }

        private void computeRibbonSpaceCurve() {
            int oldns = -1;
            int oldnt = -1;
            if (this.style == 0) {
                for (int k = 0; k < this.ribbonAtomCount; ++k) {
                    this.setGuidePoints(this.nt, k);
                    oldns = this.setGuideLines(this.nt, k, oldns);
                }
            } else if (this.style == 1) {
                for (int k = 0; k < this.ribbonAtomCount; ++k) {
                    this.setGuidePoints(this.nt, k);
                    oldns = this.setGuideLines(this.nt, k, oldns);
                    this.setLineNormals(k, this.nt);
                }
            } else {
                for (int k = 0; k < this.ribbonAtomCount; ++k) {
                    int nt = 3;
                    this.setGuidePoints(nt, k);
                    oldns = this.setGuideLines(nt, k, oldns);
                    this.setSpaceCurve(k);
                    this.setThickness(k);
                    nt = this.style == 2 ? 4 : this.nt * 2;
                    oldnt = this.setGeneratorCurve(k, nt, oldnt);
                    this.setLineNormals(k, nt);
                }
            }
        }

        private void setGuidePoints(int nt, int res) {
            float f = 1.0f / (float)(nt - 1);
            for (int k = 0; k < nt; ++k) {
                for (int j = 0; j < 4; ++j) {
                    this.gpv[res][k][j] = GeomCalc.sub(this.q[res + j], this.p[res + j]);
                    GeomCalc.scale(this.gpv[res][k][j], (float)k * f);
                    GeomCalc.increase(this.gpv[res][k][j], this.p[res + j]);
                }
            }
        }

        private int setGuideLines(int nt, int res, int oldns) {
            int ns = this.getSample(res);
            if (ns != oldns) {
                RibbonBSpline.bsSetup(ns);
            }
            for (int k = 0; k < nt; ++k) {
                int[] xgp = this.gpv[res][k];
                RibbonBSpline.bsLine(xgp, ns, this.bsv[res]);
                for (int j = 0; j < ns + 1; ++j) {
                    this.glv[res][k][j] = this.bsv[res][j];
                    this.bsv[res][j] = 0;
                }
            }
            if (this.isArrow(res)) {
                this.setArrowLines(res, nt);
            }
            return ns;
        }

        private void setSpaceCurve(int res) {
            int ns = this.getSample(res);
            for (int j = 0; j < ns + 1; ++j) {
                int t;
                int jminus;
                int jplus = j == ns ? ns : j + 1;
                int n = jminus = j == 0 ? 0 : j - 1;
                if (j == 0 && res > 0) {
                    int l = this.getSample(res - 1);
                    t = GeomCalc.sub(this.glv[res - 1][1][l], this.glv[res - 1][1][l - 1]);
                } else {
                    t = GeomCalc.sub(this.glv[res][1][jplus], this.glv[res][1][jminus]);
                }
                int b = GeomCalc.sub(this.glv[res][2][j], this.glv[res][0][j]);
                float width = (float)Math.sqrt(GeomCalc.dot(b, b));
                int n2 = GeomCalc.cross(t, b);
                GeomCalc.normalize(t);
                GeomCalc.normalize(n2);
                GeomCalc.normalize(b);
                GeomCalc.deleteVector(this.gnv[res][0][j]);
                this.gnv[res][0][j] = GeomCalc.newVector(this.glv[res][1][j]);
                GeomCalc.deleteVector(this.gnv[res][1][j]);
                this.gnv[res][1][j] = t;
                GeomCalc.deleteVector(this.gnv[res][2][j]);
                this.gnv[res][2][j] = n2;
                GeomCalc.deleteVector(this.gnv[res][3][j]);
                this.gnv[res][3][j] = b;
                GeomCalc.deleteVector(this.gnv[res][4][j]);
                this.gnv[res][4][j] = this.tubeMode ? GeomCalc.newVector(this.coilWidth, 0.0f, 0.0f) : (this.uniformCoil && RibbonVisualizer.this.backboneAtomTypes[this.startIndex + res] != 2 && RibbonVisualizer.this.backboneAtomTypes[this.startIndex + res] != 3 && RibbonVisualizer.this.backboneAtomTypes[this.startIndex + res] != 4 ? GeomCalc.newVector(this.coilWidth, 0.0f, 0.0f) : (RibbonVisualizer.this.backboneAtomTypes[this.startIndex + res] == 4 ? GeomCalc.newVector(this.sheetWidth, 0.0f, 0.0f) : GeomCalc.newVector(width, 0.0f, 0.0f)));
            }
        }

        private void setThickness(int res) {
            int ns = this.getSample(res);
            float d = this.getThickness(res);
            float d0 = res == 0 ? d : this.getThickness(res - 1);
            GeomCalc.setVectorY(this.gnv[res][4][0], d0);
            GeomCalc.setVectorY(this.gnv[res][4][1], 0.5f * (d0 + d));
            for (int j = 2; j < ns + 1; ++j) {
                GeomCalc.setVectorY(this.gnv[res][4][j], d);
            }
        }

        private int setGeneratorCurve(int res, int nt, int oldnt) {
            int k;
            float[] pcos = null;
            float[] psin = null;
            int ns = this.getSample(res);
            if (this.style == 3) {
                if (nt != oldnt) {
                    this.setCircleCoordinates(nt);
                }
                pcos = this.ca;
                psin = this.sa;
            } else if (this.style == 2) {
                pcos = this.ca4;
                psin = this.sa4;
            }
            for (int j = 0; j < ns + 1; ++j) {
                int c = this.gnv[res][0][j];
                int a = this.gnv[res][3][j];
                int b = this.gnv[res][2][j];
                float width = GeomCalc.getX(this.gnv[res][4][j]);
                float depth = GeomCalc.getY(this.gnv[res][4][j]);
                this.calculateGeneratorCurve(c, a, b, 0.5f * width, 0.5f * depth, nt, pcos, psin, this.bsv[res]);
                for (k = 0; k < nt; ++k) {
                    GeomCalc.deleteVector(this.glv[res][k][j]);
                    this.glv[res][k][j] = this.bsv[res][k];
                    this.bsv[res][k] = 0;
                }
            }
            if (res > 0 && this.toFit(res)) {
                for (k = 0; k < nt; ++k) {
                    int s = this.getSample(res - 1);
                    GeomCalc.setVector(this.glv[res][k][0], this.glv[res - 1][k][s]);
                }
            }
            return nt;
        }

        private boolean toFit(int i) {
            boolean sohim1;
            if (this.isArrow(i)) {
                return false;
            }
            if (RibbonVisualizer.this.backboneAtomTypes[this.startIndex + i] == RibbonVisualizer.this.backboneAtomTypes[this.startIndex + i - 1]) {
                return true;
            }
            boolean sohi = RibbonVisualizer.this.backboneAtomTypes[this.startIndex + i] == 3 || RibbonVisualizer.this.backboneAtomTypes[this.startIndex + i] == 2 || RibbonVisualizer.this.backboneAtomTypes[this.startIndex + i] == 4;
            boolean bl = sohim1 = RibbonVisualizer.this.backboneAtomTypes[this.startIndex + i - 1] == 3 || RibbonVisualizer.this.backboneAtomTypes[this.startIndex + i - 1] == 2 || RibbonVisualizer.this.backboneAtomTypes[this.startIndex + i - 1] == 4;
            if (!sohi && !sohim1) {
                return true;
            }
            if (sohi && this.isArrow(i - 1)) {
                return false;
            }
            if (sohi && sohim1) {
                return true;
            }
            return !this.uniformCoil;
        }

        private void calculateGeneratorCurve(int center, int b, int n, float r1, float r2, int np, float[] ca, float[] sa, int[] x) {
            int av = GeomCalc.newVector(b);
            GeomCalc.scale(av, r1);
            int bv = GeomCalc.newVector(n);
            GeomCalc.scale(bv, r2);
            for (int i = 0; i < np; ++i) {
                float xv = GeomCalc.getX(center) + sa[i] * GeomCalc.getX(av) + ca[i] * GeomCalc.getX(bv);
                float yv = GeomCalc.getY(center) + sa[i] * GeomCalc.getY(av) + ca[i] * GeomCalc.getY(bv);
                float zv = GeomCalc.getZ(center) + sa[i] * GeomCalc.getZ(av) + ca[i] * GeomCalc.getZ(bv);
                x[i] = GeomCalc.newVector(xv, yv, zv);
            }
            GeomCalc.deleteVector(av);
            GeomCalc.deleteVector(bv);
        }

        private void setLineNormals(int res, int nt) {
            int i;
            int ns = this.getSample(res);
            for (i = 0; i < nt; ++i) {
                int iminus;
                int iplus = i < nt - 1 ? i + 1 : nt - 1;
                int n = iminus = i == 0 ? 0 : i - 1;
                if (this.style == 2) {
                    iplus = (i + 1) % nt;
                    iminus = (nt + i - 1) % nt;
                }
                for (int j = 0; j < ns + 1; ++j) {
                    int jplus = j < ns ? j + 1 : ns;
                    int jminus = j == 0 ? 0 : j - 1;
                    int a = GeomCalc.sub(this.glv[res][iplus][j], this.glv[res][iminus][j]);
                    int b = GeomCalc.sub(this.glv[res][i][jplus], this.glv[res][i][jminus]);
                    int c = GeomCalc.cross(a, b);
                    GeomCalc.normalize(c);
                    if (this.gnv[res][i][j] != 0) {
                        GeomCalc.deleteVector(this.gnv[res][i][j]);
                    }
                    this.gnv[res][i][j] = c;
                    GeomCalc.deleteVector(a);
                    GeomCalc.deleteVector(b);
                }
            }
            if (res > 1) {
                for (i = 0; i < nt; ++i) {
                    int l = this.getSample(res - 1);
                    GeomCalc.setVector(this.gnv[res - 1][i][l], this.gnv[res][i][0]);
                }
            }
        }

        private void setArrowLines(int res, int nt) {
            float s;
            int j;
            float wat = this.hatw;
            float wab = RibbonVisualizer.this.backboneAtomTypes[this.startIndex + res] == 2 ? this.habw : this.sabw;
            int ns = this.getSample(res);
            wat = (wab - wat) / (float)ns;
            for (j = 0; j < ns + 1; ++j) {
                int d = GeomCalc.sub(this.glv[res][nt - 1][j], this.glv[res][0][j]);
                int c = GeomCalc.half(this.glv[res][nt - 1][j], this.glv[res][0][j]);
                s = (float)Math.sqrt(GeomCalc.dot(d, d));
                s = 0.5f * (wab / s);
                GeomCalc.scale(d, s);
                GeomCalc.setVector(this.glv[res][0][j], c);
                GeomCalc.decrease(this.glv[res][0][j], d);
                GeomCalc.setVector(this.glv[res][nt - 1][j], c);
                GeomCalc.increase(this.glv[res][nt - 1][j], d);
                wab -= wat;
                GeomCalc.deleteVector(c);
                GeomCalc.deleteVector(d);
            }
            if (nt <= 3) {
                return;
            }
            s = 1.0f / (float)(nt - 1);
            for (int k = 1; k < nt - 1; ++k) {
                for (j = 0; j < ns + 1; ++j) {
                    int a = GeomCalc.sub(this.glv[res][nt - 1][j], this.glv[res][0][j]);
                    GeomCalc.scale(a, (float)k * s);
                    GeomCalc.setVector(this.glv[res][k][j], this.glv[res][0][j]);
                    GeomCalc.increase(this.glv[res][k][j], a);
                    GeomCalc.deleteVector(a);
                }
            }
        }

        private int convertDrawType(int t) {
            this.tubeMode = t == 3;
            switch (t) {
                case 5: {
                    return 0;
                }
                case 6: {
                    return 1;
                }
                case 7: {
                    return 2;
                }
                case 3: 
                case 4: 
                case 8: {
                    return 3;
                }
            }
            return -1;
        }

        private float getWidth(int i) {
            if (this.tubeMode) {
                return this.coilWidth;
            }
            switch (RibbonVisualizer.this.backboneAtomTypes[i]) {
                case 2: {
                    return this.helixWidth;
                }
                case 3: {
                    return this.sheetWidth;
                }
                case 4: {
                    return this.sheetWidth;
                }
            }
            return this.coilWidth;
        }

        private boolean isArrow(int i) {
            int idx = this.startIndex + i;
            if (RibbonVisualizer.this.backboneAtomTypes[idx] == 3) {
                if (!this.drawSheetArrow) {
                    return false;
                }
                if (idx == this.endIndex) {
                    return true;
                }
                if (idx < this.endIndex && RibbonVisualizer.this.backboneAtomTypes[idx + 1] != 3) {
                    return true;
                }
            } else if (RibbonVisualizer.this.backboneAtomTypes[idx] == 2) {
                if (!this.drawHelixArrow) {
                    return false;
                }
                if (idx == this.endIndex) {
                    return true;
                }
                if (idx < this.endIndex && RibbonVisualizer.this.backboneAtomTypes[idx + 1] != 2) {
                    return true;
                }
            }
            return false;
        }

        private void setCircleCoordinates(int npc) {
            float ang = (float)(Math.PI * -2 / (double)npc);
            for (int i = 0; i < npc; ++i) {
                this.sa[i] = (float)Math.sin((float)i * ang);
                this.ca[i] = (float)Math.cos((float)i * ang);
            }
            this.sa[npc] = this.sa[0];
            this.ca[npc] = this.ca[0];
            this.sa[npc + 1] = this.sa[1];
            this.ca[npc + 1] = this.ca[1];
        }

        private void setQuality(int quality) {
            this.clearArrays();
            switch (quality) {
                case 3: {
                    this.hs = 8;
                    this.ss = 4;
                    this.cs = 5;
                    break;
                }
                case 2: {
                    this.hs = 6;
                    this.ss = 3;
                    this.cs = 3;
                    break;
                }
                case 1: {
                    this.hs = 3;
                    this.ss = 3;
                    this.cs = 3;
                }
            }
            this.ns = this.hs;
            this.computeRibbonSpaceCurve();
        }

        void setHelixWidth(float v) {
            if (this.helixWidth == v) {
                return;
            }
            this.helixWidth = v;
            this.reinitialize(true);
        }

        void setHelixDepth(float v) {
            if (this.hd == v) {
                return;
            }
            this.hd = v;
            this.reinitialize(false);
        }

        void setHelixShift(float v) {
            if (this.helixShift == v) {
                return;
            }
            this.helixShift = v;
            this.reinitialize(true);
        }

        void setHelixArrow(boolean drawArrow) {
            if (this.drawHelixArrow == drawArrow) {
                return;
            }
            this.drawHelixArrow = drawArrow;
            this.reinitialize(false);
        }

        void setHelixArrowWidth(float v) {
            if (this.habw == v) {
                return;
            }
            this.habw = v;
            this.reinitialize(false);
        }

        void setSheetWidth(float v) {
            if (this.sheetWidth == v) {
                return;
            }
            this.sheetWidth = v;
            this.reinitialize(true);
        }

        void setSheetDepth(float v) {
            if (this.sd == v) {
                return;
            }
            this.sd = v;
            this.reinitialize(false);
        }

        void setSheetArrow(boolean drawArrow) {
            if (this.drawSheetArrow == drawArrow) {
                return;
            }
            this.drawSheetArrow = drawArrow;
            this.reinitialize(false);
        }

        void setSheetArrowWidth(float v) {
            if (this.sabw == v) {
                return;
            }
            this.sabw = v;
            this.reinitialize(false);
        }

        void setCoilWidth(float v) {
            if (this.coilWidth == v) {
                return;
            }
            this.coilWidth = v;
            this.reinitialize(true);
        }

        void setCoilDepth(float v) {
            if (this.cd == v) {
                return;
            }
            this.cd = v;
            this.reinitialize(false);
        }

        void setCoilUniform(boolean cu) {
            if (this.uniformCoil == cu) {
                return;
            }
            this.uniformCoil = cu;
            this.reinitialize(false);
        }

        void setThreads(int nt) {
            if (this.nt == nt) {
                return;
            }
            this.nt = nt;
            this.reinitialize(false);
        }

        private void reinitialize(boolean guideCoordinates) {
            this.clearArrays();
            if (guideCoordinates) {
                for (int i = 0; i < this.p.length; ++i) {
                    GeomCalc.deleteVector(this.p[i]);
                    GeomCalc.deleteVector(this.q[i]);
                }
                if (RibbonVisualizer.this.batoms != null) {
                    this.computeNucleicAcidGuideCoordinates();
                } else {
                    this.computeGuideCoordinates();
                }
            }
            this.computeRibbonSpaceCurve();
        }
    }
}

