/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.space;

import chemaxon.common.util.GeomCalc;
import chemaxon.marvin.space.Colors;
import chemaxon.marvin.space.GraphicComponent;
import java.util.ArrayList;

public class SlabComponent
extends GraphicComponent {
    ArrayList vertices = new ArrayList();
    ArrayList normals = new ArrayList();
    float transparency = 0.5f;

    public SlabComponent() {
    }

    public SlabComponent(float[] vertices) {
        this.set(vertices);
    }

    public SlabComponent(float[][] vertices) {
        this.set(vertices);
    }

    public SlabComponent(int[] vertices) {
        this.set(vertices);
    }

    @Override
    public void onRemoveGraphicComponent() {
        this.vertices.clear();
        this.normals.clear();
    }

    public void beginSlab() {
        this.vertices.clear();
        this.normals.clear();
        this.boundingBox.clear();
    }

    public void endSlab() {
        this.setNormals();
        this.setBoundingBox();
    }

    public void addVertex(float x, float y, float z) {
        float[] v = new float[]{x, y, z};
        this.vertices.add(v);
    }

    public void set(float[][] v) {
        this.beginSlab();
        this.vertices = new ArrayList(v.length);
        for (int i = 0; i < v.length; ++i) {
            this.vertices.add(v[i]);
        }
        this.endSlab();
    }

    public void set(float[] v) {
        this.beginSlab();
        for (int i = 0; i < v.length; i += 3) {
            this.addVertex(v[i], v[i + 1], v[i + 2]);
        }
        this.endSlab();
    }

    public void set(int[] v) {
        this.beginSlab();
        this.vertices = new ArrayList(v.length);
        for (int i = 0; i < v.length; ++i) {
            this.vertices.add(GeomCalc.getFloatVector(v[i]));
        }
        this.endSlab();
    }

    private void setNormals() {
        int gv1 = GeomCalc.newVector();
        int gv2 = GeomCalc.newVector();
        for (int i = 0; i < this.vertices.size() - 2; ++i) {
            GeomCalc.setVector(gv1, (float[])this.vertices.get(i + 2));
            GeomCalc.decrease(gv1, (float[])this.vertices.get(i + 1));
            GeomCalc.setVector(gv2, (float[])this.vertices.get(0));
            GeomCalc.decrease(gv2, (float[])this.vertices.get(i + 1));
            int c = GeomCalc.cross(gv1, gv2);
            this.normals.add(GeomCalc.getFloatVector(c));
            GeomCalc.deleteVector(c);
        }
        GeomCalc.deleteVector(gv1);
        GeomCalc.deleteVector(gv2);
    }

    public void setTransparency(float f) {
        if (f >= 0.0f && f <= 1.0f) {
            this.transparency = f;
        }
    }

    @Override
    public boolean hasTransparentPart() {
        return this.visible;
    }

    @Override
    public void draw() {
    }

    @Override
    public void drawTransparentPart() {
        if (!this.visible) {
            return;
        }
        this.drawSlab();
    }

    private void drawSlab() {
        int i;
        if (this.vertices == null || this.vertices.size() == 0) {
            return;
        }
        this.gl.glEnable(3042);
        if (this.isSelected()) {
            this.gl.glColor3bv(Colors.selected, 0);
        } else {
            this.glColor();
        }
        this.gl.glDisable(2896);
        this.gl.glBegin(3);
        for (i = 0; i < this.vertices.size(); ++i) {
            this.gl.glVertex3fv((float[])this.vertices.get(i), 0);
        }
        this.gl.glVertex3fv((float[])this.vertices.get(0), 0);
        this.gl.glEnd();
        this.gl.glEnable(2896);
        if (this.normals == null || this.normals.size() == 0) {
            return;
        }
        this.gl.glDisable(2884);
        this.gl.glColor4f((float)this.color.getRed() / 255.0f, (float)this.color.getGreen() / 255.0f, (float)this.color.getBlue() / 255.0f, this.transparency);
        this.gl.glDepthMask(false);
        this.gl.glBegin(6);
        this.gl.glNormal3fv((float[])this.normals.get(0), 0);
        this.gl.glVertex3fv((float[])this.vertices.get(0), 0);
        this.gl.glVertex3fv((float[])this.vertices.get(1), 0);
        this.gl.glVertex3fv((float[])this.vertices.get(2), 0);
        for (i = 1; i < this.normals.size(); ++i) {
            this.gl.glNormal3fv((float[])this.normals.get(i), 0);
            this.gl.glVertex3fv((float[])this.vertices.get(i + 2), 0);
        }
        this.gl.glEnd();
        this.gl.glDepthMask(true);
        this.gl.glDisable(3042);
        this.gl.glEnable(2884);
    }

    private void setBoundingBox() {
        for (int i = 0; i < this.vertices.size(); ++i) {
            float[] vi = (float[])this.vertices.get(i);
            this.boundingBox.setWithCondition(vi[0], vi[1], vi[2]);
        }
        this.boundingBox.ready();
    }

    @Override
    public boolean isControllable(String type) {
        return this.active;
    }

    @Override
    public void translate(float[] v) {
        for (int i = 0; i < this.vertices.size(); ++i) {
            float[] vi = (float[])this.vertices.get(i);
            for (int j = 0; j < 3; ++j) {
                int n = j;
                vi[n] = vi[n] + v[j];
            }
        }
        super.translate(v);
    }

    @Override
    public void rotate(float[] v, float[] center) {
        for (int i = 0; i < this.vertices.size(); ++i) {
            this.rotate((float[])this.vertices.get(i), v, center);
        }
        this.normals.clear();
        this.setNormals();
    }

    @Override
    public void resize(double x, double y, double z) {
        float f = 1.0f;
        if (x != 0.0) {
            f += (float)x / 20.0f;
        } else if (y != 0.0) {
            f += (float)y / 20.0f;
        } else if (z != 0.0) {
            f += (float)z / 20.0f;
        }
        int v0 = GeomCalc.newVector();
        for (int i = 0; i < this.vertices.size(); ++i) {
            GeomCalc.setVector(v0, (float[])this.vertices.get(i));
            GeomCalc.decrease(v0, this.boundingBox.getBoundingCenter());
            GeomCalc.scale(v0, f);
            GeomCalc.increase(v0, this.boundingBox.getBoundingCenter());
            this.vertices.set(i, GeomCalc.getFloatVector(v0));
        }
        GeomCalc.deleteVector(v0);
    }
}

