/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.space;

import chemaxon.marvin.space.Colors;
import chemaxon.marvin.space.PolymerVisualizer;
import chemaxon.marvin.space.ProgressBarInterface;
import chemaxon.marvin.space.SurfaceComponent;
import chemaxon.marvin.space.grid.AtomEntries;
import chemaxon.marvin.space.grid.PropertyMapper;
import chemaxon.marvin.space.grid.WeightedValues;
import chemaxon.marvin.space.util.Palette;
import chemaxon.marvin.util.ColorPaletteUtil;
import chemaxon.struc.MoleculeIterators;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class SurfaceColoring {
    public static final int RADIUS_VDW = 1;
    public static final int RADIUS_VDW_EXTENDED = 2;
    public static final int RADIUS_CONSTANT = 3;
    public static final int NEAREST_VALUE = 0;
    public static final int SUM_OF_VALUES = 1;
    public static final int MEAN_VALUE = 2;
    public static final int DISTANCE_WEIGHTED = 3;
    public static final int DISTANCE_FROM_VDW = 1;
    public static final int DISTANCE_FROM_VDW_EXTENDED = 2;
    public static final int DISTANCE_CONSTANT = 3;
    public static final int BUILT_IN_CPK_MAPPING = 2;
    public static final int BUILT_IN_RESIDUE_MAPPING = 3;
    public static final int BUILT_IN_CHAIN_MAPPING = 4;
    public static final int BUILT_IN_SECONDARY_STRUCTURE_MAPPING = 5;
    public static final int BUILT_IN_RAINBOW_MAPPING = 6;
    public static final int ATOM_PROPERTY_MAPPING = 1;
    public static final int GRID_MAPPING = 0;
    public static final int NO_DECREASE = 1;
    public static final int DECREASE_LINEAR = 2;
    public static final int DECREASE_SQUARE = 4;
    public static final int DECREASE_RECIPROCAL_SQUARE = 8;
    public static final int COLOR_MAPPER_RAINBOW = 2;
    public static final int COLOR_MAPPER_REVERSE_RAINBOW = 3;
    public static final int COLOR_MAPPER_RED_TO_BLUE = 0;
    public static final int COLOR_MAPPER_BLUE_TO_RED = 1;
    public static final int COLOR_MAPPER_GREEN_TO_BLUE = 5;
    public static final int COLOR_MAPPER_BLUE_TO_GREEN = 4;
    public static final int COLOR_MAPPER_FIRE = 6;
    private ArrayList molecules;
    private SurfaceComponent surface;
    private float step = -1.0f;
    AtomEntries entries;
    WeightedValues values;
    PropertyMapper pm = new PropertyMapper();
    private boolean recomputeEntriesIsNecessary = true;
    private boolean propertyObjectIsSet = false;

    public SurfaceColoring(SurfaceComponent surface) {
        this.surface = surface;
        this.values = new WeightedValues();
    }

    public SurfaceColoring(ArrayList molecules, SurfaceComponent surface) {
        this.molecules = molecules;
        this.surface = surface;
        this.entries = new AtomEntries();
        this.values = new WeightedValues();
    }

    public SurfaceColoring(ArrayList molecules, SurfaceComponent surface, float step) {
        this.molecules = molecules;
        this.surface = surface;
        this.step = step;
        this.entries = new AtomEntries();
        this.values = new WeightedValues();
    }

    protected void finalize() throws Throwable {
        this.molecules = null;
        this.surface = null;
        this.entries = null;
        this.values = null;
        this.pm = null;
    }

    public void setProgressBar(ProgressBarInterface progressBar) {
        if (this.entries != null) {
            this.entries.setProgressBar(progressBar, 0, 50);
        }
        if (this.values != null) {
            this.values.setProgressBar(progressBar, 50, 80);
        }
        if (this.pm != null) {
            this.pm.setProgressBar(progressBar, 80, 100);
        }
    }

    public void setSurface(SurfaceComponent surface) {
        this.surface = surface;
    }

    public void reset() {
        this.entries.reset();
        this.values.reset();
        this.pm.reset();
    }

    public void setPropertyObject(Object o, int mappingMode) {
        this.propertyObjectIsSet = true;
        this.values.setPropertyObject(o, mappingMode);
    }

    public void setPropertyMethod(Method m) throws Exception {
        this.values.setPropertyMethod(m);
    }

    public void setBuiltInColorMapperMethod(int mode) throws Exception {
        this.pm.setBuiltInPropertyColorMapperMethod(mode, false);
    }

    public void setBuiltInColorMapperMethod(int mode, boolean twoPolePalette) throws Exception {
        if (mode == 7 || mode == 8 || mode == 9) {
            this.pm.setBuiltInPropertyColorMapperMethod(mode, false);
        } else {
            this.pm.setBuiltInPropertyColorMapperMethod(mode, twoPolePalette);
        }
    }

    public void changeColorMapperColors(int mode) {
        this.pm.changePaletteColors(mode);
    }

    public void setPropertyColorMapperRange(double min, double max) {
        this.pm.setPropertyColorMapperRange(min, max);
    }

    public void setPropertyColorMapperMethod(Method m) throws Exception {
        this.pm.setPropertyColorMapperMethod(m);
    }

    public void setPropertyColorObject(Object o) {
        this.pm.setPropertyColorObject(o);
    }

    public void doColoring() throws Exception {
        if (this.step > 0.0f) {
            this.entries.setEntries(this.molecules, this.surface, this.step);
        } else {
            this.entries.setEntries(this.molecules, this.surface);
        }
        this.values.setAtomEntries(this.molecules, this.surface, this.entries);
        this.pm.doMapping(this.surface, this.values);
    }

    public void doColoring(int mappingMode) throws Exception {
        if (this.recomputeEntriesIsNecessary) {
            if (this.step > 0.0f) {
                this.entries.setEntries(this.molecules, this.surface, this.step);
            } else {
                this.entries.setEntries(this.molecules, this.surface);
            }
            this.recomputeEntriesIsNecessary = false;
        }
        switch (mappingMode) {
            case 2: {
                this.values.setBuiltInPropertyMethod(mappingMode);
                this.values.setWeightMode(3);
                this.values.setAtomEntries(this.molecules, this.surface, this.entries);
                this.pm.setPropertyColorMapperMethod(Colors.class.getMethod("getCPKByteColor", Integer.TYPE));
                this.pm.doMapping(this.surface, this.values);
                break;
            }
            case 3: {
                this.values.setBuiltInPropertyMethod(mappingMode);
                this.values.setWeightMode(3);
                this.values.setAtomEntries(this.molecules, this.surface, this.entries);
                this.pm.setPropertyColorMapperMethod(Colors.class.getMethod("getResidueByteColor", Integer.TYPE));
                this.pm.doMapping(this.surface, this.values);
                break;
            }
            case 4: {
                this.values.setBuiltInPropertyMethod(mappingMode);
                this.values.setWeightMode(3);
                this.values.setAtomEntries(this.molecules, this.surface, this.entries);
                this.pm.setPropertyColorMapperMethod(Colors.class.getMethod("getChainColor", Integer.TYPE));
                this.pm.doMapping(this.surface, this.values);
                break;
            }
            case 5: {
                this.values.setBuiltInPropertyMethod(mappingMode);
                this.values.setWeightMode(3);
                this.values.setAtomEntries(this.molecules, this.surface, this.entries);
                this.pm.setPropertyColorMapperMethod(Colors.class.getMethod("getSecondaryTypeColor", Integer.TYPE));
                this.pm.doMapping(this.surface, this.values);
                break;
            }
            case 6: {
                int i;
                this.values.setBuiltInPropertyMethod(mappingMode);
                this.values.setWeightMode(3);
                this.values.setAtomEntries(this.molecules, this.surface, this.entries);
                for (i = 0; i < this.molecules.size(); ++i) {
                    MoleculeIterators.MoleculeInterface mi = (MoleculeIterators.MoleculeInterface)this.molecules.get(i);
                    if (!(mi instanceof PolymerVisualizer)) continue;
                    this.pm.setPropertyColorObject(((PolymerVisualizer)mi).getRainbowPalette());
                    break;
                }
                if (i == this.molecules.size()) {
                    System.out.println("Rainbow palette not found.");
                    break;
                }
                this.pm.setPropertyColorMapperMethod(Palette.class.getMethod("getByteColor", Double.TYPE));
                this.pm.doMapping(this.surface, this.values);
            }
        }
    }

    public void setEnrtyRadiusMode(int pvs) {
        this.entries.setEnrtyRadiusMode(pvs);
        this.values.setDistanceRadiusMode(pvs);
        this.recomputeEntriesIsNecessary = true;
    }

    public void setAtomRadiusExtension(float r) {
        this.entries.setAtomRadiusExtension(r);
        this.values.setDistanceRadiusExtension(r);
        this.recomputeEntriesIsNecessary = true;
    }

    public void setConstantAtomRadius(float r) {
        this.entries.setConstantAtomRadius(r);
        this.values.setConstantDistanceRadius(r);
        this.recomputeEntriesIsNecessary = true;
    }

    public void setDistanceRadiusMode(int pvs) {
        this.values.setDistanceRadiusMode(pvs);
    }

    public void setDistanceRadiusExtension(float r) {
        this.values.setDistanceRadiusExtension(r);
    }

    public void setConstantDistanceRadius(float r) {
        this.values.setConstantDistanceRadius(r);
    }

    public void setPropertyValueDecreasement(int pvd) {
        this.values.setPropertyValueDecreasement(pvd);
    }

    public void setReciprocalConstant(double c) {
        this.values.setReciprocalConstant(c);
    }

    public void setWeightMode(int mode) {
        this.values.setWeightMode(mode);
    }

    public void setHomogeneousPaletteColors(byte[][] colorArray) {
        this.pm.setHomogeneousPaletteColors(colorArray);
    }

    public static String[] getBuiltInPalettes() {
        return ColorPaletteUtil.getBuiltInPalettes();
    }

    public static byte[][] getBuiltInPalette(int paletteId) {
        return ColorPaletteUtil.getBuiltInPalette(paletteId);
    }

    public static byte[][] getBuiltInPalette(Object paletteId) {
        return ColorPaletteUtil.getBuiltInPalette(paletteId);
    }

    public double getMinimumValue() {
        return this.values.getMinimumValue();
    }

    public double getMaximumValue() {
        return this.values.getMaximumValue();
    }

    public void setMinimumValue(double v) {
        this.pm.setMinimumValue(v);
    }

    public void setMaximumValue(double v) {
        this.pm.setMaximumValue(v);
    }

    public void setLowerCutoffValue(double v) {
        this.pm.getBuiltInPalette().setLowerCutoff(v);
    }

    public void setUpperCutoffValue(double v) {
        this.pm.getBuiltInPalette().setUpperCutoff(v);
    }

    public void setSmoothColoringToCutoffValues(boolean b) {
        if (this.pm.getBuiltInPalette() == null) {
            return;
        }
        this.pm.getBuiltInPalette().smoothColorToCutoffValues(b);
    }

    public void updateColors() throws Exception {
        this.pm.doMapping(this.surface, this.values);
    }
}

