/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.space;

import chemaxon.common.util.GeomCalc;
import chemaxon.marvin.space.BoundingBox;
import chemaxon.marvin.space.GraphicCell;
import chemaxon.marvin.space.drawing.gl.def.GLBase;

public class ViewPort
extends GLBase {
    protected static final float DEFAULT_NEAR_CLIP = 0.1f;
    protected static final float DEFAULT_FAR_CLIP = 450.0f;
    protected static final float DEFAULT_FOVY = 15.0f;
    protected static final int DEFAULT_CAMERA_Z = 30;
    protected static final int ACCUM_NUMBER = 5;
    protected static final double[] j8 = new double[]{0.5, 0.5, 0.3, 0.1, 0.7, 0.9, 0.9, 0.3, 0.1, 0.7};
    protected int left;
    protected int bottom;
    protected int width;
    protected int height;
    protected float nearClip = 0.1f;
    protected float farClip = 450.0f;
    protected float fovY = 15.0f;
    protected float clippingPlanePosition = -59.9f;
    protected float farClippingPlanePosition = 450.0f;
    protected boolean movingCamera = true;
    protected double scalingFactor = 1.0;
    protected double cameraZ = 30.0;
    protected double cameraX = 0.0;
    protected double cameraY = 0.0;
    protected double[] lookAt = new double[16];
    protected double prevCameraZ = 29.0;
    protected float[] origin = new float[]{0.0f, 0.0f, 0.0f};
    protected float[] rotateMatrix = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
    protected double rotateX = 0.0;
    protected double rotateY = 0.0;
    protected double rotateZ = 0.0;
    protected double shiftx = 0.0;
    protected double shifty = 0.0;
    protected boolean fogEnabled = false;
    protected float fogstart = 30.0f;
    protected float fogend = 30.0f;
    protected boolean fogModified = false;
    protected int fogModifierNear = 0;
    protected int fogModifierFar = 40;
    protected boolean perspectiveProjection = true;
    protected boolean projectionMatrixNeedsRefresh = true;
    protected boolean antialias = false;
    protected double needsResetZoom = -1.0;
    protected GraphicCell gc;

    public ViewPort(GraphicCell gc) {
        this.gc = gc;
    }

    public float[] getRotatationMatrix() {
        return this.rotateMatrix;
    }

    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
        this.computeFovY();
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setCameraZ(double z) {
        this.cameraZ = z;
    }

    public void setCameraX(double x) {
        this.cameraX = x;
    }

    public void setFog(int fogNear, int fogFar) {
        this.fogModifierNear = fogNear;
        this.fogModifierFar = fogFar;
        this.fogModified = true;
    }

    public void setDepthCueNear(int fogNear) {
        this.fogModifierNear = fogNear;
        this.fogModified = true;
    }

    public void setDepthCueFar(int fogFar) {
        this.fogModifierFar = fogFar;
        this.fogModified = true;
    }

    public float[] getOrigin() {
        return this.origin;
    }

    public void setShiftX(double shift) {
        this.shiftx = shift;
        this.projectionMatrixNeedsRefresh = true;
    }

    public void setShiftY(double shift) {
        this.shifty = shift;
        this.projectionMatrixNeedsRefresh = true;
    }

    public void setOrigin(int left, int bottom) {
        this.left = left;
        this.bottom = bottom;
    }

    public void setLeft(int left) {
        this.left = left;
    }

    public int getLeft() {
        return this.left;
    }

    public void setBottom(int bottom) {
        this.bottom = bottom;
    }

    public int getBottom() {
        return this.bottom;
    }

    public int getTop() {
        return this.bottom + this.height;
    }

    public int getRight() {
        return this.left + this.width;
    }

    public void setAntialias(boolean antialias) {
        this.antialias = antialias;
    }

    public void setMatrices() {
        this.computeClippingPlanes();
        gl.glViewport(this.left, this.bottom, this.width, this.height);
        gl.glMatrixMode(5889);
        gl.glLoadIdentity();
        this.projectionMatrixNeedsRefresh = this.gc.setPickMatrix();
        if (this.perspectiveProjection) {
            glu.gluPerspective((double)this.fovY, (double)((float)this.width / (float)this.height), (double)this.nearClip, (double)this.farClip);
        } else {
            double d = (double)(this.nearClip + this.farClip) / 2.0;
            this.glOrtho(this.fovY, this.width / this.height, d, -d);
        }
        gl.glMatrixMode(5888);
        gl.glLoadIdentity();
    }

    public void setAccMatrices(int jitter) {
        this.computeClippingPlanes();
        gl.glViewport(this.left, this.bottom, this.width, this.height);
        gl.glMatrixMode(5889);
        gl.glLoadIdentity();
        this.accPerspective(this.fovY, (float)this.width / (float)this.height, this.nearClip, this.farClip, j8[jitter * 2], j8[jitter * 2 + 1], 0.0, 0.0, 1.0);
        gl.glMatrixMode(5888);
        gl.glLoadIdentity();
    }

    public void setModelviewMatrix() {
        if (this.cameraZ != this.prevCameraZ) {
            int minCamZ = this.getMinCameraZ();
            int maxCamZ = this.getMaxCameraZ();
            if (this.cameraZ <= (double)minCamZ) {
                this.cameraZ = minCamZ;
            } else if (this.cameraZ >= (double)maxCamZ) {
                this.cameraZ = maxCamZ;
            }
            gl.glPushMatrix();
            gl.glLoadIdentity();
            glu.gluLookAt(0.0, 0.0, this.cameraZ, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0);
            gl.glGetDoublev(2982, this.lookAt, 0);
            gl.glPopMatrix();
            gl.glMultMatrixd(this.lookAt, 0);
            this.prevCameraZ = this.cameraZ;
        } else {
            gl.glMultMatrixd(this.lookAt, 0);
        }
        if (this.shiftx != 0.0 || this.shifty != 0.0) {
            gl.glTranslated(this.shiftx, this.shifty, 0.0);
        }
        if (!this.movingCamera) {
            gl.glScaled(this.scalingFactor, this.scalingFactor, this.scalingFactor);
        }
        if (this.rotateX != 0.0 || this.rotateY != 0.0 || this.rotateZ != 0.0) {
            this.updateRotationMatrix();
        }
        gl.glMultMatrixf(this.rotateMatrix, 0);
        gl.glTranslated((double)(-this.origin[0]), (double)(-this.origin[1]), (double)(-this.origin[2]));
    }

    protected void glOrtho(double fovy, double aspect, double zNear, double zFar) {
        double ymax = zNear * Math.tan(fovy * Math.PI / 360.0);
        double ymin = -ymax;
        double xmin = ymin * aspect;
        double xmax = ymax * aspect;
        gl.glOrtho(xmin, xmax, ymin, ymax, zNear, zFar);
    }

    private void accFrustum(double left, double right, double bottom, double top, double near, double far, double pixdx, double pixdy, double eyedx, double eyedy, double focus) {
        int[] viewport = new int[4];
        gl.glGetIntegerv(2978, viewport, 0);
        double xwsize = right - left;
        double ywsize = top - bottom;
        double dx = -(pixdx * xwsize / (double)viewport[2] + eyedx * near / focus);
        double dy = -(pixdy * ywsize / (double)viewport[3] + eyedy * near / focus);
        gl.glMatrixMode(5889);
        gl.glLoadIdentity();
        gl.glFrustum(left + dx, right + dx, bottom + dy, top + dy, near, far);
        gl.glMatrixMode(5888);
        gl.glLoadIdentity();
        gl.glTranslated(-eyedx, -eyedy, 0.0);
    }

    private void accPerspective(double fovy, double aspect, double near, double far, double pixdx, double pixdy, double eyedx, double eyedy, double focus) {
        double fov2 = fovy * Math.PI / 180.0 / 2.0;
        double top = near / (Math.cos(fov2) / Math.sin(fov2));
        double bottom = -top;
        double right = top * aspect;
        double left = -right;
        this.accFrustum(left, right, bottom, top, near, far, pixdx, pixdy, eyedx, eyedy, focus);
    }

    public void zoom(double factor) {
        if (this.movingCamera) {
            this.cameraZ += factor;
        } else {
            this.scalingFactor -= 0.01 * factor;
            if (this.scalingFactor < 0.5) {
                this.scalingFactor = 0.5;
            }
            if (this.scalingFactor > 10.0) {
                this.scalingFactor = 10.0;
            }
        }
        this.projectionMatrixNeedsRefresh = true;
    }

    public void rotate(double angleX, double angleY, double angleZ) {
        this.rotateX = angleX;
        this.rotateY = angleY;
        this.rotateZ = angleZ;
    }

    public void shift(double shiftx, double shifty) {
        this.shiftx += shiftx;
        this.shifty += shifty;
    }

    public void resetCameraZ(BoundingBox boundingBox) {
        if (boundingBox != null) {
            float s = Math.min(this.width, this.height);
            s = s >= 100.0f ? 12.0f - s / 100.0f : 12.0f + s / 10.0f;
            this.cameraZ = (double)s * boundingBox.getBoundingRadius();
        } else {
            this.cameraZ = 30.0;
        }
    }

    public void resetView(BoundingBox boundingBox) {
        GeomCalc.setIdentity(this.rotateMatrix);
        this.updateRotationMatrix();
        if (boundingBox != null) {
            this.origin[0] = boundingBox.centerx();
            this.origin[1] = boundingBox.centery();
            this.origin[2] = boundingBox.centerz();
        }
        this.resetCameraZ(boundingBox);
        this.shiftx = 0.0;
        this.shifty = 0.0;
        this.setAntialias(false);
        this.setMatrices();
        this.projectionMatrixNeedsRefresh = true;
    }

    public void resetZoom(BoundingBox boundingBox) {
        if (this.needsResetZoom > -1.0) {
            this.resetCameraZ(boundingBox);
            this.cameraZ += this.needsResetZoom;
            this.setMatrices();
            this.projectionMatrixNeedsRefresh = true;
            this.needsResetZoom = -1.0;
        }
    }

    public void updateRotationMatrix() {
        gl.glPushMatrix();
        gl.glLoadIdentity();
        gl.glRotated(this.rotateX, 1.0, 0.0, 0.0);
        gl.glRotated(this.rotateY, 0.0, 1.0, 0.0);
        gl.glRotated(this.rotateZ, 0.0, 0.0, 1.0);
        gl.glMultMatrixf(this.rotateMatrix, 0);
        gl.glGetFloatv(2982, this.rotateMatrix, 0);
        this.gc.updateRotationMatrix();
        gl.glPopMatrix();
        this.rotateX = 0.0;
        this.rotateY = 0.0;
        this.rotateZ = 0.0;
    }

    public float getNearClip() {
        return this.nearClip;
    }

    public float getFarClip() {
        return this.farClip;
    }

    public float getFovY() {
        return this.fovY;
    }

    public void setFovY(float fovY) {
        this.fovY = fovY;
    }

    private void computeFovY() {
        double radtheta = Math.atan2(25.0 * (double)this.height / 1537.6, 40.0);
        this.fovY = (float)(180.0 * radtheta / Math.PI);
    }

    public double getShiftX() {
        return this.shiftx;
    }

    public double getShiftY() {
        return this.shifty;
    }

    public double getCameraZ() {
        return this.cameraZ;
    }

    public int getMinCameraZ() {
        return 1;
    }

    public int getMaxCameraZ() {
        return 800;
    }

    public void setClippingPlane(float v) {
        this.clippingPlanePosition = 0.1f + v;
        this.projectionMatrixNeedsRefresh = true;
    }

    public void setFarClippingPlane(float v) {
        this.farClippingPlanePosition = v;
        this.projectionMatrixNeedsRefresh = true;
    }

    public void enableFog(boolean fogEnabled) {
        this.fogEnabled = fogEnabled;
    }

    void setFog() {
        if (this.fogEnabled) {
            gl.glEnable(2912);
            if (this.fogModified || this.cameraZ != this.prevCameraZ || this.fogstart == this.fogend) {
                if (this.fogModifierNear == this.fogModifierFar) {
                    ++this.fogModifierFar;
                }
                this.fogstart = (float)this.cameraZ + (float)this.fogModifierNear;
                this.fogend = (float)this.cameraZ + (float)this.fogModifierFar;
                this.fogModified = false;
            }
            gl.glFogf(2915, this.fogstart);
            gl.glFogf(2916, this.fogend);
        } else {
            gl.glDisable(2912);
        }
    }

    protected void computeClippingPlanes() {
        this.nearClip = (float)this.cameraZ + this.clippingPlanePosition;
        this.nearClip = this.nearClip < 0.1f ? 0.1f : this.nearClip;
        this.farClip = (float)this.cameraZ + this.farClippingPlanePosition;
        this.farClip = this.farClip > (float)this.getMaxCameraZ() + 450.0f ? (float)this.getMaxCameraZ() + 450.0f : this.farClip;
        this.farClip = this.farClip <= this.nearClip ? this.nearClip + 1.0f : this.farClip;
    }

    protected void drawAntiAliased() {
        gl.glClear(512);
        for (int jitter = 0; jitter < 5; ++jitter) {
            gl.glClear(16640);
            this.gc.drawSmoothBackground();
            this.setAccMatrices(jitter);
            this.gc.drawComponents();
            gl.glAccum(256, 0.2f);
        }
        gl.glAccum(258, 1.0f);
    }

    public void draw() {
        gl.glScissor(this.left, this.bottom, this.width, this.height);
        if (this.antialias) {
            this.drawAntiAliased();
            return;
        }
        gl.glClear(16640);
        this.resetZoom(this.gc.getBoundingBoxAndSetSphereRadius());
        this.gc.drawSmoothBackground();
        this.setMatrices();
        int errorCode = gl.glGetError();
        String errorString = glu.gluErrorString(errorCode);
        if (errorString != null && !errorString.equals("no error")) {
            System.out.println("Initialize draw, setting projection matrices:  >>>  " + errorString + "  <<<  ");
        }
        this.gc.drawCell();
    }
}

