/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.space;

import chemaxon.common.util.GeomCalc;
import chemaxon.marvin.space.Colors;
import chemaxon.marvin.space.MacroMoleculeComponent;
import chemaxon.marvin.space.MoleculeComponent;
import chemaxon.marvin.space.PolymerVisualizer;
import chemaxon.marvin.space.drawing.AromaticRings;
import chemaxon.marvin.space.drawing.Bonds;
import chemaxon.marvin.space.drawing.DefaultSettingsProvider;
import chemaxon.marvin.space.drawing.DrawableCollection;
import chemaxon.marvin.space.drawing.DrawableException;
import chemaxon.marvin.space.drawing.DrawableFactory;
import chemaxon.marvin.space.drawing.Wire;
import chemaxon.marvin.space.drawing.iface.IDrawable;
import chemaxon.marvin.space.render.Cylinder;
import chemaxon.marvin.space.render.Renderer;
import chemaxon.marvin.space.render.UniformSphere;
import chemaxon.marvin.space.util.Palette;
import chemaxon.struc.MacroMolecule;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeIterators;
import chemaxon.struc.PeriodicSystem;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import javax.media.opengl.GL;
import javax.media.opengl.glu.GLU;

public class VisibleMolecule {
    protected static final int HIDDEN = -1;
    protected static final int FADED = -2;
    protected static final int DRAW_TYPE_WIRE = 2;
    protected static final int DRAW_TYPE_BALL = 3;
    protected static final int DRAW_TYPE_STICK = 4;
    protected static final int DRAW_TYPE_BALL_AND_WIRE = 5;
    protected static final int DRAW_TYPE_BALL_AND_STICK = 6;
    protected static final int DRAW_TYPE_SPACEFILL = 7;
    protected static final int BOND_DRAW_TYPE_BOND = 1;
    protected static final int BOND_DRAW_TYPE_STICK = 2;
    protected static final int BOND_DRAW_TYPE_WIRE = 3;
    public static final int LONE_PAIR_TYPE = 130;
    protected int drawType = 2;
    public int colorType = 1;
    protected int quality = 2;
    public Palette rainbowPalette = null;
    public int startIndex = 0;
    public Palette bfactorPalette = null;
    public double ballRadius;
    public double bondRadius;
    public double stickRadius;
    public double lineWidth;
    public double jointRadius;
    public int ballPrecision;
    public int spacefillPrecision;
    public int bondSlicePrecision;
    public int stickSlicePrecision;
    public int jointPrecision;
    public boolean oldStyleStickColoring = true;
    public boolean scaledBalls;
    public boolean bondFacing = false;
    boolean displayBondOrder;
    public int bondDistance;
    public int bondWidth;
    protected UniformSphere joint = null;
    protected UniformSphere ball = null;
    protected UniformSphere spacefill = null;
    protected int jointDlist = -1;
    protected int oneJointDlist = -1;
    protected int globalBallDlist = -1;
    protected int oneBallDlist = -1;
    protected int[] ballDlists = null;
    protected int globalSpacefillDlist = -1;
    protected int oneSpacefillDlist = -1;
    protected int[] spacefillDlists = null;
    protected AromaticRings _aromaticRings = null;
    protected Bonds _bonds = null;
    protected ArrayList<IDrawable> _staticDrawables = new ArrayList();
    protected DrawableCollection _dynamicDrawables;
    protected Wire _wire;
    protected int displayList = -1;
    protected int displayList2D = -1;
    protected int selectedAtomsDlist = -1;
    public boolean drawHydrogens = true;
    public boolean drawLonePairs = true;
    protected boolean needRecreateDisplayList = true;
    protected boolean needRecreateDisplayList2D = true;
    protected boolean needRecreateWire = true;
    protected boolean needRecreateGlobalBalls = true;
    protected boolean needRecreateGlobalBonds = true;
    protected boolean needRecreateGlobalSticks = true;
    protected boolean needRecreateAromaticRings = true;
    protected boolean needRecreateGlobalSpacefills = true;
    protected boolean needRecreateJoints = true;
    protected boolean needRecreateBalls = true;
    protected boolean needRecreateBonds = true;
    protected boolean needRecreateSticks = true;
    protected boolean needRecreateSpacefills = true;
    protected boolean needRecreateOneJoint = true;
    protected boolean needRecreateOneBall = true;
    protected boolean needRecreateOneBond = true;
    protected boolean needRecreateOneStick = true;
    protected boolean needRecreateOneAromaticRing = true;
    protected boolean needRecreateOneSpacefill = true;
    protected boolean needRecreateDLists = false;
    protected boolean needRecreateCoordinateDependentLists = false;
    protected boolean needRecreateSelectionDlist = false;
    protected boolean needRecreateDynamicDrawables = true;
    protected int[] inOnePieceMatrices = null;
    protected int[] firstHalfMatrices = null;
    protected int[] secondHalfMatrices = null;
    protected boolean[] selectedAtoms = null;
    protected int[] atomDrawTypes = null;
    protected int selectedAtomCount = 0;
    protected boolean initialized = false;
    protected boolean highlighted = false;
    AromaticRing[] rings = null;
    public MoleculeIterators.MoleculeInterface molecule;
    public MoleculeIterators.AtomPropertyInterface props;
    GL gl;
    GLU glu;

    public VisibleMolecule(GL gl, GLU glu, MoleculeIterators.MoleculeInterface molecule) {
        this.gl = gl;
        this.glu = glu;
        this.molecule = molecule;
        DrawableFactory.RegisterSettingsProvider(new DefaultSettingsProvider(this));
    }

    public void onRemove() {
        if (this.inOnePieceMatrices != null) {
            int i;
            for (i = 0; i < this.inOnePieceMatrices.length; ++i) {
                GeomCalc.deleteMatrix(this.inOnePieceMatrices[i]);
            }
            if (this.firstHalfMatrices != null) {
                for (i = 0; i < this.inOnePieceMatrices.length; ++i) {
                    GeomCalc.deleteMatrix(this.firstHalfMatrices[i]);
                    GeomCalc.deleteMatrix(this.secondHalfMatrices[i]);
                }
                this.firstHalfMatrices = null;
                this.secondHalfMatrices = null;
            }
            this.inOnePieceMatrices = null;
        }
        this.deleteListIndices();
        this.selectedAtoms = null;
        this.molecule = null;
        this.props = null;
        this.ballDlists = null;
        this.spacefillDlists = null;
        this.atomDrawTypes = null;
    }

    public void init() {
        this.props = this.molecule.getAtomProperty();
        MoleculeIterators.AtomIteratorInterface atomsWithH = this.molecule.getAtomIterator(true);
        MoleculeIterators.BondIteratorInterface bondsWithH = this.molecule.getBondIterator(true);
        int maxIndex = atomsWithH.getMaxIndex();
        int i = 0;
        bondsWithH.reset();
        while (bondsWithH.hasNext()) {
            bondsWithH.next();
            ++i;
        }
        int bondCountWithH = i;
        this.selectedAtoms = new boolean[maxIndex + 1];
        this.atomDrawTypes = new int[maxIndex + 1];
        this.inOnePieceMatrices = new int[bondCountWithH];
        this.firstHalfMatrices = new int[bondCountWithH];
        this.secondHalfMatrices = new int[bondCountWithH];
        i = 0;
        bondsWithH.reset();
        while (bondsWithH.hasNext()) {
            this.inOnePieceMatrices[i] = GeomCalc.newMatrix();
            this.firstHalfMatrices[i] = GeomCalc.newMatrix();
            this.secondHalfMatrices[i] = GeomCalc.newMatrix();
            bondsWithH.next();
            ++i;
        }
        this.setListIndices(maxIndex + 1, bondCountWithH);
        this.setBondMatrices(bondsWithH);
        this.generateOneBallDlist();
        this.needRecreateOneBall = false;
        this.generateOneSpacefillDlist();
        this.needRecreateOneSpacefill = false;
        this.generateBallLists();
        this.needRecreateBalls = false;
        this.generateSpacefillLists();
        this.needRecreateSpacefills = false;
        this.initialized = true;
    }

    protected void setHighlightedMaterial() {
        this.gl.glMaterialfv(1032, 4608, Colors.yellowF, 0);
        this.gl.glMaterialfv(1032, 4610, Colors.whiteF, 0);
        this.gl.glMaterialf(1032, 5633, 30.0f);
    }

    protected void setMaterial() {
        this.gl.glMaterialfv(1032, 4608, Colors.grayF, 0);
        this.gl.glMaterialfv(1032, 4610, Colors.grayF, 0);
        this.gl.glMaterialf(1032, 5633, 100.0f);
    }

    public void drawByDrawType(GL gl) {
        if (this.highlighted) {
            this.setHighlightedMaterial();
        }
        switch (this.drawType) {
            case 2: {
                this._aromaticRings.draw();
                this._wire.draw();
                break;
            }
            case 4: {
                gl.glCallList(this.jointDlist);
                this._aromaticRings.draw();
                this._bonds.draw();
                break;
            }
            case 3: {
                gl.glCallList(this.globalBallDlist);
                break;
            }
            case 5: {
                gl.glCallList(this.globalBallDlist);
                this._aromaticRings.draw();
                this._wire.draw();
                break;
            }
            case 6: {
                gl.glCallList(this.globalBallDlist);
                this._aromaticRings.draw();
                this._bonds.draw();
                break;
            }
            case 7: {
                gl.glCallList(this.globalSpacefillDlist);
            }
        }
        gl.glCallList(this.selectedAtomsDlist);
        if (this.highlighted) {
            this.setMaterial();
        }
    }

    public void draw(GL gl) {
        if (!this.initialized) {
            this.init();
        }
        this.generateNecessaryDisplayLists();
        this.drawByDrawType(gl);
    }

    protected void glColor(Color color) {
        this.gl.glColor3f((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f);
    }

    public void drawAtomSelection(int mode, int irm) {
        double e;
        this.gl.glColor3bv(Colors.white, 0);
        double eh = 1.0;
        double sqrt2p2 = Math.sqrt(2.0) / 2.0;
        switch (this.drawType) {
            case 4: {
                e = this.stickRadius;
                break;
            }
            case 7: {
                e = PeriodicSystem.getVanDerWaalsRadius(6);
                break;
            }
            default: {
                e = this.ballRadius;
                eh = e / 2.0;
            }
        }
        double s = sqrt2p2 * e;
        double sh = s / 2.0;
        MoleculeIterators.AtomIteratorInterface ai = this.molecule.getAtomIterator(true);
        ai.reset();
        while (ai.hasNext()) {
            if (this.isAtomVisible(ai.current())) {
                if (this.drawType == 7) {
                    e = ai.getAtomType() == 130 ? PeriodicSystem.getVanDerWaalsRadius(1) : PeriodicSystem.getVanDerWaalsRadius(ai.getAtomType());
                    s = sqrt2p2 * e;
                }
                if (mode == 7170) {
                    this.gl.glPushName(ai.current());
                }
                double x = ai.getX();
                double y = ai.getY();
                double z = ai.getZ();
                this.gl.glPushMatrix();
                this.gl.glTranslated(x, y, z);
                this.gl.glMultMatrixf(GeomCalc.getMatrix(irm), 0);
                this.gl.glTranslated(-x, -y, -z);
                if (this.drawType != 4 && this.drawType != 7 && (ai.getAtomType() == 1 || ai.getAtomType() == 130)) {
                    this.gl.glBegin(6);
                    this.gl.glVertex3d(x, y, z);
                    this.gl.glVertex3d(x - eh, y, z);
                    this.gl.glVertex3d(x - sh, y - sh, z);
                    this.gl.glVertex3d(x, y - eh, z);
                    this.gl.glVertex3d(x + sh, y - sh, z);
                    this.gl.glVertex3d(x + eh, y, z);
                    this.gl.glVertex3d(x + sh, y + sh, z);
                    this.gl.glVertex3d(x, y + eh, z);
                    this.gl.glVertex3d(x - sh, y + sh, z);
                    this.gl.glVertex3d(x - eh, y, z);
                    this.gl.glEnd();
                } else {
                    this.gl.glBegin(6);
                    this.gl.glVertex3d(x, y, z);
                    this.gl.glVertex3d(x - e, y, z);
                    this.gl.glVertex3d(x - s, y - s, z);
                    this.gl.glVertex3d(x, y - e, z);
                    this.gl.glVertex3d(x + s, y - s, z);
                    this.gl.glVertex3d(x + e, y, z);
                    this.gl.glVertex3d(x + s, y + s, z);
                    this.gl.glVertex3d(x, y + e, z);
                    this.gl.glVertex3d(x - s, y + s, z);
                    this.gl.glVertex3d(x - e, y, z);
                    this.gl.glEnd();
                }
                this.gl.glPopMatrix();
                if (mode == 7170) {
                    this.gl.glPopName();
                }
            }
            ai.next();
        }
    }

    public int getDisplayList() {
        if (!this.initialized) {
            this.init();
        }
        this.generateNecessaryDisplayLists();
        return this.displayList;
    }

    public int getDisplayList2D() {
        if (!this.initialized) {
            this.init();
        }
        this.generateNecessaryDisplayLists();
        return this.displayList2D;
    }

    protected void generateDisplayList() {
        this.gl.glNewList(this.displayList, 4864);
        this.drawByDrawType(this.gl);
        this.gl.glEndList();
        this.checkErrors("generateDisplayList");
    }

    protected void generateDisplayList2D() {
    }

    protected void generateSelectionDlist() {
        this.gl.glNewList(this.selectedAtomsDlist, 4864);
        this.gl.glColor3bv(Colors.selected, 0);
        int s = 0;
        MoleculeIterators.AtomIteratorInterface ai = this.molecule.getAtomIterator(true);
        ai.reset();
        while (ai.hasNext() && s != this.selectedAtomCount) {
            if ((this.drawHydrogens || ai.getAtomType() != 1) && (this.drawLonePairs || ai.getAtomType() != 130) && this.selectedAtoms[ai.current()]) {
                if (this.drawType == 7) {
                    this.gl.glCallList(this.spacefillDlists[ai.current()]);
                } else if (this.drawType == 4 && (ai.getAtomType() == 1 || ai.getAtomType() == 130)) {
                    this.gl.glPushMatrix();
                    this.gl.glTranslated((double)ai.getX(), (double)ai.getY(), (double)ai.getZ());
                    this.gl.glCallList(this.oneJointDlist);
                    this.gl.glPopMatrix();
                } else {
                    this.gl.glCallList(this.ballDlists[ai.current()]);
                }
                ++s;
            }
            ai.next();
        }
        this.gl.glEndList();
        this.checkErrors("generateSelectionDlist");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateNecessaryDisplayLists() {
        try {
            if (this.needRecreateDynamicDrawables) {
                this._staticDrawables = new ArrayList();
            }
            this.ref_generateRendererDlists();
            if (this.needRecreateAromaticRings) {
                this.generateGlobalAromaticRingDlist();
                this.needRecreateAromaticRings = false;
            }
            if (this.drawType == 6 && this.needRecreateBonds) {
                this.ref_generateBondLists();
                this.needRecreateBonds = false;
            }
            if ((this.drawType == 2 || this.drawType == 5) && this.needRecreateWire) {
                this.ref_generateDListOfWire();
                this.needRecreateWire = false;
            }
            if (this.drawType == 4 && this.needRecreateSticks) {
                this.ref_generateStickLists();
                this.needRecreateSticks = false;
            }
            if (this.needRecreateSelectionDlist) {
                this.generateSelectionDlist();
                this.needRecreateSelectionDlist = false;
            }
            if (this.needRecreateDisplayList) {
                this.generateDisplayList();
                this.needRecreateDisplayList = false;
            }
            if (this.needRecreateDisplayList2D) {
                this.generateDisplayList2D();
                this.needRecreateDisplayList2D = false;
            }
            if (this.drawType != 7 && this.needRecreateBalls) {
                this.generateBallLists();
                this.needRecreateBalls = false;
            }
            if ((this.drawType == 3 || this.drawType == 6 || this.drawType == 5) && this.needRecreateGlobalBalls) {
                this.generateGlobalBallDlist();
                this.needRecreateGlobalBalls = false;
            }
            if (this.drawType == 6) {
                if (this.needRecreateGlobalBonds) {
                    this.needRecreateGlobalBonds = false;
                }
                return;
            }
            if (this.drawType == 7) {
                if (this.needRecreateSpacefills) {
                    this.generateSpacefillLists();
                    this.needRecreateSpacefills = false;
                }
                if (this.needRecreateGlobalSpacefills) {
                    this.generateGlobalSpacefillDlist();
                    this.needRecreateGlobalSpacefills = false;
                }
                return;
            }
            if (this.drawType == 4) {
                if (this.needRecreateGlobalSticks) {
                    this.needRecreateGlobalSticks = false;
                }
                if (this.needRecreateJoints) {
                    this.generateJointDlist();
                    this.needRecreateJoints = false;
                }
            }
        }
        finally {
            if (this.needRecreateDynamicDrawables || this._staticDrawables.size() > 0) {
                if (this._dynamicDrawables != null) {
                    this._dynamicDrawables.cleanup();
                }
                this._dynamicDrawables = new DrawableCollection(this._staticDrawables);
                this._staticDrawables.clear();
                this.needRecreateDynamicDrawables = false;
            }
        }
    }

    protected void needRecreateGlobalDLists() {
        this.needRecreateGlobalBalls = true;
        this.needRecreateGlobalBonds = true;
        this.needRecreateGlobalSpacefills = true;
        this.needRecreateGlobalSticks = true;
        this.needRecreateWire = true;
        this.needRecreateJoints = true;
    }

    protected void needRecreateOneRendererDLists() {
        this.needRecreateOneJoint = true;
        this.needRecreateOneBall = true;
        this.needRecreateOneSpacefill = true;
        this.needRecreateOneBond = true;
        this.needRecreateOneStick = true;
        this.needRecreateOneAromaticRing = true;
    }

    protected void setListIndices(int atomCountWithH, int bondCountWithH) {
        this.ballDlists = new int[atomCountWithH];
        this.spacefillDlists = new int[atomCountWithH];
        this.displayList = this.gl.glGenLists(1);
        this.displayList2D = this.gl.glGenLists(1);
        this.jointDlist = this.gl.glGenLists(1);
        this.globalBallDlist = this.gl.glGenLists(1);
        this.globalSpacefillDlist = this.gl.glGenLists(1);
        for (int i = 0; i < atomCountWithH; ++i) {
            this.ballDlists[i] = this.gl.glGenLists(1);
            this.spacefillDlists[i] = this.gl.glGenLists(1);
        }
        for (int j = 0; j < bondCountWithH; ++j) {
        }
        this.oneJointDlist = this.gl.glGenLists(1);
        this.oneBallDlist = this.gl.glGenLists(1);
        this.oneSpacefillDlist = this.gl.glGenLists(1);
        this.selectedAtomsDlist = this.gl.glGenLists(1);
        this.checkErrors("setListIndices");
    }

    protected void deleteListIndices() {
        if (this.gl == null) {
            System.out.println("GL is null in finalize, error delete display lists.");
            return;
        }
        if (this.ballDlists != null) {
            for (int i = 0; i < this.ballDlists.length; ++i) {
                this.gl.glDeleteLists(this.ballDlists[i], 1);
                this.gl.glDeleteLists(this.spacefillDlists[i], 1);
            }
        }
        this.gl.glDeleteLists(this.displayList, 1);
        this.gl.glDeleteLists(this.displayList2D, 1);
        this.gl.glDeleteLists(this.jointDlist, 1);
        this.gl.glDeleteLists(this.globalBallDlist, 1);
        this.gl.glDeleteLists(this.globalSpacefillDlist, 1);
        this.gl.glDeleteLists(this.oneJointDlist, 1);
        this.gl.glDeleteLists(this.oneBallDlist, 1);
        this.gl.glDeleteLists(this.oneSpacefillDlist, 1);
        this.gl.glDeleteLists(this.selectedAtomsDlist, 1);
        if (this._aromaticRings != null) {
            this._aromaticRings.cleanup();
        }
        if (this._bonds != null) {
            this._bonds.cleanup();
        }
        if (this._wire != null) {
            this._wire.cleanup();
        }
        if (this._dynamicDrawables != null) {
            this._dynamicDrawables.cleanup();
        }
        this._staticDrawables.clear();
    }

    protected void setBondMatrices(MoleculeIterators.BondIteratorInterface bondsWithH) {
        float[] modelview = new float[16];
        this.gl.glPushMatrix();
        this.gl.glLoadIdentity();
        int i = 0;
        int node1 = GeomCalc.newVector();
        int node2 = GeomCalc.newVector();
        bondsWithH.reset();
        while (bondsWithH.hasNext()) {
            GeomCalc.setVector(node1, bondsWithH.getX(1), bondsWithH.getY(1), bondsWithH.getZ(1));
            GeomCalc.setVector(node2, bondsWithH.getX(2), bondsWithH.getY(2), bondsWithH.getZ(2));
            double distance = GeomCalc.distance(node1, node2);
            int directionVector = GeomCalc.sub(node2, node1);
            GeomCalc.normalize(directionVector);
            double angle = Math.acos(GeomCalc.getZ(directionVector)) * 180.0 / Math.PI;
            int half = GeomCalc.half(node1, node2);
            this.gl.glPushMatrix();
            this.gl.glTranslated((double)GeomCalc.getX(node1), (double)GeomCalc.getY(node1), (double)GeomCalc.getZ(node1));
            this.gl.glRotated(angle, (double)(-GeomCalc.getY(directionVector)), (double)GeomCalc.getX(directionVector), 0.0);
            this.gl.glScaled(1.0, 1.0, distance);
            this.gl.glGetFloatv(2982, modelview, 0);
            GeomCalc.setMatrix(this.inOnePieceMatrices[i], modelview);
            this.gl.glPopMatrix();
            if (this.oldStyleStickColoring) {
                this.gl.glPushMatrix();
                this.gl.glTranslated((double)GeomCalc.getX(node1), (double)GeomCalc.getY(node1), (double)GeomCalc.getZ(node1));
                this.gl.glRotated(angle, (double)(-GeomCalc.getY(directionVector)), (double)GeomCalc.getX(directionVector), 0.0);
                this.gl.glScaled(1.0, 1.0, distance /= 2.0);
                this.gl.glGetFloatv(2982, modelview, 0);
                GeomCalc.setMatrix(this.firstHalfMatrices[i], modelview);
                this.gl.glPopMatrix();
                this.gl.glPushMatrix();
                this.gl.glTranslated((double)GeomCalc.getX(half), (double)GeomCalc.getY(half), (double)GeomCalc.getZ(half));
                this.gl.glRotated(angle, (double)(-GeomCalc.getY(directionVector)), (double)GeomCalc.getX(directionVector), 0.0);
                this.gl.glScaled(1.0, 1.0, distance);
                this.gl.glGetFloatv(2982, modelview, 0);
                GeomCalc.setMatrix(this.secondHalfMatrices[i], modelview);
                this.gl.glPopMatrix();
            }
            GeomCalc.deleteVector(directionVector);
            GeomCalc.deleteVector(half);
            bondsWithH.next();
            ++i;
        }
        this.gl.glPopMatrix();
        GeomCalc.deleteVector(node1);
        GeomCalc.deleteVector(node2);
        this.checkErrors("setBondMatrices");
    }

    protected void ref_generateDListOfWire() {
        try {
            if (this._wire != null) {
                this._wire.cleanup();
            }
            if (this._bonds != null) {
                this._bonds.cleanup();
            }
            this._wire = new Wire(this._staticDrawables, this.drawType, this.atomDrawTypes, this.molecule);
        }
        catch (Exception ex) {
            System.out.println("Exception during wire generation:\n" + ex.getMessage());
        }
        this.checkErrors("generateWire");
    }

    protected void ref_generateBondLists() {
        try {
            if (this._bonds != null) {
                this._bonds.cleanup();
            }
            if (this._wire != null) {
                this._wire.cleanup();
            }
            this._bonds = new Bonds(this._staticDrawables, this.drawType, this.atomDrawTypes, this.molecule);
        }
        catch (Exception ex) {
            System.out.println("Exception during bond generation:\n" + ex.getMessage());
        }
        this.checkErrors("generate bond/stick");
    }

    protected void ref_generateStickLists() {
        this.ref_generateBondLists();
    }

    protected void ref_generateOneBondDlist() {
        try {
            DrawableFactory.Get().CreateReferenceCylinderBond();
            DrawableFactory.Get().CreateReferenceCylinderDoubleAndTripleBond();
        }
        catch (DrawableException ex) {
            boolean bl = false;
        }
    }

    protected void ref_generateOneStickDlist() {
        try {
            DrawableFactory.Get().CreateReferenceCylinderStick();
        }
        catch (DrawableException ex) {
            boolean bl = false;
        }
    }

    private int getBondShiftingDirection(int node1, int node2, int node3) {
        if (node3 == -1) {
            return GeomCalc.newVector(1.0f, 0.0f, 0.0f);
        }
        return GeomCalc.GeomTransformations.linePerpendicularToLineInPlane(node1, node2, node3);
    }

    private boolean drawBondOnePiece(MoleculeIterators.BondIteratorInterface bi) {
        switch (this.colorType) {
            case 1: {
                return bi.getAtomType(1) == bi.getAtomType(2);
            }
            case 3: {
                return bi.getResidueType(1) == bi.getResidueType(2);
            }
            case 12: {
                return this.props.getBFactor(bi.getAtomIndex(1)) == this.props.getBFactor(bi.getAtomIndex(2));
            }
        }
        return true;
    }

    protected void drawWire() {
        this.gl.glDisable(2896);
        this.gl.glEnable(3042);
        if (this.highlighted) {
            this.gl.glLineWidth((float)this.lineWidth + 1.0f);
        } else {
            this.gl.glLineWidth((float)this.lineWidth);
        }
        if (this.colorType == 2) {
            this.glColor(((MacroMoleculeComponent.MoleculeVisualizer)((Object)this.molecule)).getColor());
        }
        int node1 = GeomCalc.newVector();
        int node2 = GeomCalc.newVector();
        int node3 = GeomCalc.newVector();
        this.gl.glLineStipple(1, (short)-3856);
        MoleculeIterators.BondIteratorInterface bi = this.molecule.getBondIterator(true);
        boolean[] lonelyAtoms = new boolean[this.atomDrawTypes.length];
        Arrays.fill(lonelyAtoms, true);
        bi.reset();
        while (bi.hasNext()) {
            if (this.atomDrawTypes[bi.getAtomIndex(1)] != -1 && this.atomDrawTypes[bi.getAtomIndex(2)] != -1) {
                GeomCalc.setVector(node1, bi.getX(1), bi.getY(1), bi.getZ(1));
                GeomCalc.setVector(node2, bi.getX(2), bi.getY(2), bi.getZ(2));
                GeomCalc.setVector(node3, bi.getX(0), bi.getY(0), bi.getZ(0));
                if ((this.drawHydrogens || bi.getAtomType(1) != 1 && bi.getAtomType(2) != 1) && (this.drawLonePairs || bi.getAtomType(1) != 130 && bi.getAtomType(2) != 130)) {
                    lonelyAtoms[bi.getAtomIndex((int)1)] = false;
                    lonelyAtoms[bi.getAtomIndex((int)2)] = false;
                    if (this.displayBondOrder && bi.getBondType() == 2) {
                        int bondDirection = this.getBondShiftingDirection(node1, node2, node3);
                        GeomCalc.scale(bondDirection, (float)(this.bondRadius * (double)this.bondDistance / 100.0));
                        this.gl.glPushMatrix();
                        this.gl.glTranslated((double)GeomCalc.getX(bondDirection), (double)GeomCalc.getY(bondDirection), (double)GeomCalc.getZ(bondDirection));
                        this.gl.glBegin(1);
                        this.setColor(bi, 1);
                        this.gl.glVertex3fv(GeomCalc.getVector(node1), 0);
                        this.setColor(bi, 2);
                        this.gl.glVertex3fv(GeomCalc.getVector(node2), 0);
                        this.gl.glEnd();
                        this.gl.glTranslated((double)(-2.0f * GeomCalc.getX(bondDirection)), (double)(-2.0f * GeomCalc.getY(bondDirection)), (double)(-2.0f * GeomCalc.getZ(bondDirection)));
                        this.gl.glBegin(1);
                        this.setColor(bi, 1);
                        this.gl.glVertex3fv(GeomCalc.getVector(node1), 0);
                        this.setColor(bi, 2);
                        this.gl.glVertex3fv(GeomCalc.getVector(node2), 0);
                        this.gl.glEnd();
                        this.gl.glPopMatrix();
                        GeomCalc.deleteVector(bondDirection);
                    } else {
                        if (this.displayBondOrder && bi.getBondType() == 4) {
                            this.gl.glEnable(2852);
                        }
                        this.gl.glBegin(1);
                        this.setColor(bi, 1);
                        this.gl.glVertex3fv(GeomCalc.getVector(node1), 0);
                        this.setColor(bi, 2);
                        this.gl.glVertex3fv(GeomCalc.getVector(node2), 0);
                        this.gl.glEnd();
                        if (this.displayBondOrder && bi.getBondType() == 4) {
                            this.gl.glDisable(2852);
                        }
                    }
                }
            }
            bi.next();
        }
        MoleculeIterators.AtomIteratorInterface ai = this.molecule.getAtomIterator(true);
        ai.reset();
        while (ai.hasNext()) {
            if (lonelyAtoms[ai.current()] && (this.drawHydrogens || ai.getAtomType() != 1) && (this.drawLonePairs || ai.getAtomType() != 130) && this.atomDrawTypes[ai.current()] != -1 && this.atomDrawTypes[ai.current()] != -2) {
                this.gl.glPushMatrix();
                this.gl.glTranslated((double)ai.getX(), (double)ai.getY(), (double)ai.getZ());
                this.gl.glBegin(1);
                this.gl.glVertex3d(this.ballRadius, 0.0, 0.0);
                this.gl.glVertex3d(-this.ballRadius, 0.0, 0.0);
                this.gl.glVertex3d(0.0, this.ballRadius, 0.0);
                this.gl.glVertex3d(0.0, -this.ballRadius, 0.0);
                this.gl.glVertex3d(0.0, 0.0, this.ballRadius);
                this.gl.glVertex3d(0.0, 0.0, -this.ballRadius);
                this.gl.glEnd();
                this.gl.glPopMatrix();
            }
            ai.next();
        }
        GeomCalc.deleteVector(node1);
        GeomCalc.deleteVector(node2);
        GeomCalc.deleteVector(node3);
        this.gl.glDisable(3042);
        this.gl.glEnable(2896);
        this.gl.glLineWidth(1.0f);
    }

    protected void drawBondLike(int type, MoleculeIterators.BondIteratorInterface bi, int edgeIndex, Cylinder bondLike) {
        if (this.displayBondOrder && type == 1 && bi.getBondType() == 2) {
            int node1 = GeomCalc.newVector(bi.getX(1), bi.getY(1), bi.getZ(1));
            int node2 = GeomCalc.newVector(bi.getX(2), bi.getY(2), bi.getZ(2));
            int node3 = GeomCalc.newVector(bi.getX(0), bi.getY(0), bi.getZ(0));
            int bondDirection = this.getBondShiftingDirection(node1, node2, node3);
            GeomCalc.deleteVector(node1);
            GeomCalc.deleteVector(node2);
            GeomCalc.deleteVector(node3);
            GeomCalc.scale(bondDirection, (float)(this.bondRadius * (double)this.bondDistance / 100.0));
            this.gl.glPushMatrix();
            this.gl.glTranslated((double)GeomCalc.getX(bondDirection), (double)GeomCalc.getY(bondDirection), (double)GeomCalc.getZ(bondDirection));
            this.gl.glMultMatrixf(GeomCalc.getMatrix(this.inOnePieceMatrices[edgeIndex]), 0);
            if (type == 1) {
                this.gl.glScaled((double)this.bondWidth / 100.0, (double)this.bondWidth / 100.0, 1.0);
            }
            byte[] c1 = this.getColor(bi, 1);
            byte[] c2 = this.getColor(bi, 2);
            bondLike.draw(this.gl, c1, c2);
            this.gl.glPopMatrix();
            this.gl.glPushMatrix();
            this.gl.glTranslated((double)(-GeomCalc.getX(bondDirection)), (double)(-GeomCalc.getY(bondDirection)), (double)(-GeomCalc.getZ(bondDirection)));
            this.gl.glMultMatrixf(GeomCalc.getMatrix(this.inOnePieceMatrices[edgeIndex]), 0);
            if (type == 1) {
                this.gl.glScaled((double)this.bondWidth / 100.0, (double)this.bondWidth / 100.0, 1.0);
            }
            c1 = this.getColor(bi, 1);
            c2 = this.getColor(bi, 2);
            bondLike.draw(this.gl, c1, c2);
            this.gl.glPopMatrix();
            GeomCalc.deleteVector(bondDirection);
        } else {
            this.gl.glPushMatrix();
            this.gl.glMultMatrixf(GeomCalc.getMatrix(this.inOnePieceMatrices[edgeIndex]), 0);
            byte[] c1 = this.getColor(bi, 1);
            byte[] c2 = this.getColor(bi, 2);
            bondLike.draw(this.gl, c1, c2);
            this.gl.glPopMatrix();
        }
    }

    protected void generateGlobalBallDlist() {
        this.gl.glNewList(this.globalBallDlist, 4864);
        this.glColor(((MacroMoleculeComponent.MoleculeVisualizer)((Object)this.molecule)).getColor());
        MoleculeIterators.AtomIteratorInterface ai = this.molecule.getAtomIterator(true);
        ai.reset();
        while (ai.hasNext()) {
            if ((this.drawHydrogens || ai.getAtomType() != 1) && (this.drawLonePairs || ai.getAtomType() != 130) && this.atomDrawTypes[ai.current()] != -1) {
                this.setColor(ai);
                this.gl.glCallList(this.ballDlists[ai.current()]);
            }
            ai.next();
        }
        this.gl.glEndList();
        this.checkErrors("GenerateGlobalBalls");
    }

    protected void generateGlobalSpacefillDlist() {
        this.gl.glNewList(this.globalSpacefillDlist, 4864);
        this.glColor(((MacroMoleculeComponent.MoleculeVisualizer)((Object)this.molecule)).getColor());
        MoleculeIterators.AtomIteratorInterface ai = this.molecule.getAtomIterator(true);
        ai.reset();
        while (ai.hasNext()) {
            if ((this.drawHydrogens || ai.getAtomType() != 1) && (this.drawLonePairs || ai.getAtomType() != 130) && this.atomDrawTypes[ai.current()] != -1) {
                this.setColor(ai);
                this.gl.glCallList(this.spacefillDlists[ai.current()]);
            }
            ai.next();
        }
        this.gl.glEndList();
        this.checkErrors("generate globalSpacefill");
    }

    protected void generateJointDlist() {
        this.gl.glNewList(this.jointDlist, 4864);
        this.glColor(((MacroMoleculeComponent.MoleculeVisualizer)((Object)this.molecule)).getColor());
        MoleculeIterators.AtomIteratorInterface ai = this.molecule.getAtomIterator(true);
        ai.reset();
        while (ai.hasNext()) {
            if ((this.drawHydrogens || ai.getAtomType() != 1) && (this.drawLonePairs || ai.getAtomType() != 130) && this.atomDrawTypes[ai.current()] != -1) {
                this.setColor(ai);
                this.gl.glPushMatrix();
                this.gl.glTranslated((double)ai.getX(), (double)ai.getY(), (double)ai.getZ());
                this.gl.glCallList(this.oneJointDlist);
                this.gl.glPopMatrix();
            }
            ai.next();
        }
        this.gl.glEndList();
        this.checkErrors("generate joints");
    }

    protected void generateGlobalAromaticRingDlist() {
        MacroMoleculeComponent.MoleculeVisualizer mi = (MacroMoleculeComponent.MoleculeVisualizer)((Object)this.molecule);
        MacroMoleculeComponent mmc = mi.getMacroMoleculeComponent();
        Molecule mol = mmc == null ? ((MoleculeComponent)this.molecule).getMolecule() : mmc.getMolecule();
        try {
            if (this._aromaticRings != null) {
                this._aromaticRings.cleanup();
            }
            this._aromaticRings = new AromaticRings(this.drawType, mol);
        }
        catch (Exception ex) {
            System.out.println("Exception during aromatic ring generation:\n" + ex.getMessage());
        }
        this.checkErrors("generate global aromatic ring");
    }

    protected void generateBallLists() {
        MoleculeIterators.AtomIteratorInterface ai = this.molecule.getAtomIterator(true);
        ai.reset();
        while (ai.hasNext()) {
            this.gl.glNewList(this.ballDlists[ai.current()], 4864);
            this.drawBall(ai);
            this.gl.glEndList();
            ai.next();
        }
        this.checkErrors("generate ball");
    }

    protected void drawBall(MoleculeIterators.AtomIteratorInterface ai) {
        this.gl.glPushMatrix();
        this.gl.glTranslated((double)ai.getX(), (double)ai.getY(), (double)ai.getZ());
        if (this.scaledBalls) {
            double f = PeriodicSystem.getAtomicRadius(ai.getAtomType());
            if (ai.getAtomType() == 130) {
                f = 0.5;
            }
            this.gl.glScaled(f, f, f);
        } else if (ai.getAtomType() == 1 || ai.getAtomType() == 130) {
            this.gl.glScaled(0.5, 0.5, 0.5);
        }
        this.gl.glCallList(this.oneBallDlist);
        this.gl.glPopMatrix();
    }

    protected void generateSpacefillLists() {
        MoleculeIterators.AtomIteratorInterface ai = this.molecule.getAtomIterator(true);
        ai.reset();
        while (ai.hasNext()) {
            this.gl.glNewList(this.spacefillDlists[ai.current()], 4864);
            this.drawSpacefill(ai);
            this.gl.glEndList();
            ai.next();
        }
        this.checkErrors("generate spacefill");
    }

    protected void drawSpacefill(MoleculeIterators.AtomIteratorInterface ai) {
        this.gl.glPushMatrix();
        this.gl.glTranslated((double)ai.getX(), (double)ai.getY(), (double)ai.getZ());
        double factor = PeriodicSystem.getVanDerWaalsRadius(ai.getAtomType());
        if (ai.getAtomType() == 130) {
            factor = PeriodicSystem.getVanDerWaalsRadius(1);
        }
        this.gl.glScaled(factor, factor, factor);
        this.gl.glCallList(this.oneSpacefillDlist);
        this.gl.glPopMatrix();
    }

    protected void generateAromaticringList() {
    }

    protected void ref_generateRendererDlists() {
        try {
            if (this.needRecreateOneJoint) {
                DrawableFactory.Get().CreateReferenceJoint();
                this.generateOneJointDlist();
                this.needRecreateOneJoint = false;
            }
            if (this.needRecreateOneBall) {
                this.generateOneBallDlist();
                this.needRecreateOneBall = false;
            }
            if (this.needRecreateOneSpacefill) {
                this.generateOneSpacefillDlist();
                this.needRecreateOneSpacefill = false;
            }
            if (this.needRecreateOneBond) {
                this.ref_generateOneBondDlist();
                this.needRecreateOneBond = false;
            }
            if (this.needRecreateOneStick) {
                this.ref_generateOneStickDlist();
                this.needRecreateOneStick = false;
            }
            if (this.needRecreateOneAromaticRing) {
                this.generateGlobalAromaticRingDlist();
                this.needRecreateOneAromaticRing = false;
            }
        }
        catch (DrawableException ex) {
            System.out.println(ex);
        }
    }

    protected void generateRendererDlists() {
        if (this.needRecreateOneJoint) {
            this.generateOneJointDlist();
            this.needRecreateOneJoint = false;
        }
        if (this.needRecreateOneBall) {
            this.generateOneBallDlist();
            this.needRecreateOneBall = false;
        }
        if (this.needRecreateOneSpacefill) {
            this.generateOneSpacefillDlist();
            this.needRecreateOneSpacefill = false;
        }
        if (this.needRecreateOneAromaticRing) {
            this.generateGlobalAromaticRingDlist();
            this.needRecreateOneAromaticRing = false;
        }
    }

    protected void generateOneJointDlist() {
        this.joint = Renderer.spheres.getUniformSphere(this.jointPrecision, (float)this.jointRadius);
        this.joint.generateRendererDisplayList(this.oneJointDlist, this.gl);
    }

    protected void generateOneBallDlist() {
        this.ball = Renderer.spheres.getUniformSphere(this.ballPrecision, (float)this.ballRadius);
        this.ball.generateRendererDisplayList(this.oneBallDlist, this.gl);
    }

    protected void generateOneSpacefillDlist() {
        this.spacefill = Renderer.spheres.getUniformSphere(this.spacefillPrecision, 1.0f);
        this.spacefill.generateRendererDisplayList(this.oneSpacefillDlist, this.gl);
    }

    public void location(int vector) {
    }

    public void orientation(int vector, double[] center) {
    }

    public void setColor(MoleculeIterators.AtomIteratorInterface ai) {
        if (this.isAtomFaded(ai.current())) {
            this.gl.glColor3bv(Colors.gray, 0);
        } else if (this.colorType == 1) {
            this.gl.glColor3bv(Colors.getCPKByteColor(ai.getAtomType()), 0);
        } else if (this.colorType == 3) {
            if (!(ai instanceof MacroMolecule.Polymer.AtomIterator)) {
                this.glColor(((MacroMoleculeComponent.MoleculeVisualizer)((Object)this.molecule)).getColor());
                return;
            }
            MacroMolecule.Polymer.AtomIterator atomIterator = (MacroMolecule.Polymer.AtomIterator)ai;
            this.gl.glColor3bv(Colors.getResidueByteColor(atomIterator.getResidueType()), 0);
        } else if (this.colorType == 4) {
            int cn = ((PolymerVisualizer)this.molecule).getChainNumber();
            this.gl.glColor3bv(Colors.getChainColor(cn), 0);
        } else if (this.colorType == 5) {
            this.gl.glColor3bv(Colors.getSecondaryTypeColor(ai.getSecondaryStructureType()), 0);
        } else if (this.colorType == 11 && ai instanceof MacroMolecule.Protein.AtomIterator && this.rainbowPalette != null) {
            int i = 0;
            MacroMolecule.Protein protein = (MacroMolecule.Protein)((PolymerVisualizer)this.molecule).getPolymer();
            MacroMolecule.Protein.CAlphaAtomIterator atoms = protein.getCAlphaAtomIterator();
            ((MacroMolecule.Polymer.AtomIterator)atoms).reset();
            while (((MacroMolecule.Polymer.AtomIterator)atoms).hasNext()) {
                if (atoms.sameResidue(((MacroMolecule.Polymer.AtomIterator)atoms).current(), ai.current())) {
                    this.gl.glColor3bv(this.rainbowPalette.getByteColor(this.startIndex + i), 0);
                    return;
                }
                ((MacroMolecule.Polymer.AtomIterator)atoms).next();
                ++i;
            }
        } else if (this.colorType == 12 && this.bfactorPalette != null) {
            float bf = ((PolymerVisualizer)this.molecule).getAtomProperty().getBFactor(ai.current());
            this.gl.glColor3bv(this.bfactorPalette.getByteColor(bf), 0);
        }
    }

    public void setColor(MoleculeIterators.BondIteratorInterface bi, int which) {
        if (this.isAtomFaded(bi.getAtomIndex(which))) {
            this.gl.glColor3bv(Colors.gray, 0);
        } else if (this.colorType == 1) {
            this.gl.glColor3bv(Colors.getCPKByteColor(bi.getAtomType(which)), 0);
        } else if (this.colorType == 3) {
            if (!(bi instanceof MacroMolecule.Polymer.BondIterator)) {
                this.glColor(((MacroMoleculeComponent.MoleculeVisualizer)((Object)this.molecule)).getColor());
                return;
            }
            MacroMolecule.Polymer.BondIterator bondIterator = (MacroMolecule.Polymer.BondIterator)bi;
            this.gl.glColor3bv(Colors.getResidueByteColor(bondIterator.getResidueType(which)), 0);
        } else if (this.colorType == 4) {
            int cn = ((PolymerVisualizer)this.molecule).getChainNumber();
            this.gl.glColor3bv(Colors.getChainColor(cn), 0);
        } else if (this.colorType == 5) {
            this.gl.glColor3bv(Colors.getSecondaryTypeColor(bi.getSecondaryStructureType(which)), 0);
        } else if (this.colorType == 11 && bi instanceof MacroMolecule.Protein.BondIterator && this.rainbowPalette != null) {
            int i = 0;
            MacroMolecule.Protein protein = (MacroMolecule.Protein)((PolymerVisualizer)this.molecule).getPolymer();
            MacroMolecule.Protein.CAlphaAtomIterator atoms = protein.getCAlphaAtomIterator();
            ((MacroMolecule.Polymer.AtomIterator)atoms).reset();
            while (((MacroMolecule.Polymer.AtomIterator)atoms).hasNext()) {
                if (atoms.sameResidue(((MacroMolecule.Polymer.AtomIterator)atoms).current(), bi.getAtomIndex(1))) {
                    this.gl.glColor3bv(this.rainbowPalette.getByteColor(this.startIndex + i), 0);
                    return;
                }
                ((MacroMolecule.Polymer.AtomIterator)atoms).next();
                ++i;
            }
        } else if (this.colorType == 12 && this.bfactorPalette != null) {
            float bf = ((PolymerVisualizer)this.molecule).getAtomProperty().getBFactor(bi.getAtomIndex(which));
            this.gl.glColor3bv(this.bfactorPalette.getByteColor(bf), 0);
        }
    }

    public byte[] getColor(MoleculeIterators.BondIteratorInterface bi, int which) {
        if (this.colorType == 2) {
            Color color = ((MacroMoleculeComponent.MoleculeVisualizer)((Object)this.molecule)).getColor();
            byte[] ret = new byte[]{(byte)(color.getRed() / 2), (byte)(color.getGreen() / 2), (byte)(color.getBlue() / 2)};
            return ret;
        }
        if (this.colorType == 1) {
            return Colors.getCPKByteColor(bi.getAtomType(which));
        }
        if (this.colorType == 3) {
            if (!(bi instanceof MacroMolecule.Polymer.BondIterator)) {
                Color color = ((MacroMoleculeComponent.MoleculeVisualizer)((Object)this.molecule)).getColor();
                byte[] ret = new byte[]{(byte)(color.getRed() / 2), (byte)(color.getGreen() / 2), (byte)(color.getBlue() / 2)};
                return ret;
            }
            MacroMolecule.Polymer.BondIterator bondIterator = (MacroMolecule.Polymer.BondIterator)bi;
            return Colors.getResidueByteColor(bondIterator.getResidueType(which));
        }
        if (this.colorType == 4) {
            int cn = ((PolymerVisualizer)this.molecule).getChainNumber();
            return Colors.getChainColor(cn);
        }
        if (this.colorType == 5) {
            if (!(bi instanceof MacroMolecule.Polymer.BondIterator)) {
                Color color = ((MacroMoleculeComponent.MoleculeVisualizer)((Object)this.molecule)).getColor();
                byte[] ret = new byte[]{(byte)(color.getRed() / 2), (byte)(color.getGreen() / 2), (byte)(color.getBlue() / 2)};
                return ret;
            }
            MacroMolecule.Polymer.BondIterator bondIterator = (MacroMolecule.Polymer.BondIterator)bi;
            return Colors.getResidueByteColor(bondIterator.getSecondaryStructureType(which));
        }
        if (this.colorType == 12 && this.bfactorPalette != null) {
            float bf = ((PolymerVisualizer)this.molecule).getAtomProperty().getBFactor(bi.getAtomIndex(which));
            return this.bfactorPalette.getByteColor(bf);
        }
        return Colors.silver;
    }

    public void qualityChanged() {
        try {
            DrawableFactory.Get().CreateReferenceBall();
            DrawableFactory.Get().CreateReferenceCylinderBond();
            DrawableFactory.Get().CreateReferenceCylinderDoubleAndTripleBond();
            DrawableFactory.Get().CreateReferenceCylinderStick();
            DrawableFactory.Get().CreateReferenceJoint();
        }
        catch (DrawableException ex) {
            boolean bl = false;
        }
        this.needRecreateOneRendererDLists();
        this.needRecreateDisplayList = true;
        this.needRecreateSticks = true;
        this.needRecreateBonds = true;
        this.needRecreateAromaticRings = true;
        this.needRecreateDynamicDrawables = true;
    }

    public void showHydrogensChanged() {
        this.needRecreateGlobalDLists();
        this.needRecreateDisplayList = true;
        this.needRecreateSelectionDlist = true;
        this.needRecreateBonds = true;
        this.needRecreateSticks = true;
        this.needRecreateDynamicDrawables = true;
    }

    public void colorTypeChanged() {
        this.needRecreateGlobalDLists();
        this.needRecreateDisplayList = true;
        this.needRecreateDynamicDrawables = true;
        this.needRecreateSticks = true;
        this.needRecreateBonds = true;
        this.needRecreateAromaticRings = true;
        if (this.selectedAtomCount > 0) {
            this.needRecreateSelectionDlist = true;
        }
    }

    public void drawTypeChanged() {
        this.needRecreateDynamicDrawables = true;
        this.needRecreateDisplayList = true;
        this.needRecreateSelectionDlist = true;
        this.needRecreateAromaticRings = true;
        this.needRecreateBonds = true;
        this.needRecreateSticks = true;
        this.needRecreateWire = true;
    }

    public void stickStyleChanged() {
        if (!this.oldStyleStickColoring || this.firstHalfMatrices == null) {
            // empty if block
        }
        this.needRecreateDisplayList = true;
        this.needRecreateDynamicDrawables = true;
        this.needRecreateBonds = true;
        this.needRecreateSticks = true;
        this.needRecreateWire = true;
        this.needRecreateAromaticRings = true;
    }

    public void coordinatesChanged() {
        this.setBondMatrices(this.molecule.getBondIterator(true));
        this.needRecreateSticks = true;
        this.needRecreateBonds = true;
        this.needRecreateDisplayList = true;
        this.needRecreateBalls = true;
        this.needRecreateSpacefills = true;
        this.needRecreateWire = true;
        this.needRecreateJoints = true;
        this.needRecreateAromaticRings = true;
        this.needRecreateDynamicDrawables = true;
    }

    public boolean isAtomVisible(int i) {
        if (!this.drawHydrogens && this.props.getType(i) == 1) {
            return false;
        }
        if (!this.drawLonePairs && this.props.getType(i) == 130) {
            return false;
        }
        return this.atomDrawTypes[i] != -1 && this.atomDrawTypes[i] != -2;
    }

    public boolean isAtomFaded(int i) {
        return this.atomDrawTypes[i] == -2;
    }

    public int getAtomDrawType(int i) {
        return this.atomDrawTypes[i];
    }

    public void setAtomDrawType(int i, int dt) {
        if (dt == -2 || this.atomDrawTypes[i] == -2) {
            this.needRecreateBonds = true;
            this.needRecreateSticks = true;
        }
        this.atomDrawTypes[i] = dt;
        this.needRecreateGlobalDLists();
    }

    public void selectAtom(int i) {
        if (!this.selectedAtoms[i]) {
            this.selectedAtoms[i] = true;
            ++this.selectedAtomCount;
            this.needRecreateSelectionDlist = true;
        }
    }

    public void unSelectAtom(int i) {
        if (this.selectedAtoms[i]) {
            this.selectedAtoms[i] = false;
            --this.selectedAtomCount;
            this.needRecreateSelectionDlist = true;
        }
    }

    public int selectedAtomCount() {
        return this.selectedAtomCount;
    }

    public boolean isSelectedAtom(int i) {
        return this.selectedAtoms[i];
    }

    public boolean isHighlighted() {
        return this.highlighted;
    }

    public void setHighlighted(boolean state) {
        if (this.highlighted == state) {
            return;
        }
        this.highlighted = state;
        this.needRecreateDisplayList = true;
        this.needRecreateWire = true;
    }

    private void checkErrors(String caller) {
        int errorCode = this.gl.glGetError();
        String errorString = this.glu.gluErrorString(errorCode);
        if (errorString != null && !errorString.equals("no error")) {
            System.out.println("  >>>  " + caller + ": " + errorString + "  <<<  ");
        }
    }

    protected void drawOldStyleWire() {
        this.gl.glDisable(2896);
        this.gl.glEnable(3042);
        if (this.highlighted) {
            this.gl.glLineWidth((float)this.lineWidth + 1.0f);
        } else {
            this.gl.glLineWidth((float)this.lineWidth);
        }
        if (this.colorType == 2) {
            this.glColor(((MacroMoleculeComponent.MoleculeVisualizer)((Object)this.molecule)).getColor());
        }
        int node1 = GeomCalc.newVector();
        int node2 = GeomCalc.newVector();
        int node3 = GeomCalc.newVector();
        MoleculeIterators.BondIteratorInterface bi = this.molecule.getBondIterator(true);
        boolean[] lonelyAtoms = new boolean[this.atomDrawTypes.length];
        Arrays.fill(lonelyAtoms, true);
        this.gl.glLineStipple(1, (short)-3856);
        bi.reset();
        while (bi.hasNext()) {
            if (this.atomDrawTypes[bi.getAtomIndex(1)] != -1 && this.atomDrawTypes[bi.getAtomIndex(2)] != -1) {
                GeomCalc.setVector(node1, bi.getX(1), bi.getY(1), bi.getZ(1));
                GeomCalc.setVector(node2, bi.getX(2), bi.getY(2), bi.getZ(2));
                if (Double.isNaN(bi.getX(0))) {
                    GeomCalc.setVector(node3, bi.getX(1) + bi.getX(2), bi.getY(1) + bi.getY(2), bi.getZ(1) + bi.getZ(2));
                } else {
                    GeomCalc.setVector(node3, bi.getX(0), bi.getY(0), bi.getZ(0));
                }
                int half = GeomCalc.half(node1, node2);
                if ((this.drawHydrogens || bi.getAtomType(1) != 1 && bi.getAtomType(2) != 1) && (this.drawLonePairs || bi.getAtomType(1) != 130 && bi.getAtomType(2) != 130)) {
                    int bondDirection;
                    lonelyAtoms[bi.getAtomIndex((int)1)] = false;
                    lonelyAtoms[bi.getAtomIndex((int)2)] = false;
                    if (this.displayBondOrder && bi.getBondType() == 2) {
                        bondDirection = this.getBondShiftingDirection(node1, node2, node3);
                        GeomCalc.scale(bondDirection, (float)(this.bondRadius * (double)this.bondDistance / 100.0));
                        if (this.drawBondOnePiece(bi)) {
                            this.gl.glPushMatrix();
                            this.gl.glTranslated((double)GeomCalc.getX(bondDirection), (double)GeomCalc.getY(bondDirection), (double)GeomCalc.getZ(bondDirection));
                            this.setColor(bi, 1);
                            this.drawLine(node1, node2);
                            this.gl.glTranslated((double)(-2.0f * GeomCalc.getX(bondDirection)), (double)(-2.0f * GeomCalc.getY(bondDirection)), (double)(-2.0f * GeomCalc.getZ(bondDirection)));
                            this.drawLine(node1, node2);
                            this.gl.glPopMatrix();
                        } else {
                            this.gl.glPushMatrix();
                            this.gl.glTranslated((double)GeomCalc.getX(bondDirection), (double)GeomCalc.getY(bondDirection), (double)GeomCalc.getZ(bondDirection));
                            this.setColor(bi, 1);
                            this.drawLine(node1, half);
                            this.setColor(bi, 2);
                            this.drawLine(half, node2);
                            this.gl.glTranslated((double)(-2.0f * GeomCalc.getX(bondDirection)), (double)(-2.0f * GeomCalc.getY(bondDirection)), (double)(-2.0f * GeomCalc.getZ(bondDirection)));
                            this.setColor(bi, 1);
                            this.drawLine(node1, half);
                            this.setColor(bi, 2);
                            this.drawLine(half, node2);
                            this.gl.glPopMatrix();
                        }
                        GeomCalc.deleteVector(bondDirection);
                    } else if (this.displayBondOrder && bi.getBondType() == 3) {
                        bondDirection = this.getBondShiftingDirection(node1, node2, node3);
                        GeomCalc.scale(bondDirection, (float)(this.bondRadius * (double)this.bondDistance / 100.0));
                        if (this.drawBondOnePiece(bi)) {
                            this.gl.glPushMatrix();
                            this.setColor(bi, 1);
                            this.drawLine(node1, node2);
                            this.gl.glTranslated((double)GeomCalc.getX(bondDirection), (double)GeomCalc.getY(bondDirection), (double)GeomCalc.getZ(bondDirection));
                            this.drawLine(node1, node2);
                            this.gl.glTranslated((double)(-2.0f * GeomCalc.getX(bondDirection)), (double)(-2.0f * GeomCalc.getY(bondDirection)), (double)(-2.0f * GeomCalc.getZ(bondDirection)));
                            this.drawLine(node1, node2);
                            this.gl.glPopMatrix();
                        } else {
                            this.gl.glPushMatrix();
                            this.setColor(bi, 1);
                            this.drawLine(node1, half);
                            this.setColor(bi, 2);
                            this.drawLine(half, node2);
                            this.gl.glTranslated((double)GeomCalc.getX(bondDirection), (double)GeomCalc.getY(bondDirection), (double)GeomCalc.getZ(bondDirection));
                            this.setColor(bi, 1);
                            this.drawLine(node1, half);
                            this.setColor(bi, 2);
                            this.drawLine(half, node2);
                            this.gl.glTranslated((double)(-2.0f * GeomCalc.getX(bondDirection)), (double)(-2.0f * GeomCalc.getY(bondDirection)), (double)(-2.0f * GeomCalc.getZ(bondDirection)));
                            this.setColor(bi, 1);
                            this.drawLine(node1, half);
                            this.setColor(bi, 2);
                            this.drawLine(half, node2);
                            this.gl.glPopMatrix();
                        }
                        GeomCalc.deleteVector(bondDirection);
                    } else {
                        if (this.displayBondOrder && bi.getBondType() == 4) {
                            this.gl.glEnable(2852);
                        }
                        if (this.drawBondOnePiece(bi)) {
                            this.setColor(bi, 1);
                            this.drawLine(node1, node2);
                        } else {
                            this.setColor(bi, 1);
                            this.drawLine(node1, half);
                            this.setColor(bi, 2);
                            this.drawLine(half, node2);
                        }
                        if (this.displayBondOrder && bi.getBondType() == 4) {
                            this.gl.glDisable(2852);
                        }
                    }
                    GeomCalc.deleteVector(half);
                }
            }
            bi.next();
        }
        MoleculeIterators.AtomIteratorInterface ai = this.molecule.getAtomIterator(true);
        ai.reset();
        while (ai.hasNext()) {
            if (lonelyAtoms[ai.current()] && (this.drawHydrogens || ai.getAtomType() != 1) && (this.drawLonePairs || ai.getAtomType() != 130) && this.atomDrawTypes[ai.current()] != -1) {
                this.setColor(ai);
                this.gl.glPushMatrix();
                this.gl.glTranslated((double)ai.getX(), (double)ai.getY(), (double)ai.getZ());
                this.gl.glBegin(1);
                this.gl.glVertex3d(this.ballRadius, 0.0, 0.0);
                this.gl.glVertex3d(-this.ballRadius, 0.0, 0.0);
                this.gl.glVertex3d(0.0, this.ballRadius, 0.0);
                this.gl.glVertex3d(0.0, -this.ballRadius, 0.0);
                this.gl.glVertex3d(0.0, 0.0, this.ballRadius);
                this.gl.glVertex3d(0.0, 0.0, -this.ballRadius);
                this.gl.glEnd();
                this.gl.glPopMatrix();
            }
            ai.next();
        }
        GeomCalc.deleteVector(node1);
        GeomCalc.deleteVector(node2);
        GeomCalc.deleteVector(node3);
        this.gl.glDisable(3042);
        this.gl.glEnable(2896);
        this.gl.glLineWidth(1.0f);
    }

    private void drawLine(int n1, int n2) {
        this.gl.glBegin(1);
        this.gl.glVertex3fv(GeomCalc.getVector(n1), 0);
        this.gl.glVertex3fv(GeomCalc.getVector(n2), 0);
        this.gl.glEnd();
    }

    private void findAromaticRings() {
        int i;
        if (!(this.molecule instanceof MoleculeComponent)) {
            return;
        }
        Molecule oldmol = ((MoleculeComponent)this.molecule).getMolecule().cloneMolecule();
        Molecule mol = ((MoleculeComponent)this.molecule).getMolecule().cloneMolecule();
        for (i = 0; i < mol.getBondCount(); ++i) {
            if (mol.getBond(i).getType() == 4) continue;
            mol.removeBond(mol.getBond(i));
        }
        for (i = 0; i < mol.getAtomCount(); ++i) {
            if (mol.getAtom(i).getBondCount() != 0) continue;
            mol.removeAtom(mol.getAtom(i));
        }
        int[][] sssr = mol.getSSSR();
        this.rings = new AromaticRing[sssr.length];
        for (int i2 = 0; i2 < sssr.length; ++i2) {
            this.rings[i2] = new AromaticRing(sssr[i2].length);
            for (int j = 0; j < sssr[i2].length; ++j) {
                this.rings[i2].set(j, mol.getAtom(sssr[i2][j]));
            }
            this.rings[i2].computeGeometry();
        }
    }

    private void drawAromaticRing() {
        if (this.rings == null) {
            return;
        }
        this.gl.glDisable(2896);
        this.gl.glEnable(3042);
        for (int i = 0; i < this.rings.length; ++i) {
            this.rings[i].drawRing();
        }
        this.gl.glDisable(3042);
        this.gl.glEnable(2896);
    }

    public void draw() {
        if (this.gl.glIsList(this.getDisplayList())) {
            this.gl.glPushMatrix();
            this.gl.glCallList(this.getDisplayList());
            this.gl.glPopMatrix();
        }
        if (this._dynamicDrawables != null) {
            this._dynamicDrawables.draw();
        }
    }

    private class AromaticRing {
        MolAtom[] ringAtoms;
        int n;
        int c;
        int v0;
        double angle;
        double angleZ;
        double r;
        int z;

        public AromaticRing() {
        }

        public AromaticRing(int n) {
            this.ringAtoms = new MolAtom[n];
        }

        public void finalize() {
            GeomCalc.deleteVector(this.c);
            GeomCalc.deleteVector(this.n);
            GeomCalc.deleteVector(this.v0);
            GeomCalc.deleteVector(this.z);
        }

        public void set(int i, MolAtom ma) {
            this.ringAtoms[i] = ma;
        }

        public void drawRing() {
            this.drawCircle();
        }

        public void computeGeometry() {
            this.c = GeomCalc.newVector();
            int n1 = GeomCalc.newVector((float)this.ringAtoms[0].getX(), (float)this.ringAtoms[0].getY(), (float)this.ringAtoms[0].getZ());
            int n2 = GeomCalc.newVector((float)this.ringAtoms[1].getX(), (float)this.ringAtoms[1].getY(), (float)this.ringAtoms[1].getZ());
            int n3 = GeomCalc.newVector((float)this.ringAtoms[2].getX(), (float)this.ringAtoms[2].getY(), (float)this.ringAtoms[2].getZ());
            GeomCalc.decrease(n1, n2);
            GeomCalc.decrease(n3, n2);
            this.n = GeomCalc.cross(n1, n3);
            GeomCalc.normalize(this.n);
            GeomCalc.increase(n1, n2);
            for (int j = 0; j < this.ringAtoms.length; ++j) {
                GeomCalc.setVector(n3, (float)this.ringAtoms[j].getX(), (float)this.ringAtoms[j].getY(), (float)this.ringAtoms[j].getZ());
                GeomCalc.increase(this.c, n3);
                if (j != this.ringAtoms.length / 2) continue;
                this.r = 0.6 * GeomCalc.distance(n1, n3) / 2.0;
            }
            GeomCalc.scale(this.c, 1.0f / (float)this.ringAtoms.length);
            this.v0 = GeomCalc.newVector(n1);
            GeomCalc.deleteVector(n1);
            GeomCalc.deleteVector(n2);
            GeomCalc.deleteVector(n3);
            this.findVectorsInPlane();
        }

        private void drawCircle() {
            VisibleMolecule.this.gl.glPushMatrix();
            VisibleMolecule.this.gl.glTranslated((double)GeomCalc.getX(this.c), (double)GeomCalc.getY(this.c), (double)GeomCalc.getZ(this.c));
            this.angle = Math.acos(GeomCalc.getZ(this.n)) * 180.0 / Math.PI;
            VisibleMolecule.this.gl.glRotated(this.angle, (double)(-GeomCalc.getY(this.n)), (double)GeomCalc.getX(this.n), 0.0);
            VisibleMolecule.this.gl.glRotated(-this.angleZ, 0.0, 0.0, 1.0);
            int circlePoints = this.ringAtoms.length * 10;
            VisibleMolecule.this.gl.glBegin(3);
            for (int i = 0; i < circlePoints + 1; ++i) {
                if (i == 0) {
                    VisibleMolecule.this.gl.glColor3bv(Colors.yellow, 0);
                } else if (i == 5) {
                    VisibleMolecule.this.gl.glColor3bv(Colors.green, 0);
                } else if (i % 10 == 0 && i < circlePoints) {
                    VisibleMolecule.this.gl.glColor3bv(Colors.getCPKByteColor(this.ringAtoms[i / 10].getAtno()), 0);
                }
                double anglei = Math.PI * -2 * (double)i / (double)circlePoints;
                VisibleMolecule.this.gl.glVertex3d(this.r * Math.cos(anglei), this.r * Math.sin(anglei), 0.0);
            }
            VisibleMolecule.this.gl.glEnd();
            VisibleMolecule.this.gl.glPopMatrix();
        }

        private void findVectorsInPlane() {
            VisibleMolecule.this.gl.glPushMatrix();
            VisibleMolecule.this.gl.glLoadIdentity();
            VisibleMolecule.this.gl.glTranslated((double)GeomCalc.getX(this.c), (double)GeomCalc.getY(this.c), (double)GeomCalc.getZ(this.c));
            double angle = Math.acos(GeomCalc.getZ(this.n)) * 180.0 / Math.PI;
            VisibleMolecule.this.gl.glRotated(angle, (double)(-GeomCalc.getY(this.n)), (double)GeomCalc.getX(this.n), 0.0);
            float[] ringPlane = new float[16];
            VisibleMolecule.this.gl.glGetFloatv(2982, ringPlane, 0);
            this.z = GeomCalc.newVector(1.0f, 0.0f, 0.0f);
            GeomCalc.multVectorWithMatrix(this.z, ringPlane);
            GeomCalc.decrease(this.z, this.c);
            GeomCalc.decrease(this.v0, this.c);
            this.angleZ = GeomCalc.angle(this.z, this.v0);
            GeomCalc.increase(this.z, this.c);
            GeomCalc.increase(this.v0, this.c);
            VisibleMolecule.this.gl.glPopMatrix();
        }
    }

    private static enum BondDrawType {
        OnePiece,
        FirstHalf,
        SecondHalf;

    }
}

