/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.space.drawing;

import chemaxon.marvin.space.drawing.DrawableException;
import chemaxon.marvin.space.drawing.DrawableFactory;
import chemaxon.marvin.space.drawing.Transform;
import chemaxon.marvin.space.drawing.iface.IDrawable;

public class AromaticRing
implements IDrawable {
    protected IDrawable _drawable;

    public AromaticRing(int drawType, float r, float[] pos, float[] rot, float[] scale) throws DrawableException {
        IDrawable drawable = drawType == 4 || drawType == 6 ? DrawableFactory.Get().CreateTorus(r) : DrawableFactory.Get().CreateCircle(r -= DrawableFactory.GetSettingsProvider().GetBondRadius() + DrawableFactory.GetSettingsProvider().GetBallRadius() + DrawableFactory.GetSettingsProvider().GetARingInset());
        Transform transformable = new Transform(drawable);
        transformable.getTransform().setPos(pos[0], pos[1], pos[2]);
        transformable.getTransform().setRot(rot[0], rot[1], rot[2], rot[3]);
        transformable.getTransform().setScale(scale[0], scale[1], scale[2]);
        this._drawable = DrawableFactory.Get().CreateStaticDrawable(transformable);
        this._drawable.setColor(DrawableFactory.GetSettingsProvider().getConstantColor());
    }

    @Override
    public void cleanup() {
        this._drawable.cleanup();
    }

    @Override
    public void draw() {
        this._drawable.draw();
    }

    @Override
    public void init() {
        this._drawable.init();
    }

    @Override
    public void setColor(byte[] color) {
        this._drawable.setColor(color);
    }

    @Override
    public void select(boolean select) {
        this._drawable.select(select);
    }

    @Override
    public IDrawable.DrawType getDrawType() {
        return this._drawable.getDrawType();
    }

    @Override
    public int getVertexCount() {
        return this._drawable.getVertexCount();
    }
}

