/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.space.drawing;

import chemaxon.marvin.paint.internal.AromatiCalc;
import chemaxon.marvin.space.drawing.AromaticRing;
import chemaxon.marvin.space.drawing.DrawableCollection;
import chemaxon.marvin.space.drawing.VectorUtil;
import chemaxon.marvin.space.drawing.iface.IDrawable;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import java.util.ArrayList;

public class AromaticRings
implements IDrawable {
    protected IDrawable _ringList;

    public AromaticRings(int drawType, Molecule mol) throws Exception {
        int start;
        int[][] sssr = mol.getSSSR();
        ArrayList<Integer> rings = new ArrayList<Integer>();
        int end = sssr.length;
        for (int i = start = 0; i < end; ++i) {
            rings.add(i);
        }
        DPoint3[] screenCoords = new DPoint3[mol.getAtomCount()];
        for (int k = 0; k < screenCoords.length; ++k) {
            DPoint3 p = screenCoords[k] = new DPoint3();
            mol.getAtom(k).getLocation(p);
        }
        AromatiCalc ac = new AromatiCalc(screenCoords, mol);
        ArrayList<ArrayList<Integer>> aRings = ac.getAromaticRings(rings, sssr);
        ArrayList<IDrawable> ringArrayList = new ArrayList<IDrawable>(aRings.size());
        for (int j = 0; j < aRings.size(); ++j) {
            float[] pos = this.GetPos(mol, aRings.get(j));
            float[] rot = this.GetRot(mol, aRings.get(j));
            float r = this.GetScale(mol, aRings.get(j), pos);
            float[] scale = new float[]{1.0f, 1.0f, 1.0f};
            AromaticRing drawable = new AromaticRing(drawType, r, pos, rot, scale);
            ringArrayList.add(drawable);
        }
        this._ringList = new DrawableCollection(ringArrayList);
        this.init();
    }

    @Override
    public void cleanup() {
        this._ringList.cleanup();
    }

    @Override
    public void draw() {
        this._ringList.draw();
    }

    @Override
    public void init() {
        this._ringList.init();
    }

    @Override
    public void select(boolean select) {
        this._ringList.select(select);
    }

    @Override
    public void setColor(byte[] color) {
        this._ringList.setColor(color);
    }

    private float[] GetPos(Molecule mol, ArrayList<Integer> aRing) {
        float[] pos = new float[]{0.0f, 0.0f, 0.0f};
        for (int i : aRing) {
            MolAtom a = mol.getAtom(i);
            DPoint3 loc = a.getLocation();
            pos[0] = pos[0] + (float)loc.x;
            pos[1] = pos[1] + (float)loc.y;
            pos[2] = pos[2] + (float)loc.z;
        }
        pos[0] = pos[0] / (float)aRing.size();
        pos[1] = pos[1] / (float)aRing.size();
        pos[2] = pos[2] / (float)aRing.size();
        return pos;
    }

    private double[] GetPlane(double[] p1, double[] p2, double[] p3) {
        double[] p = new double[]{-(p2[1] * p3[2] + p1[1] * p2[2] + p1[2] * p3[1] - p2[2] * p3[1] - p1[1] * p3[2] - p1[2] * p2[1]), -(p1[0] * p3[2] + p2[2] * p3[0] + p1[2] * p2[0] - p1[0] * p2[2] - p2[0] * p3[2] - p1[2] * p3[0]), -(p1[0] * p2[1] + p1[1] * p3[0] + p2[0] * p3[1] - p1[0] * p3[1] - p1[1] * p2[0] - p2[1] * p3[0])};
        double d = Math.sqrt(p[0] * p[0] + p[1] * p[1] + p[2] * p[2]);
        p[0] = p[0] / d;
        p[1] = p[1] / d;
        p[2] = p[2] / d;
        return p;
    }

    private float[] GetRot(Molecule mol, ArrayList<Integer> aRing) {
        MolAtom a1 = mol.getAtom(aRing.get(0));
        DPoint3 loc1 = a1.getLocation();
        MolAtom a2 = mol.getAtom(aRing.get(1));
        DPoint3 loc2 = a2.getLocation();
        MolAtom a3 = mol.getAtom(aRing.get(2));
        DPoint3 loc3 = a3.getLocation();
        double[] v1 = new double[]{loc3.x - loc1.x, loc3.y - loc1.y, loc3.z - loc1.z};
        double[] v2 = new double[]{loc3.x - loc2.x, loc3.y - loc2.y, loc3.z - loc2.z};
        VectorUtil.Normalize(v1);
        VectorUtil.Normalize(v2);
        double[] n = VectorUtil.Cross(v1, v2);
        VectorUtil.Normalize(n);
        double[] torusN = new double[]{0.0, 0.0, 1.0};
        double angle = VectorUtil.DotRad(n, torusN) * 180.0 / Math.PI;
        double[] e = VectorUtil.Cross(n, torusN);
        return new float[]{(float)e[0], (float)e[1], (float)e[2], (float)(-angle)};
    }

    private float GetScale(Molecule mol, ArrayList<Integer> aRing, float[] loc) {
        double min = 0.0;
        for (int i : aRing) {
            MolAtom a = mol.getAtom(i);
            DPoint3 aLoc = a.getLocation();
            double x = (double)loc[0] - aLoc.x;
            double y = (double)loc[1] - aLoc.y;
            double z = (double)loc[2] - aLoc.z;
            double d = Math.sqrt(x * x + y * y + z * z);
            if (min != 0.0 && !(min > d)) continue;
            min = d;
        }
        return (float)min;
    }

    @Override
    public IDrawable.DrawType getDrawType() {
        return this._ringList.getDrawType();
    }

    @Override
    public int getVertexCount() {
        return this._ringList.getVertexCount();
    }
}

