/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.space.drawing;

import chemaxon.marvin.space.drawing.DrawableCollection;
import chemaxon.marvin.space.drawing.DrawableFactory;
import chemaxon.marvin.space.drawing.Transform;
import chemaxon.marvin.space.drawing.iface.IDrawable;
import chemaxon.marvin.space.drawing.iface.ISettingsProvider;
import chemaxon.struc.MoleculeIterators;
import chemaxon.struc.PeriodicSystem;
import java.util.ArrayList;

public class Atoms
implements IDrawable {
    protected static final int HIDDEN = -1;
    protected static final int FADED = -2;
    protected static final int LONE_PAIR_TYPE = 130;
    protected IDrawable _drawable;

    public Atoms(int drawType, int[] atomDrawTypes, MoleculeIterators.MoleculeInterface molecule) throws Exception {
        ISettingsProvider sp = DrawableFactory.GetSettingsProvider();
        MoleculeIterators.AtomIteratorInterface ai = molecule.getAtomIterator(sp.GetDrawHydrogens());
        ArrayList<IDrawable> atoms = new ArrayList<IDrawable>(ai.getCount());
        ai.reset();
        while (ai.hasNext()) {
            if (atomDrawTypes[ai.getCurrentAtomId()] != -1) {
                IDrawable atom = drawType == 4 ? DrawableFactory.Get().GetReferenceJoint() : DrawableFactory.Get().GetReferenceBall();
                byte[] color = DrawableFactory.GetSettingsProvider().getColor(ai, molecule);
                atom.setColor(color);
                Transform transform = new Transform(atom);
                transform.getTransform().setPos(ai.getX(), ai.getY(), ai.getZ());
                if (sp.GetScaledBalls()) {
                    double f = PeriodicSystem.getAtomicRadius(ai.getAtomType());
                    if (ai.getAtomType() == 130) {
                        f *= 0.5;
                    }
                    transform.getTransform().setScale((float)f, (float)f, (float)f);
                } else if (ai.getAtomType() == 1 || ai.getAtomType() == 130) {
                    transform.getTransform().setScale(0.5f, 0.5f, 0.5f);
                }
                atoms.add(DrawableFactory.Get().CreateStaticDrawable(atom));
            }
            ai.next();
        }
        this._drawable = new DrawableCollection(atoms);
        this.init();
    }

    @Override
    public void cleanup() {
        this._drawable.cleanup();
    }

    @Override
    public void select(boolean select) {
        this._drawable.select(select);
    }

    @Override
    public void setColor(byte[] color) {
    }

    @Override
    public void init() {
        this._drawable.init();
    }

    @Override
    public void draw() {
        this._drawable.draw();
    }

    @Override
    public IDrawable.DrawType getDrawType() {
        return this._drawable.getDrawType();
    }

    @Override
    public int getVertexCount() {
        return this._drawable.getVertexCount();
    }
}

