/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.space.drawing;

import chemaxon.marvin.space.drawing.DrawableFactory;
import chemaxon.marvin.space.drawing.iface.ISettingsProvider;
import chemaxon.struc.MoleculeIterators;
import java.util.Iterator;

public class BondIterator
implements Iterable<BondData>,
Iterator<BondData> {
    static final int FADED = -2;
    static final int HIDDEN = -1;
    static final int LONE_PAIR_TYPE = 130;
    int[] _atomDrawTypes;
    MoleculeIterators.BondIteratorInterface _bi;
    MoleculeIterators.MoleculeInterface _molecule;
    ISettingsProvider _sp;
    BondData _next;
    BondData _next2;

    public BondIterator(MoleculeIterators.MoleculeInterface molecule, int[] atomDrawTypes) {
        this._molecule = molecule;
        this._atomDrawTypes = atomDrawTypes;
        this._sp = DrawableFactory.GetSettingsProvider();
        this._bi = molecule.getBondIterator(this._sp.GetDrawHydrogens());
        this._bi.reset();
    }

    @Override
    public Iterator<BondData> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        if (this._next2 != null) {
            this._next2 = null;
            return true;
        }
        while (this._bi.hasNext()) {
            if (this._atomDrawTypes[this._bi.getAtomIndex(1)] != -1 && this._atomDrawTypes[this._bi.getAtomIndex(2)] != -1 && (this._sp.GetDrawHydrogens() || this._bi.getAtomType(1) != 1 && this._bi.getAtomType(2) != 1) && (this._sp.GetDrawLonePairs() || this._bi.getAtomType(1) != 130 && this._bi.getAtomType(2) != 130)) {
                this._next = new BondData();
                this._next._pos1 = new float[]{this._bi.getX(1), this._bi.getY(1), this._bi.getZ(1)};
                this._next._color1 = DrawableFactory.GetSettingsProvider().getColor(this._molecule, this._bi, 1);
                this._next._color2 = DrawableFactory.GetSettingsProvider().getColor(this._molecule, this._bi, this._sp.SmoothStickColoring() ? 2 : 1);
                this._next._bondType = this._bi.getBondType();
                if (!this._sp.drawBondOnePiece(this._bi) && !this._sp.SmoothStickColoring()) {
                    this._next2 = new BondData();
                    this._next2._bondType = this._next._bondType;
                    this._next2._pos2 = new float[]{this._bi.getX(2), this._bi.getY(2), this._bi.getZ(2)};
                    this._next._pos2 = new float[]{(this._next2._pos2[0] + this._next._pos1[0]) / 2.0f, (this._next2._pos2[1] + this._next._pos1[1]) / 2.0f, (this._next2._pos2[2] + this._next._pos1[2]) / 2.0f};
                    this._next2._pos1 = this._next._pos2;
                    this._next._pos2 = this._next._pos2;
                    this._next2._color1 = DrawableFactory.GetSettingsProvider().getColor(this._molecule, this._bi, 2);
                    this._next2._color2 = DrawableFactory.GetSettingsProvider().getColor(this._molecule, this._bi, 2);
                } else {
                    this._next._pos2 = new float[]{this._bi.getX(2), this._bi.getY(2), this._bi.getZ(2)};
                }
                this._bi.next();
                return true;
            }
            this._bi.next();
        }
        return false;
    }

    @Override
    public BondData next() {
        BondData res = this._next;
        if (this._next2 != null) {
            this._next = this._next2;
        }
        return res;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public class BondData {
        public int _bondType;
        public byte[] _color1;
        public byte[] _color2;
        public float[] _pos1;
        public float[] _pos2;
    }
}

