/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.space.drawing;

import chemaxon.marvin.space.drawing.iface.IDrawable;
import java.util.ArrayList;

public class DrawableCollection
implements IDrawable {
    protected ArrayList<IDrawable> _drawable;

    public DrawableCollection(ArrayList<IDrawable> drawable) {
        this._drawable = new ArrayList<IDrawable>(drawable);
    }

    @Override
    public void draw() {
        for (IDrawable d : this._drawable) {
            d.draw();
        }
    }

    @Override
    public void init() {
        for (IDrawable d : this._drawable) {
            d.init();
        }
    }

    @Override
    public void select(boolean select) {
        for (IDrawable d : this._drawable) {
            d.select(select);
        }
    }

    @Override
    public void setColor(byte[] color) {
        for (IDrawable d : this._drawable) {
            d.setColor(color);
        }
    }

    @Override
    public IDrawable.DrawType getDrawType() {
        return IDrawable.DrawType.STATIC;
    }

    @Override
    public int getVertexCount() {
        int sum = 0;
        for (IDrawable d : this._drawable) {
            sum += d.getVertexCount();
        }
        return sum;
    }

    @Override
    public void cleanup() {
        for (IDrawable d : this._drawable) {
            d.cleanup();
        }
    }
}

