/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.space.drawing;

import chemaxon.marvin.space.drawing.DrawableException;
import chemaxon.marvin.space.drawing.iface.IDrawable;
import chemaxon.marvin.space.drawing.iface.ISettingsProvider;
import chemaxon.marvin.space.drawing.iface.ITransform;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;

public abstract class DrawableFactory {
    private static DrawableFactory _dF = null;
    private static ISettingsProvider _sP = null;
    public static final int DRAW_TYPE_WIRE = 2;
    public static final int DRAW_TYPE_BALL = 3;
    public static final int DRAW_TYPE_STICK = 4;
    public static final int DRAW_TYPE_BALL_AND_WIRE = 5;
    public static final int DRAW_TYPE_BALL_AND_STICK = 6;

    public static DrawableFactory Get() throws DrawableException {
        if (_dF == null) {
            throw new DrawableException("DrawableFactory uninitialized...");
        }
        return _dF;
    }

    public abstract IDrawable CreateCircle(float var1, int var2);

    public abstract IDrawable CreateCircle(float var1);

    public abstract IDrawable CreateTorus(float var1, float var2, int var3, int var4);

    public abstract IDrawable CreateTorus(float var1);

    public abstract IDrawable CreateLines(FloatBuffer var1);

    public abstract IDrawable CreateLines(float[] var1);

    public abstract IDrawable CreateBond(int var1, int var2, byte[] var3, byte[] var4) throws DrawableException;

    public abstract IDrawable CreateAtom(int var1);

    public abstract IDrawable CreateReferenceCylinderStick();

    public abstract IDrawable CreateReferenceCylinderBond();

    public abstract IDrawable CreateReferenceCylinderDoubleAndTripleBond();

    public abstract IDrawable CreateBond(int var1, int var2, float[] var3, float[] var4, byte[] var5, byte[] var6) throws DrawableException;

    public abstract IDrawable CreateReferenceBall();

    public abstract IDrawable CreateReferenceJoint();

    public abstract IDrawable GetReferenceBall();

    public abstract IDrawable GetReferenceJoint();

    public abstract ITransform CreateTransform();

    public abstract IDrawable CreateStaticDrawable(IDrawable var1);

    public abstract IDrawable CreateColorBuffer(IDrawable var1, ByteBuffer var2);

    public abstract IDrawable CreateColorBuffer(IDrawable var1, byte[] var2);

    public static void Set(DrawableFactory dF) {
        _dF = dF;
    }

    public static void RegisterSettingsProvider(ISettingsProvider settingsProvider) {
        _sP = settingsProvider;
    }

    public static ISettingsProvider GetSettingsProvider() {
        return _sP;
    }
}

