/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.space.gl.viewport;

import chemaxon.marvin.space.GraphicCell;
import chemaxon.marvin.space.ViewPort;

public class AsymStereoViewport
extends ViewPort {
    private static final double DTR = 0.0174532925;
    private static final double IOD = 0.5;
    private Camera leftCam;
    private Camera rightCam;
    private double screenZ;
    private static final double _farClip = 450.0;
    private static final double _nearClip = 0.1;

    public AsymStereoViewport(GraphicCell gc) {
        super(gc);
        this.screenZ = this.cameraZ;
    }

    @Override
    public void setSize(int width, int height) {
        super.setSize(width, height);
        this.setFrustum();
    }

    private void setFrustum() {
        double top = 0.1 * Math.tan(0.0174532925 * (double)this.fovY / 2.0);
        double right = (double)this.width / (double)this.height * top;
        double frustumshift = 0.025 / this.screenZ;
        this.leftCam = new Camera();
        this.leftCam.topfrustum = top;
        this.leftCam.bottomfrustum = -top;
        this.leftCam.leftfrustum = -right + frustumshift;
        this.leftCam.rightfrustum = right + frustumshift;
        this.leftCam.modeltranslation = 0.25;
        this.rightCam = new Camera();
        this.rightCam.topfrustum = top;
        this.rightCam.bottomfrustum = -top;
        this.rightCam.leftfrustum = -right - frustumshift;
        this.rightCam.rightfrustum = right - frustumshift;
        this.rightCam.modeltranslation = -0.25;
    }

    protected void setMatrices(Camera cam) {
        this.computeClippingPlanes();
        this.dumpError("glViewport_before");
        AsymStereoViewport.getGL().glViewport(this.left, this.bottom, this.width, this.height);
        this.dumpError("glViewport");
        AsymStereoViewport.getGL().glMatrixMode(5889);
        AsymStereoViewport.getGL().glLoadIdentity();
        this.dumpError("setPickMatrix_before");
        this.projectionMatrixNeedsRefresh = this.gc.setPickMatrix();
        this.dumpError("setPickMatrix");
        if (this.perspectiveProjection) {
            this.dumpError("glFrustum_before");
            AsymStereoViewport.getGL().glFrustum(cam.leftfrustum, cam.rightfrustum, cam.bottomfrustum, cam.topfrustum, 0.1, 450.0);
            this.dumpError("glFrustum");
        } else {
            double d = 225.05;
            this.glOrtho(this.fovY, this.width / this.height, d, -d);
        }
        AsymStereoViewport.getGL().glMatrixMode(5888);
        AsymStereoViewport.getGL().glLoadIdentity();
    }

    @Override
    public void draw() {
        this.dumpError("draw_begin");
        AsymStereoViewport.getGL().glScissor(this.left, this.bottom, this.width, this.height);
        AsymStereoViewport.getGL().glColorMask(true, true, true, true);
        AsymStereoViewport.getGL().glClear(16640);
        this.resetZoom(this.gc.getBoundingBoxAndSetSphereRadius());
        this.gc.drawSmoothBackground();
        this.dumpError("setMatrices_begin");
        this.cameraX = this.leftCam.modeltranslation;
        this.setMatrices(this.leftCam);
        this.dumpError("setMatrices_end");
        AsymStereoViewport.getGL().glPushMatrix();
        AsymStereoViewport.getGL().glColorMask(true, false, false, true);
        this.dumpError("drawCell_begin");
        this.gc.drawCell();
        AsymStereoViewport.getGL().glPopMatrix();
        AsymStereoViewport.getGL().glClear(256);
        this.cameraX = this.rightCam.modeltranslation;
        this.setMatrices(this.rightCam);
        AsymStereoViewport.getGL().glPushMatrix();
        AsymStereoViewport.getGL().glColorMask(false, true, false, true);
        this.gc.drawCell();
        AsymStereoViewport.getGL().glPopMatrix();
        this.dumpError("draw_end");
    }

    protected class Camera {
        double leftfrustum;
        double rightfrustum;
        double bottomfrustum;
        double topfrustum;
        double modeltranslation;

        protected Camera() {
        }
    }
}

