/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.space.grid;

import chemaxon.marvin.space.Colors;
import chemaxon.marvin.space.MoleculeComponent;
import chemaxon.marvin.space.SurfaceComponent;
import chemaxon.marvin.space.grid.AtomGrid;
import chemaxon.marvin.space.grid.ColorGrid;
import chemaxon.struc.MoleculeIterators;
import chemaxon.struc.PeriodicSystem;
import java.util.ArrayList;
import java.util.HashMap;
import javax.media.opengl.GL;

public class AtomTypeColorGrid
extends ColorGrid {
    MoleculeIterators.MoleculeInterface mc = null;
    AtomGrid atomGrid = null;
    private float[][][] atomSpheres = null;
    protected HashMap elementIndices = new HashMap();
    protected double sas = 0.0;

    public AtomTypeColorGrid() {
    }

    public AtomTypeColorGrid(ArrayList ms, AtomGrid ag, String surfaceType) {
        int i;
        this.atomGrid = ag;
        this.step = this.atomGrid.getStepX();
        this.setStart(this.atomGrid.getStartX(), this.atomGrid.getStartY(), this.atomGrid.getStartZ());
        this.setSize(this.atomGrid.getSizeX(), this.atomGrid.getSizeY(), this.atomGrid.getSizeZ());
        if (surfaceType.equals("Solvent-accessible") || surfaceType.equals("Gaussian Cube")) {
            this.sas = this.atomGrid.getProbeRadius();
        }
        for (i = 0; i < MoleculeComponent.elementList.length; ++i) {
            this.elementIndices.put(new Integer(MoleculeComponent.elementList[i]), new Integer(i));
        }
        this.atomSpheres = new float[MoleculeComponent.elementList.length][][];
        for (i = 0; i < MoleculeComponent.elementList.length; ++i) {
            double r = PeriodicSystem.getVanDerWaalsRadius(MoleculeComponent.elementList[i]) + this.sas;
            this.atomSpheres[i] = this.createSphere(r, Colors.getCPKColor(MoleculeComponent.elementList[i]));
        }
        for (MoleculeIterators.MoleculeInterface this.mc : ms) {
            this.placeSpheres();
        }
    }

    @Override
    public void finalize() {
    }

    public void coloringSurface(SurfaceComponent surface) {
        surface.coloring(true);
        for (int i = 0; i < surface.getVertexCount(); ++i) {
            float z;
            float y;
            float x = surface.getVertexX(i);
            byte[] c = this.getByte(x, y = surface.getVertexY(i), z = surface.getVertexZ(i));
            if (c == null || c[0] == 0 && c[1] == 0 && c[2] == 0) {
                surface.putColor(surface.getColor3());
                continue;
            }
            surface.putColor(c);
        }
    }

    protected int getRadius(double radius) {
        return (int)Math.round(radius / (double)this.getStep()) + 2;
    }

    @Override
    public void drawGrid(GL gl) {
        gl.glDisable(2896);
        gl.glPointSize(2.0f);
        gl.glBegin(0);
        for (int k = 0; k < this.sizeZ; ++k) {
            for (int j = this.sizeY - 1; j >= 0; --j) {
                for (int i = 0; i < this.sizeX; ++i) {
                    gl.glColor3fv(Colors.whiteF, 0);
                    gl.glVertex3dv(this.getCoordinates(i, j, k), 0);
                }
            }
        }
        gl.glEnd();
        gl.glEnable(2896);
    }

    protected float[][] createSphere(double radius, float[] value) {
        int gridRadius = this.getRadius(radius);
        int size = 2 * gridRadius;
        int r2 = gridRadius * gridRadius;
        float[][] sphere = new float[size * size * size][3];
        for (int i = 0; i < gridRadius; ++i) {
            int j2;
            int i2 = i * i;
            for (int j = 0; j < gridRadius && (j2 = j * j) + i2 <= r2; ++j) {
                for (int k = 0; k < gridRadius; ++k) {
                    int d = j2 + i2 + k * k;
                    if (d > r2) continue;
                    float s = (float)(r2 - d) / (float)r2 * 2.0f;
                    if (s > 1.0f) {
                        s = 1.0f;
                    }
                    this.setCell(sphere, size, gridRadius + i, gridRadius + j, gridRadius + k, value, s);
                    this.setCell(sphere, size, gridRadius + i, gridRadius + j, gridRadius - k, value, s);
                    this.setCell(sphere, size, gridRadius + i, gridRadius - j, gridRadius + k, value, s);
                    this.setCell(sphere, size, gridRadius + i, gridRadius - j, gridRadius - k, value, s);
                    this.setCell(sphere, size, gridRadius - i, gridRadius + j, gridRadius + k, value, s);
                    this.setCell(sphere, size, gridRadius - i, gridRadius + j, gridRadius - k, value, s);
                    this.setCell(sphere, size, gridRadius - i, gridRadius - j, gridRadius + k, value, s);
                    this.setCell(sphere, size, gridRadius - i, gridRadius - j, gridRadius - k, value, s);
                }
            }
        }
        return sphere;
    }

    protected void setCell(float[][] sphere, int size, int i, int j, int k, float[] value, float s) {
        sphere[i * size * size + j * size + k][0] = value[0];
        sphere[i * size * size + j * size + k][1] = value[1];
        sphere[i * size * size + j * size + k][2] = value[2];
    }

    private void placeSpheres() {
        MoleculeIterators.AtomIteratorInterface ai = this.mc.getAtomIterator(true);
        ai.reset();
        while (ai.hasNext()) {
            int index = this.getElementSphereIndex(ai.getAtomType());
            double radius = PeriodicSystem.getVanDerWaalsRadius(ai.getAtomType()) + this.sas;
            this.placeSphere(ai.getX(), ai.getY(), ai.getZ(), this.atomSpheres[index], radius);
            ai.next();
        }
    }

    protected void placeSphere(double x, double y, double z, float[][] sphere, double radius) {
        int sphereRadius = this.getRadius(radius);
        int[] cCoords = this.getGridCoords(x, y, z);
        this.placeSphere(cCoords, sphere, sphereRadius);
    }

    protected void placeSphere(int[] cCoords, float[][] sphere, int sphereRadius) {
        cCoords[0] = cCoords[0] - sphereRadius;
        cCoords[1] = cCoords[1] - sphereRadius;
        cCoords[2] = cCoords[2] - sphereRadius;
        int sphereSize = 2 * sphereRadius;
        int sphereSize2 = sphereSize * sphereSize;
        for (int i = 0; i < sphereSize; ++i) {
            for (int j = 0; j < sphereSize; ++j) {
                for (int k = 0; k < sphereSize; ++k) {
                    float[] oldc;
                    float[] c = sphere[i * sphereSize2 + j * sphereSize + k];
                    if (c[0] == 0.0f && c[1] == 0.0f && c[2] == 0.0f || (oldc = this.get(i + cCoords[0], j + cCoords[1], k + cCoords[2])) == null) continue;
                    if (oldc[0] == 0.0f && oldc[1] == 0.0f && oldc[2] == 0.0f) {
                        this.set(i + cCoords[0], j + cCoords[1], k + cCoords[2], c);
                        continue;
                    }
                    if (oldc[0] == c[0] && oldc[1] == c[1] && oldc[2] == c[2]) continue;
                    this.blur(i + cCoords[0], j + cCoords[1], k + cCoords[2], c);
                }
            }
        }
    }

    private int getElementSphereIndex(int atomType) {
        if (!this.elementIndices.containsKey(new Integer(atomType))) {
            System.out.println("Problem with " + atomType + " sphereIndex");
            return 0;
        }
        return (Integer)this.elementIndices.get(new Integer(atomType));
    }
}

