/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.space.grid;

import chemaxon.common.util.GeomCalc;
import chemaxon.marvin.space.Colors;
import chemaxon.marvin.space.PolymerVisualizer;
import chemaxon.marvin.space.grid.AtomGrid;
import chemaxon.marvin.space.grid.AtomTypeColorGrid;
import chemaxon.struc.MacroMolecule;
import chemaxon.struc.MoleculeIterators;
import java.util.ArrayList;

public class ChainTypeColorGrid
extends AtomTypeColorGrid {
    private float[][][] chainSpheres = null;

    public ChainTypeColorGrid(ArrayList ms, AtomGrid ag, String surfaceType) {
        this.atomGrid = ag;
        this.step = this.atomGrid.getStepX();
        this.start = GeomCalc.newVector(this.atomGrid.getStartX(), this.atomGrid.getStartY(), this.atomGrid.getStartZ());
        this.setSize(this.atomGrid.getSizeX(), this.atomGrid.getSizeY(), this.atomGrid.getSizeZ());
        if (surfaceType.equals("Solvent-accessible") || surfaceType.equals("Gaussian Cube")) {
            this.sas = this.atomGrid.getProbeRadius();
        }
        this.chainSpheres = new float[22][][];
        for (int i = 0; i < 22; ++i) {
            byte[] cc = Colors.getChainColor(i);
            float[] cfc = new float[]{(float)cc[0] / 127.0f, (float)cc[1] / 127.0f, (float)cc[2] / 127.0f};
            this.chainSpheres[i] = this.createSphere(2.0 + this.sas, cfc);
        }
        for (MoleculeIterators.MoleculeInterface this.mc : ms) {
            this.placeSpheres();
        }
    }

    @Override
    public void finalize() {
    }

    private void placeSpheres() {
        int index = ((PolymerVisualizer)this.mc).getChainNumber();
        MoleculeIterators.AtomIteratorInterface ai = this.mc.getAtomIterator(true);
        if (!(ai instanceof MacroMolecule.Polymer.AtomIterator)) {
            return;
        }
        MacroMolecule.Polymer.AtomIterator atomIterator = (MacroMolecule.Polymer.AtomIterator)ai;
        atomIterator.reset();
        while (atomIterator.hasNext()) {
            this.placeSphere(atomIterator.getX(), atomIterator.getY(), atomIterator.getZ(), this.chainSpheres[index], 2.0 + this.sas);
            atomIterator.next();
        }
    }
}

