/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.space.grid;

import chemaxon.marvin.space.MoleculeComponent;
import chemaxon.marvin.space.grid.AtomGrid;
import chemaxon.struc.MoleculeIterators;
import chemaxon.struc.PeriodicSystem;
import java.util.ArrayList;

public class Connolly {
    static final int ATOM_VDW_CELL = 16;
    static final int ATOM_SAS_CELL = 32;
    static final int PROBE_ATOM_CELL = 64;
    static final int BOUNDARY_CELL = 128;
    private MoleculeIterators.MoleculeInterface mc;
    private AtomGrid ag;
    private double probeRadius;
    private int[][] atomSpheres = null;
    private int[] probeSphere = null;
    private int probeSphereRadius;
    private ArrayList boundary = new ArrayList();

    public Connolly(AtomGrid ag, MoleculeIterators.MoleculeInterface mc, double probeRadius) {
        this.mc = mc;
        this.ag = ag;
        this.probeRadius = probeRadius;
        this.atomSpheres = new int[MoleculeComponent.elementList.length][];
        for (int i = 0; i < MoleculeComponent.elementList.length; ++i) {
            this.atomSpheres[i] = this.createSphere(PeriodicSystem.getVanDerWaalsRadius(MoleculeComponent.elementList[i]), 16, probeRadius, 32, false);
        }
        this.probeSphere = this.createSphere(probeRadius, 64, 0.0, 0, false);
        this.probeSphereRadius = this.getIntRadius(probeRadius);
    }

    public void calculate() {
        this.placeSASSpheres();
        this.detectBoundary();
        this.rollSphere();
        this.setConnollyValues();
    }

    public int getElementSphereIndex(int atomType) {
        int i;
        for (i = 0; i < MoleculeComponent.elementList.length; ++i) {
            if (MoleculeComponent.elementList[i] != atomType) continue;
            return i;
        }
        return i - 1;
    }

    private void placeSASSpheres() {
        int i = 0;
        MoleculeIterators.AtomIteratorInterface ai = this.mc.getAtomIterator(true);
        ai.reset();
        while (ai.hasNext()) {
            if (ai.getAtomType() != 130) {
                int index = this.getElementSphereIndex(ai.getAtomType());
                double radius = PeriodicSystem.getVanDerWaalsRadius(ai.getAtomType());
                this.placeSphere(ai.getX(), ai.getY(), ai.getZ(), this.atomSpheres[index], radius, false);
            }
            ai.next();
            ++i;
        }
    }

    private void detectBoundary() {
        for (int i = 1; i < this.ag.getSizeX() - 1; ++i) {
            for (int j = 1; j < this.ag.getSizeY() - 1; ++j) {
                for (int k = 1; k < this.ag.getSizeZ() - 1; ++k) {
                    if (this.ag.get(i, j, k) != 32.0f) continue;
                    if (this.ag.get(i - 1, j, k) == 0.0f) {
                        this.ag.set(i - 1, j, k, 128.0f);
                        this.putBoundary(i - 1, j, k);
                    }
                    if (this.ag.get(i + 1, j, k) == 0.0f) {
                        this.ag.set(i + 1, j, k, 128.0f);
                        this.putBoundary(i + 1, j, k);
                    }
                    if (this.ag.get(i, j - 1, k) == 0.0f) {
                        this.ag.set(i, j - 1, k, 128.0f);
                        this.putBoundary(i, j - 1, k);
                    }
                    if (this.ag.get(i, j + 1, k) == 0.0f) {
                        this.ag.set(i, j + 1, k, 128.0f);
                        this.putBoundary(i, j + 1, k);
                    }
                    if (this.ag.get(i, j, k - 1) == 0.0f) {
                        this.ag.set(i, j, k - 1, 128.0f);
                        this.putBoundary(i, j, k - 1);
                    }
                    if (this.ag.get(i, j, k + 1) != 0.0f) continue;
                    this.ag.set(i, j, k + 1, 128.0f);
                    this.putBoundary(i, j, k + 1);
                }
            }
        }
    }

    private void putBoundary(int i, int j, int k) {
        this.boundary.add(new Integer(i));
        this.boundary.add(new Integer(j));
        this.boundary.add(new Integer(k));
    }

    private void rollSphere() {
        int[] cCoords = new int[3];
        int s = this.boundary.size() / 3;
        for (int i = 0; i < s; ++i) {
            cCoords[0] = (Integer)this.boundary.get(i * 3);
            cCoords[1] = (Integer)this.boundary.get(i * 3 + 1);
            cCoords[2] = (Integer)this.boundary.get(i * 3 + 2);
            if (((int)this.ag.get(cCoords[0], cCoords[1], cCoords[2]) & 0x80) == 0) continue;
            this.placeSphere(cCoords, this.probeSphere, this.probeSphereRadius, true);
        }
    }

    private void setConnollyValues() {
        for (int i = 0; i < this.ag.getSizeX(); ++i) {
            for (int j = 0; j < this.ag.getSizeY(); ++j) {
                for (int k = 0; k < this.ag.getSizeZ(); ++k) {
                    double v = this.ag.get(i, j, k);
                    if (v == 32.0) {
                        this.ag.set(i, j, k, this.ag.thresholdPlusEpsilon);
                        continue;
                    }
                    if (v != (double)((int)v) || v == 0.0) continue;
                    this.ag.set(i, j, k, 0.0f);
                }
            }
        }
    }

    private void placeSphere(double x, double y, double z, int[] sphere, double radius, boolean anyway) {
        int sphereRadius = this.getIntRadius(radius + this.probeRadius);
        int[] cCoords = this.ag.getCellCoordinates(x, y, z);
        this.placeSphere(cCoords, sphere, sphereRadius, anyway);
    }

    private void placeSphere(int[] cCoords, int[] sphere, int sphereRadius, boolean anyway) {
        cCoords[0] = cCoords[0] - sphereRadius;
        cCoords[1] = cCoords[1] - sphereRadius;
        cCoords[2] = cCoords[2] - sphereRadius;
        int sphereSize = 2 * sphereRadius;
        int sphereSize2 = sphereSize * sphereSize;
        for (int i = 0; i < sphereSize; ++i) {
            for (int j = 0; j < sphereSize; ++j) {
                for (int k = 0; k < sphereSize; ++k) {
                    int v = sphere[i * sphereSize2 + j * sphereSize + k];
                    if (v == 0 || !this.isValidIndex(i + cCoords[0], j + cCoords[1], k + cCoords[2])) continue;
                    if (anyway) {
                        int oldv = (int)this.ag.get(i + cCoords[0], j + cCoords[1], k + cCoords[2]);
                        if (oldv == 128 || v == 64 && oldv == 64) continue;
                        this.ag.set(i + cCoords[0], j + cCoords[1], k + cCoords[2], v);
                        continue;
                    }
                    if (!(this.ag.get(i + cCoords[0], j + cCoords[1], k + cCoords[2]) < this.ag.surfaceThreshold)) continue;
                    this.ag.set(i + cCoords[0], j + cCoords[1], k + cCoords[2], v);
                }
            }
        }
    }

    private boolean isValidIndex(int x, int y, int z) {
        return x >= 0 && x < this.ag.getSizeX() && y >= 0 && y < this.ag.getSizeY() && z >= 0 && z < this.ag.getSizeZ();
    }

    private int[] createSphere(double radius, int type, double extRadius, int extType, boolean empty) {
        int gridRadius = this.getIntRadius(radius);
        int gridExtRadius = this.getIntRadius(radius + extRadius);
        int size = 2 * gridExtRadius;
        int[] sphere = new int[size * size * size];
        int r2 = gridRadius * gridRadius;
        int extr2 = gridExtRadius * gridExtRadius;
        for (int i = 0; i < gridExtRadius; ++i) {
            int j2;
            int i2 = i * i;
            for (int j = 0; j < gridExtRadius && (j2 = j * j) + i2 <= extr2; ++j) {
                for (int k = 0; k < gridExtRadius; ++k) {
                    int d = j2 + i2 + k * k;
                    if (d > extr2 || empty && d <= r2) continue;
                    int col = d <= r2 ? type : extType;
                    this.setCell(sphere, size, gridExtRadius + i, gridExtRadius + j, gridExtRadius + k, col);
                    this.setCell(sphere, size, gridExtRadius + i, gridExtRadius + j, gridExtRadius - k, col);
                    this.setCell(sphere, size, gridExtRadius + i, gridExtRadius - j, gridExtRadius + k, col);
                    this.setCell(sphere, size, gridExtRadius + i, gridExtRadius - j, gridExtRadius - k, col);
                    this.setCell(sphere, size, gridExtRadius - i, gridExtRadius + j, gridExtRadius + k, col);
                    this.setCell(sphere, size, gridExtRadius - i, gridExtRadius + j, gridExtRadius - k, col);
                    this.setCell(sphere, size, gridExtRadius - i, gridExtRadius - j, gridExtRadius + k, col);
                    this.setCell(sphere, size, gridExtRadius - i, gridExtRadius - j, gridExtRadius - k, col);
                }
            }
        }
        return sphere;
    }

    private void setCell(int[] grid, int size, int i, int j, int k, int value) {
        grid[i * size * size + j * size + k] = value;
    }

    private int getIntRadius(double radius) {
        return (int)Math.round(radius / (double)this.ag.getStepX());
    }
}

